package ONVIF::Media::Types::RecordingJobSource;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %SourceToken_of :ATTR(:get<SourceToken>);
my %AutoCreateReceiver_of :ATTR(:get<AutoCreateReceiver>);
my %Tracks_of :ATTR(:get<Tracks>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        SourceToken
        AutoCreateReceiver
        Tracks
        Extension

    ) ],
    {
        'SourceToken' => \%SourceToken_of,
        'AutoCreateReceiver' => \%AutoCreateReceiver_of,
        'Tracks' => \%Tracks_of,
        'Extension' => \%Extension_of,
    },
    {
        'SourceToken' => 'ONVIF::Media::Types::SourceReference',
        'AutoCreateReceiver' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'Tracks' => 'ONVIF::Media::Types::RecordingJobTrack',
        'Extension' => 'ONVIF::Media::Types::RecordingJobSourceExtension',
    },
    {

        'SourceToken' => 'SourceToken',
        'AutoCreateReceiver' => 'AutoCreateReceiver',
        'Tracks' => 'Tracks',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::RecordingJobSource

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RecordingJobSource from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * SourceToken


=item * AutoCreateReceiver


=item * Tracks


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::RecordingJobSource
   SourceToken =>  { # ONVIF::Media::Types::SourceReference
     Token => $some_value, # ReferenceToken
   },
   AutoCreateReceiver =>  $some_value, # boolean
   Tracks =>  { # ONVIF::Media::Types::RecordingJobTrack
     SourceTag =>  $some_value, # string
     Destination => $some_value, # TrackReference
   },
   Extension =>  { # ONVIF::Media::Types::RecordingJobSourceExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

