package ONVIF::PTZ::Types::PTZPresetTourOptions;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %AutoStart_of :ATTR(:get<AutoStart>);
my %StartingCondition_of :ATTR(:get<StartingCondition>);
my %TourSpot_of :ATTR(:get<TourSpot>);

__PACKAGE__->_factory(
    [ qw(        AutoStart
        StartingCondition
        TourSpot

    ) ],
    {
        'AutoStart' => \%AutoStart_of,
        'StartingCondition' => \%StartingCondition_of,
        'TourSpot' => \%TourSpot_of,
    },
    {
        'AutoStart' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'StartingCondition' => 'ONVIF::PTZ::Types::PTZPresetTourStartingConditionOptions',
        'TourSpot' => 'ONVIF::PTZ::Types::PTZPresetTourSpotOptions',
    },
    {

        'AutoStart' => 'AutoStart',
        'StartingCondition' => 'StartingCondition',
        'TourSpot' => 'TourSpot',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::PTZPresetTourOptions

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
PTZPresetTourOptions from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * AutoStart


=item * StartingCondition


=item * TourSpot




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::PTZPresetTourOptions
   AutoStart =>  $some_value, # boolean
   StartingCondition =>  { # ONVIF::PTZ::Types::PTZPresetTourStartingConditionOptions
     RecurringTime =>  { # ONVIF::PTZ::Types::IntRange
       Min =>  $some_value, # int
       Max =>  $some_value, # int
     },
     RecurringDuration =>  { # ONVIF::PTZ::Types::DurationRange
       Min =>  $some_value, # duration
       Max =>  $some_value, # duration
     },
     Direction => $some_value, # PTZPresetTourDirection
     Extension =>  { # ONVIF::PTZ::Types::PTZPresetTourStartingConditionOptionsExtension
     },
   },
   TourSpot =>  { # ONVIF::PTZ::Types::PTZPresetTourSpotOptions
     PresetDetail =>  { # ONVIF::PTZ::Types::PTZPresetTourPresetDetailOptions
       PresetToken => $some_value, # ReferenceToken
       Home =>  $some_value, # boolean
       PanTiltPositionSpace =>  { # ONVIF::PTZ::Types::Space2DDescription
         URI =>  $some_value, # anyURI
         XRange =>  { # ONVIF::PTZ::Types::FloatRange
           Min =>  $some_value, # float
           Max =>  $some_value, # float
         },
         YRange =>  { # ONVIF::PTZ::Types::FloatRange
           Min =>  $some_value, # float
           Max =>  $some_value, # float
         },
       },
       ZoomPositionSpace =>  { # ONVIF::PTZ::Types::Space1DDescription
         URI =>  $some_value, # anyURI
         XRange =>  { # ONVIF::PTZ::Types::FloatRange
           Min =>  $some_value, # float
           Max =>  $some_value, # float
         },
       },
       Extension =>  { # ONVIF::PTZ::Types::PTZPresetTourPresetDetailOptionsExtension
       },
     },
     StayTime =>  { # ONVIF::PTZ::Types::DurationRange
       Min =>  $some_value, # duration
       Max =>  $some_value, # duration
     },
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

