package ONVIF::Media::Types::Certificate;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %CertificateID_of :ATTR(:get<CertificateID>);
my %Certificate_of :ATTR(:get<Certificate>);

__PACKAGE__->_factory(
    [ qw(        CertificateID
        Certificate

    ) ],
    {
        'CertificateID' => \%CertificateID_of,
        'Certificate' => \%Certificate_of,
    },
    {
        'CertificateID' => 'SOAP::WSDL::XSD::Typelib::Builtin::token',
        'Certificate' => 'ONVIF::Media::Types::BinaryData',
    },
    {

        'CertificateID' => 'CertificateID',
        'Certificate' => 'Certificate',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::Certificate

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Certificate from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * CertificateID


=item * Certificate




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::Certificate
   CertificateID =>  $some_value, # token
   Certificate =>  { # ONVIF::Media::Types::BinaryData
     Data =>  $some_value, # base64Binary
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

