package ONVIF::PTZ::Types::ProfileExtension;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %AudioOutputConfiguration_of :ATTR(:get<AudioOutputConfiguration>);
my %AudioDecoderConfiguration_of :ATTR(:get<AudioDecoderConfiguration>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        AudioOutputConfiguration
        AudioDecoderConfiguration
        Extension

    ) ],
    {
        'AudioOutputConfiguration' => \%AudioOutputConfiguration_of,
        'AudioDecoderConfiguration' => \%AudioDecoderConfiguration_of,
        'Extension' => \%Extension_of,
    },
    {
        'AudioOutputConfiguration' => 'ONVIF::PTZ::Types::AudioOutputConfiguration',
        'AudioDecoderConfiguration' => 'ONVIF::PTZ::Types::AudioDecoderConfiguration',
        'Extension' => 'ONVIF::PTZ::Types::ProfileExtension2',
    },
    {

        'AudioOutputConfiguration' => 'AudioOutputConfiguration',
        'AudioDecoderConfiguration' => 'AudioDecoderConfiguration',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::ProfileExtension

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ProfileExtension from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * AudioOutputConfiguration


=item * AudioDecoderConfiguration


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::ProfileExtension
   AudioOutputConfiguration =>  { # ONVIF::PTZ::Types::AudioOutputConfiguration
     OutputToken => $some_value, # ReferenceToken
     SendPrimacy =>  $some_value, # anyURI
     OutputLevel =>  $some_value, # int
   },
   AudioDecoderConfiguration =>  { # ONVIF::PTZ::Types::AudioDecoderConfiguration
   },
   Extension =>  { # ONVIF::PTZ::Types::ProfileExtension2
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

