package ONVIF::Media::Types::MediaUri;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Uri_of :ATTR(:get<Uri>);
my %InvalidAfterConnect_of :ATTR(:get<InvalidAfterConnect>);
my %InvalidAfterReboot_of :ATTR(:get<InvalidAfterReboot>);
my %Timeout_of :ATTR(:get<Timeout>);

__PACKAGE__->_factory(
    [ qw(        Uri
        InvalidAfterConnect
        InvalidAfterReboot
        Timeout

    ) ],
    {
        'Uri' => \%Uri_of,
        'InvalidAfterConnect' => \%InvalidAfterConnect_of,
        'InvalidAfterReboot' => \%InvalidAfterReboot_of,
        'Timeout' => \%Timeout_of,
    },
    {
        'Uri' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
        'InvalidAfterConnect' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'InvalidAfterReboot' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'Timeout' => 'SOAP::WSDL::XSD::Typelib::Builtin::duration',
    },
    {

        'Uri' => 'Uri',
        'InvalidAfterConnect' => 'InvalidAfterConnect',
        'InvalidAfterReboot' => 'InvalidAfterReboot',
        'Timeout' => 'Timeout',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::MediaUri

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
MediaUri from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Uri


=item * InvalidAfterConnect


=item * InvalidAfterReboot


=item * Timeout




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::MediaUri
   Uri =>  $some_value, # anyURI
   InvalidAfterConnect =>  $some_value, # boolean
   InvalidAfterReboot =>  $some_value, # boolean
   Timeout =>  $some_value, # duration
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

