package ONVIF::Media::Types::DateTime;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Time_of :ATTR(:get<Time>);
my %Date_of :ATTR(:get<Date>);

__PACKAGE__->_factory(
    [ qw(        Time
        Date

    ) ],
    {
        'Time' => \%Time_of,
        'Date' => \%Date_of,
    },
    {
        'Time' => 'ONVIF::Media::Types::Time',
        'Date' => 'ONVIF::Media::Types::Date',
    },
    {

        'Time' => 'Time',
        'Date' => 'Date',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::DateTime

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
DateTime from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Time


=item * Date




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::DateTime
   Time =>  { # ONVIF::Media::Types::Time
     Hour =>  $some_value, # int
     Minute =>  $some_value, # int
     Second =>  $some_value, # int
   },
   Date =>  { # ONVIF::Media::Types::Date
     Year =>  $some_value, # int
     Month =>  $some_value, # int
     Day =>  $some_value, # int
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

