package WSDiscovery10::Types::EndpointReferenceType;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'http://schemas.xmlsoap.org/ws/2004/08/addressing' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Address_of :ATTR(:get<Address>);
my %ReferenceProperties_of :ATTR(:get<ReferenceProperties>);
my %ReferenceParameters_of :ATTR(:get<ReferenceParameters>);
my %PortType_of :ATTR(:get<PortType>);
my %ServiceName_of :ATTR(:get<ServiceName>);

__PACKAGE__->_factory(
    [ qw(        Address
        ReferenceProperties
        ReferenceParameters
        PortType
        ServiceName

    ) ],
    {
        'Address' => \%Address_of,
        'ReferenceProperties' => \%ReferenceProperties_of,
        'ReferenceParameters' => \%ReferenceParameters_of,
        'PortType' => \%PortType_of,
        'ServiceName' => \%ServiceName_of,
    },
    {
        'Address' => 'WSDiscovery10::Types::AttributedURI',
        'ReferenceProperties' => 'WSDiscovery10::Types::ReferencePropertiesType',
        'ReferenceParameters' => 'WSDiscovery10::Types::ReferenceParametersType',
        'PortType' => 'WSDiscovery10::Types::AttributedQName',
        'ServiceName' => 'WSDiscovery10::Types::ServiceNameType',
    },
    {

        'Address' => 'Address',
        'ReferenceProperties' => 'ReferenceProperties',
        'ReferenceParameters' => 'ReferenceParameters',
        'PortType' => 'PortType',
        'ServiceName' => 'ServiceName',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

WSDiscovery10::Types::EndpointReferenceType

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
EndpointReferenceType from the namespace http://schemas.xmlsoap.org/ws/2004/08/addressing.

If "Policy" elements from namespace "http://schemas.xmlsoap.org/ws/2002/12/policy#policy" are used, they must appear first (before any extensibility elements). 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Address


=item * ReferenceProperties


=item * ReferenceParameters


=item * PortType


=item * ServiceName




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # WSDiscovery10::Types::EndpointReferenceType
   Address =>  { value => $some_value },
   ReferenceProperties =>  { # WSDiscovery10::Types::ReferencePropertiesType
   },
   ReferenceParameters =>  { # WSDiscovery10::Types::ReferenceParametersType
   },
   PortType =>  { value => $some_value },
   ServiceName =>  { value => $some_value },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

