package ONVIF::Device::Types::DynamicDNSInformation;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Type_of :ATTR(:get<Type>);
my %Name_of :ATTR(:get<Name>);
my %TTL_of :ATTR(:get<TTL>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Type
        Name
        TTL
        Extension

    ) ],
    {
        'Type' => \%Type_of,
        'Name' => \%Name_of,
        'TTL' => \%TTL_of,
        'Extension' => \%Extension_of,
    },
    {
        'Type' => 'ONVIF::Device::Types::DynamicDNSType',
        'Name' => 'ONVIF::Device::Types::DNSName',
        'TTL' => 'SOAP::WSDL::XSD::Typelib::Builtin::duration',
        'Extension' => 'ONVIF::Device::Types::DynamicDNSInformationExtension',
    },
    {

        'Type' => 'Type',
        'Name' => 'Name',
        'TTL' => 'TTL',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::DynamicDNSInformation

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
DynamicDNSInformation from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Type


=item * Name


=item * TTL


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::DynamicDNSInformation
   Type => $some_value, # DynamicDNSType
   Name => $some_value, # DNSName
   TTL =>  $some_value, # duration
   Extension =>  { # ONVIF::Device::Types::DynamicDNSInformationExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

