/*
 * access.c
 *
 * Copyright (C) 1993 Alain Knaff
 */

#define _LARGEFILE64_SOURCE
#define _GNU_SOURCE

#include "sysincludes.h"

int access(__const char *file_name,int mode)
{
  int ret,ft;

  _zlibc_init();
  ret= zlib_real_access(file_name, mode);
  if ( ret >= 0 || errno != ENOENT )
    return ret;

  {
    char newname[MAXPATHLEN + MAXEXTLEN + 1];
    
    zlib_initialise();
    if ( zlib_mode & CM_DISAB )
      return ret;

    ft = zlib_getfiletype(file_name,-1);
    if ( zlib_mode & CM_VERBOSE )
      fprintf(stderr,"accessing %s %x\n", file_name,mode);
    if ((ft & PM_READ_MASK) == PM_LEAVE_COMPR)
      return ret;

    if (!(ft & (PM_CREATE_COMPR | PM_APPEND_COMPR | PM_UNCOMPR_BEFORE_WRITE)) &&
	(mode & W_OK))
      return ret;    
    
    strncpy(newname,file_name,1024);
    strcat(newname,zlib_ext);
    
    ret= zlib_real_access(newname, mode);
    if ( ret < 0 && errno == EINVAL )
      errno = ENOENT;
    return ret;
  }
}
