#import "TestSuiteTest.h"

#import "InheritedTestCase.h"
#import "NoTestCases.h"
#import "NotVoidTestCase.h"
#import "OneTestCase.h"

@implementation TestSuiteTest

+ (TestSuite *)suite {
    TestSuite *suite = [[[TestSuite alloc] initWithName:@"Test Suite"] autorelease];
    [suite addTest:[TestSuiteTest testWithName:@"testNoTestCases"]];
    [suite addTest:[TestSuiteTest testWithName:@"testOneTestCase"]];
    [suite addTest:[TestSuiteTest testWithName:@"testNotExistingTestCase"]];
    [suite addTest:[TestSuiteTest testWithName:@"testAddTestSuite"]];
    [suite addTest:[TestSuiteTest testWithName:@"testNotVoidTestCase"]];
    [suite addTest:[TestSuiteTest testWithName:@"testInheritedTestCase"]];
    return suite;
}

- (void)setUp {
    result = [[TestResult alloc] init];
}

- (void)tearDown {
    [result release];
}

- (void)testNoTestCases {
    id<Test> test = [TestSuite suiteWithClass:[NoTestCases class]];
    [test run:result];
    [self assertInt:[result numberOfTestsRun] equals:1];
    [self assertInt:[result numberOfFailures] equals:1];
    [self assertInt:[result numberOfErrors] equals:0];
    [self assertFalse:[result wasSuccessful]];
}

- (void)testOneTestCase {
    id<Test> test = [TestSuite suiteWithClass:[OneTestCase class]];
    [test run:result];
    [self assertInt:[result numberOfTestsRun] equals:1];
    [self assertInt:[result numberOfFailures] equals:0];
    [self assertInt:[result numberOfErrors] equals:0];
    [self assertTrue:[result wasSuccessful]];
}

- (void)testNotExistingTestCase {
    id<Test> test = [TestSuiteTest testWithName:@"notExistingMethod"];
    [test run:result];
    [self assertInt:[result numberOfTestsRun] equals:1];
    [self assertInt:[result numberOfFailures] equals:0];
    [self assertInt:[result numberOfErrors] equals:1];
    [self assertFalse:[result wasSuccessful]];
}

- (void)testAddTestSuite {
    TestSuite *suite = [[[TestSuite alloc] initWithName:@""] autorelease];
    [suite addTestSuite:[OneTestCase class]];
    [suite run:result];
    [self assertInt:[result numberOfTestsRun] equals:1];
}

- (void)testNotVoidTestCase {
    id<Test> test = [TestSuite suiteWithClass:[NotVoidTestCase class]];
    [self assertInt:[test countTestCases] equals:1];
}

- (void)testInheritedTestCase {
    id<Test> test = [TestSuite suiteWithClass:[InheritedTestCase class]];
    [self assertInt:[test countTestCases] equals:2];
}

@end
