/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.NoEndpointException;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.RouterPrx;
import IceInternal.Endpoint;
import IceUtil.Debug;
import java.util.Hashtable;

public final class RouterInfo {
    private RouterPrx _router;
    private Endpoint[] _clientEndpoints;
    private Endpoint[] _serverEndpoints;
    private ObjectAdapter _adapter;
    private Hashtable _identities;

    RouterInfo(RouterPrx routerPrx) {
        this._router = routerPrx;
        this._identities = new Hashtable();
    }

    public synchronized void destroy() {
        this._clientEndpoints = new Endpoint[0];
        this._serverEndpoints = new Endpoint[0];
        this._adapter = null;
        this._identities.clear();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RouterInfo) {
            return this._router.equals(((RouterInfo)object)._router);
        }
        return false;
    }

    public RouterPrx getRouter() {
        return this._router;
    }

    public synchronized Endpoint[] getClientEndpoints() {
        if (this._clientEndpoints == null) {
            ObjectPrx objectPrx = this._router.getClientProxy();
            if (objectPrx == null) {
                this._clientEndpoints = ((ObjectPrxHelperBase)((Object)this._router)).__reference().getEndpoints();
            } else {
                objectPrx = objectPrx.ice_router(null);
                objectPrx = objectPrx.ice_timeout(this._router.ice_getConnection().timeout());
                this._clientEndpoints = ((ObjectPrxHelperBase)objectPrx).__reference().getEndpoints();
            }
        }
        return this._clientEndpoints;
    }

    public synchronized Endpoint[] getServerEndpoints() {
        if (this._serverEndpoints == null) {
            ObjectPrx objectPrx = this._router.getServerProxy();
            if (objectPrx == null) {
                throw new NoEndpointException();
            }
            objectPrx = objectPrx.ice_router(null);
            this._serverEndpoints = ((ObjectPrxHelperBase)objectPrx).__reference().getEndpoints();
        }
        return this._serverEndpoints;
    }

    public void addProxy(ObjectPrx objectPrx) {
        Debug.Assert(objectPrx != null);
        if (!this._identities.containsKey(objectPrx.ice_getIdentity())) {
            ObjectPrx[] objectPrxArray = new ObjectPrx[]{objectPrx};
            ObjectPrx[] objectPrxArray2 = this._router.addProxies(objectPrxArray);
            this._identities.put(objectPrx.ice_getIdentity(), new Integer(0));
            for (int i = 0; i < objectPrxArray2.length; ++i) {
                this._identities.remove(objectPrxArray2[i].ice_getIdentity());
            }
        }
    }

    public synchronized void setAdapter(ObjectAdapter objectAdapter) {
        this._adapter = objectAdapter;
    }

    public synchronized ObjectAdapter getAdapter() {
        return this._adapter;
    }
}

