// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

package com.zeroc.IceGridGUI;

import javax.swing.JOptionPane;

public class MainProxy
{
    public static void main(final String[] args)
    {
        //
        // Save main arguments for later usage.
        //
        _args = java.util.Arrays.copyOf(args, args.length);

        if(System.getProperty("os.name").startsWith("Mac OS"))
        {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "IceGrid GUI");

            // To catch Command+Q
            System.setProperty("apple.eawt.quitStrategy", "CLOSE_ALL_WINDOWS");
        }

        String version =  System.getProperty("java.version");

        Class<?> cls = com.zeroc.IceInternal.Util.findClass("com.javafx.main.Main", null);
        if(cls != null && version.indexOf("1.7") == 0)
        {
            try
            {
                java.lang.reflect.Method main = cls.getMethod("main", new Class[]{String[].class});
                main.invoke(null, new Object[]{args});
                return;
            }
            catch(NoSuchMethodException ex)
            {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(
                    null, "Unable to find method `main(String[] args)' in class `com.javafx.main.Main'",
                    "IceGrid GUI Error", JOptionPane.ERROR_MESSAGE);
            }
            catch(IllegalAccessException ex)
            {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(
                    null,
                    "IllegalAccessException invoking method `main(String[] args)' in class `com.javafx.main.Main'",
                    "IceGrid GUI Error", JOptionPane.ERROR_MESSAGE);
            }
            catch(java.lang.reflect.InvocationTargetException ex)
            {
            }
        }
        cls = com.zeroc.IceInternal.Util.findClass("com.zeroc.IceGridGUI.Main", null);
        if(cls == null)
        {
            JOptionPane.showMessageDialog(null, "Unable to find class `com.zeroc.IceGridGUI.Main'",
                                          "IceGrid GUI Error", JOptionPane.ERROR_MESSAGE);
            return;
        }
        try
        {
            java.lang.reflect.Method main = cls.getMethod("main", new Class[]{String[].class});
            main.invoke(null, new Object[]{args});
            return;
        }
        catch(NoSuchMethodException ex)
        {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(
                null, "Unable to find method `main(String[] args)' in class `com.javafx.main.Main'",
                "IceGrid GUI Error", JOptionPane.ERROR_MESSAGE);
        }
        catch(IllegalAccessException ex)
        {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(
                null, "IllegalAccessException invoking method `main(String[] args)' in class `com.javafx.main.Main'",
                "IceGrid GUI Error", JOptionPane.ERROR_MESSAGE);
        }
        catch(java.lang.reflect.InvocationTargetException ex)
        {
        }
    }

    public static String[] args()
    {
        return _args;
    }

    private static String[] _args = new String[]{};
}
