<?php
return array(
	'maintenances' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'maintenanceid',
		'fields' => array(
			'maintenanceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'maintenance_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'description' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'active_since' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'active_till' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'hosts' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'hostid',
		'fields' => array(
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'proxy_hostid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
			'host' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'disable_until' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'error' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'available' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'errors_from' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'lastaccess' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ipmi_authtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ipmi_privilege' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			),
			'ipmi_username' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 16,
				'default' => '',
			),
			'ipmi_password' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 20,
				'default' => '',
			),
			'ipmi_disable_until' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ipmi_available' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmp_disable_until' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmp_available' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'maintenanceid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'maintenances',
				'ref_field' => 'maintenanceid',
			),
			'maintenance_status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'maintenance_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'maintenance_from' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ipmi_errors_from' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmp_errors_from' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ipmi_error' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'snmp_error' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'jmx_disable_until' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'jmx_available' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'jmx_errors_from' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'jmx_error' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'flags' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'templateid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
		),
	),
	'groups' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'groupid',
		'fields' => array(
			'groupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'internal' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'flags' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'group_prototype' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'group_prototypeid',
		'fields' => array(
			'group_prototypeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'groupid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			),
			'templateid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'group_prototype',
				'ref_field' => 'group_prototypeid',
			),
		),
	),
	'group_discovery' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'groupid',
		'fields' => array(
			'groupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			),
			'parent_group_prototypeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'group_prototype',
				'ref_field' => 'group_prototypeid',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'lastcheck' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ts_delete' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'screens' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'screenid',
		'fields' => array(
			'screenid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
			),
			'hsize' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'vsize' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'templateid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
		),
	),
	'screens_items' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'screenitemid',
		'fields' => array(
			'screenitemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'screenid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'screens',
				'ref_field' => 'screenid',
			),
			'resourcetype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'resourceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'width' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '320',
			),
			'height' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '200',
			),
			'x' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'y' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'colspan' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'rowspan' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'elements' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '25',
			),
			'valign' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'halign' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'style' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'url' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'dynamic' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'sort_triggers' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'application' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'slideshows' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'slideshowid',
		'fields' => array(
			'slideshowid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'delay' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'slides' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'slideid',
		'fields' => array(
			'slideid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'slideshowid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'slideshows',
				'ref_field' => 'slideshowid',
			),
			'screenid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'screens',
				'ref_field' => 'screenid',
			),
			'step' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'delay' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'drules' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'druleid',
		'fields' => array(
			'druleid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'proxy_hostid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'iprange' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'delay' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '3600',
			),
			'nextcheck' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'dchecks' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'dcheckid',
		'fields' => array(
			'dcheckid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'druleid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'drules',
				'ref_field' => 'druleid',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'key_' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'snmp_community' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'ports' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '0',
			),
			'snmpv3_securityname' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'snmpv3_securitylevel' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmpv3_authpassphrase' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'snmpv3_privpassphrase' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'uniq' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmpv3_authprotocol' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmpv3_privprotocol' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmpv3_contextname' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'applications' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'applicationid',
		'fields' => array(
			'applicationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'httptest' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'httptestid',
		'fields' => array(
			'httptestid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'applicationid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'applications',
				'ref_field' => 'applicationid',
			),
			'nextcheck' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'delay' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '60',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'variables' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'agent' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'authentication' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'http_user' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'http_password' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
			'templateid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'httptest',
				'ref_field' => 'httptestid',
			),
			'http_proxy' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'retries' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
		),
	),
	'httpstep' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'httpstepid',
		'fields' => array(
			'httpstepid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'httptestid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'httptest',
				'ref_field' => 'httptestid',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'no' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'url' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'timeout' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '30',
			),
			'posts' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'required' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'status_codes' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'variables' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
		),
	),
	'interface' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'interfaceid',
		'fields' => array(
			'interfaceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
			'main' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'useip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '127.0.0.1',
			),
			'dns' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'port' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '10050',
			),
		),
	),
	'valuemaps' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'valuemapid',
		'fields' => array(
			'valuemapid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
		),
	),
	'items' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'itemid',
		'fields' => array(
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmp_community' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'snmp_oid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'key_' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'delay' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'history' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '90',
			),
			'trends' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'trapper_hosts' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'units' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'multiplier' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'delta' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmpv3_securityname' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'snmpv3_securitylevel' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmpv3_authpassphrase' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'snmpv3_privpassphrase' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'formula' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '1',
			),
			'error' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'lastlogsize' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			),
			'logtimefmt' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'templateid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'valuemapid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'valuemaps',
				'ref_field' => 'valuemapid',
			),
			'delay_flex' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'params' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'ipmi_sensor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'data_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'authtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'username' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'password' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'publickey' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'privatekey' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'mtime' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'flags' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'filter' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'interfaceid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'interface',
				'ref_field' => 'interfaceid',
			),
			'port' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'description' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'inventory_link' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'lifetime' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '30',
			),
			'snmpv3_authprotocol' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmpv3_privprotocol' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'state' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'snmpv3_contextname' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'httpstepitem' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'httpstepitemid',
		'fields' => array(
			'httpstepitemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'httpstepid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'httpstep',
				'ref_field' => 'httpstepid',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'httptestitem' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'httptestitemid',
		'fields' => array(
			'httptestitemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'httptestid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'httptest',
				'ref_field' => 'httptestid',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'media_type' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'mediatypeid',
		'fields' => array(
			'mediatypeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'description' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			),
			'smtp_server' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'smtp_helo' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'smtp_email' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'exec_path' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'gsm_modem' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'username' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'passwd' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'users' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'userid',
		'fields' => array(
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'alias' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			),
			'surname' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			),
			'passwd' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => '',
			),
			'url' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'autologin' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'autologout' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '900',
			),
			'lang' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 5,
				'default' => 'en_GB',
			),
			'refresh' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '30',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'theme' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => 'default',
			),
			'attempt_failed' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
			),
			'attempt_ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'attempt_clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
			),
			'rows_per_page' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => 50,
			),
		),
	),
	'usrgrp' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'usrgrpid',
		'fields' => array(
			'usrgrpid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'gui_access' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'users_status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'debug_mode' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'users_groups' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'usrgrpid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'usrgrp',
				'ref_field' => 'usrgrpid',
			),
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			),
		),
	),
	'scripts' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'scriptid',
		'fields' => array(
			'scriptid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'command' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'host_access' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			),
			'usrgrpid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'usrgrp',
				'ref_field' => 'usrgrpid',
			),
			'groupid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			),
			'description' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'confirmation' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'execute_on' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
		),
	),
	'actions' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'actionid',
		'fields' => array(
			'actionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'eventsource' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'evaltype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'esc_period' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'def_shortdata' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'def_longdata' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'recovery_msg' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'r_shortdata' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'r_longdata' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
		),
	),
	'operations' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'operationid',
		'fields' => array(
			'operationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'actionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'actions',
				'ref_field' => 'actionid',
			),
			'operationtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'esc_period' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'esc_step_from' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'esc_step_to' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'evaltype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'opmessage' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'operationid',
		'fields' => array(
			'operationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			),
			'default_msg' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'subject' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'message' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'mediatypeid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'media_type',
				'ref_field' => 'mediatypeid',
			),
		),
	),
	'opmessage_grp' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'opmessage_grpid',
		'fields' => array(
			'opmessage_grpid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'operationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			),
			'usrgrpid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'usrgrp',
				'ref_field' => 'usrgrpid',
			),
		),
	),
	'opmessage_usr' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'opmessage_usrid',
		'fields' => array(
			'opmessage_usrid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'operationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			),
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			),
		),
	),
	'opcommand' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'operationid',
		'fields' => array(
			'operationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'scriptid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'scripts',
				'ref_field' => 'scriptid',
			),
			'execute_on' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'port' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'authtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'username' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'password' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'publickey' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'privatekey' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'command' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
		),
	),
	'opcommand_hst' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'opcommand_hstid',
		'fields' => array(
			'opcommand_hstid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'operationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			),
			'hostid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
		),
	),
	'opcommand_grp' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'opcommand_grpid',
		'fields' => array(
			'opcommand_grpid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'operationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			),
			'groupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			),
		),
	),
	'opgroup' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'opgroupid',
		'fields' => array(
			'opgroupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'operationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			),
			'groupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			),
		),
	),
	'optemplate' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'optemplateid',
		'fields' => array(
			'optemplateid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'operationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			),
			'templateid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
		),
	),
	'opconditions' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'opconditionid',
		'fields' => array(
			'opconditionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'operationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			),
			'conditiontype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'operator' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'conditions' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'conditionid',
		'fields' => array(
			'conditionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'actionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'actions',
				'ref_field' => 'actionid',
			),
			'conditiontype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'operator' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'config' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'configid',
		'fields' => array(
			'configid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'refresh_unsupported' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'work_period' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '1-5,00:00-24:00',
			),
			'alert_usrgrpid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'usrgrp',
				'ref_field' => 'usrgrpid',
			),
			'event_ack_enable' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'event_expire' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '7',
			),
			'event_show_max' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '100',
			),
			'default_theme' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => 'originalblue',
			),
			'authentication_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ldap_host' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'ldap_port' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => 389,
			),
			'ldap_base_dn' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'ldap_bind_dn' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'ldap_bind_password' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'ldap_search_attribute' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'dropdown_first_entry' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'dropdown_first_remember' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'discovery_groupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			),
			'max_in_table' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '50',
			),
			'search_limit' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1000',
			),
			'severity_color_0' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'DBDBDB',
			),
			'severity_color_1' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'D6F6FF',
			),
			'severity_color_2' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'FFF6A5',
			),
			'severity_color_3' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'FFB689',
			),
			'severity_color_4' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'FF9999',
			),
			'severity_color_5' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'FF3838',
			),
			'severity_name_0' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => 'Not classified',
			),
			'severity_name_1' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => 'Information',
			),
			'severity_name_2' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => 'Warning',
			),
			'severity_name_3' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => 'Average',
			),
			'severity_name_4' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => 'High',
			),
			'severity_name_5' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => 'Disaster',
			),
			'ok_period' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1800',
			),
			'blink_period' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1800',
			),
			'problem_unack_color' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'DC0000',
			),
			'problem_ack_color' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'DC0000',
			),
			'ok_unack_color' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '00AA00',
			),
			'ok_ack_color' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '00AA00',
			),
			'problem_unack_style' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'problem_ack_style' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'ok_unack_style' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'ok_ack_style' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'snmptrap_logging' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'server_check_interval' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '10',
			),
			'hk_events_mode' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'hk_events_trigger' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			),
			'hk_events_internal' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			),
			'hk_events_discovery' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			),
			'hk_events_autoreg' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			),
			'hk_services_mode' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'hk_services' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			),
			'hk_audit_mode' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'hk_audit' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			),
			'hk_sessions_mode' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'hk_sessions' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			),
			'hk_history_mode' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'hk_history_global' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'hk_history' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '90',
			),
			'hk_trends_mode' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'hk_trends_global' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'hk_trends' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			),
		),
	),
	'triggers' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'triggerid',
		'fields' => array(
			'triggerid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'expression' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'description' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'url' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'priority' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'lastchange' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'comments' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'error' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'templateid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'state' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'flags' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'trigger_depends' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'triggerdepid',
		'fields' => array(
			'triggerdepid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'triggerid_down' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			),
			'triggerid_up' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			),
		),
	),
	'functions' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'functionid',
		'fields' => array(
			'functionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'triggerid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			),
			'function' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 12,
				'default' => '',
			),
			'parameter' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '0',
			),
		),
	),
	'graphs' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'graphid',
		'fields' => array(
			'graphid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'width' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '900',
			),
			'height' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '200',
			),
			'yaxismin' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0',
			),
			'yaxismax' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '100',
			),
			'templateid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'graphs',
				'ref_field' => 'graphid',
			),
			'show_work_period' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'show_triggers' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'graphtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'show_legend' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'show_3d' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'percent_left' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0',
			),
			'percent_right' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0',
			),
			'ymin_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ymax_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ymin_itemid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'ymax_itemid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'flags' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'graphs_items' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'gitemid',
		'fields' => array(
			'gitemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'graphid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'graphs',
				'ref_field' => 'graphid',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'drawtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'sortorder' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'color' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '009600',
			),
			'yaxisside' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'calc_fnc' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'graph_theme' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'graphthemeid',
		'fields' => array(
			'graphthemeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'description' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'theme' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'backgroundcolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'F0F0F0',
			),
			'graphcolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'FFFFFF',
			),
			'graphbordercolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '222222',
			),
			'gridcolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'CCCCCC',
			),
			'maingridcolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'AAAAAA',
			),
			'gridbordercolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '000000',
			),
			'textcolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '202020',
			),
			'highlightcolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'AA4444',
			),
			'leftpercentilecolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '11CC11',
			),
			'rightpercentilecolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'CC1111',
			),
			'nonworktimecolor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'CCCCCC',
			),
			'gridview' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => 1,
			),
			'legendview' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => 1,
			),
		),
	),
	'globalmacro' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'globalmacroid',
		'fields' => array(
			'globalmacroid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'macro' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'hostmacro' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'hostmacroid',
		'fields' => array(
			'hostmacroid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
			'macro' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'hosts_groups' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'hostgroupid',
		'fields' => array(
			'hostgroupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
			'groupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			),
		),
	),
	'hosts_templates' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'hosttemplateid',
		'fields' => array(
			'hosttemplateid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
			'templateid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
		),
	),
	'items_applications' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'itemappid',
		'fields' => array(
			'itemappid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'applicationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'applications',
				'ref_field' => 'applicationid',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
		),
	),
	'mappings' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'mappingid',
		'fields' => array(
			'mappingid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'valuemapid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'valuemaps',
				'ref_field' => 'valuemapid',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'newvalue' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
		),
	),
	'media' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'mediaid',
		'fields' => array(
			'mediaid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			),
			'mediatypeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'media_type',
				'ref_field' => 'mediatypeid',
			),
			'sendto' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			),
			'active' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'severity' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '63',
			),
			'period' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '1-7,00:00-24:00',
			),
		),
	),
	'rights' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'rightid',
		'fields' => array(
			'rightid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'groupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'usrgrp',
				'ref_field' => 'usrgrpid',
			),
			'permission' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			),
		),
	),
	'services' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'serviceid',
		'fields' => array(
			'serviceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'algorithm' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'triggerid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			),
			'showsla' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'goodsla' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '99.9',
			),
			'sortorder' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'services_links' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'linkid',
		'fields' => array(
			'linkid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'serviceupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'services',
				'ref_field' => 'serviceid',
			),
			'servicedownid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'services',
				'ref_field' => 'serviceid',
			),
			'soft' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'services_times' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'timeid',
		'fields' => array(
			'timeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'serviceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'services',
				'ref_field' => 'serviceid',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ts_from' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ts_to' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'note' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'icon_map' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'iconmapid',
		'fields' => array(
			'iconmapid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'default_iconid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'images',
				'ref_field' => 'imageid',
			),
		),
	),
	'icon_mapping' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'iconmappingid',
		'fields' => array(
			'iconmappingid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'iconmapid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'icon_map',
				'ref_field' => 'iconmapid',
			),
			'iconid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'images',
				'ref_field' => 'imageid',
			),
			'inventory_link' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'expression' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'sortorder' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'sysmaps' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'sysmapid',
		'fields' => array(
			'sysmapid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'width' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '600',
			),
			'height' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '400',
			),
			'backgroundid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'images',
				'ref_field' => 'imageid',
			),
			'label_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			),
			'label_location' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'highlight' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'expandproblem' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'markelements' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'show_unack' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'grid_size' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '50',
			),
			'grid_show' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'grid_align' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
			'label_format' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'label_type_host' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			),
			'label_type_hostgroup' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			),
			'label_type_trigger' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			),
			'label_type_map' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			),
			'label_type_image' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			),
			'label_string_host' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'label_string_hostgroup' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'label_string_trigger' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'label_string_map' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'label_string_image' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'iconmapid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'icon_map',
				'ref_field' => 'iconmapid',
			),
			'expand_macros' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'severity_min' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'sysmaps_elements' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'selementid',
		'fields' => array(
			'selementid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'sysmapid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'sysmaps',
				'ref_field' => 'sysmapid',
			),
			'elementid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'elementtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'iconid_off' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'images',
				'ref_field' => 'imageid',
			),
			'iconid_on' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'images',
				'ref_field' => 'imageid',
			),
			'label' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
			'label_location' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '-1',
			),
			'x' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'y' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'iconid_disabled' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'images',
				'ref_field' => 'imageid',
			),
			'iconid_maintenance' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'images',
				'ref_field' => 'imageid',
			),
			'elementsubtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'areatype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'width' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '200',
			),
			'height' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '200',
			),
			'viewtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'use_iconmap' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			),
		),
	),
	'sysmaps_links' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'linkid',
		'fields' => array(
			'linkid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'sysmapid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'sysmaps',
				'ref_field' => 'sysmapid',
			),
			'selementid1' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'sysmaps_elements',
				'ref_field' => 'selementid',
			),
			'selementid2' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'sysmaps_elements',
				'ref_field' => 'selementid',
			),
			'drawtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'color' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '000000',
			),
			'label' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			),
		),
	),
	'sysmaps_link_triggers' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'linktriggerid',
		'fields' => array(
			'linktriggerid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'linkid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'sysmaps_links',
				'ref_field' => 'linkid',
			),
			'triggerid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			),
			'drawtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'color' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '000000',
			),
		),
	),
	'sysmap_element_url' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'sysmapelementurlid',
		'fields' => array(
			'sysmapelementurlid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'selementid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'sysmaps_elements',
				'ref_field' => 'selementid',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
			),
			'url' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'sysmap_url' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'sysmapurlid',
		'fields' => array(
			'sysmapurlid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'sysmapid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'sysmaps',
				'ref_field' => 'sysmapid',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
			),
			'url' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'elementtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'maintenances_hosts' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'maintenance_hostid',
		'fields' => array(
			'maintenance_hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'maintenanceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'maintenances',
				'ref_field' => 'maintenanceid',
			),
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
		),
	),
	'maintenances_groups' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'maintenance_groupid',
		'fields' => array(
			'maintenance_groupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'maintenanceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'maintenances',
				'ref_field' => 'maintenanceid',
			),
			'groupid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			),
		),
	),
	'timeperiods' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'timeperiodid',
		'fields' => array(
			'timeperiodid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'timeperiod_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'every' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'month' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'dayofweek' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'day' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'start_time' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'period' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'start_date' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'maintenances_windows' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'maintenance_timeperiodid',
		'fields' => array(
			'maintenance_timeperiodid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'maintenanceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'maintenances',
				'ref_field' => 'maintenanceid',
			),
			'timeperiodid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'timeperiods',
				'ref_field' => 'timeperiodid',
			),
		),
	),
	'regexps' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'regexpid',
		'fields' => array(
			'regexpid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'test_string' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
		),
	),
	'expressions' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'expressionid',
		'fields' => array(
			'expressionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'regexpid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'regexps',
				'ref_field' => 'regexpid',
			),
			'expression' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'expression_type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'exp_delimiter' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 1,
				'default' => '',
			),
			'case_sensitive' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'nodes' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'nodeid',
		'fields' => array(
			'nodeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '0',
			),
			'ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'port' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '10051',
			),
			'nodetype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'masterid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'ref_table' => 'nodes',
				'ref_field' => 'nodeid',
			),
		),
	),
	'node_cksum' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => '',
		'fields' => array(
			'nodeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'ref_table' => 'nodes',
				'ref_field' => 'nodeid',
			),
			'tablename' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'recordid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'cksumtype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'cksum' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'sync' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
		),
	),
	'ids' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'nodeid,table_name,field_name',
		'fields' => array(
			'nodeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'ref_table' => 'nodes',
				'ref_field' => 'nodeid',
			),
			'table_name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'field_name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'nextid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
		),
	),
	'alerts' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'alertid',
		'fields' => array(
			'alertid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'actionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'actions',
				'ref_field' => 'actionid',
			),
			'eventid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'events',
				'ref_field' => 'eventid',
			),
			'userid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'mediatypeid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'media_type',
				'ref_field' => 'mediatypeid',
			),
			'sendto' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			),
			'subject' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'message' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'retries' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'error' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'esc_step' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'alerttype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'history' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => '',
		'fields' => array(
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0.0000',
			),
			'ns' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'history_sync' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
			),
			'nodeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'ref_table' => 'nodes',
				'ref_field' => 'nodeid',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0.0000',
			),
			'ns' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'history_uint' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => '',
		'fields' => array(
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			),
			'ns' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'history_uint_sync' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
			),
			'nodeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'ref_table' => 'nodes',
				'ref_field' => 'nodeid',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			),
			'ns' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'history_str' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => '',
		'fields' => array(
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'ns' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'history_str_sync' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
			),
			'nodeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'ref_table' => 'nodes',
				'ref_field' => 'nodeid',
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'ns' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'history_log' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'timestamp' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'source' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'severity' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'logeventid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ns' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'history_text' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'ns' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'proxy_history' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'timestamp' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'source' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'severity' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'logeventid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ns' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'state' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'proxy_dhistory' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'druleid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'drules',
				'ref_field' => 'druleid',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'port' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'key_' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'dcheckid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'dchecks',
				'ref_field' => 'dcheckid',
			),
			'dns' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
		),
	),
	'events' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'eventid',
		'fields' => array(
			'eventid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'source' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'object' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'objectid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'acknowledged' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ns' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'trends' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'itemid,clock',
		'fields' => array(
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'num' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value_min' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0.0000',
			),
			'value_avg' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0.0000',
			),
			'value_max' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0.0000',
			),
		),
	),
	'trends_uint' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'itemid,clock',
		'fields' => array(
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'num' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value_min' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			),
			'value_avg' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			),
			'value_max' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			),
		),
	),
	'acknowledges' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'acknowledgeid',
		'fields' => array(
			'acknowledgeid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			),
			'eventid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'events',
				'ref_field' => 'eventid',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'message' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'auditlog' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'auditid',
		'fields' => array(
			'auditid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'action' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'resourcetype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'details' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '0',
			),
			'ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'resourceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'resourcename' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'auditlog_details' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'auditdetailid',
		'fields' => array(
			'auditdetailid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'auditid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'auditlog',
				'ref_field' => 'auditid',
			),
			'table_name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'field_name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'oldvalue' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'newvalue' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
		),
	),
	'service_alarms' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'servicealarmid',
		'fields' => array(
			'servicealarmid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'serviceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'services',
				'ref_field' => 'serviceid',
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'autoreg_host' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'autoreg_hostid',
		'fields' => array(
			'autoreg_hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'proxy_hostid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
			'host' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'listen_ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'listen_port' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'listen_dns' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'host_metadata' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'proxy_autoreg_host' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'id',
		'fields' => array(
			'id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
			),
			'clock' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'host' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'listen_ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'listen_port' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'listen_dns' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'host_metadata' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'dhosts' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'dhostid',
		'fields' => array(
			'dhostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'druleid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'drules',
				'ref_field' => 'druleid',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'lastup' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'lastdown' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'dservices' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'dserviceid',
		'fields' => array(
			'dserviceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'dhostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'dhosts',
				'ref_field' => 'dhostid',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'key_' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'port' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'lastup' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'lastdown' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'dcheckid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'dchecks',
				'ref_field' => 'dcheckid',
			),
			'ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'dns' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
		),
	),
	'escalations' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'escalationid',
		'fields' => array(
			'escalationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'actionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'actions',
				'ref_field' => 'actionid',
			),
			'triggerid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			),
			'eventid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'events',
				'ref_field' => 'eventid',
			),
			'r_eventid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'events',
				'ref_field' => 'eventid',
			),
			'nextcheck' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'esc_step' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'itemid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
		),
	),
	'globalvars' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'globalvarid',
		'fields' => array(
			'globalvarid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'snmp_lastsize' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'graph_discovery' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'graphdiscoveryid',
		'fields' => array(
			'graphdiscoveryid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'graphid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'graphs',
				'ref_field' => 'graphid',
			),
			'parent_graphid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'graphs',
				'ref_field' => 'graphid',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
		),
	),
	'host_inventory' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'hostid',
		'fields' => array(
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
			'inventory_mode' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'type_full' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'alias' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'os' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'os_full' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'os_short' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'serialno_a' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'serialno_b' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'tag' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'asset_tag' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'macaddress_a' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'macaddress_b' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'hardware' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'hardware_full' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'software' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'software_full' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'software_app_a' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'software_app_b' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'software_app_c' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'software_app_d' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'software_app_e' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'contact' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'location' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'location_lat' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 16,
				'default' => '',
			),
			'location_lon' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 16,
				'default' => '',
			),
			'notes' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'chassis' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'model' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'hw_arch' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => '',
			),
			'vendor' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'contract_number' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'installer_name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'deployment_status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'url_a' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'url_b' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'url_c' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'host_networks' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'host_netmask' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'host_router' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'oob_ip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'oob_netmask' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'oob_router' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			),
			'date_hw_purchase' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'date_hw_install' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'date_hw_expiry' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'date_hw_decomm' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'site_address_a' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'site_address_b' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'site_address_c' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'site_city' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'site_state' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'site_country' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'site_zip' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'site_rack' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'site_notes' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'poc_1_name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'poc_1_email' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'poc_1_phone_a' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'poc_1_phone_b' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'poc_1_cell' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'poc_1_screen' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'poc_1_notes' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
			'poc_2_name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'poc_2_email' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			),
			'poc_2_phone_a' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'poc_2_phone_b' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'poc_2_cell' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'poc_2_screen' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'poc_2_notes' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			),
		),
	),
	'housekeeper' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'housekeeperid',
		'fields' => array(
			'housekeeperid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'tablename' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'field' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'value' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'value',
			),
		),
	),
	'images' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'imageid',
		'fields' => array(
			'imageid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'imagetype' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '0',
			),
			'image' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_BLOB,
				'length' => 2048,
				'default' => '',
			),
		),
	),
	'item_discovery' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'itemdiscoveryid',
		'fields' => array(
			'itemdiscoveryid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'parent_itemid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'key_' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'lastcheck' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ts_delete' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'host_discovery' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'hostid',
		'fields' => array(
			'hostid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
			'parent_hostid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			),
			'parent_itemid' => array(
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			),
			'host' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			),
			'lastcheck' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'ts_delete' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'interface_discovery' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'interfaceid',
		'fields' => array(
			'interfaceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'interface',
				'ref_field' => 'interfaceid',
			),
			'parent_interfaceid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'interface',
				'ref_field' => 'interfaceid',
			),
		),
	),
	'profiles' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'profileid',
		'fields' => array(
			'profileid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			),
			'idx' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 96,
				'default' => '',
			),
			'idx2' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'value_id' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			),
			'value_int' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'value_str' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'source' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 96,
				'default' => '',
			),
			'type' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'sessions' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'sessionid',
		'fields' => array(
			'sessionid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => '',
			),
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			),
			'lastaccess' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'status' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
	'trigger_discovery' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'triggerdiscoveryid',
		'fields' => array(
			'triggerdiscoveryid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'triggerid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			),
			'parent_triggerid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			),
			'name' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'user_history' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => 'userhistoryid',
		'fields' => array(
			'userhistoryid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'userid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			),
			'title1' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'url1' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'title2' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'url2' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'title3' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'url3' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'title4' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'url4' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'title5' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
			'url5' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			),
		),
	),
	'application_template' => array(
		'type' => DB::TABLE_TYPE_CONFIG,
		'key' => 'application_templateid',
		'fields' => array(
			'application_templateid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			),
			'applicationid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'applications',
				'ref_field' => 'applicationid',
			),
			'templateid' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'applications',
				'ref_field' => 'applicationid',
			),
		),
	),
	'dbversion' => array(
		'type' => DB::TABLE_TYPE_HISTORY,
		'key' => '',
		'fields' => array(
			'mandatory' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
			'optional' => array(
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			),
		),
	),
);
?>
