/*
 * @(#)OctGLP.h
 *
 * Copyright 2023 - 2024  David A. Bagley, bagleyd AT verizon.net
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for OctGL */

#ifndef _OctGLP_h
#define _OctGLP_h

#include "OctGL.h"
#include <GL/gl.h>
#include <GL/glu.h>
#ifndef WINVER
#include <GL/glx.h>

/* This gets around C's inability to do inheritance */
typedef struct _OctGLClassPart {
	int ignore;
} OctGLClassPart;

typedef struct _OctGLClassRec {
	CoreClassPart coreClass;
	OctClassPart octClass;
	OctGLClassPart octGLClass;
} OctGLClassRec;

extern OctGLClassRec octGLClassRec;
#endif

#define MAX_SIZE w->oct.size
#define LAST (w->oct.size-1)
#define FIRST 0
#define SCALE (float) (2.1/MAX_SIZE)

#define TOP_FACE 0
#define RIGHT_FACE 1
#define BOTTOM_FACE 2
#define LEFT_FACE 3
#define TOP_BACK 4
#define RIGHT_BACK 5
#define BOTTOM_BACK 6
#define LEFT_BACK 7
#define BORDER_FACE (MAX_FACES)
#define NO_FACE (MAX_FACES+1)
#define NO_EDGE 24
#define NO_POSITION (IGNORE_DIR)
#define NO_ROTATION (2*MAX_ORIENT)
#define NO_DEPTH (IGNORE_DIR)
#define NO_STYLE (IGNORE_DIR)
#define REV(a) (MAX_SIZE-a-1)
#define MAX_TURN_INC 10

#define FACET_LENGTH (float) 0.5
#define SELECT_LENGTH2 (float) 0.5
#define STICKER_LENGTH2 (float) 0.485

#define FACET_TETRA (FACET_LENGTH-(float) 0.02)
#define STICKER_TETRA2 (FACET_TETRA-(float) 0.04)
#define STICKER_TETRA3 (STICKER_TETRA2-(float) 0.04)
#define SELECT_TETRA2 (STICKER_TETRA2-(float) 0.04)
#define SELECT_TETRA3 (STICKER_TETRA3-(float) 0.06)

#define BAR_WIDTH (FACET_LENGTH*(float) 0.05)
#define GAP_WIDTH (FACET_LENGTH*(float) 0.15)
#define GAP_WIDTH2 (FACET_LENGTH*(float) 0.2)

#define FACET_OCTA (FACET_LENGTH*(float) 1.90)
#define STICKER_OCTA2 (FACET_LENGTH*(float) 1.85)
#define SELECT_OCTA2 (FACET_LENGTH*(float) 1.81)

#define STICKER_LONG (FACET_TETRA-(float) 0.05)
#define STICKER_SHORT (STICKER_LONG-(float) 0.05)
#define STICKER_HALF ((STICKER_SHORT)*(float) 0.5)
#define STICKER_DEPTH (FACET_LENGTH+(float) 0.01)
#define SELECT_LONG (float) (4.5*FACET_TETRA/5.0-0.05)
#define SELECT_SHORT (float) (3.5*STICKER_LONG/5.0-0.05)
#define CUT (float) 0.04
#define CUT2 (float) 0.02
#define CUT_DEPTH (STICKER_DEPTH+(float) 0.001)
#define SELECT_DEPTH (STICKER_DEPTH+(float) 0.002)

typedef struct _OctMove {
	int         face, direction;
	int         position;
	int         style;
	Boolean     control;
} OctMove;

typedef struct _OctSlice {
	int         edge, rotation;
} OctSlice;

typedef struct _OctGLPart {
	double      angleStep;
	double      rotateStep;
	int         numTurnInc;
	Position    faceDiagonal;
	Position    cubeDiagonalx, cubeDiagonaly, cubeDiagonalz;
	/*Point       cubeSizex, cubeSizey, cubeSizez;*/
	Point       faceSize, viewSize;
	Point       viewMiddle;
	OctMove     movement;
	int         step;
} OctGLPart;

typedef struct _OctGLRec {
	CorePart    core;
	OctPart     oct;
	OctGLPart   octGL;
} OctGLRec;

extern Boolean selectPiecesGL(OctGLWidget w, int x, int y,
	int *face, int *position);
extern Boolean narrowSelectionGL(OctGLWidget w, int style,
	int *face, int *position, int *direction);
/*extern void drawFrameGL(OctGLWidget w, Boolean focus);*/
extern void drawAllPiecesGL(OctGLWidget w);
/*extern void moveAllPiecesGL(OctGLWidget w, int face, int direction,
	int style, int fast);*/
extern void movePiecesGL(OctGLWidget w, int face, int position,
	int direction, int style, Boolean control, int fast);
#ifdef WINVER
extern void resizePuzzleGL(OctGLWidget w);
extern void exposePuzzleGL(OctGLWidget w);
#endif

#endif /* _OctGLP_h */
