/* xkeycaps, Copyright (c) 1997, 1999 Jamie Zawinski <jwz@jwz.org>
 *
 * This file describes the key surfaces of the Micron
 * Transport Trek2 notebook keyboard interface.
 * By Alan Ho <alanho@princeton.edu>
 */

static const struct key_strings trek_caps [] = {

 /* Row 0 */

 {"Esc", 0, 0}, {"F1", 0, 0}, {"F2", 0, 0}, {"F3", 0, 0}, {"F4", 0, 0},
 {"F5", 0, 0}, {"F6", 0, 0}, {"F7", 0, 0}, {"F8", 0, 0}, {"F9", 0, 0},
 {"F10", 0, 0}, {"F11", 0, 0}, {"F12", 0, 0}, {"Pause", "Break", 0}, 
 {"PrtSc", "SysRq", 0}, {"Ins", "Num", 0}, {"Del", "ScrLk", 0},

 /* Row 2 */

 {"~", "`", 0}, {"!", "1", 0}, {"@", "2", 0}, {"#", "3", 0}, {"$", "4", 0},
 {"%", "5", 0}, {"^", "6", 0}, {"&", "7", "7"}, {"*", "8", "8"},
 {"(", "9", "9"}, {")", "0", "*"}, {"_", "-", 0}, {"+", "=", 0},
 {"Backspace", 0, 0}, {"Home", 0, 0},

 /* Row 3 */
 {"Tab", 0, 0}, {"Q", 0, 0}, {"W", 0, 0}, {"E", 0, 0}, {"R", 0, 0},
 {"T", 0, 0}, {"Y", 0, 0}, {"U", 0, "4"}, {"I", 0, "5"}, {"O", 0, "6"},
 {"P", 0, "-"}, {"{", "[", 0}, {"}", "]", 0}, {"|", "\\", 0}, {"PgUp", 0, 0},

 /* Row 4 */

 {"Caps", "Lock", 0}, {"A", 0, 0}, {"S", 0, 0}, {"D", 0, 0}, {"F", 0, 0},
 {"G", 0, 0}, {"H", 0, 0}, {"J", 0, "1"}, {"K", 0, "2"}, {"L", 0, "3"},
 {":", ";", 0}, {"\"", "'", 0}, {"Enter", 0, 0}, {"PgDn", 0, 0},

 /* Row 5 */

 {"Shift", 0, 0},  {"Z", 0, 0}, {"X", 0, 0}, {"C", 0, 0}, {"V", 0, 0},
 {"B", 0, 0}, {"N", 0, 0}, {"M", 0, "0"}, {"<", ", ", "0"}, {">", ".", "."},
 {"?", "/", "/"}, {"Shift", 0, 0}, {"UpArrow", 0, 0}, {"End", 0, 0},

 /* Row 6 */

 {"Fn", 0, 0}, {"Ctrl", 0, 0}, {"MS", 0, 0}, {"Alt", 0, 0}, {" ", 0, 0},
 {"Alt", 0, 0}, {"MS2", 0, 0}, {"MS3", 0, 0}, {"LeftArrow", 0, 0},
 {"DownArrow", 0, 0}, {"RightArrow", 0, 0}
};

