#include "udposix.h"

#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>

#include "uthread.h"


    int
nanosleep(rqtp, rmtp)
    const struct timespec     *rqtp;
    struct timespec           *rmtp;
{
    struct timeval	timeout;

    timeout.tv_sec	= rqtp->tv_sec;
    timeout.tv_usec	= rqtp->tv_nsec / 1000;

    if (select(0, (fd_set*)0, (fd_set*)0, (fd_set*)0, &timeout) == 0)
	return 0;

    if (rmtp)
    {
	rmtp->tv_sec = timeout.tv_sec;
	rmtp->tv_nsec = timeout.tv_usec * 1000;
    }

    return -1;
}
