#ifdef HAVE_XENSTORE

#include <stdio.h>
#include <stdlib.h>

#include <xs.h>

#include "xs_tools.h"

/* ------------------------------------------------------------- */

struct xs_handle *xenstore_open(int daemon, int domain,
				int readonly_ok, int verbose)
{
    struct xs_handle *xenstore = NULL;

    if (NULL == xenstore && daemon && readonly_ok) {
	xenstore = xs_daemon_open_readonly();
	if (NULL == xenstore)
	    fprintf(stderr,"can't connect to %s\n",xs_daemon_socket_ro());
	else
	    if (verbose)
		printf("connected to %s\n", xs_daemon_socket_ro());
    }

    if (NULL == xenstore && daemon) {
	xenstore = xs_daemon_open();
	if (NULL == xenstore)
	    fprintf(stderr,"can't connect to %s\n",xs_daemon_socket());
	else
	    if (verbose)
		printf("connected to %s\n", xs_daemon_socket());
    }

    if (NULL == xenstore && domain) {
	xenstore = xs_domain_open();
	if (NULL == xenstore)
	    fprintf(stderr, "can't connect to %s\n", xs_domain_dev());
	else
	    if (verbose)
		printf("connected to %s\n", xs_domain_dev());
    }
    return xenstore;
}

int xenstore_read(struct xs_handle *xenstore, char *path, char *dst, size_t size)
{
    xs_transaction_t xst;
    char *xs_value = NULL;

    xst = xs_transaction_start(xenstore);
    if (!xst)
	return -1;

    xs_value = xs_read(xenstore, xst, path, NULL);
    xs_transaction_end(xenstore, xst, 0);
    if (NULL == xs_value)
	return -2;
    snprintf(dst, size, "%s", xs_value);
    free(xs_value);
    return 0;
}

#endif /* HAVE_XENSTORE */
