# Copyright (c) 2012 Linaro Ltd.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

import os
import subprocess
import unittest

import utils


@unittest.skipUnless(utils.file_on_path('pep8', os.environ['PATH']),
                     "pep8 not found")
class TestPep8(unittest.TestCase):
    def test_pep8(self):
        # ignore return code
        proc = subprocess.Popen(
            ['pep8', '--repeat', '.'],
            stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        (stdout, stderr) = proc.communicate()
        self.assertEqual(b'', stdout)
        self.assertEqual(b'', stderr)
