/* fileviewerbg.hh
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2010 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef FILEVIEWERBG_HH
#define FILEVIEWERBG_HH

#include "wdefines.h"
#include <string>
#include <list>
#include <aguix/refcount.hh>
#include <aguix/backgroundmessagehandler.hh>

class FileViewerDestroyCallback;
class TextStorageFile;
class TextView;
class SearchTextStorage;

class FileViewerBG : public BackgroundMessageHandler
{
public:
    ~FileViewerBG();
    
    void view( const std::list<std::string> &filelist,
               int initial_line_number = 0,
               bool highlight_initial_line = false,
               RefCount< FileViewerDestroyCallback > destroy_callback = NULL );
    void setLineWrap( bool nv );
    bool getLineWrap() const;
    void setShowLineNumbers( bool nv );
    bool getShowLineNumbers() const;
    
    void handleAGUIXMessage( AGMessage &msg );
protected:
    friend class FileViewer;

    FileViewerBG();
    FileViewerBG( const FileViewerBG &other );
    FileViewerBG &operator=( const FileViewerBG &other );

    AWindow *getAWindow();
private:
    std::list< std::string > m_filelist;
    RefCount< FileViewerDestroyCallback > m_destroy_callback;
    AWindow *win;
    bool m_wrap_mode;
    bool m_showlinenumbers_mode;
    TextStorageFile *ts;
    TextView *tv;
    RefCount<SearchTextStorage> ts_search;
    StringGadget *search_sg;
    Button *okb;
    ChooseButton *wcb;
    ChooseButton *slncb;
    Button *jumplineb;
    Button *readmoreb;

    int buildTextView( const std::string &filename,
                       class AContainer *ac1,
                       class Text *fnt,
                       const RefCount<class AWidth> &lencalc );
    void jumpToLine();
    void nextMatch();
};

#endif
