/* pathjumpui.hh
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2012 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef PATHJUMPUI_HH
#define PATHJUMPUI_HH

#include "wdefines.h"
#include <memory>
#include <string>
#include <list>
#include <vector>

class DeepPathStore;
class Button;
class FieldListView;
class Text;
class AGUIX;
class SolidButton;
class AContainer;
class Worker;
class PrefixDB;
class ChooseButton;
class CycleButton;
class Worker;

class PathJumpUI
{
public:
    PathJumpUI( AGUIX &aguix, DeepPathStore &path_store, Worker &worker );
    ~PathJumpUI();

    int mainLoop();
    std::string getSelectedPath();

    void setCurrentDirname( const std::string &dirname );
    void setCurrentBasename( const std::string &basename );
private:
    AGUIX &m_aguix;
    Worker &m_worker;
    DeepPathStore &m_path_store;

    std::string m_dirname, m_basename;
    std::string m_filter;
    std::string m_selected_path;
    
    std::auto_ptr<class AWindow> m_win;
    FieldListView *m_lv;
    Text *m_infixtext;
    Button *m_okb;
    Button *m_cancelb;
    Button *m_cleanupb;
    AContainer *m_co1;
    ChooseButton *m_show_all_cb;
    CycleButton *m_filter_mode_cyb;

    typedef enum {
        PATH_HIDE,
        PATH_SHOW,
        BOOKMARK_HIDE,
        BOOKMARK_SHOW,
        BOOKMARK_MATCHED,
        BOOKMARK_FLEXIBLE_MATCHED
    } entry_visibility_t;

    struct pathjump_entry {
        entry_visibility_t m_type;
        int m_blockcount;
        std::string m_path;
        bool m_post_filtering;

        pathjump_entry( entry_visibility_t type,
                        int blockcount,
                        const std::string &path ) : m_type( type ),
                                                    m_blockcount( blockcount ),
                                                    m_path( path ),
                                                    m_post_filtering( true )
        {}

        bool operator<( const pathjump_entry &rhs )
        {
            if ( m_blockcount < rhs.m_blockcount ) return true;
            else if ( m_blockcount == rhs.m_blockcount ) {
                if ( m_path < rhs.m_path ) return true;
            }

            return false;
        }
    };

    std::list< pathjump_entry > m_entries;
    AContainer *m_breadcrumb_co;
    std::vector< Button * > m_breadcrumb_buttons;
    int m_current_depth;
    std::vector< std::string > m_current_components;
    std::list< std::string > m_bookmarks;
    std::auto_ptr< PrefixDB > m_pdb;

    bool m_show_hidden_entries;

    typedef enum {
        SHOW_ALL,
        SHOW_ONLY_SUBDIRS,
        SHOW_ONLY_DIRECT_SUBDIRS
    } entry_filter_mode_t;

    entry_filter_mode_t m_entry_filter_mode;

    std::string m_current_entry;

    bool m_lv_dirty;

    std::vector< std::string > m_entry_fullnames;

    void showData();
    void maximizeWin();

    int apply_filter( const std::string &filter );
    int update_breadcrumb();

    void highlight_best_hit( const std::string &filter );

    int find_best_matching_depth( const std::string &filter );
    int find_best_matching_depth( const std::string &path,
                                  const std::string &filter );
    int build_current_path_components();
    int build_current_path_components( const std::string &path );

    int post_filtering();

    int find_entry( const std::string &name, const std::string &filter );
    int set_entry( const std::string &name );

    int cleanup();
};

#endif
