/* packet-dcerpc-cds_clerkserver.c
 *
 * Routines for cds_clerkserver  dissection
 * Routines for dcerpc Afs4Int dissection
 * Copyright 2002, Jaime Fournier <Jaime.Fournier@hush.com>
 * This information is based off the released idl files from opengroup.
 * ftp://ftp.opengroup.org/pub/dce122/dce/src/directory.tar.gz directory/cds/stubs/cds_clerkserver.idl
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "config.h"


#include <epan/packet.h>
#include "packet-dcerpc.h"

void proto_register_cds_clerkserver (void);
void proto_reg_handoff_cds_clerkserver (void);

static int proto_cds_clerkserver = -1;
static int hf_cds_clerkserver_opnum = -1;


static gint ett_cds_clerkserver = -1;


static e_guid_t uuid_cds_clerkserver = { 0x257df1c9, 0xc6d3, 0x11ca, { 0x85, 0x54, 0x08, 0x00, 0x2b, 0x1c, 0x8f, 0x1f } };
static guint16  ver_cds_clerkserver = 1;



static dcerpc_sub_dissector cds_clerkserver_dissectors[] = {
	{  0, "AddReplica",             NULL, NULL},
	{  1, "AllowClearinghouses",    NULL, NULL},
	{  2, "Combine",                NULL, NULL},
	{  3, "CreateChild",            NULL, NULL},
	{  4, "CreateDirectory",        NULL, NULL},
	{  5, "CreateSoftLink",         NULL, NULL},
	{  6, "CreateObject",           NULL, NULL},
	{  7, "DeleteChild",            NULL, NULL},
	{  8, "DeleteObject",           NULL, NULL},
	{  9, "DeleteSoftLink",         NULL, NULL},
	{ 10, "DeleteDirectory",        NULL, NULL},
	{ 11, "DisallowClearinghouses", NULL, NULL},
	{ 12, "DoUpdate",               NULL, NULL},
	{ 13, "EnumerateAttributes",    NULL, NULL},
	{ 14, "EnumerateChildren",      NULL, NULL},
	{ 15, "EnumerateObjects",       NULL, NULL},
	{ 16, "EnumerateSoftLinks",     NULL, NULL},
	{ 17, "LinkReplica",            NULL, NULL},
	{ 18, "ModifyAttribute",        NULL, NULL},
	{ 19, "ModifyReplica",          NULL, NULL},
	{ 20, "NewEpoch",               NULL, NULL},
	{ 21, "ReadAttribute",          NULL, NULL},
	{ 22, "RemoveReplica",          NULL, NULL},
	{ 23, "ResolveName",            NULL, NULL},
	{ 24, "Skulk",                  NULL, NULL},
	{ 25, "TestAttribute",          NULL, NULL},
	{ 26, "TestGroup",              NULL, NULL},
	{ 0, NULL, NULL, NULL }
};

void
proto_register_cds_clerkserver (void)
{
	static hf_register_info hf[] = {
	  { &hf_cds_clerkserver_opnum,
	    { "Operation", "cds_clerkserver.opnum", FT_UINT16, BASE_DEC,
	      NULL, 0x0, NULL, HFILL }}
	};

	static gint *ett[] = {
		&ett_cds_clerkserver,
	};
	proto_cds_clerkserver = proto_register_protocol ("CDS Clerk Server Calls", "CDS_CLERK", "cds_clerkserver");
	proto_register_field_array (proto_cds_clerkserver, hf, array_length (hf));
	proto_register_subtree_array (ett, array_length (ett));
}

void
proto_reg_handoff_cds_clerkserver (void)
{
	/* Register the protocol as dcerpc */
	dcerpc_init_uuid (proto_cds_clerkserver, ett_cds_clerkserver, &uuid_cds_clerkserver, ver_cds_clerkserver, cds_clerkserver_dissectors, hf_cds_clerkserver_opnum);
}

/*
 * Editor modelines  -  http://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 8
 * tab-width: 8
 * indent-tabs-mode: t
 * End:
 *
 * vi: set shiftwidth=8 tabstop=8 noexpandtab:
 * :indentSize=8:tabSize=8:noTabs=false:
 */
