#
# $Id$
#
# - Try to find GModule2 
# Find GModule headers, libraries and the answer to all questions.
#
#  GMODULE2_FOUND               True if GMODULE2 got found
#  GMODULE2_INCLUDE_DIRS        Location of GMODULE2 headers 
#  GMODULE2_LIBRARIES           List of libraries to use GMODULE2 
#
#  Copyright (c) 2008 Bjoern Ricks <bjoern.ricks@googlemail.com>
#
#  Redistribution and use is allowed according to the terms of the New
#  BSD license.
#  For details see the accompanying COPYING-CMAKE-SCRIPTS file.
#

INCLUDE( FindPkgConfig )

IF ( GMODULE2_FIND_REQUIRED )
	SET( _pkgconfig_REQUIRED "REQUIRED" )
ELSE( GMODULE2_FIND_REQUIRED )
	SET( _pkgconfig_REQUIRED "" )	
ENDIF ( GMODULE2_FIND_REQUIRED )

IF ( GMODULE2_MIN_VERSION )
	PKG_SEARCH_MODULE( GMODULE2 ${_pkgconfig_REQUIRED} gmodule-2.0>=${GMODULE2_MIN_VERSION} )
ELSE ( GMODULE2_MIN_VERSION )
	PKG_SEARCH_MODULE( GMODULE2 ${_pkgconfig_REQUIRED} gmodule-2.0 )
ENDIF ( GMODULE2_MIN_VERSION )


IF( NOT GMODULE2_FOUND AND NOT PKG_CONFIG_FOUND )
	FIND_PATH( GMODULE2_INCLUDE_DIRS gmodule.h PATH_SUFFIXES glib-2.0 )

	IF ( APPLE )
		FIND_LIBRARY( GMODULE2_LIBRARIES glib )
	ELSE ( APPLE )
		FIND_LIBRARY( GMODULE2_LIBRARIES NAMES gmodule-2.0 gmodule )
	ENDIF (APPLE)

	# Report results
	IF ( GMODULE2_LIBRARIES AND GMODULE2_INCLUDE_DIRS )	
		SET( GMODULE2_FOUND 1 )
		IF ( NOT GMODULE2_FIND_QUIETLY )
			MESSAGE( STATUS "Found GMODULE2: ${GMODULE2_LIBRARIES} ${GMODULE2_INCLUDE_DIRS}" )
		ENDIF ( NOT GMODULE2_FIND_QUIETLY )
	ELSE ( GMODULE2_LIBRARIES AND GMODULE2_INCLUDE_DIRS )	
		IF ( GMODULE2_FIND_REQUIRED )
			MESSAGE( SEND_ERROR "Could NOT find GMODULE2" )
		ELSE ( GMODULE2_FIND_REQUIRED )
			IF ( NOT GMODULE2_FIND_QUIETLY )
				MESSAGE( STATUS "Could NOT find GMODULE2" )	
			ENDIF ( NOT GMODULE2_FIND_QUIETLY )
		ENDIF ( GMODULE2_FIND_REQUIRED )
	ENDIF ( GMODULE2_LIBRARIES AND GMODULE2_INCLUDE_DIRS )
ENDIF( NOT GMODULE2_FOUND AND NOT PKG_CONFIG_FOUND )

MARK_AS_ADVANCED( GMODULE2_LIBRARIES GMODULE2_INCLUDE_DIRS )
