/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import ptolemy.gui.QueryListener;

public class Query
extends JPanel {
    public static final int DEFAULT_ENTRY_HEIGHT = 10;
    public static final int DEFAULT_ENTRY_WIDTH = 30;
    protected Color _background = null;
    protected GridBagConstraints _constraints;
    protected GridBagLayout _grid;
    protected Vector _listeners;
    private int _columns = 1;
    private Map _entries = new HashMap();
    private JPanel _entryPanel = new JPanel();
    private JScrollPane _entryScrollPane;
    private int _height = 10;
    private Map _labels = new HashMap();
    private Insets _leftPadding = new Insets(0, 10, 0, 0);
    private JTextArea _messageArea = null;
    private JScrollPane _messageScrollPane;
    private boolean _messageScrollPaneAdded = false;
    private Insets _noPadding = new Insets(0, 0, 0, 0);
    private Map _previous = new HashMap();
    private int _widgetsHeight = 20;
    private int _width = 30;

    public Query() {
        this._grid = new GridBagLayout();
        this._constraints = new GridBagConstraints();
        this._constraints.fill = 2;
        this._constraints.weightx = 1.0;
        this._constraints.anchor = 18;
        this._entryPanel.setLayout(this._grid);
        this.setLayout(new BoxLayout(this, 1));
        this._entryPanel.setAlignmentX(0.0f);
        this._messageArea = new JTextArea("");
        this._messageArea.setFont(new Font("SansSerif", 0, 12));
        this._messageArea.setEditable(false);
        this._messageArea.setLineWrap(true);
        this._messageArea.setWrapStyleWord(true);
        this._messageArea.setBackground(null);
        this._messageArea.setAlignmentX(0.0f);
        this._messageScrollPane = new JScrollPane(this._messageArea);
        this._messageScrollPane.setVerticalScrollBarPolicy(20);
        this._messageScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this._messageScrollPane.getViewport().setBackground(null);
        this._entryScrollPane = new JScrollPane(this._entryPanel);
        this._entryScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this._entryScrollPane.getViewport().setBackground(null);
        this._entryScrollPane.setBackground(null);
        this.add(this._entryScrollPane);
        this._entryPanel.setBackground(null);
    }

    public void addCheckBox(String string, String string2, boolean bl) {
        JLabel jLabel = new JLabel(string2 + ": ");
        jLabel.setBackground(this._background);
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setBackground(this._background);
        jCheckBox.setOpaque(false);
        jCheckBox.setSelected(bl);
        this._addPair(string, jLabel, jCheckBox, jCheckBox);
        jCheckBox.addItemListener(new QueryItemListener(string));
    }

    public void addChoice(String string, String string2, String[] stringArray, String string3) {
        this.addChoice(string, string2, stringArray, string3, false);
    }

    public void addChoice(String string, String string2, String[] stringArray, String string3, boolean bl) {
        this.addChoice(string, string2, stringArray, string3, bl, Color.white, Color.black);
    }

    public void addChoice(String string, String string2, String[] stringArray, String string3, boolean bl, final Color color, final Color color2) {
        JLabel jLabel = new JLabel(string2 + ": ");
        jLabel.setBackground(this._background);
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setEditable(bl);
        jComboBox.setEditor(new BasicComboBoxEditor(){

            public Component getEditorComponent() {
                Component component = super.getEditorComponent();
                component.setBackground(color);
                component.setForeground(color2);
                return component;
            }
        });
        jComboBox.setSelectedItem(string3);
        this._addPair(string, jLabel, jComboBox, jComboBox);
        jComboBox.addItemListener(new QueryItemListener(string));
    }

    public void addColorChooser(String string, String string2, String string3) {
        JLabel jLabel = new JLabel(string2 + ": ");
        jLabel.setBackground(this._background);
        QueryColorChooser queryColorChooser = new QueryColorChooser(string, string3);
        this._addPair(string, jLabel, queryColorChooser, queryColorChooser);
    }

    public void addDisplay(String string, String string2, String string3) {
        JLabel jLabel = new JLabel(string2 + ": ");
        jLabel.setBackground(this._background);
        JTextArea jTextArea = new JTextArea(string3, 1, 10);
        jTextArea.setEditable(false);
        jTextArea.setBackground(this._background);
        this._addPair(string, jLabel, jTextArea, jTextArea);
    }

    public void addFileChooser(String string, String string2, String string3, URI uRI, File file) {
        this.addFileChooser(string, string2, string3, uRI, file, true, false, Color.white, Color.black);
    }

    public void addFileChooser(String string, String string2, String string3, URI uRI, File file, boolean bl, boolean bl2) {
        this.addFileChooser(string, string2, string3, uRI, file, bl, bl2, Color.white, Color.black);
    }

    public void addFileChooser(String string, String string2, String string3, URI uRI, File file, Color color, Color color2) {
        this.addFileChooser(string, string2, string3, uRI, file, true, false, color, color2);
    }

    public void addFileChooser(String string, String string2, String string3, URI uRI, File file, boolean bl, boolean bl2, Color color, Color color2) {
        JLabel jLabel = new JLabel(string2 + ": ");
        jLabel.setBackground(this._background);
        QueryFileChooser queryFileChooser = new QueryFileChooser(string, string3, uRI, file, bl, bl2, color, color2);
        this._addPair(string, jLabel, queryFileChooser, queryFileChooser);
    }

    public void addLine(String string, String string2, String string3) {
        this.addLine(string, string2, string3, Color.white, Color.black);
    }

    public void addLine(String string, String string2, String string3, Color color, Color color2) {
        JLabel jLabel = new JLabel(string2 + ": ");
        jLabel.setBackground(this._background);
        JTextField jTextField = new JTextField(string3, this._width);
        jTextField.setBackground(color);
        jTextField.setForeground(color2);
        this._addPair(string, jLabel, jTextField, jTextField);
        jTextField.addActionListener(new QueryActionListener(string));
        jTextField.addFocusListener(new QueryFocusListener(string));
    }

    public void addPassword(String string, String string2, String string3) {
        this.addPassword(string, string2, string3, Color.white, Color.black);
    }

    public void addPassword(String string, String string2, String string3, Color color, Color color2) {
        JLabel jLabel = new JLabel(string2 + ": ");
        jLabel.setBackground(this._background);
        JPasswordField jPasswordField = new JPasswordField(string3, this._width);
        jPasswordField.setBackground(color);
        jPasswordField.setForeground(color2);
        this._addPair(string, jLabel, jPasswordField, jPasswordField);
        jPasswordField.addActionListener(new QueryActionListener(string));
        jPasswordField.addFocusListener(new QueryFocusListener(string));
    }

    public void addQueryListener(QueryListener queryListener) {
        if (this._listeners == null) {
            this._listeners = new Vector();
        }
        if (this._listeners.contains(queryListener)) {
            return;
        }
        this._listeners.add(queryListener);
    }

    public void addRadioButtons(String string, String string2, String[] stringArray, String string3) {
        JLabel jLabel = new JLabel(string2 + ": ");
        jLabel.setBackground(this._background);
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        JPanel jPanel = new JPanel(flowLayout);
        ButtonGroup buttonGroup = new ButtonGroup();
        QueryActionListener queryActionListener = new QueryActionListener(string);
        JRadioButton[] jRadioButtonArray = new JRadioButton[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            JRadioButton jRadioButton;
            jRadioButtonArray[i] = jRadioButton = new JRadioButton(stringArray[i]);
            jRadioButton.setBackground(this._background);
            jRadioButton.setOpaque(false);
            if (stringArray[i].equals(string3)) {
                jRadioButton.setSelected(true);
            }
            buttonGroup.add(jRadioButton);
            jPanel.add(jRadioButton);
            jRadioButton.addActionListener(queryActionListener);
        }
        this._addPair(string, jLabel, jPanel, jRadioButtonArray);
    }

    public void addSelectButtons(String string, String string2, String[] stringArray, Set hashSet) {
        JLabel jLabel = new JLabel(string2 + ": ");
        jLabel.setBackground(this._background);
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        JPanel jPanel = new JPanel(flowLayout);
        QueryActionListener queryActionListener = new QueryActionListener(string);
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        JRadioButton[] jRadioButtonArray = new JRadioButton[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            JRadioButton jRadioButton;
            jRadioButtonArray[i] = jRadioButton = new JRadioButton(stringArray[i]);
            jRadioButton.setBackground(this._background);
            jRadioButton.setOpaque(false);
            if (hashSet.contains(stringArray[i])) {
                jRadioButton.setSelected(true);
            }
            jPanel.add(jRadioButton);
            jRadioButton.addActionListener(queryActionListener);
        }
        this._addPair(string, jLabel, jPanel, jRadioButtonArray);
    }

    public void addSlider(String string, String string2, int n, int n2, int n3) throws IllegalArgumentException {
        JLabel jLabel = new JLabel(string2 + ": ");
        if (n2 > n3) {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        if (n > n3 || n < n2) {
            throw new IllegalArgumentException("Desired default value \"" + n + "\" does not fall " + "between the minimum and maximum.");
        }
        JSlider jSlider = new JSlider(n2, n3, n);
        this._addPair(string, jLabel, jSlider, jSlider);
        jSlider.addChangeListener(new SliderListener(string));
    }

    public void addTextArea(String string, String string2, String string3) {
        this.addTextArea(string, string2, string3, Color.white, Color.black, this._height, this._width);
    }

    public void addTextArea(String string, String string2, String string3, Color color, Color color2) {
        this.addTextArea(string, string2, string3, color, color2, this._height, this._width);
    }

    public void addTextArea(String string, String string2, String string3, Color color, Color color2, int n, int n2) {
        JLabel jLabel = new JLabel(string2 + ": ");
        jLabel.setBackground(this._background);
        JTextArea jTextArea = new JTextArea(string3, n, n2);
        jTextArea.setEditable(true);
        jTextArea.setBackground(color);
        jTextArea.setForeground(color2);
        QueryScrollPane queryScrollPane = new QueryScrollPane(jTextArea);
        this._addPair(string, jLabel, queryScrollPane, queryScrollPane);
        jTextArea.addFocusListener(new QueryFocusListener(string));
    }

    public boolean booleanValue(String string) throws NoSuchElementException, IllegalArgumentException {
        return this.getBooleanValue(string);
    }

    public double doubleValue(String string) throws IllegalArgumentException, NoSuchElementException, NumberFormatException {
        return this.getDoubleValue(string);
    }

    public boolean getBooleanValue(String string) throws NoSuchElementException, IllegalArgumentException {
        Object v = this._entries.get(string);
        if (v == null) {
            throw new NoSuchElementException("No item named \"" + string + "\" in the query box.");
        }
        if (v instanceof JToggleButton) {
            return ((JToggleButton)v).isSelected();
        }
        throw new IllegalArgumentException("Item named \"" + string + "\" is not a radio button, and hence does not have " + "a boolean value.");
    }

    public char[] getCharArrayValue(String string) throws NoSuchElementException, IllegalArgumentException {
        Object v = this._entries.get(string);
        if (v == null) {
            throw new NoSuchElementException("No item named \"" + string + "\" in the query box.");
        }
        if (v instanceof JPasswordField) {
            return ((JPasswordField)v).getPassword();
        }
        return this.getStringValue(string).toCharArray();
    }

    public double getDoubleValue(String string) throws IllegalArgumentException, NoSuchElementException, NumberFormatException {
        Object v = this._entries.get(string);
        if (v == null) {
            throw new NoSuchElementException("No item named \"" + string + " \" in the query box.");
        }
        if (v instanceof JPasswordField) {
            throw new IllegalArgumentException("For security reasons, calling getDoubleValue() on a password field is not permitted.  Instead, call getCharArrayValue()");
        }
        if (v instanceof JTextField) {
            return Double.valueOf(((JTextField)v).getText());
        }
        throw new IllegalArgumentException("Item named \"" + string + "\" is not a text line, and hence cannot be converted " + "to a double value.");
    }

    public int getIntValue(String string) throws IllegalArgumentException, NoSuchElementException, NumberFormatException {
        Object v = this._entries.get(string);
        if (v == null) {
            throw new NoSuchElementException("No item named \"" + string + " \" in the query box.");
        }
        if (v instanceof JPasswordField) {
            throw new IllegalArgumentException("For security reasons, calling getIntValue() on a password field is not permitted.  Instead, call getCharArrayValue()");
        }
        if (v instanceof JTextField) {
            return Integer.valueOf(((JTextField)v).getText());
        }
        if (v instanceof JSlider) {
            return ((JSlider)v).getValue();
        }
        if (v instanceof JComboBox) {
            return ((JComboBox)v).getSelectedIndex();
        }
        if (v instanceof JToggleButton[]) {
            JToggleButton[] jToggleButtonArray = (JToggleButton[])v;
            for (int i = 0; i < jToggleButtonArray.length; ++i) {
                if (!jToggleButtonArray[i].isSelected()) continue;
                return i;
            }
            return -1;
        }
        throw new IllegalArgumentException("Item named \"" + string + "\" is not a text line or slider, and hence " + "cannot be converted to " + "an integer value.");
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.width = Short.MAX_VALUE;
        return dimension;
    }

    public String getStringValue(String string) throws NoSuchElementException, IllegalArgumentException {
        Object v = this._entries.get(string);
        if (v == null) {
            throw new NoSuchElementException("No item named \"" + string + " \" in the query box.");
        }
        if (v instanceof JTextField) {
            return ((JTextField)v).getText();
        }
        if (v instanceof QueryColorChooser) {
            return ((QueryColorChooser)v).getSelectedColor();
        }
        if (v instanceof QueryFileChooser) {
            return ((QueryFileChooser)v).getSelectedFileName();
        }
        if (v instanceof JTextArea) {
            return ((JTextArea)v).getText();
        }
        if (v instanceof JToggleButton) {
            JToggleButton jToggleButton = (JToggleButton)v;
            if (jToggleButton.isSelected()) {
                return "true";
            }
            return "false";
        }
        if (v instanceof JSlider) {
            return "" + ((JSlider)v).getValue();
        }
        if (v instanceof JComboBox) {
            return (String)((JComboBox)v).getSelectedItem();
        }
        if (v instanceof JToggleButton[]) {
            JToggleButton[] jToggleButtonArray = (JToggleButton[])v;
            StringBuffer stringBuffer = null;
            for (int i = 0; i < jToggleButtonArray.length; ++i) {
                if (!jToggleButtonArray[i].isSelected()) continue;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(jToggleButtonArray[i].getText());
                    continue;
                }
                stringBuffer.append(", " + jToggleButtonArray[i].getText());
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            return stringBuffer.toString();
        }
        if (v instanceof QueryScrollPane) {
            return ((QueryScrollPane)v).getText();
        }
        throw new IllegalArgumentException("Query class cannot generate a string representation for entries of type " + v.getClass());
    }

    public int getTextHeight() {
        return this._height;
    }

    public int getTextWidth() {
        return this._width;
    }

    public int intValue(String string) throws IllegalArgumentException, NoSuchElementException, NumberFormatException {
        return this.getIntValue(string);
    }

    public void notifyListeners() {
        Iterator iterator = this._entries.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this._notifyListeners(string);
        }
    }

    public void removeQueryListener(QueryListener queryListener) {
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(queryListener);
    }

    public void set(String string, String string2) throws NoSuchElementException, IllegalArgumentException {
        Object v = this._entries.get(string);
        if (v == null) {
            throw new NoSuchElementException("No item named \"" + string + " \" in the query box.");
        }
        if (v instanceof JTextField) {
            ((JTextField)v).setText(string2);
        } else if (v instanceof JTextArea) {
            ((JTextArea)v).setText(string2);
        } else if (v instanceof QueryScrollPane) {
            ((QueryScrollPane)v).setText(string2);
        } else if (v instanceof JToggleButton) {
            Boolean bl = Boolean.valueOf(string2);
            this.setBoolean(string, bl);
        } else if (v instanceof JSlider) {
            Integer n = Integer.valueOf(string2);
            ((JSlider)v).setValue(n);
        } else if (v instanceof JComboBox) {
            ((JComboBox)v).setSelectedItem(string2);
        } else if (v instanceof JToggleButton[]) {
            HashSet<String> hashSet = new HashSet<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken().trim());
            }
            JToggleButton[] jToggleButtonArray = (JToggleButton[])v;
            for (int i = 0; i < jToggleButtonArray.length; ++i) {
                if (hashSet.contains(jToggleButtonArray[i].getText())) {
                    jToggleButtonArray[i].setSelected(true);
                    continue;
                }
                jToggleButtonArray[i].setSelected(false);
            }
        } else if (v instanceof QueryColorChooser) {
            ((QueryColorChooser)v).setColor(string2);
        } else if (v instanceof QueryFileChooser) {
            ((QueryFileChooser)v).setFileName(string2);
        } else {
            throw new IllegalArgumentException("Query class cannot set a string representation for entries of type " + v.getClass());
        }
        this._previous.put(string, string2);
    }

    public void setAndNotify(String string, String string2) throws NoSuchElementException, IllegalArgumentException {
        this.set(string, string2);
        this._notifyListeners(string);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this._background = color;
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof JTextField) continue;
            componentArray[i].setBackground(this._background);
        }
    }

    public void setBoolean(String string, boolean bl) throws NoSuchElementException, IllegalArgumentException {
        Object v = this._entries.get(string);
        if (v == null) {
            throw new NoSuchElementException("No item named \"" + string + "\" in the query box.");
        }
        if (!(v instanceof JToggleButton)) {
            throw new IllegalArgumentException("Item named \"" + string + "\" is not a radio button, and hence does not have " + "a boolean value.");
        }
        ((JToggleButton)v).setSelected(bl);
        this._notifyListeners(string);
    }

    public void setColumns(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Query.setColumns() requires a strictly positive argument.");
        }
        this._columns = n;
    }

    public void setDisplay(String string, String string2) throws NoSuchElementException, IllegalArgumentException {
        Object v = this._entries.get(string);
        if (v == null) {
            throw new NoSuchElementException("No item named \"" + string + " \" in the query box.");
        }
        if (!(v instanceof JTextArea)) {
            throw new IllegalArgumentException("Item named \"" + string + "\" is not a display, and hence cannot be set using " + "setDisplay().");
        }
        JTextArea jTextArea = (JTextArea)v;
        jTextArea.setText(string2);
        this._notifyListeners(string);
    }

    public void setEnabled(String string, boolean bl) {
        Object v = this._entries.get(string);
        if (v == null) {
            throw new NoSuchElementException("No item named \"" + string + " \" in the query box.");
        }
        if (v instanceof JComponent) {
            ((JComponent)v).setEnabled(bl);
        } else if (v instanceof JToggleButton[]) {
            JToggleButton[] jToggleButtonArray = (JToggleButton[])v;
            for (int i = 0; i < jToggleButtonArray.length; ++i) {
                jToggleButtonArray[i].setEnabled(bl);
            }
        }
    }

    public void setLine(String string, String string2) {
        Object v = this._entries.get(string);
        if (v == null) {
            throw new NoSuchElementException("No item named \"" + string + " \" in the query box.");
        }
        if (!(v instanceof JTextField)) {
            throw new IllegalArgumentException("Item named \"" + string + "\" is not a line, and hence cannot be set using " + "setLine().");
        }
        JTextField jTextField = (JTextField)v;
        jTextField.setText(string2);
        this._notifyListeners(string);
    }

    public void setMessage(String string) {
        if (!this._messageScrollPaneAdded) {
            this._messageScrollPaneAdded = true;
            this.add((Component)this._messageScrollPane, 1);
            this.add(Box.createRigidArea(new Dimension(0, 10)), 2);
        }
        this._messageArea.setText(string);
        int n = this._messageArea.getLineCount() + 1;
        if (n > 30) {
            n = 30;
        }
        this._messageArea.setRows(n);
        this._messageArea.setColumns(this._width);
        this.validate();
    }

    public void setSlider(String string, int n) {
        Object v = this._entries.get(string);
        if (v == null) {
            throw new NoSuchElementException("No item named \"" + string + " \" in the query box.");
        }
        if (!(v instanceof JSlider)) {
            throw new IllegalArgumentException("Item named \"" + string + "\" is not a slider, and hence cannot be set using " + "setSlider().");
        }
        JSlider jSlider = (JSlider)v;
        jSlider.setValue(n);
        this._notifyListeners(string);
    }

    public void setTextHeight(int n) {
        this._height = n;
    }

    public void setTextWidth(int n) {
        this._width = n;
    }

    public void setToolTip(String string, String string2) {
        JLabel jLabel = (JLabel)this._labels.get(string);
        if (jLabel != null) {
            jLabel.setToolTipText(string2);
        }
    }

    public static Color stringToColor(String string) {
        String[] stringArray = string.split("[{},]");
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 1.0f;
        try {
            int n = 0;
            while (stringArray[n].trim().equals("")) {
                ++n;
            }
            if (stringArray.length > n) {
                f = Float.parseFloat(stringArray[n]);
            }
            ++n;
            while (stringArray[n].trim().equals("")) {
                ++n;
            }
            if (stringArray.length > n) {
                f2 = Float.parseFloat(stringArray[n]);
            }
            ++n;
            while (stringArray[n].trim().equals("")) {
                ++n;
            }
            if (stringArray.length > n) {
                f3 = Float.parseFloat(stringArray[n]);
            }
            ++n;
            while (stringArray[n].trim().equals("")) {
                ++n;
            }
            if (stringArray.length > n) {
                f4 = Float.parseFloat(stringArray[n]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Color(f, f2, f3, f4);
    }

    public String stringValue(String string) throws NoSuchElementException, IllegalArgumentException {
        return this.getStringValue(string);
    }

    protected void _addPair(String string, JLabel jLabel, Component component, Object object) {
        this._constraints.gridwidth = 1;
        this._constraints.insets = this._leftPadding;
        this._grid.setConstraints(jLabel, this._constraints);
        this._entryPanel.add(jLabel);
        this._constraints.insets = this._noPadding;
        this._constraints.gridwidth = this._columns > 1 && (this._entries.size() + 1) % this._columns != 0 ? 1 : 0;
        this._grid.setConstraints(component, this._constraints);
        this._entryPanel.add(component);
        this._entries.put(string, object);
        this._labels.put(string, jLabel);
        this._previous.put(string, this.getStringValue(string));
        Dimension dimension = this._entryPanel.getPreferredSize();
        dimension.width += 25;
        this._widgetsHeight += component.getPreferredSize().height;
        dimension.height = this._widgetsHeight;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (dimension.height > toolkit.getScreenSize().height) {
            dimension.height = (int)((double)toolkit.getScreenSize().height * 0.75);
            this._entryScrollPane.setPreferredSize(dimension);
        }
        this._entryScrollPane.setPreferredSize(dimension);
        this._entryPanel.revalidate();
    }

    void _notifyListeners(String string) {
        if (this._listeners != null) {
            String string2 = (String)this._previous.get(string);
            String string3 = this.getStringValue(string);
            if (string3.equals(string2)) {
                return;
            }
            this._previous.put(string, string3);
            Enumeration enumeration = this._listeners.elements();
            while (enumeration.hasMoreElements()) {
                QueryListener queryListener = (QueryListener)enumeration.nextElement();
                queryListener.changed(string);
            }
        }
    }

    class SliderListener
    implements ChangeListener {
        private String _name;

        public SliderListener(String string) {
            this._name = string;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Query.this._notifyListeners(this._name);
        }
    }

    static class QueryScrollPane
    extends JScrollPane {
        public JTextArea textArea;

        QueryScrollPane(JTextArea jTextArea) {
            super(jTextArea);
            this.textArea = jTextArea;
        }

        public String getText() {
            String string = this.textArea.getText();
            return string;
        }

        public void setText(String string) {
            this.textArea.setText(string);
        }
    }

    class QueryItemListener
    implements ItemListener {
        private String _name;

        public QueryItemListener(String string) {
            this._name = string;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Query.this._notifyListeners(this._name);
        }
    }

    class QueryFocusListener
    implements FocusListener {
        private String _name;

        public QueryFocusListener(String string) {
            this._name = string;
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            Query.this._notifyListeners(this._name);
        }
    }

    class QueryFileChooser
    extends Box
    implements ActionListener {
        private URI _base;
        private JTextField _entryBox;
        private String _name;
        private File _startingDirectory;
        private boolean _allowFiles;
        private boolean _allowDirectories;

        public QueryFileChooser(String string, String string2, URI uRI, File file, boolean bl, boolean bl2) {
            this(string, string2, uRI, file, bl, bl2, Color.white, Color.black);
        }

        public QueryFileChooser(String string, String string2, URI uRI, File file, boolean bl, boolean bl2, Color color, Color color2) {
            super(0);
            this._base = uRI;
            this._startingDirectory = file;
            if (!bl && !bl2) {
                throw new IllegalArgumentException("QueryFileChooser: nothing to be chosen.");
            }
            this._allowFiles = bl;
            this._allowDirectories = bl2;
            this._entryBox = new JTextField(string2, Query.this._width);
            this._entryBox.setBackground(color);
            this._entryBox.setForeground(color2);
            JButton jButton = new JButton("Browse");
            jButton.addActionListener(this);
            this.add(this._entryBox);
            this.add(jButton);
            this._entryBox.addActionListener(new QueryActionListener(string));
            this._entryBox.addFocusListener(new QueryFocusListener(string));
            this._name = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(this._startingDirectory);
            jFileChooser.setApproveButtonText("Select");
            jFileChooser.setApproveButtonMnemonic('S');
            if (this._allowFiles && this._allowDirectories) {
                jFileChooser.setFileSelectionMode(2);
            } else if (this._allowFiles && !this._allowDirectories) {
                jFileChooser.setFileSelectionMode(0);
            } else if (!this._allowFiles && this._allowDirectories) {
                jFileChooser.setFileSelectionMode(1);
            } else {
                throw new RuntimeException("QueryFileChooser: nothing to be chosen.");
            }
            int n = jFileChooser.showOpenDialog(Query.this);
            if (n == 0) {
                if (this._base == null) {
                    try {
                        this._entryBox.setText(jFileChooser.getSelectedFile().getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        this._entryBox.setText(jFileChooser.getSelectedFile().getName());
                    }
                } else {
                    File file = jFileChooser.getSelectedFile();
                    try {
                        file = file.getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    URI uRI = this._base.relativize(file.toURI());
                    this._entryBox.setText(uRI.toString());
                }
                Query.this._notifyListeners(this._name);
            }
        }

        public String getSelectedFileName() {
            return this._entryBox.getText();
        }

        public void setFileName(String string) {
            this._entryBox.setText(string);
        }
    }

    class QueryColorChooser
    extends Box
    implements ActionListener {
        private JTextField _entryBox;
        private String _name;

        public QueryColorChooser(String string, String string2) {
            super(0);
            this._entryBox = new JTextField(string2, Query.this._width);
            JButton jButton = new JButton("Choose");
            jButton.addActionListener(this);
            this.add(this._entryBox);
            this.add(jButton);
            this._entryBox.addActionListener(new QueryActionListener(string));
            this._entryBox.addFocusListener(new QueryFocusListener(string));
            this._name = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getSelectedColor().trim();
            Color color = JColorChooser.showDialog(Query.this, "Choose Color", Query.stringToColor(string));
            if (color != null) {
                float[] fArray = color.getRGBComponents(null);
                StringBuffer stringBuffer = new StringBuffer("{");
                for (int i = 0; i < fArray.length; ++i) {
                    stringBuffer.append(fArray[i]);
                    if (i < fArray.length - 1) {
                        stringBuffer.append(",");
                        continue;
                    }
                    stringBuffer.append("}");
                }
                this._entryBox.setText(stringBuffer.toString());
                Query.this._notifyListeners(this._name);
            }
        }

        public String getSelectedColor() {
            return this._entryBox.getText();
        }

        public void setColor(String string) {
            this._entryBox.setText(string);
        }
    }

    class QueryActionListener
    implements ActionListener {
        private String _name;

        public QueryActionListener(String string) {
            this._name = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Query.this._notifyListeners(this._name);
        }
    }
}

