/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Image;
import java.util.Enumeration;
import rene.util.FileName;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.QuadricObject;

public class ImageObject
extends ConstructionObject {
    PointObject[] P;
    static Count N = new Count();
    String Filename;
    Image I;

    public ImageObject(Construction construction, PointObject[] pointObjectArray, String string) {
        super(construction);
        this.P = pointObjectArray;
        this.Filename = FileName.filename(string);
        this.updateText();
    }

    public String getTag() {
        return "Image";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        try {
            String[] stringArray = new String[this.P.length];
            for (int i = 0; i < this.P.length; ++i) {
                stringArray[i] = this.P[i].getName();
            }
            this.setText(ImageObject.textAny(Zirkel.name("text.image"), stringArray));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void validate() {
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        if (!this.Valid || this.mustHide(zirkelCanvas)) {
            return;
        }
        if (this.I == null) {
            this.I = zirkelCanvas.doLoadImage(this.Filename);
            if (this.I == null || this.I.getWidth(zirkelCanvas) == 0 || this.I.getHeight(zirkelCanvas) == 0) {
                this.Valid = false;
                return;
            }
            this.Valid = true;
        }
        if (this.P[1] == this.P[2] || this.P[0] == this.P[2]) {
            int n = this.I.getWidth(zirkelCanvas);
            int n2 = this.I.getWidth(zirkelCanvas);
            double d2 = this.P[1].getX() - this.P[0].getX();
            double d3 = this.P[1].getY() - this.P[0].getY();
            myGraphics.drawImage(this.I, zirkelCanvas.col(this.P[0].getX()), zirkelCanvas.row(this.P[0].getY()), zirkelCanvas.col(this.P[1].getX()), zirkelCanvas.row(this.P[1].getY()), zirkelCanvas.col(this.P[0].getX() + d3), zirkelCanvas.row(this.P[0].getY() - d2), zirkelCanvas);
        }
        myGraphics.drawImage(this.I, zirkelCanvas.col(this.P[0].getX()), zirkelCanvas.row(this.P[0].getY()), zirkelCanvas.col(this.P[1].getX()), zirkelCanvas.row(this.P[1].getY()), zirkelCanvas.col(this.P[2].getX()), zirkelCanvas.row(this.P[2].getY()), zirkelCanvas);
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        if (!this.displays(zirkelCanvas)) {
            return false;
        }
        return this.P[0].nearto(n, n2, zirkelCanvas) || this.P[1].nearto(n, n2, zirkelCanvas) || this.P[2].nearto(n, n2, zirkelCanvas);
    }

    public void edit(ZirkelCanvas zirkelCanvas) {
        new ObjectEditDialog(zirkelCanvas.getFrame(), "", this).setVisible(true);
        zirkelCanvas.repaint();
    }

    public void printArgs(XmlWriter xmlWriter) {
        for (int i = 0; i < this.P.length; ++i) {
            xmlWriter.printArg("point" + (i + 1), this.P[i].getName());
        }
        xmlWriter.printArg("filename", FileName.filename(this.Filename));
    }

    public Enumeration depending() {
        DL.reset();
        for (int i = 0; i < this.P.length; ++i) {
            DL.add(this.P[i]);
        }
        return DL.elements();
    }

    public void translate() {
        for (int i = 0; i < this.P.length; ++i) {
            this.P[i] = (PointObject)this.P[i].getTranslation();
        }
    }

    public ConstructionObject copy() {
        try {
            QuadricObject quadricObject = (QuadricObject)this.clone();
            this.setTranslation(quadricObject);
            quadricObject.P = new PointObject[this.P.length];
            for (int i = 0; i < this.P.length; ++i) {
                quadricObject.P[i] = this.P[i];
            }
            quadricObject.translateConditionals();
            quadricObject.translate();
            quadricObject.setName();
            quadricObject.updateText();
            quadricObject.setBreak(false);
            quadricObject.setTarget(false);
            return quadricObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean onlynearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return this.nearto(n, n2, zirkelCanvas);
    }

    public boolean hasUnit() {
        return false;
    }
}

