/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.LineConstructor;
import rene.zirkel.constructors.PointConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.MidpointObject;
import rene.zirkel.objects.PointObject;

public class MidpointConstructor
extends LineConstructor {
    public ConstructionObject create(Construction construction, PointObject pointObject, PointObject pointObject2) {
        return new MidpointObject(construction, pointObject, pointObject2);
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.P1 == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.midpoint.first", "Midpoint: Set the first point!"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.midpoint.second", "Midpoint: Set the second point!"));
        }
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        if (!this.testTree(xmlTree, "Midpoint")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        if (!xmlTag.hasParam("first") || !xmlTag.hasParam("second")) {
            throw new ConstructionException("Line points missing!");
        }
        try {
            PointObject pointObject = (PointObject)construction.find(xmlTag.getValue("first"));
            PointObject pointObject2 = (PointObject)construction.find(xmlTag.getValue("second"));
            MidpointObject midpointObject = new MidpointObject(construction, pointObject, pointObject2);
            PointConstructor.setType(xmlTag, midpointObject);
            this.setName(xmlTag, midpointObject);
            this.set(xmlTree, midpointObject);
            construction.add(midpointObject);
            this.setConditionals(xmlTree, construction, midpointObject);
        }
        catch (ConstructionException constructionException) {
            throw constructionException;
        }
        catch (Exception exception) {
            throw new ConstructionException("Midpoint points illegal!");
        }
        return true;
    }

    public String getPrompt() {
        return Zirkel.name("prompt.midpoint");
    }

    public String getTag() {
        return "Midpoint";
    }

    public void construct(Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
        if (n != 2) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        ConstructionObject constructionObject = construction.find(stringArray[0]);
        if (constructionObject == null) {
            throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[0]);
        }
        if (!(constructionObject instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[0]);
        }
        ConstructionObject constructionObject2 = construction.find(stringArray[1]);
        if (constructionObject2 == null) {
            throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[1]);
        }
        if (!(constructionObject2 instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[1]);
        }
        MidpointObject midpointObject = new MidpointObject(construction, (PointObject)constructionObject, (PointObject)constructionObject2);
        if (!string.equals("")) {
            midpointObject.setNameCheck(string);
        }
        construction.add(midpointObject);
        midpointObject.setDefaults();
    }
}

