/*
 * Decompiled with CFR 0.152.
 */
package rene.gui;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Vector;
import rene.dialogs.ItemEditor;
import rene.dialogs.ItemEditorElement;
import rene.dialogs.ItemPanel;
import rene.gui.ButtonAction;
import rene.gui.Global;
import rene.gui.KeyDictionary;
import rene.gui.KeyboardItem;
import rene.gui.MyTextField;

public class KeyboardPanel
extends ItemPanel
implements KeyListener {
    TextField MenuString;
    TextField ActionName;
    TextField CharKey;
    Checkbox Shift;
    Checkbox Control;
    Checkbox Alt;
    String Name = "";
    Choice C;
    ItemEditor E;

    public KeyboardPanel() {
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 1));
        this.MenuString = new MyTextField("", 30);
        panel.add(this.MenuString);
        this.MenuString.setEditable(false);
        this.ActionName = new MyTextField();
        panel.add(this.ActionName);
        this.ActionName.setEditable(false);
        this.CharKey = new MyTextField();
        panel.add(this.CharKey);
        this.CharKey.setEditable(false);
        this.CharKey.addKeyListener(this);
        this.Shift = new Checkbox(Global.name("keyeditor.shift"));
        panel.add(this.Shift);
        this.Control = new Checkbox(Global.name("keyeditor.control"));
        panel.add(this.Control);
        this.Alt = new Checkbox(Global.name("keyeditor.alt"));
        panel.add(this.Alt);
        this.add("Center", panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        Panel panel3 = new Panel();
        this.C = new Choice();
        if (Global.NormalFont != null) {
            this.C.setFont(Global.NormalFont);
        }
        panel3.add(this.C);
        this.C.add("-------------");
        panel2.add("Center", panel3);
        Panel panel4 = new Panel();
        panel4.add(new ButtonAction(this, Global.name("keyeditor.default"), "Default"));
        panel4.add(new ButtonAction(this, Global.name("keyeditor.none"), "None"));
        panel2.add("South", panel4);
        this.add("South", panel2);
    }

    public void setItemEditor(ItemEditor itemEditor) {
        this.E = itemEditor;
    }

    public void makeCommandChoice() {
        this.C.removeAll();
        this.C.add("");
        for (int i = 1; i <= 5; ++i) {
            String string = this.commandShortcut(i);
            this.C.add(i + ": " + string);
        }
        this.C.select(0);
    }

    public String commandShortcut(int n) {
        String string = "command." + n;
        Enumeration enumeration = this.E.getElements().elements();
        while (enumeration.hasMoreElements()) {
            KeyboardItem keyboardItem = (KeyboardItem)enumeration.nextElement();
            if (!keyboardItem.getMenuString().equals(string)) continue;
            return keyboardItem.shortcut();
        }
        return "";
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.Shift.setState(keyEvent.isShiftDown());
        this.Control.setState(keyEvent.isControlDown());
        this.Alt.setState(keyEvent.isAltDown());
        this.CharKey.setText(KeyDictionary.translate(keyEvent.getKeyCode()).toLowerCase());
        this.C.select(0);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void display(ItemEditorElement itemEditorElement) {
        KeyboardItem keyboardItem = (KeyboardItem)itemEditorElement;
        this.Name = keyboardItem.getName();
        this.MenuString.setText(keyboardItem.getMenuString());
        this.ActionName.setText(keyboardItem.getActionName());
        this.CharKey.setText(keyboardItem.getCharKey());
        this.MenuString.setText(keyboardItem.getMenuString());
        this.Shift.setState(keyboardItem.isShift());
        this.Control.setState(keyboardItem.isControl());
        this.Alt.setState(keyboardItem.isAlt());
        this.C.select(keyboardItem.getCommandType());
    }

    public ItemEditorElement getElement() {
        int n = this.C.getSelectedIndex();
        return new KeyboardItem(this.CharKey.getText(), this.MenuString.getText(), this.ActionName.getText(), this.Shift.getState(), this.Control.getState(), this.Alt.getState(), n);
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String string) {
        this.Name = string;
        this.MenuString.setText(string);
    }

    public void notifyChange(Vector vector, int n) {
        KeyboardItem keyboardItem = (KeyboardItem)vector.elementAt(n);
        String string = keyboardItem.keyDescription();
        for (int i = 0; i < vector.size(); ++i) {
            KeyboardItem keyboardItem2;
            if (i == n || !(keyboardItem2 = (KeyboardItem)vector.elementAt(i)).keyDescription().equals(string)) continue;
            vector.setElementAt(new KeyboardItem(keyboardItem2.getMenuString(), "none"), i);
        }
        if (keyboardItem.getMenuString().startsWith("command.")) {
            this.makeCommandChoice();
        }
    }

    public void doAction(String string) {
        if (string.equals("Default")) {
            String string2 = this.MenuString.getText();
            KeyboardItem keyboardItem = new KeyboardItem(string2, Global.name("key." + string2));
            this.CharKey.setText(keyboardItem.getCharKey());
            this.Shift.setState(keyboardItem.isShift());
            this.Control.setState(keyboardItem.isControl());
            this.Alt.setState(keyboardItem.isAlt());
        } else if (string.equals("None")) {
            this.CharKey.setText("none");
            this.Shift.setState(false);
            this.Control.setState(false);
            this.Alt.setState(false);
        } else {
            super.doAction(string);
        }
    }

    public boolean extra(Vector vector) {
        vector.removeAllElements();
        return true;
    }
}

