/*
 * Decompiled with CFR 0.152.
 */
import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.JCMPanel;
import edu.hws.jcm.awt.Tie;
import edu.hws.jcm.awt.VariableInput;
import edu.hws.jcm.awt.VariableSlider;
import edu.hws.jcm.data.Constant;
import edu.hws.jcm.data.Expression;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.SimpleFunction;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.data.ValueMath;
import edu.hws.jcm.data.Variable;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.DrawGeometric;
import edu.hws.jcm.draw.DrawString;
import edu.hws.jcm.draw.Graph1D;
import edu.hws.jcm.functions.WrapperFunction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.io.Serializable;
import java.util.StringTokenizer;

public class EpsilonDelta
extends GenericGraphApplet {
    private VariableInput xInput;
    private VariableInput epsilonInput;
    private VariableInput deltaInput;
    private VariableInput limitInput;
    private VariableSlider xSlider;
    private VariableSlider epsilonSlider;
    private VariableSlider deltaSlider;
    private VariableSlider limitSlider;
    private Controller subController;
    private Variable xValue;
    private Variable limitValue;
    private Function func;
    private Graph1D graph;

    @Override
    protected void setUpBottomPanel() {
        double d;
        double d2;
        super.setUpBottomPanel();
        this.subController = new Controller();
        this.mainController.add(this.subController);
        JCMPanel jCMPanel = new JCMPanel(3);
        this.subController.add(jCMPanel);
        jCMPanel.setBackground(this.getColorParam("PanelBackground", Color.lightGray));
        if (this.inputPanel == null) {
            this.mainPanel.add((Component)jCMPanel, "South");
        } else {
            this.inputPanel.add((Component)jCMPanel, "South");
        }
        JCMPanel jCMPanel2 = new JCMPanel(0, 1, 2);
        JCMPanel jCMPanel3 = new JCMPanel(0, 1, 2);
        JCMPanel jCMPanel4 = new JCMPanel(0, 1, 2);
        jCMPanel.add((Component)jCMPanel4, "Center");
        jCMPanel.add((Component)jCMPanel2, "West");
        jCMPanel.add((Component)jCMPanel3, "East");
        double[] dArray = this.getNumericParam("AValue");
        double d3 = d2 = dArray == null || dArray.length < 1 ? 0.0 : dArray[0];
        if ("yes".equalsIgnoreCase(this.getParameter("UseAInput", "yes"))) {
            this.xSlider = new VariableSlider();
            this.xInput = new VariableInput();
            this.xInput.setVal(d2);
            this.xSlider.setVal(d2);
            this.xInput.setThrowErrors(false);
            this.subController.add(new Tie(this.xSlider, this.xInput));
            this.xValue = this.xInput.getVariable();
            jCMPanel2.add(new Label("limit at a = ", 2));
            jCMPanel4.add(this.xSlider);
            jCMPanel3.add(this.xInput);
        } else {
            this.xValue = new Variable();
            this.xValue.setVal(d2);
        }
        dArray = this.getNumericParam("LimitValue");
        double d4 = d = dArray == null || dArray.length < 1 ? 1.0 : dArray[0];
        if ("yes".equalsIgnoreCase(this.getParameter("UseLimitInput", "yes"))) {
            this.limitSlider = new VariableSlider();
            this.limitInput = new VariableInput();
            this.limitInput.setVal(d);
            this.limitSlider.setVal(d);
            this.limitInput.setThrowErrors(false);
            this.subController.add(new Tie(this.limitSlider, this.limitInput));
            this.limitValue = this.limitInput.getVariable();
            jCMPanel2.add(new Label(" test limit L = ", 2));
            jCMPanel4.add(this.limitSlider);
            jCMPanel3.add(this.limitInput);
        } else {
            this.limitValue = new Variable();
            this.limitValue.setVal(d);
        }
        dArray = this.getNumericParam("EpsilonValue");
        double d5 = dArray == null || dArray.length < 1 ? 0.25 : dArray[0];
        this.epsilonSlider = new VariableSlider(new Constant(0.0), new Constant(2.0));
        this.epsilonInput = new VariableInput();
        this.epsilonInput.setVal(d5);
        this.epsilonSlider.setVal(d5);
        this.epsilonInput.setThrowErrors(false);
        this.subController.add(new Tie(this.epsilonSlider, this.epsilonInput));
        jCMPanel2.add(new Label("epsilon = ", 2));
        jCMPanel4.add(this.epsilonSlider);
        jCMPanel3.add(this.epsilonInput);
        dArray = this.getNumericParam("DeltaValue");
        double d6 = dArray == null || dArray.length < 1 ? 1.0 : dArray[0];
        this.deltaSlider = new VariableSlider(new Constant(0.0), new Constant(2.0));
        this.deltaInput = new VariableInput();
        this.deltaInput.setVal(d6);
        this.deltaSlider.setVal(d6);
        this.deltaInput.setThrowErrors(false);
        this.subController.add(new Tie(this.deltaSlider, this.deltaInput));
        jCMPanel2.add(new Label("delta = ", 2));
        jCMPanel4.add(this.deltaSlider);
        jCMPanel3.add(this.deltaInput);
    }

    @Override
    protected void setUpCanvas() {
        Serializable serializable;
        Object object;
        if (this.functionInput != null) {
            this.func = this.functionInput.getFunction(this.xVar);
        } else {
            object = this.getParameter("Function", "abs(" + this.xVar.getName() + ") ^ " + this.xVar.getName());
            serializable = new SimpleFunction((Expression)this.parser.parse((String)object), this.xVar);
            this.func = new WrapperFunction((Function)serializable);
        }
        this.graph = new Graph1D(this.func);
        this.graph.setColor(this.getColorParam("GraphColor", Color.black));
        object = new ValueMath(this.xValue, this.deltaInput, '-');
        serializable = new ValueMath(this.xValue, this.deltaInput, '+');
        ValueMath valueMath = new ValueMath(this.limitValue, this.epsilonInput, '-');
        ValueMath valueMath2 = new ValueMath(this.limitValue, this.epsilonInput, '+');
        Value value = this.canvas.getCoordinateRect().getValueObject(0);
        Value value2 = this.canvas.getCoordinateRect().getValueObject(1);
        Value value3 = this.canvas.getCoordinateRect().getValueObject(2);
        Value value4 = this.canvas.getCoordinateRect().getValueObject(3);
        if (this.xSlider != null) {
            this.xSlider.setMin(value);
            this.xSlider.setMax(value2);
        }
        if (this.limitSlider != null) {
            this.limitSlider.setMin(value3);
            this.limitSlider.setMax(value4);
        }
        DrawGeometric drawGeometric = new DrawGeometric(2, (Value)object, value3, (Value)serializable, value4);
        drawGeometric.setFillColor(new Color(225, 255, 225));
        drawGeometric.setLineWidth(0);
        DrawGeometric drawGeometric2 = new DrawGeometric(2, value, (Value)valueMath, value2, valueMath2);
        drawGeometric2.setFillColor(new Color(255, 230, 230));
        drawGeometric2.setLineWidth(0);
        DrawGeometric drawGeometric3 = new DrawGeometric(2, (Value)object, (Value)valueMath, (Value)serializable, valueMath2);
        drawGeometric3.setFillColor(new Color(255, 255, 225));
        drawGeometric3.setColor(Color.yellow);
        DrawGeometric drawGeometric4 = new DrawGeometric(0, (Value)this.xValue, value3, this.xValue, value4);
        drawGeometric4.setColor(new Color(130, 255, 130));
        DrawGeometric drawGeometric5 = new DrawGeometric(0, value, (Value)this.limitValue, value2, this.limitValue);
        drawGeometric5.setColor(new Color(255, 150, 150));
        this.canvas.add(drawGeometric);
        this.canvas.add(drawGeometric2);
        this.canvas.add(drawGeometric3);
        this.canvas.add(drawGeometric4);
        this.canvas.add(drawGeometric5);
        DrawString drawString = new DrawString("a = #\nL = #\nf(a) = #", 0, new Value[]{this.xValue, this.limitValue, new ValueMath(this.func, this.xValue)});
        drawString.setBackgroundColor(Color.white);
        drawString.setFrameWidth(1);
        this.subController.add(drawString);
        this.subController.add(drawGeometric);
        this.subController.add(drawGeometric2);
        this.subController.add(drawGeometric3);
        this.subController.add(drawGeometric4);
        this.subController.add(drawGeometric5);
        this.mainController.remove(this.canvas);
        this.mainController.add(this.graph);
        this.canvas.getCoordinateRect().setOnChange(this.mainController);
        this.deltaSlider.setOnUserAction(this.subController);
        this.epsilonSlider.setOnUserAction(this.subController);
        this.deltaInput.setOnTextChange(this.subController);
        this.epsilonInput.setOnTextChange(this.subController);
        this.subController.add(this.deltaSlider);
        this.subController.add(this.epsilonSlider);
        this.subController.add(this.deltaInput);
        this.subController.add(this.epsilonInput);
        if (this.xInput != null) {
            this.xSlider.setOnUserAction(this.subController);
            this.xInput.setOnTextChange(this.subController);
            this.subController.add(this.xSlider);
            this.subController.add(this.xInput);
        }
        if (this.limitInput != null) {
            this.limitSlider.setOnUserAction(this.subController);
            this.limitInput.setOnTextChange(this.subController);
            this.subController.add(this.limitSlider);
            this.subController.add(this.limitInput);
        }
        super.setUpCanvas();
        this.canvas.add(this.graph);
        this.canvas.add(drawString);
    }

    @Override
    protected void doLoadExample(String string) {
        Object object;
        int n = string.indexOf(";");
        double[] dArray = new double[]{-5.0, 5.0, -5.0, 5.0};
        if (n > 0) {
            int n2;
            object = string.substring(n + 1);
            string = string.substring(0, n);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, " ,");
            double[] dArray2 = new double[stringTokenizer.countTokens()];
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                try {
                    dArray2[n2] = new Double(stringTokenizer.nextToken());
                    continue;
                }
                catch (Exception exception) {
                    dArray2[n2] = Double.NaN;
                }
            }
            for (n2 = 0; n2 < 4; ++n2) {
                if (dArray2.length < n2 || Double.isNaN(dArray2[n2])) continue;
                dArray[n2] = dArray2[n2];
            }
            if (dArray2.length > 4 && !Double.isNaN(dArray2[4])) {
                this.xValue.setVal(dArray2[4]);
            } else {
                this.xValue.setVal((dArray[0] + dArray[1]) / 2.0);
            }
            if (dArray2.length > 5 && !Double.isNaN(dArray2[5])) {
                this.limitValue.setVal(dArray2[5]);
            } else {
                this.limitValue.setVal((dArray[0] + dArray[1]) / 2.0);
            }
            if (dArray2.length > 8 && !Double.isNaN(dArray2[8])) {
                this.epsilonSlider.setMax(new Constant(dArray2[8]));
            } else {
                this.epsilonSlider.setMax(new Constant(Math.abs(dArray[2] - dArray[3]) / 2.0));
            }
            if (dArray2.length > 9 && !Double.isNaN(dArray2[9])) {
                this.deltaSlider.setMax(new Constant(dArray2[9]));
            } else {
                this.deltaSlider.setMax(new Constant(Math.abs(dArray[0] - dArray[1]) / 2.0));
            }
            if (dArray2.length > 6 && !Double.isNaN(dArray2[6])) {
                this.epsilonInput.setVal(dArray2[6]);
                this.epsilonSlider.setVal(dArray2[6]);
            } else {
                this.epsilonInput.setVal(Math.abs(dArray[2] - dArray[3]) / 8.0);
                this.epsilonSlider.setVal(Math.abs(dArray[2] - dArray[3]) / 8.0);
            }
            if (dArray2.length > 7 && !Double.isNaN(dArray2[7])) {
                this.deltaInput.setVal(dArray2[7]);
                this.deltaSlider.setVal(dArray2[7]);
            } else {
                this.deltaInput.setVal(Math.abs(dArray[0] - dArray[1]) / 8.0);
                this.deltaSlider.setVal(Math.abs(dArray[0] - dArray[1]) / 8.0);
            }
        }
        if (this.functionInput != null) {
            this.functionInput.setText(string);
        } else {
            try {
                object = new SimpleFunction((Expression)this.parser.parse(string), this.xVar);
                ((WrapperFunction)this.func).setFunction((Function)object);
            }
            catch (ParseError parseError) {
                // empty catch block
            }
        }
        object = this.canvas.getCoordinateRect(0);
        ((CoordinateRect)object).setLimits(dArray);
        ((CoordinateRect)object).setRestoreBuffer();
        this.mainController.compute();
    }
}

