/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.ConstructionObject;

public class PolygonDrawer {
    MyGraphics G;
    ConstructionObject O;
    double C;
    double R;
    double C1;
    double R1;
    boolean HaveToFinish;
    public static int step = 9;
    public boolean Marker = false;
    public boolean Started;
    boolean Solid;

    public PolygonDrawer(MyGraphics myGraphics, ConstructionObject constructionObject) {
        this.G = myGraphics;
        this.O = constructionObject;
        this.Started = false;
    }

    public void startPolygon(double d2, double d3) {
        this.C = d2;
        this.R = d3;
        this.HaveToFinish = false;
        this.Started = true;
    }

    public void drawTo(double d2, double d3, boolean bl) {
        if (!this.Started) {
            this.startPolygon(d2, d3);
            return;
        }
        if (bl || (d2 - this.C) * (d2 - this.C) + (d3 - this.R) * (d3 - this.R) > (double)step) {
            if (this.Marker) {
                ((MyGraphics13)this.G).drawMarkerLine(this.C, this.R, d2, d3);
            } else {
                this.G.drawLine(this.C, this.R, d2, d3, this.O);
            }
            this.C = d2;
            this.R = d3;
            this.HaveToFinish = false;
        } else {
            this.C1 = d2;
            this.R1 = d3;
            this.HaveToFinish = true;
        }
    }

    public void drawTo(double d2, double d3) {
        this.drawTo(d2, d3, false);
    }

    public void finishPolygon() {
        if (this.HaveToFinish) {
            if (this.Marker) {
                ((MyGraphics13)this.G).drawMarkerLine(this.C, this.R, this.C1, this.R1);
            } else {
                this.G.drawLine(this.C, this.R, this.C1, this.R1, this.O);
            }
            this.HaveToFinish = false;
        }
        this.Started = false;
    }

    public boolean hasStarted() {
        return this.Started;
    }

    public double c() {
        return this.C;
    }

    public double r() {
        return this.R;
    }

    public void useAsMarker() {
        this.Marker = true;
        step = 18;
    }
}

