/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem.ds;

import WIMSchem.Molecule;
import WIMSchem.MoleculeStream;
import WIMSchem.Util;
import WIMSchem.ds.DataSheet;
import WIMSchem.ds.TrivialDOM;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;

public class DataSheetStream {
    public static boolean examineIsXMLDS(FileInputStream istr) {
        boolean ret = false;
        try {
            long lastpos = istr.getChannel().position();
            BufferedReader rdr = new BufferedReader(new InputStreamReader(istr));
            ret = DataSheetStream.examineIsXMLDS(rdr);
            istr.getChannel().position(lastpos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public static boolean examineIsXMLDS(BufferedReader rdr) {
        try {
            String str;
            for (int n = 0; n < 2 && (str = rdr.readLine()) != null; ++n) {
                if (!str.startsWith("<DataSheet>")) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean examineIsMDLSDF(FileInputStream istr) {
        boolean ret = false;
        try {
            long lastpos = istr.getChannel().position();
            BufferedReader rdr = new BufferedReader(new InputStreamReader(istr));
            ret = DataSheetStream.examineIsMDLSDF(rdr);
            istr.getChannel().position(lastpos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public static boolean examineIsMDLSDF(BufferedReader rdr) {
        try {
            String str;
            for (int n = 0; n < 3000 && (str = rdr.readLine()) != null; ++n) {
                if (str.compareTo("$$$$") != 0) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static DataSheet readXML(InputStream istr) throws IOException {
        return DataSheetStream.readXML(new BufferedReader(new InputStreamReader(istr)));
    }

    public static DataSheet readXML(BufferedReader in) throws IOException {
        int n;
        TrivialDOM xml = TrivialDOM.readXML(in);
        if (xml.document().nodeName().compareTo("DataSheet") != 0) {
            throw new IOException("Input stream is XML, but the root node is not <DataSheet>.");
        }
        DataSheet ds = new DataSheet();
        TrivialDOM.Node doc = xml.document();
        TrivialDOM.Node header = null;
        TrivialDOM.Node content = null;
        TrivialDOM.Node summary = null;
        for (int n2 = 0; n2 < doc.numChildren(); ++n2) {
            if (doc.childType(n2) != 1) continue;
            TrivialDOM.Node node = doc.getChildNode(n2);
            if (node.nodeName().equals("Summary")) {
                summary = node;
            }
            if (node.nodeName().equals("Header")) {
                header = node;
            }
            if (!node.nodeName().equals("Content")) continue;
            content = node;
        }
        if (header == null) {
            throw new IOException("XML document lacks a <Header> element.");
        }
        if (content == null) {
            throw new IOException("XML document lacks a <Content> element.");
        }
        int ncols = Util.safeInt(header.attribute("ncols"), -1);
        int nrows = Util.safeInt(header.attribute("nrows"), -1);
        if (ncols < 0 || ncols > 5000) {
            throw new IOException("Header@ncols attribute absent or improperly specified.");
        }
        if (nrows < 0) {
            throw new IOException("Header@nrows attribute absent or improperly specified.");
        }
        if (summary != null) {
            for (int n3 = 0; n3 < summary.numChildren(); ++n3) {
                if (summary.childType(n3) != 1) continue;
                TrivialDOM.Node node = summary.getChildNode(n3);
                if (node.nodeName().equals("Title")) {
                    ds.setTitle(node.getText());
                    continue;
                }
                if (!node.nodeName().equals("Description")) continue;
                ds.setDescription(node.getText());
            }
        }
        String[] colName = new String[ncols];
        String[] colDescr = new String[ncols];
        int[] colType = new int[ncols];
        for (n = 0; n < ncols; ++n) {
            colName[n] = null;
        }
        for (n = 0; n < header.numChildren(); ++n) {
            TrivialDOM.Node node;
            if (header.childType(n) != 1 || (node = header.getChildNode(n)).nodeName().compareTo("Column") != 0) continue;
            int id = Util.safeInt(node.attribute("id"), 0);
            if (id < 1 || id > ncols) {
                throw new IOException("Column@id out of range.");
            }
            String strName = node.attribute("name");
            String strType = node.attribute("type");
            if (strName == null) {
                throw new IOException("Column name not specified.");
            }
            if (strType == null) {
                throw new IOException("Column type not specified.");
            }
            int type = 0;
            if (strType.compareTo("molecule") == 0) {
                type = 1;
            } else if (strType.compareTo("string") == 0) {
                type = 2;
            } else if (strType.compareTo("integer") == 0) {
                type = 3;
            } else if (strType.compareTo("real") == 0) {
                type = 4;
            } else if (strType.compareTo("boolean") == 0) {
                type = 5;
            } else {
                throw new IOException("Coltype type [" + strType + "] not recognised.");
            }
            colName[id - 1] = strName;
            colType[id - 1] = type;
            colDescr[id - 1] = node.getText();
        }
        for (n = 0; n < ncols; ++n) {
            if (colName[n] != null) continue;
            throw new IOException("Column id#" + (n + 1) + " is not defined.");
        }
        for (n = 0; n < ncols; ++n) {
            ds.appendColumn(colName[n], colType[n], colDescr[n]);
        }
        for (n = 0; n < nrows; ++n) {
            ds.appendRow();
        }
        for (int i = 0; i < content.numChildren(); ++i) {
            TrivialDOM.Node row;
            if (content.childType(i) != 1 || (row = content.getChildNode(i)).nodeName().compareTo("Row") != 0) continue;
            int rid = Util.safeInt(row.attribute("id"), 0);
            if (rid < 1 || rid > nrows) {
                throw new IOException("Row@id out of range.");
            }
            for (int j = 0; j < row.numChildren(); ++j) {
                TrivialDOM.Node cell;
                if (row.childType(j) != 1 || (cell = row.getChildNode(j)).nodeName().compareTo("Cell") != 0) continue;
                int cid = Util.safeInt(cell.attribute("id"), 0);
                if (cid < 1 || cid > ncols) {
                    throw new IOException("Cell@id out of range.");
                }
                String data = cell.getText();
                int type = colType[cid - 1];
                if (type == 1) {
                    Molecule mol = null;
                    try {
                        mol = MoleculeStream.readUnknown(new BufferedReader(new StringReader(data)));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ds.setMolecule(rid - 1, cid - 1, mol);
                    continue;
                }
                if (type == 2) {
                    ds.setString(rid - 1, cid - 1, data);
                    continue;
                }
                if (type == 3) {
                    try {
                        int v = new Integer(data);
                        ds.setInteger(rid - 1, cid - 1, v);
                    }
                    catch (NumberFormatException e) {
                        ds.setToNull(rid - 1, cid - 1);
                    }
                    continue;
                }
                if (type == 4) {
                    try {
                        double v = new Double(data);
                        ds.setReal(rid - 1, cid - 1, v);
                    }
                    catch (NumberFormatException e) {
                        ds.setToNull(rid - 1, cid - 1);
                    }
                    continue;
                }
                if (type != 5) continue;
                ds.setBoolean(rid - 1, cid - 1, data.toLowerCase().compareTo("true") == 0);
            }
        }
        return ds;
    }

    public static DataSheet readSDF(InputStream istr) throws IOException {
        return DataSheetStream.readSDF(new BufferedReader(new InputStreamReader(istr)));
    }

    public static DataSheet readSDF(BufferedReader in) throws IOException {
        String line;
        DataSheet ds = new DataSheet();
        ds.appendColumn("mol", 1, "Molecule");
        ArrayList<String> entry = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            int pos;
            if (!line.startsWith("$$$$")) {
                entry.add(line);
                continue;
            }
            int rn = ds.appendRow();
            StringBuffer sb = new StringBuffer();
            for (pos = 0; pos < entry.size() && !(line = (String)entry.get(pos)).startsWith("> "); ++pos) {
                sb.append(line + "\n");
                if (!line.startsWith("M  END")) continue;
            }
            Molecule mol = null;
            try {
                mol = MoleculeStream.readMDLMOL(new BufferedReader(new StringReader(sb.toString())));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (mol != null) {
                ds.setMolecule(rn, 0, mol);
            }
            while (pos + 2 < entry.size()) {
                int z;
                String key = (String)entry.get(pos);
                String val = (String)entry.get(pos + 1);
                if (key.startsWith(">") && (z = key.indexOf("<")) >= 0 && (z = (key = key.substring(z + 1)).indexOf(">")) >= 0 && (key = key.substring(0, z)).length() != 0) {
                    int type = val.length() > 0 ? 2 : 3;
                    double dval = 0.0;
                    int ival = 0;
                    try {
                        dval = Double.parseDouble(val);
                        ival = (int)Math.round(dval);
                        type = dval == (double)ival ? 3 : 4;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    int cn = -1;
                    for (int n = 0; n < ds.numCols(); ++n) {
                        if (ds.colName(n).compareTo(key) != 0) continue;
                        cn = n;
                        break;
                    }
                    if (cn < 0) {
                        cn = ds.appendColumn(key, type, "");
                    }
                    int curType = ds.colType(cn);
                    if (val.length() == 0) {
                        ds.setToNull(rn, cn);
                    } else if (curType == 2) {
                        ds.setString(rn, cn, val);
                    } else if (curType == 4) {
                        if (type == 2) {
                            if (ds.changeColumnType(cn, 2, false)) {
                                ds.setString(rn, cn, val);
                            }
                        } else {
                            ds.setReal(rn, cn, dval);
                        }
                    } else if (curType == 3) {
                        if (type == 2) {
                            if (ds.changeColumnType(cn, 2, false)) {
                                ds.setString(rn, cn, val);
                            }
                        } else if (type == 4) {
                            if (ds.changeColumnType(cn, 4, false)) {
                                ds.setReal(rn, cn, dval);
                            }
                        } else {
                            ds.setInteger(rn, cn, ival);
                        }
                    }
                }
                pos += 3;
            }
            entry.clear();
        }
        return ds;
    }

    public static void writeXML(OutputStream ostr, DataSheet ds) throws IOException {
        DataSheetStream.writeXML(new BufferedWriter(new OutputStreamWriter(ostr)), ds);
    }

    public static void writeXML(BufferedWriter out, DataSheet ds) throws IOException {
        TrivialDOM xml = new TrivialDOM("DataSheet");
        int ncols = ds.numCols();
        int nrows = ds.numRows();
        TrivialDOM.Node summary = xml.document().appendNode("Summary");
        summary.appendNode("Title").setText(ds.getTitle(), false);
        summary.appendNode("Description").setText(ds.getDescription(), true);
        TrivialDOM.Node header = xml.document().appendNode("Header");
        header.setAttribute("ncols", ds.numCols() + "");
        header.setAttribute("nrows", ds.numRows() + "");
        for (int n = 0; n < ncols; ++n) {
            TrivialDOM.Node col = header.appendNode("Column");
            col.setAttribute("id", String.valueOf(n + 1));
            col.setAttribute("name", ds.colName(n));
            int type = ds.colType(n);
            if (type == 1) {
                col.setAttribute("type", "molecule");
            } else if (type == 2) {
                col.setAttribute("type", "string");
            } else if (type == 3) {
                col.setAttribute("type", "integer");
            } else if (type == 4) {
                col.setAttribute("type", "real");
            } else if (type == 5) {
                col.setAttribute("type", "boolean");
            }
            col.setText(ds.colDescr(n), false);
        }
        TrivialDOM.Node content = xml.document().appendNode("Content");
        for (int i = 0; i < nrows; ++i) {
            TrivialDOM.Node row = content.appendNode("Row");
            row.setAttribute("id", String.valueOf(i + 1));
            for (int j = 0; j < ncols; ++j) {
                TrivialDOM.Node col = row.appendNode("Cell");
                col.setAttribute("id", String.valueOf(j + 1));
                int type = ds.colType(j);
                if (ds.isNull(i, j)) continue;
                if (type == 1) {
                    try {
                        StringWriter sw = new StringWriter();
                        BufferedWriter bw = new BufferedWriter(sw);
                        MoleculeStream.writeNative(bw, ds.getMolecule(i, j));
                        col.setText(sw.toString(), true);
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                if (type == 2) {
                    col.setText(ds.getString(i, j), true);
                    continue;
                }
                if (type == 3) {
                    col.setText(String.valueOf(ds.getInteger(i, j)), false);
                    continue;
                }
                if (type == 4) {
                    col.setText(String.valueOf(ds.getReal(i, j)), false);
                    continue;
                }
                if (type != 5) continue;
                col.setText(ds.getBoolean(i, j) ? "true" : "false", false);
            }
        }
        TrivialDOM.writeXML(out, xml);
    }

    public static void writeSDF(OutputStream ostr, DataSheet ds) throws IOException {
        DataSheetStream.writeSDF(new BufferedWriter(new OutputStreamWriter(ostr)), ds);
    }

    public static void writeSDF(BufferedWriter out, DataSheet ds) throws IOException {
        int molfld = -1;
        for (int n = 0; n < ds.numCols(); ++n) {
            if (ds.colType(n) != 1) continue;
            molfld = n;
            break;
        }
        for (int i = 0; i < ds.numRows(); ++i) {
            if (molfld >= 0 && !ds.isNull(i, molfld)) {
                MoleculeStream.writeMDLMOL(out, ds.getMolecule(i, molfld));
            }
            for (int j = 0; j < ds.numCols(); ++j) {
                int n;
                if (ds.colType(j) == 1 || ds.isNull(i, j)) continue;
                String line = "";
                if (ds.colType(j) == 2) {
                    line = ds.getString(i, j);
                } else if (ds.colType(j) == 3) {
                    line = String.valueOf(ds.getInteger(i, j));
                } else if (ds.colType(j) == 4) {
                    line = String.valueOf(ds.getReal(i, j));
                } else if (ds.colType(j) == 5) {
                    String string = line = ds.getBoolean(i, j) ? "true" : "false";
                }
                if (line.length() == 0) continue;
                String[] bits = line.split("\n");
                boolean anything = false;
                for (n = 0; n < bits.length; ++n) {
                    if (bits[n].length() <= 0) continue;
                    anything = true;
                }
                if (!anything) continue;
                out.write("> <" + ds.colName(j) + ">\n");
                for (n = 0; n < bits.length; ++n) {
                    if (bits[n].length() <= 0) continue;
                    if (bits[n].length() > 78) {
                        bits[n] = bits[n].substring(0, 78);
                    }
                    out.write(bits[n] + "\n");
                }
                out.write("\n");
            }
            out.write("$$$$\n");
        }
        out.flush();
    }
}

