/**
 * CoordSyst.java
 *
 * Created on Jul 3, 2006
 */
package maths;

/**
 * Cette interface represente un systeme de coordonees.
 * Un tel objet traduit des coordonees en pixels en coordonees
 * complexes et inversement.
 *
 * @author Nicolae
 */
public interface CoordSyst {
	
	/**
	 * Etablit les dimensions en pixels.
	 *
	 * @param w la largeur.
	 * @param h la hauteur.
	 */
	public void setPix(int w, int h);
		
	/**
	 * Etablit les coordonees complexes du rectangle.
	 * On doit respecter <code>r1 < r2</code> et <code>i1 < i2</code>.
	 *
	 * @param r1 coordonee reele gauche.
	 * @param i1 coordonee imaginaire bas.
	 * @param r2 coordonee reele droite.
	 * @param i2 coordonee imaginaire haut.
	 */
	public void setCoord(double r1, double i1, double r2, double i2);
			
	/**
	 * Etablie le rapport desire entre la largeur et la hauteur. Une valeur
	 * negative signifie que le rapport est variable.
	 * 
	 * @param rat le rapport.
	 */
	public void setRatio(double rat);
	
	/**
	 * Renvoie le rapport desire entre la largeur et la hauteur. Une valeur
	 * negative signifie que le rapport est variable.
	 *
	 * @return le rapport desire entre la largeur et la hauteur.
	 */
	public double getRatio();
	
	/**
	 * Renvoie la largeur en pixels.
	 *
	 * @return la largeur en pixels.
	 */
	public int getWidth();

	/**
	 * Renvoie la hauteur en pixels.
	 *
	 * @return la hauteur en pixels.
	 */
	public int getHeigth();
	
	/**
	 * Renvoie la partie reele de la colonne de pixels <code>x</code>.
	 *
	 * @param x abscise en pixels.
	 * @return partie reele.
	 */
	public double getRe(int x);
	
	/**
	 * Renvoie la partie imaginaire de la ligne de pixels <code>y</code>.
	 *
	 * @param y ordonee en pixels.
	 * @return partie imaginaire.
	 */
	public double getIm(int y);

	/**
	 * Renvoie la colone de pixels qui correspond a la partie reele <code>re</code>.
	 *
	 * @param re partie reeele.
	 * @return la colone de pixels.
	 */
	public int getX(double re);

	/**
	 * Renvoie la ligne de pixels qui correspond a la partie imaginaire <code>im</code>.
	 *
	 * @param im partie imaginaire.
	 * @return la ligne de pixels.
	 */
	public int getY(double im);
		
	/**
	 * Renvoie <code>true</code> si l'objet est pret a l'emploi.
	 *
	 * @return <code>true</code> si l'objet est pret a l'emploi <code>false</code> sinon.
	 */
	public boolean isValid();
	
	/**
	 * Renvoie la partie reele gauche.
	 *
	 * @return la partie reele gauche.
	 */
	public double getRe1();
	
	/**
	 * Renvoie la partie reele droite.
	 *
	 * @return la partie reele droite.
	 */
	public double getRe2();
	
	/**
	 * Renvoie la partie imaginaire bas.
	 *
	 * @return la partie imaginaire bas.
	 */
	public double getIm1();
	
	/**
	 * Renvoie la partie imaginaire haut.
	 *
	 * @return la partie imaginaire haut.
	 */
	public double getIm2();
		
	/**
	 * Deplace le rectagle complexe pour avoir comme centre <code>(re, im)</code>.
	 *
	 * @param re partie reele du centre.
	 * @param im partie imaginaire du centre.
	 */
	public void moveCenter(double re, double im);
		
	/**
	 * Effectue un zoom centr de rapport <code>zm > 0</code>.
	 * 
	 * @param zm rapport de zoom.
	 */
	public void zoom(double zm);	
	
	/**
	 * Renvoie une copie identique du l'objet.
	 *
	 * @return une copie.
	 */
	public CoordSyst copie();
}
