/**
 * Set.java
 *
 * Created on Jul 10, 2006
 */
package maths;

/**
 * Cette interface represente un sous-ensemble du plan (complexe).
 *
 * @author Nicolae
 */
public interface Set {

	/**
	 * Renvoie <code>true</code> si <code>(re, im)</code> appartient a l'ensemble.
	 *
	 * @param re partie reele.
	 * @param im partie imaginaire.
	 * @return <code>true</code> si <code>(re, im)</code> appartient a l'ensemble,
	 *         <code>false</code> sinon.
	 */
	public boolean contains(double re, double im);
		
	/**
	 * L'application characteristique de l'ensemble.
	 *
	 * @return l'application characteristique de l'ensemble.
	 */
	public Fonction charact();

	/**
	 * Le complementaire dans le plan.
	 *
	 * @return le complementaire.
	 */
	public Set complement();
	
	/**
	 * La reunion avec l'ensemble <code>A</code>.
	 *
	 * @param A ensemble.
	 * @return la reunion.
	 */
	public Set union(Set A);
	
	/**
	 * L'intersection avec l'ensemble <code>A</code>.
	 *
	 * @param A ensemble.
	 * @return l'intersection.
	 */
	public Set inter(Set A);

	/**
	 * La difference avec l'ensemble <code>A</code>.
	 *
	 * @param A ensemble.
	 * @return la difference.
	 */
	public Set minus(Set A);
	
	/**
	 * La difference symmetrique avec l'ensemble <code>A</code>.
	 *
	 * @param A ensemble.
	 * @return la difference.
	 */
	public Set symmDiff(Set A);
}
