(* ########################################################################## *)
(*                             Definitions of matrices                        *)
(*                         Frdric Gava (Universit Paris 12)                *)
(* ########################################################################## *)

(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)
Require Export Why.

(*Why type*) Definition fmatrice: Set ->Set.
Admitted.

(*Why logic*) Definition mat_access :
  forall (A1:Set), (fmatrice A1) -> Z -> Z -> A1.
Admitted.
Implicit Arguments mat_access.

(*Why logic*) Definition mat_update :
  forall (A1:Set), (fmatrice A1) -> Z -> Z -> A1 -> (fmatrice A1).
Admitted.
Implicit Arguments mat_update.

(*Why axiom*) Lemma mat_access_update :
  forall (A1:Set),
  (forall (m:(fmatrice A1)),
   (forall (i:Z),
    (forall (j:Z), (forall (v:A1), (mat_access (mat_update m i j v) i j) = v)))).
Admitted.

(*Why axiom*) Lemma access_update_neq :
  forall (A1:Set),
  (forall (m:(fmatrice A1)),
   (forall (i1:Z),
    (forall (j1:Z),
     (forall (i2:Z),
      (forall (j2:Z),
       (forall (v:A1),
        (i1 <> i2 \/ j1 <> j2 ->
         (mat_access (mat_update m i1 j1 v) i2 j2) = (mat_access m i2 j2)))))))).
Admitted.

Admitted.
Implicit Arguments matrice_size_row.

Admitted.
Implicit Arguments matrice_size_column.

(*Why logic*) Definition mat_size_row : forall (A1:Set), (fmatrice A1) -> Z.
Admitted.
Implicit Arguments mat_size_row.

(*Why logic*) Definition mat_size_column :
  forall (A1:Set), (fmatrice A1) -> Z.
Admitted.
Implicit Arguments mat_size_column.

Admitted.

(*Why axiom*) Lemma mat_size_row_update :
  forall (A1:Set),
  (forall (m:(fmatrice A1)),
   (forall (i:Z),
    (forall (j:Z),
     (forall (v:A1), (mat_size_row (mat_update m i j v)) = (mat_size_row m))))).
Admitted.

(*Why axiom*) Lemma mat_size_column_update :
  forall (A1:Set),
  (forall (m:(fmatrice A1)),
   (forall (i:Z),
    (forall (j:Z),
     (forall (v:A1), (mat_size_column (mat_update m i j v)) =
      (mat_size_column m))))).
Admitted.

(*Why logic*) Definition N : Z.
Admitted.

(*Why axiom*) Lemma N_range : 1 <= N.
Admitted.


Require Export Recdef.

Require Import ZArithRing.
Require Import Omega.
Require Export Rbase.

Function sigma_mat_mult (A:(fmatrice R)) (B:(fmatrice R)) 
                        (mini:Z) (maxi:Z) (i:Z) (j:Z) {wf (Zwf mini) maxi} : R :=
  if (Z_lt_dec maxi mini) then 0%R 
   else (((mat_access A i maxi)%R * (mat_access B maxi j)%R)%R + (sigma_mat_mult A B mini (maxi-1) i j)%R)%R.
Proof.
intros; unfold Zwf; omega.
intro;exact (Zwf_well_founded mini).
Qed.


Lemma sigma_mat_mult_zero: forall (A:(fmatrice R)), forall (B:(fmatrice R)), forall (i:Z), forall (j:Z), forall (r:Z),
r<0 -> sigma_mat_mult A B 0 r i j=0%R.
Proof.
intros.
generalize (sigma_mat_mult_equation A B 0 r i j);intro Heq;rewrite Heq.
case (Z_lt_dec r 0); intro;intuition.
Save.


Lemma sigma_mat_mult_plus: forall (A:(fmatrice R)), forall (B:(fmatrice R)), forall (i:Z), forall (j:Z), forall (r:Z), 0<=r ->
((sigma_mat_mult A B 0 (r-1) i j)%R+(mat_access A i r)%R * (mat_access B r j)%R)%R=(sigma_mat_mult A B 0 r i j)%R.
Proof.
intros.
generalize (sigma_mat_mult_equation A B 0 r i j);intro Heq;rewrite Heq.
case (Z_lt_dec r 0); intro;intuition.
absurd (0 <= r);omega.
Save.



(*Why predicate*) Definition mat_mult_done  (A:(fmatrice R)) (B:(fmatrice R)) (C:(fmatrice R)) (iu:Z) (id:Z) (jl:Z) (jr:Z)
  := (forall (i:Z),
      (forall (j:Z),
       ((iu <= i /\ i < id) /\ jl <= j /\ j < jr ->
        (eq (mat_access C i j) (sigma_mat_mult A B 0 (N - 1) i j))))).

(*Why predicate*) Definition mat_mult_todo  (C:(fmatrice R)) (C':(fmatrice R)) (iu:Z) (id:Z) (jl:Z) (jr:Z)
  := (forall (i:Z),
      (forall (j:Z),
       ((iu <= i /\ i < id) /\ jl <= j /\ j < jr ->
        (eq (mat_access C i j) (mat_access C' i j))))).

(*Why predicate*) Definition mat_mult  (A:(fmatrice R)) (B:(fmatrice R)) (C:(fmatrice R))
  := (mat_mult_done A B C 0 N 0 N).

(* Why obligation from file "matrice.why", line 136, characters 10-209: *)
(*Why goal*) Lemma mult_po_1 : 
  forall (A: (fmatrice R)),
  forall (B: (fmatrice R)),
  forall (C: (fmatrice R)),
  forall (HW_1: (mat_size_row A) = N /\ (mat_size_row B) = N /\
                (mat_size_row C) = N /\ (mat_size_column A) = N /\
                (mat_size_column B) = N /\ (mat_size_column C) = N /\
                (forall (x:Z),
                 (forall (y:Z),
                  ((0 <= x /\ x < N) /\ 0 <= y /\ y < N ->
                   (eq (mat_access C x y) (0)%R))))),
  ((0 <= 0 /\ 0 <= N) /\ (mat_mult_done A B C 0 0 0 N) /\
  (mat_mult_todo C C 0 N 0 N) /\ (mat_size_column C) = (mat_size_column C) /\
  (mat_size_row C) = (mat_size_row C)).
Proof.
intros.
split.
assert (1<=N).
apply N_range.
intuition.
split;intuition.
unfold mat_mult_done.
intros.
destruct H5;intuition.
absurd (i < 0);omega.
unfold mat_mult_todo.
intros.
auto.
Save.


(* Why obligation from file "matrice.why", line 146, characters 12-274: *)
(*Why goal*) Lemma mult_po_2 : 
  forall (A: (fmatrice R)),
  forall (B: (fmatrice R)),
  forall (C: (fmatrice R)),
  forall (HW_1: (mat_size_row A) = N /\ (mat_size_row B) = N /\
                (mat_size_row C) = N /\ (mat_size_column A) = N /\
                (mat_size_column B) = N /\ (mat_size_column C) = N /\
                (forall (x:Z),
                 (forall (y:Z),
                  ((0 <= x /\ x < N) /\ 0 <= y /\ y < N ->
                   (eq (mat_access C x y) (0)%R))))),
  forall (C0: (fmatrice R)),
  forall (i: Z),
  forall (HW_2: (0 <= i /\ i <= N) /\ (mat_mult_done A B C0 0 i 0 N) /\
                (mat_mult_todo C0 C i N 0 N) /\ (mat_size_column C0) =
                (mat_size_column C) /\ (mat_size_row C0) = (mat_size_row C)),
  forall (HW_3: i < N),
  ((0 <= 0 /\ 0 <= N) /\ (mat_mult_done A B C0 0 i 0 N) /\
  (mat_mult_todo C0 C (i + 1) N 0 N) /\
  (mat_mult_done A B C0 i (i + 1) 0 0) /\
  (mat_mult_todo C0 C i (i + 1) 0 N) /\ (mat_size_column C0) =
  (mat_size_column C) /\ (mat_size_row C0) = (mat_size_row C)).
Proof.
intros.
split;intuition.
generalize H4.
unfold mat_mult_todo;intros;intuition.
unfold mat_mult_done;intros;intuition.
unfold mat_mult_todo;intros;intuition.
Save.

(* Why obligation from file "matrice.why", line 157, characters 8-382: *)
(*Why goal*) Lemma mult_po_3 : 
  forall (A: (fmatrice R)),
  forall (B: (fmatrice R)),
  forall (C: (fmatrice R)),
  forall (HW_1: (mat_size_row A) = N /\ (mat_size_row B) = N /\
                (mat_size_row C) = N /\ (mat_size_column A) = N /\
                (mat_size_column B) = N /\ (mat_size_column C) = N /\
                (forall (x:Z),
                 (forall (y:Z),
                  ((0 <= x /\ x < N) /\ 0 <= y /\ y < N ->
                   (eq (mat_access C x y) (0)%R))))),
  forall (C0: (fmatrice R)),
  forall (i: Z),
  forall (HW_2: (0 <= i /\ i <= N) /\ (mat_mult_done A B C0 0 i 0 N) /\
                (mat_mult_todo C0 C i N 0 N) /\ (mat_size_column C0) =
                (mat_size_column C) /\ (mat_size_row C0) = (mat_size_row C)),
  forall (HW_3: i < N),
  forall (C1: (fmatrice R)),
  forall (j: Z),
  forall (HW_4: (0 <= j /\ j <= N) /\ (mat_mult_done A B C1 0 i 0 N) /\
                (mat_mult_todo C1 C (i + 1) N 0 N) /\
                (mat_mult_done A B C1 i (i + 1) 0 j) /\
                (mat_mult_todo C1 C i (i + 1) j N) /\ (mat_size_column C1) =
                (mat_size_column C) /\ (mat_size_row C1) = (mat_size_row C)),
  forall (HW_5: j < N),
  ((0 <= 0 /\ 0 <= N) /\ (mat_mult_done A B C1 0 i 0 N) /\
  (mat_mult_todo C1 C (i + 1) N 0 N) /\
  (mat_mult_done A B C1 i (i + 1) 0 j) /\
  (mat_mult_todo C1 C i (i + 1) (j + 1) N) /\
  (eq (mat_access C1 i j) (Rplus
                           (mat_access C i j) (sigma_mat_mult
                                               A B 0 (0 - 1) i j))) /\
  (mat_size_column C1) = (mat_size_column C) /\ (mat_size_row C1) =
  (mat_size_row C)).
Proof.
intros.
split.
omega.
decompose [and or] HW_1;clear HW_1.
decompose [and or] HW_2;clear HW_2.
decompose [and or] HW_4;clear HW_4.
intuition.
generalize  H17.
unfold  mat_mult_todo.
intros.
intuition.
rewrite sigma_mat_mult_zero;auto.
generalize H17.
unfold  mat_mult_todo.
intros.
rewrite (H19 i j).
ring.
omega.
omega.
Save.



(* Why obligation from file "matrice.why", line 166, characters 21-36: *)
(*Why goal*) Lemma mult_po_4 : 
  forall (A: (fmatrice R)),
  forall (B: (fmatrice R)),
  forall (C: (fmatrice R)),
  forall (HW_1: (mat_size_row A) = N /\ (mat_size_row B) = N /\
                (mat_size_row C) = N /\ (mat_size_column A) = N /\
                (mat_size_column B) = N /\ (mat_size_column C) = N /\
                (forall (x:Z),
                 (forall (y:Z),
                  ((0 <= x /\ x < N) /\ 0 <= y /\ y < N ->
                   (eq (mat_access C x y) (0)%R))))),
  forall (C0: (fmatrice R)),
  forall (i: Z),
  forall (HW_2: (0 <= i /\ i <= N) /\ (mat_mult_done A B C0 0 i 0 N) /\
                (mat_mult_todo C0 C i N 0 N) /\ (mat_size_column C0) =
                (mat_size_column C) /\ (mat_size_row C0) = (mat_size_row C)),
  forall (HW_3: i < N),
  forall (C1: (fmatrice R)),
  forall (j: Z),
  forall (HW_4: (0 <= j /\ j <= N) /\ (mat_mult_done A B C1 0 i 0 N) /\
                (mat_mult_todo C1 C (i + 1) N 0 N) /\
                (mat_mult_done A B C1 i (i + 1) 0 j) /\
                (mat_mult_todo C1 C i (i + 1) j N) /\ (mat_size_column C1) =
                (mat_size_column C) /\ (mat_size_row C1) = (mat_size_row C)),
  forall (HW_5: j < N),
  forall (C2: (fmatrice R)),
  forall (r: Z),
  forall (HW_6: (0 <= r /\ r <= N) /\ (mat_mult_done A B C2 0 i 0 N) /\
                (mat_mult_todo C2 C (i + 1) N 0 N) /\
                (mat_mult_done A B C2 i (i + 1) 0 j) /\
                (mat_mult_todo C2 C i (i + 1) (j + 1) N) /\
                (eq (mat_access C2 i j) (Rplus
                                         (mat_access C i j) (sigma_mat_mult
                                                             A B 0 (r - 1) i j))) /\
                (mat_size_column C2) = (mat_size_column C) /\
                (mat_size_row C2) = (mat_size_row C)),
  forall (HW_7: r < N),
  ((0 <= i /\ i < (mat_size_row C2)) /\ 0 <= j /\ j < (mat_size_column C2)).
Proof.
intros.
omega.
Save.


(* Why obligation from file "matrice.why", line 166, characters 42-57: *)
(*Why goal*) Lemma mult_po_5 : 
  forall (A: (fmatrice R)),
  forall (B: (fmatrice R)),
  forall (C: (fmatrice R)),
  forall (HW_1: (mat_size_row A) = N /\ (mat_size_row B) = N /\
                (mat_size_row C) = N /\ (mat_size_column A) = N /\
                (mat_size_column B) = N /\ (mat_size_column C) = N /\
                (forall (x:Z),
                 (forall (y:Z),
                  ((0 <= x /\ x < N) /\ 0 <= y /\ y < N ->
                   (eq (mat_access C x y) (0)%R))))),
  forall (C0: (fmatrice R)),
  forall (i: Z),
  forall (HW_2: (0 <= i /\ i <= N) /\ (mat_mult_done A B C0 0 i 0 N) /\
                (mat_mult_todo C0 C i N 0 N) /\ (mat_size_column C0) =
                (mat_size_column C) /\ (mat_size_row C0) = (mat_size_row C)),
  forall (HW_3: i < N),
  forall (C1: (fmatrice R)),
  forall (j: Z),
  forall (HW_4: (0 <= j /\ j <= N) /\ (mat_mult_done A B C1 0 i 0 N) /\
                (mat_mult_todo C1 C (i + 1) N 0 N) /\
                (mat_mult_done A B C1 i (i + 1) 0 j) /\
                (mat_mult_todo C1 C i (i + 1) j N) /\ (mat_size_column C1) =
                (mat_size_column C) /\ (mat_size_row C1) = (mat_size_row C)),
  forall (HW_5: j < N),
  forall (C2: (fmatrice R)),
  forall (r: Z),
  forall (HW_6: (0 <= r /\ r <= N) /\ (mat_mult_done A B C2 0 i 0 N) /\
                (mat_mult_todo C2 C (i + 1) N 0 N) /\
                (mat_mult_done A B C2 i (i + 1) 0 j) /\
                (mat_mult_todo C2 C i (i + 1) (j + 1) N) /\
                (eq (mat_access C2 i j) (Rplus
                                         (mat_access C i j) (sigma_mat_mult
                                                             A B 0 (r - 1) i j))) /\
                (mat_size_column C2) = (mat_size_column C) /\
                (mat_size_row C2) = (mat_size_row C)),
  forall (HW_7: r < N),
  forall (HW_8: (0 <= i /\ i < (mat_size_row C2)) /\ 0 <= j /\ j <
                (mat_size_column C2)),
  forall (result: R),
  forall (HW_9: result = (mat_access C2 i j)),
  ((0 <= i /\ i < (mat_size_row A)) /\ 0 <= r /\ r < (mat_size_column A)).
Proof.
intros.
omega.
Save.

(* Why obligation from file "matrice.why", line 166, characters 62-77: *)
(*Why goal*) Lemma mult_po_6 : 
  forall (A: (fmatrice R)),
  forall (B: (fmatrice R)),
  forall (C: (fmatrice R)),
  forall (HW_1: (mat_size_row A) = N /\ (mat_size_row B) = N /\
                (mat_size_row C) = N /\ (mat_size_column A) = N /\
                (mat_size_column B) = N /\ (mat_size_column C) = N /\
                (forall (x:Z),
                 (forall (y:Z),
                  ((0 <= x /\ x < N) /\ 0 <= y /\ y < N ->
                   (eq (mat_access C x y) (0)%R))))),
  forall (C0: (fmatrice R)),
  forall (i: Z),
  forall (HW_2: (0 <= i /\ i <= N) /\ (mat_mult_done A B C0 0 i 0 N) /\
                (mat_mult_todo C0 C i N 0 N) /\ (mat_size_column C0) =
                (mat_size_column C) /\ (mat_size_row C0) = (mat_size_row C)),
  forall (HW_3: i < N),
  forall (C1: (fmatrice R)),
  forall (j: Z),
  forall (HW_4: (0 <= j /\ j <= N) /\ (mat_mult_done A B C1 0 i 0 N) /\
                (mat_mult_todo C1 C (i + 1) N 0 N) /\
                (mat_mult_done A B C1 i (i + 1) 0 j) /\
                (mat_mult_todo C1 C i (i + 1) j N) /\ (mat_size_column C1) =
                (mat_size_column C) /\ (mat_size_row C1) = (mat_size_row C)),
  forall (HW_5: j < N),
  forall (C2: (fmatrice R)),
  forall (r: Z),
  forall (HW_6: (0 <= r /\ r <= N) /\ (mat_mult_done A B C2 0 i 0 N) /\
                (mat_mult_todo C2 C (i + 1) N 0 N) /\
                (mat_mult_done A B C2 i (i + 1) 0 j) /\
                (mat_mult_todo C2 C i (i + 1) (j + 1) N) /\
                (eq (mat_access C2 i j) (Rplus
                                         (mat_access C i j) (sigma_mat_mult
                                                             A B 0 (r - 1) i j))) /\
                (mat_size_column C2) = (mat_size_column C) /\
                (mat_size_row C2) = (mat_size_row C)),
  forall (HW_7: r < N),
  forall (HW_8: (0 <= i /\ i < (mat_size_row C2)) /\ 0 <= j /\ j <
                (mat_size_column C2)),
  forall (result: R),
  forall (HW_9: result = (mat_access C2 i j)),
  forall (HW_10: (0 <= i /\ i < (mat_size_row A)) /\ 0 <= r /\ r <
                 (mat_size_column A)),
  forall (result0: R),
  forall (HW_11: result0 = (mat_access A i r)),
  ((0 <= r /\ r < (mat_size_row B)) /\ 0 <= j /\ j < (mat_size_column B)).
Proof.
intros.
omega.
Save.

(* Why obligation from file "matrice.why", line 157, characters 8-382: *)
(*Why goal*) Lemma mult_po_7 : 
  forall (A: (fmatrice R)),
  forall (B: (fmatrice R)),
  forall (C: (fmatrice R)),
  forall (HW_1: (mat_size_row A) = N /\ (mat_size_row B) = N /\
                (mat_size_row C) = N /\ (mat_size_column A) = N /\
                (mat_size_column B) = N /\ (mat_size_column C) = N /\
                (forall (x:Z),
                 (forall (y:Z),
                  ((0 <= x /\ x < N) /\ 0 <= y /\ y < N ->
                   (eq (mat_access C x y) (0)%R))))),
  forall (C0: (fmatrice R)),
  forall (i: Z),
  forall (HW_2: (0 <= i /\ i <= N) /\ (mat_mult_done A B C0 0 i 0 N) /\
                (mat_mult_todo C0 C i N 0 N) /\ (mat_size_column C0) =
                (mat_size_column C) /\ (mat_size_row C0) = (mat_size_row C)),
  forall (HW_3: i < N),
  forall (C1: (fmatrice R)),
  forall (j: Z),
  forall (HW_4: (0 <= j /\ j <= N) /\ (mat_mult_done A B C1 0 i 0 N) /\
                (mat_mult_todo C1 C (i + 1) N 0 N) /\
                (mat_mult_done A B C1 i (i + 1) 0 j) /\
                (mat_mult_todo C1 C i (i + 1) j N) /\ (mat_size_column C1) =
                (mat_size_column C) /\ (mat_size_row C1) = (mat_size_row C)),
  forall (HW_5: j < N),
  forall (C2: (fmatrice R)),
  forall (r: Z),
  forall (HW_6: (0 <= r /\ r <= N) /\ (mat_mult_done A B C2 0 i 0 N) /\
                (mat_mult_todo C2 C (i + 1) N 0 N) /\
                (mat_mult_done A B C2 i (i + 1) 0 j) /\
                (mat_mult_todo C2 C i (i + 1) (j + 1) N) /\
                (eq (mat_access C2 i j) (Rplus
                                         (mat_access C i j) (sigma_mat_mult
                                                             A B 0 (r - 1) i j))) /\
                (mat_size_column C2) = (mat_size_column C) /\
                (mat_size_row C2) = (mat_size_row C)),
  forall (HW_7: r < N),
  forall (HW_8: (0 <= i /\ i < (mat_size_row C2)) /\ 0 <= j /\ j <
                (mat_size_column C2)),
  forall (result: R),
  forall (HW_9: result = (mat_access C2 i j)),
  forall (HW_10: (0 <= i /\ i < (mat_size_row A)) /\ 0 <= r /\ r <
                 (mat_size_column A)),
  forall (result0: R),
  forall (HW_11: result0 = (mat_access A i r)),
  forall (HW_12: (0 <= r /\ r < (mat_size_row B)) /\ 0 <= j /\ j <
                 (mat_size_column B)),
  forall (result1: R),
  forall (HW_13: result1 = (mat_access B r j)),
  forall (HW_14: (0 <= i /\ i < (mat_size_row C2)) /\ 0 <= j /\ j <
                 (mat_size_column C2)),
  forall (C3: (fmatrice R)),
  forall (HW_15: C3 =
                 (mat_update C2 i j (Rplus result (Rmult result0 result1)))),
  forall (r0: Z),
  forall (HW_16: r0 = (r + 1)),
  ((0 <= r0 /\ r0 <= N) /\ (mat_mult_done A B C3 0 i 0 N) /\
  (mat_mult_todo C3 C (i + 1) N 0 N) /\
  (mat_mult_done A B C3 i (i + 1) 0 j) /\
  (mat_mult_todo C3 C i (i + 1) (j + 1) N) /\
  (eq (mat_access C3 i j) (Rplus
                           (mat_access C i j) (sigma_mat_mult
                                               A B 0 (r0 - 1) i j))) /\
  (mat_size_column C3) = (mat_size_column C) /\ (mat_size_row C3) =
  (mat_size_row C)).
Proof.
intros.
split.
omega.
subst r0.
decompose [and or] HW_6;clear HW_6.

split.
generalize H.
unfold mat_mult_done;intros.
assert (i<>i0 \/ j<>j0).
omega.
generalize (access_update_neq R C2 i j i0 j0 (result + result0 * result1)%R H10).
rewrite (H7 i0 j0 H9).
rewrite HW_15.
intuition.

split.
generalize H0.
unfold mat_mult_todo;intros.
assert (i<>i0 \/ j<>j0).
omega.
generalize (access_update_neq R C2 i j i0 j0 (result + result0 * result1)%R H10).
rewrite (H7 i0 j0 H9).
rewrite HW_15.
intuition.

split.
generalize H3.
unfold mat_mult_done;intros.
assert (i<>i0 \/ j<>j0).
omega.
generalize (access_update_neq R C2 i j i0 j0 (result + result0 * result1)%R H10).
rewrite (H7 i0 j0 H9).
rewrite HW_15.
intuition.

split.
generalize H4.
unfold mat_mult_todo;intros.
assert (i<>i0 \/ j<>j0).
omega.
generalize (access_update_neq R C2 i j i0 j0 (result + result0 * result1)%R H10).
rewrite (H7 i0 j0 H9).
rewrite HW_15.
intuition.

split.
assert (r=r+1-1).
omega.
induction H7.
generalize (mat_access_update R C2 i j (result + result0 * result1)%R).
generalize HW_15.
rewrite HW_9.
rewrite HW_11.
rewrite HW_13.
intro.
rewrite HW_0.
assert (mat_update C2 i j (mat_access C2 i j + mat_access A i r * mat_access B r j)%R = C3).
auto.
rewrite H7.
rewrite H5.
generalize (sigma_mat_mult_plus A B i j r H1);intros.
rewrite H10.
assert (sigma_mat_mult A B 0 r i j = (sigma_mat_mult A B 0 (r - 1) i j + mat_access A i r * mat_access B r j)%R).
intuition.
rewrite H11.
intuition.


generalize (mat_size_row_update R C2 i j (result + result0 * result1)%R).
generalize (mat_size_column_update R C2 i j (result + result0 * result1)%R).
rewrite HW_15.
intros.
intuition.
Save.

(* Why obligation from file "matrice.why", line 165, characters 11-14: *)
(*Why goal*) Lemma mult_po_8 : 
  forall (A: (fmatrice R)),
  forall (B: (fmatrice R)),
  forall (C: (fmatrice R)),
  forall (HW_1: (mat_size_row A) = N /\ (mat_size_row B) = N /\
                (mat_size_row C) = N /\ (mat_size_column A) = N /\
                (mat_size_column B) = N /\ (mat_size_column C) = N /\
                (forall (x:Z),
                 (forall (y:Z),
                  ((0 <= x /\ x < N) /\ 0 <= y /\ y < N ->
                   (eq (mat_access C x y) (0)%R))))),
  forall (C0: (fmatrice R)),
  forall (i: Z),
  forall (HW_2: (0 <= i /\ i <= N) /\ (mat_mult_done A B C0 0 i 0 N) /\
                (mat_mult_todo C0 C i N 0 N) /\ (mat_size_column C0) =
                (mat_size_column C) /\ (mat_size_row C0) = (mat_size_row C)),
  forall (HW_3: i < N),
  forall (C1: (fmatrice R)),
  forall (j: Z),
  forall (HW_4: (0 <= j /\ j <= N) /\ (mat_mult_done A B C1 0 i 0 N) /\
                (mat_mult_todo C1 C (i + 1) N 0 N) /\
                (mat_mult_done A B C1 i (i + 1) 0 j) /\
                (mat_mult_todo C1 C i (i + 1) j N) /\ (mat_size_column C1) =
                (mat_size_column C) /\ (mat_size_row C1) = (mat_size_row C)),
  forall (HW_5: j < N),
  forall (C2: (fmatrice R)),
  forall (r: Z),
  forall (HW_6: (0 <= r /\ r <= N) /\ (mat_mult_done A B C2 0 i 0 N) /\
                (mat_mult_todo C2 C (i + 1) N 0 N) /\
                (mat_mult_done A B C2 i (i + 1) 0 j) /\
                (mat_mult_todo C2 C i (i + 1) (j + 1) N) /\
                (eq (mat_access C2 i j) (Rplus
                                         (mat_access C i j) (sigma_mat_mult
                                                             A B 0 (r - 1) i j))) /\
                (mat_size_column C2) = (mat_size_column C) /\
                (mat_size_row C2) = (mat_size_row C)),
  forall (HW_7: r < N),
  forall (HW_8: (0 <= i /\ i < (mat_size_row C2)) /\ 0 <= j /\ j <
                (mat_size_column C2)),
  forall (result: R),
  forall (HW_9: result = (mat_access C2 i j)),
  forall (HW_10: (0 <= i /\ i < (mat_size_row A)) /\ 0 <= r /\ r <
                 (mat_size_column A)),
  forall (result0: R),
  forall (HW_11: result0 = (mat_access A i r)),
  forall (HW_12: (0 <= r /\ r < (mat_size_row B)) /\ 0 <= j /\ j <
                 (mat_size_column B)),
  forall (result1: R),
  forall (HW_13: result1 = (mat_access B r j)),
  forall (HW_14: (0 <= i /\ i < (mat_size_row C2)) /\ 0 <= j /\ j <
                 (mat_size_column C2)),
  forall (C3: (fmatrice R)),
  forall (HW_15: C3 =
                 (mat_update C2 i j (Rplus result (Rmult result0 result1)))),
  forall (r0: Z),
  forall (HW_16: r0 = (r + 1)),
  (Zwf 0 (N - r0) (N - r)).
Proof.
intuition.
Save.

(* Why obligation from file "matrice.why", line 146, characters 12-274: *)
(*Why goal*) Lemma mult_po_9 : 
  forall (A: (fmatrice R)),
  forall (B: (fmatrice R)),
  forall (C: (fmatrice R)),
  forall (HW_1: (mat_size_row A) = N /\ (mat_size_row B) = N /\
                (mat_size_row C) = N /\ (mat_size_column A) = N /\
                (mat_size_column B) = N /\ (mat_size_column C) = N /\
                (forall (x:Z),
                 (forall (y:Z),
                  ((0 <= x /\ x < N) /\ 0 <= y /\ y < N ->
                   (eq (mat_access C x y) (0)%R))))),
  forall (C0: (fmatrice R)),
  forall (i: Z),
  forall (HW_2: (0 <= i /\ i <= N) /\ (mat_mult_done A B C0 0 i 0 N) /\
                (mat_mult_todo C0 C i N 0 N) /\ (mat_size_column C0) =
                (mat_size_column C) /\ (mat_size_row C0) = (mat_size_row C)),
  forall (HW_3: i < N),
  forall (C1: (fmatrice R)),
  forall (j: Z),
  forall (HW_4: (0 <= j /\ j <= N) /\ (mat_mult_done A B C1 0 i 0 N) /\
                (mat_mult_todo C1 C (i + 1) N 0 N) /\
                (mat_mult_done A B C1 i (i + 1) 0 j) /\
                (mat_mult_todo C1 C i (i + 1) j N) /\ (mat_size_column C1) =
                (mat_size_column C) /\ (mat_size_row C1) = (mat_size_row C)),
  forall (HW_5: j < N),
  forall (C2: (fmatrice R)),
  forall (r: Z),
  forall (HW_6: (0 <= r /\ r <= N) /\ (mat_mult_done A B C2 0 i 0 N) /\
                (mat_mult_todo C2 C (i + 1) N 0 N) /\
                (mat_mult_done A B C2 i (i + 1) 0 j) /\
                (mat_mult_todo C2 C i (i + 1) (j + 1) N) /\
                (eq (mat_access C2 i j) (Rplus
                                         (mat_access C i j) (sigma_mat_mult
                                                             A B 0 (r - 1) i j))) /\
                (mat_size_column C2) = (mat_size_column C) /\
                (mat_size_row C2) = (mat_size_row C)),
  forall (HW_17: r >= N),
  forall (j0: Z),
  forall (HW_18: j0 = (j + 1)),
  ((0 <= j0 /\ j0 <= N) /\ (mat_mult_done A B C2 0 i 0 N) /\
  (mat_mult_todo C2 C (i + 1) N 0 N) /\
  (mat_mult_done A B C2 i (i + 1) 0 j0) /\
  (mat_mult_todo C2 C i (i + 1) j0 N) /\ (mat_size_column C2) =
  (mat_size_column C) /\ (mat_size_row C2) = (mat_size_row C)).
Proof.
intros.
split.
omega.

split.
intuition.

split.
intuition.

split.
decompose [and or] HW_6;clear HW_6.


subst.
assert (r=N).
omega.
subst.
clear HW_17 H2 H1.
generalize H3.
unfold mat_mult_done;intros.
case (Z_lt_ge_dec j0 j); intro.
assert (i <= i0 < i + 1 /\ 0 <= j0 < j).
omega.
apply (H1 i0 j0 H7).
assert (i0=i).
omega.
subst i0.
assert (j0=j).
omega.
subst j0.
assert ((mat_access C i j = 0)%R).
intuition.
generalize H5.
rewrite H7.
intros.
rewrite H9.
intuition.

split.
subst.
assert (r=N).
omega.
subst.
intuition.
intuition.

Save.

(* Why obligation from file "matrice.why", line 153, characters 15-18: *)
(*Why goal*) Lemma mult_po_10 : 
  forall (A: (fmatrice R)),
  forall (B: (fmatrice R)),
  forall (C: (fmatrice R)),
  forall (HW_1: (mat_size_row A) = N /\ (mat_size_row B) = N /\
                (mat_size_row C) = N /\ (mat_size_column A) = N /\
                (mat_size_column B) = N /\ (mat_size_column C) = N /\
                (forall (x:Z),
                 (forall (y:Z),
                  ((0 <= x /\ x < N) /\ 0 <= y /\ y < N ->
                   (eq (mat_access C x y) (0)%R))))),
  forall (C0: (fmatrice R)),
  forall (i: Z),
  forall (HW_2: (0 <= i /\ i <= N) /\ (mat_mult_done A B C0 0 i 0 N) /\
                (mat_mult_todo C0 C i N 0 N) /\ (mat_size_column C0) =
                (mat_size_column C) /\ (mat_size_row C0) = (mat_size_row C)),
  forall (HW_3: i < N),
  forall (C1: (fmatrice R)),
  forall (j: Z),
  forall (HW_4: (0 <= j /\ j <= N) /\ (mat_mult_done A B C1 0 i 0 N) /\
                (mat_mult_todo C1 C (i + 1) N 0 N) /\
                (mat_mult_done A B C1 i (i + 1) 0 j) /\
                (mat_mult_todo C1 C i (i + 1) j N) /\ (mat_size_column C1) =
                (mat_size_column C) /\ (mat_size_row C1) = (mat_size_row C)),
  forall (HW_5: j < N),
  forall (C2: (fmatrice R)),
  forall (r: Z),
  forall (HW_6: (0 <= r /\ r <= N) /\ (mat_mult_done A B C2 0 i 0 N) /\
                (mat_mult_todo C2 C (i + 1) N 0 N) /\
                (mat_mult_done A B C2 i (i + 1) 0 j) /\
                (mat_mult_todo C2 C i (i + 1) (j + 1) N) /\
                (eq (mat_access C2 i j) (Rplus
                                         (mat_access C i j) (sigma_mat_mult
                                                             A B 0 (r - 1) i j))) /\
                (mat_size_column C2) = (mat_size_column C) /\
                (mat_size_row C2) = (mat_size_row C)),
  forall (HW_17: r >= N),
  forall (j0: Z),
  forall (HW_18: j0 = (j + 1)),
  (Zwf 0 (N - j0) (N - j)).
Proof.
intuition.
Save.

(* Why obligation from file "matrice.why", line 136, characters 10-209: *)
(*Why goal*) Lemma mult_po_11 : 
  forall (A: (fmatrice R)),
  forall (B: (fmatrice R)),
  forall (C: (fmatrice R)),
  forall (HW_1: (mat_size_row A) = N /\ (mat_size_row B) = N /\
                (mat_size_row C) = N /\ (mat_size_column A) = N /\
                (mat_size_column B) = N /\ (mat_size_column C) = N /\
                (forall (x:Z),
                 (forall (y:Z),
                  ((0 <= x /\ x < N) /\ 0 <= y /\ y < N ->
                   (eq (mat_access C x y) (0)%R))))),
  forall (C0: (fmatrice R)),
  forall (i: Z),
  forall (HW_2: (0 <= i /\ i <= N) /\ (mat_mult_done A B C0 0 i 0 N) /\
                (mat_mult_todo C0 C i N 0 N) /\ (mat_size_column C0) =
                (mat_size_column C) /\ (mat_size_row C0) = (mat_size_row C)),
  forall (HW_3: i < N),
  forall (C1: (fmatrice R)),
  forall (j: Z),
  forall (HW_4: (0 <= j /\ j <= N) /\ (mat_mult_done A B C1 0 i 0 N) /\
                (mat_mult_todo C1 C (i + 1) N 0 N) /\
                (mat_mult_done A B C1 i (i + 1) 0 j) /\
                (mat_mult_todo C1 C i (i + 1) j N) /\ (mat_size_column C1) =
                (mat_size_column C) /\ (mat_size_row C1) = (mat_size_row C)),
  forall (HW_19: j >= N),
  forall (i0: Z),
  forall (HW_20: i0 = (i + 1)),
  ((0 <= i0 /\ i0 <= N) /\ (mat_mult_done A B C1 0 i0 0 N) /\
  (mat_mult_todo C1 C i0 N 0 N) /\ (mat_size_column C1) =
  (mat_size_column C) /\ (mat_size_row C1) = (mat_size_row C)).
Proof.
intros.
split.
omega.


subst.
assert (j=N).
omega.
subst.
decompose [and or] HW_4;clear HW_4.
clear HW_19 H1 H2.

split.
generalize H.
generalize H3.
unfold mat_mult_done;intros.
case (Z_lt_ge_dec i0 i); intro.
assert (0 <= i0 < i /\ 0 <= j < N).
omega.
apply (H2 i0 j H8).
assert (i0=i).
omega.
subst i0.
assert (i <= i< i + 1 /\ 0 <= j < N).
omega.
apply (H1 i j H8).

intuition.
Save.

(* Why obligation from file "matrice.why", line 141, characters 13-16: *)
(*Why goal*) Lemma mult_po_12 : 
  forall (A: (fmatrice R)),
  forall (B: (fmatrice R)),
  forall (C: (fmatrice R)),
  forall (HW_1: (mat_size_row A) = N /\ (mat_size_row B) = N /\
                (mat_size_row C) = N /\ (mat_size_column A) = N /\
                (mat_size_column B) = N /\ (mat_size_column C) = N /\
                (forall (x:Z),
                 (forall (y:Z),
                  ((0 <= x /\ x < N) /\ 0 <= y /\ y < N ->
                   (eq (mat_access C x y) (0)%R))))),
  forall (C0: (fmatrice R)),
  forall (i: Z),
  forall (HW_2: (0 <= i /\ i <= N) /\ (mat_mult_done A B C0 0 i 0 N) /\
                (mat_mult_todo C0 C i N 0 N) /\ (mat_size_column C0) =
                (mat_size_column C) /\ (mat_size_row C0) = (mat_size_row C)),
  forall (HW_3: i < N),
  forall (C1: (fmatrice R)),
  forall (j: Z),
  forall (HW_4: (0 <= j /\ j <= N) /\ (mat_mult_done A B C1 0 i 0 N) /\
                (mat_mult_todo C1 C (i + 1) N 0 N) /\
                (mat_mult_done A B C1 i (i + 1) 0 j) /\
                (mat_mult_todo C1 C i (i + 1) j N) /\ (mat_size_column C1) =
                (mat_size_column C) /\ (mat_size_row C1) = (mat_size_row C)),
  forall (HW_19: j >= N),
  forall (i0: Z),
  forall (HW_20: i0 = (i + 1)),
  (Zwf 0 (N - i0) (N - i)).
Proof.
intuition.
Save.

(* Why obligation from file "matrice.why", line 174, characters 4-19: *)
(*Why goal*) Lemma mult_po_13 : 
  forall (A: (fmatrice R)),
  forall (B: (fmatrice R)),
  forall (C: (fmatrice R)),
  forall (HW_1: (mat_size_row A) = N /\ (mat_size_row B) = N /\
                (mat_size_row C) = N /\ (mat_size_column A) = N /\
                (mat_size_column B) = N /\ (mat_size_column C) = N /\
                (forall (x:Z),
                 (forall (y:Z),
                  ((0 <= x /\ x < N) /\ 0 <= y /\ y < N ->
                   (eq (mat_access C x y) (0)%R))))),
  forall (C0: (fmatrice R)),
  forall (i: Z),
  forall (HW_2: (0 <= i /\ i <= N) /\ (mat_mult_done A B C0 0 i 0 N) /\
                (mat_mult_todo C0 C i N 0 N) /\ (mat_size_column C0) =
                (mat_size_column C) /\ (mat_size_row C0) = (mat_size_row C)),
  forall (HW_21: i >= N),
  (mat_mult A B C0).
Proof.
intros.
assert (i=N).
omega.
decompose [and] HW_2;clear HW_2.
generalize H0.
rewrite H.
auto.
Save.
