<?php
/**************************************************************************
* This file is part of the WebIssues Server program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

require_once( 'logging.inc.php' );

switch ( $config[ 'db_engine' ] ) {
    case 'mysql':
        if ( function_exists( 'mysql_connect' ) )
            require_once( 'database-mysql.inc.php' );
        break;
    case 'mysqli':
        if ( function_exists( 'mysqli_connect' ) )
            require_once( 'database-mysqli.inc.php' );
        break;
    case 'pgsql':
        if ( function_exists( 'pg_connect' ) )
            require_once( 'database-pgsql.inc.php' );
        break;
    case 'mssql':
        if ( class_exists( 'COM' ) && version_compare( PHP_VERSION, '5.0', '>=' ) )
            require_once( 'database-mssql.inc.php' );
        break;
    case 'firebird':
        if ( function_exists( 'ibase_connect' ) )
            require_once( 'database-firebird.inc.php' );
        break;
}

function wi_check_database()
{
    return function_exists( 'wi_db_connect' );
}

function wi_open_database()
{
    global $config;

    @set_magic_quotes_runtime( 0 );

    if ( !wi_db_connect( $config[ 'db_host' ], $config[ 'db_database' ], $config[ 'db_user' ], $config[ 'db_password' ] ) )
        return false;

    ignore_user_abort( true );

    return true;
}

function wi_query( $query )
{
    $args = func_get_args();
    array_shift( $args );

    return wi_query_args( $query, $args );
}

function wi_query_row( $query )
{
    if ( func_num_args() > 1 ) {
        $args = func_get_args();
        array_shift( $args );
    } else {
        $args = null;
    }

    $rs = wi_query_args( $query, $args );
    if ( !$rs )
        return false;

    return wi_db_fetch_assoc( $rs );
}

function wi_query_args( $query, $args )
{
    global $config;

    $query = str_replace( '{', $config[ 'db_prefix' ], $query );
    $query = str_replace( '}', '', $query );

    $params = array();
    $query = wi_build_query( $query, $args, $params );

    $rs = wi_db_query( $query, $params );

    return $rs;
}

function wi_build_query( $query, $args, &$params )
{
    $result = '';
    $index = 0;

    $parts = preg_split( '/(%(?:\d+\\$)?[a-z])/', $query, -1, PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_NO_EMPTY );
    foreach ( $parts as $part ) {
        if ( $part{0} == '%' ) {
            $type = substr( $part, -1, 1 );
            if ( strlen( $part ) > 2 )
                $index = (int)substr( $part, 1, -2 );
            else
                $index = $index + 1;
            $arg = $args[ $index - 1 ];
            if ( $type == 'l' )
                $result .= wi_build_list_arg( $arg, 'd', $params );
            else
                $result .= wi_db_escape_arg( $arg, $type, $params );
        } else {
            $result .= $part;
        }
    }

    return $result;
}

function wi_build_list_arg( $list, $type, &$params )
{
    $result = array();
    foreach ( $list as $item )
        $result[] = wi_db_escape_arg( $item, $type, $params );
    return implode( ',', $result );
}

function wi_fetch( $rs )
{
    return wi_db_fetch_assoc( $rs );
}

function wi_unescape_blob( $data )
{
    return wi_db_unescape_blob( $data );
}

function wi_insert_id( $table, $column )
{
    global $config;

    return wi_db_insert_id( $config[ 'db_prefix' ] . $table, $column );
}

function wi_table_exists( $table )
{
    global $config;

    return wi_db_table_exists( $config[ 'db_prefix' ] . $table );
}
