package WebGUI::Form::Radio;

=head1 LEGAL

 -------------------------------------------------------------------
  WebGUI is Copyright 2001-2009 Plain Black Corporation.
 -------------------------------------------------------------------
  Please read the legal notices (docs/legal.txt) and the license
  (docs/license.txt) that came with this distribution before using
  this software.
 -------------------------------------------------------------------
  http://www.plainblack.com                     info@plainblack.com
 -------------------------------------------------------------------

=cut

use strict;
use base 'WebGUI::Form::Control';
use WebGUI::International;

=head1 NAME

Package WebGUI::Form::Radio

=head1 DESCRIPTION

Creates a radio button form field.

=head1 SEE ALSO

This is a subclass of WebGUI::Form::Control.

=head1 METHODS 

The following methods are specifically available from this class. Check the superclass for additional methods.

=cut

#-------------------------------------------------------------------

=head2 definition ( [ additionalTerms ] )

See the super class for additional details.

=head3 additionalTerms

The following additional parameters have been added via this sub class.

=head4 checked

Defaults to "0". Set to "1" if this field should be checked.

=cut

sub definition {
	my $class = shift;
	my $session = shift;
	my $definition = shift || [];
	push(@{$definition}, {
		checked=>{
			defaultValue=> 0
        },
        label    => {
            defaultValue => undef,
        },
		});
        return $class->SUPER::definition($session, $definition);
}


#-------------------------------------------------------------------

=head2 generateIdParameter ( )

A class method that returns a value to be used as the autogenerated ID for this field instance. Returns undef because this field type can have more than one with the same name, therefore autogenerated ID's aren't terribly useful.

=cut

sub generateIdParameter {
	return undef;
}

#-------------------------------------------------------------------

=head2 getName ( session )

Returns the human readable name of this control.

=cut

sub getName {
    my ($self, $session) = @_;
    return WebGUI::International->new($session, 'WebGUI')->get('radio');
}

#-------------------------------------------------------------------

=head2 toHtml ( )

Renders and input tag of type radio.

=cut

sub toHtml {
	my $self = shift;
	my $value = $self->getOriginalValue();
    $value = defined $value ? $self->fixMacros($self->fixQuotes($self->fixSpecialCharacters($value))) : '';
	my $checkedText = $self->get("checked") ? ' checked="checked"' 			: '';
	my $idText 		= $self->get('id') 		? ' id="'.$self->get('id').'" ' : '';
    my $control = '<input type="radio" name="'.$self->get("name").'" value="'.$value.'"'.$idText.$checkedText.' '.($self->get("extras")||'').' />';
    if ($self->get('label')) {
        return "<label>" . $control . $self->get('label') . "</label>";
    }
    return $control;
}


1;

