#ifndef QRK_ANGLE_H
#define QRK_ANGLE_H

/*!
  \file
  \brief px̌^Ǘ

  \author Satofumi KAMIMURA

  $Id: Angle.h 1811 2010-04-30 16:12:05Z satofumi $
*/


namespace qrk
{
    /*!
      \brief px̌^Ǘ
    */
    class Angle
    {
    public:
        Angle(void);
        Angle(const Angle& rhs);

        Angle& operator = (const Angle& rhs);
        Angle& operator += (const Angle& rhs);
        const Angle operator + (const Angle& rhs) const;
        Angle& operator -= (const Angle& rhs);
        const Angle operator - (const Angle& rhs) const;
        Angle& operator *= (const double rhs);
        Angle operator * (const double rhs) const;
        friend const Angle operator * (const double lhs, const Angle& rhs);

        void normalize(void);


        /*!
          \brief degree pxւ̕ϊ

          \return degree px
        */
        int to_deg(void) const;


        /*!
          \brief radian pxւ̕ϊ

          \return radian px
        */
        double to_rad(void) const;

    private:
        double radian_angle_;

        friend Angle rad(double radian);
        friend Angle deg(int degree);
    };


    /*!
      \brief radian px Angle ɕϊ

      \param[in] radian radian px
      \return Angle IuWFNg
    */
    extern Angle rad(double radian);


    /*!
      \brief degree px Angle ɕϊ

      \param[in] degree degree px
      \return Angle IuWFNg
    */
    extern Angle deg(int degree);
}

#endif /* !QRK_ANGLE__H */
