/* i386-linux.elf.execve-entry.h
   created from i386-linux.elf.execve-entry.bin, 37970 (0x9452) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2020 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2020 Laszlo Molnar
   Copyright (C) 2000-2020 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_I386_LINUX_ELF_EXECVE_ENTRY_SIZE    37970
#define STUB_I386_LINUX_ELF_EXECVE_ENTRY_ADLER32 0x4ca6cf8c
#define STUB_I386_LINUX_ELF_EXECVE_ENTRY_CRC32   0xe9f3159e

unsigned char stub_i386_linux_elf_execve_entry[37970] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */  32, 34,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,232,252,255,255,255,184,  0,  0,  0,  0, 96,106,
/* 0x0040 */   0,139,116, 36, 40,139,124, 36, 48,131,205,255,235,  3,164,235,
/* 0x0050 */   3,138,  6, 70,136,  7, 71,  1,219,117,  7,139, 30,131,238,252,
/* 0x0060 */  17,219,114,  1, 49,192, 64,138,  7,114,255,184,  1,  0,  0,  0,
/* 0x0070 */   1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,  1,219,117,
/* 0x0080 */   7,139, 30,131,238,252, 17,219,115,255,  1,219,115,255,117,  9,
/* 0x0090 */ 139, 30,131,238,252, 17,219,115,255, 49,201,131,232,  3,114, 13,
/* 0x00a0 */ 193,224,  8,138,  6, 70,131,240,255,116,255,137,197,  1,219,117,
/* 0x00b0 */   7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,
/* 0x00c0 */ 131,238,252, 17,219, 17,201,117,255, 65,  1,219,117,  7,139, 30,
/* 0x00d0 */ 131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252,
/* 0x00e0 */  17,219,115, 48,  1,219,115, 48,117,  9,139, 30,131,238,252, 17,
/* 0x00f0 */ 219,115, 48, 65, 65,131,193,  2,129,253,  0,243,255,255,131,209,
/* 0x0100 */   1, 86,141, 52, 47,243,164, 94,233,252,255,255,255,141, 20, 47,
/* 0x0110 */ 131,253,252,138,  4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,
/* 0x0120 */ 247,233,252,255,255,255,139,  2,131,194,  4,137,  7,131,199,  4,
/* 0x0130 */ 131,233,  4,119,241,  1,207,233,252,255,255,255,235,  3,164,235,
/* 0x0140 */   3,138,  6, 70,136,  7, 71,  1,219,117,  7,139, 30,131,238,252,
/* 0x0150 */  17,219,114,  1, 49,192, 64,138,  7,114,255,184,  1,  0,  0,  0,
/* 0x0160 */   1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,  1,219,117,
/* 0x0170 */   7,139, 30,131,238,252, 17,219,114, 15,  1,219,115, 11,117, 15,
/* 0x0180 */ 139, 30,131,238,252, 17,219,114, 15, 72,  1,219,117,  7,139, 30,
/* 0x0190 */ 131,238,252, 17,219, 17,192,235,255, 49,201,131,232,  3,114, 17,
/* 0x01a0 */ 193,224,  8,138,  6, 70,131,240,255,116,255,209,248,137,197,235,
/* 0x01b0 */  11,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,
/* 0x01c0 */ 117,  7,139, 30,131,238,252, 17,219, 17,201,117,255, 65,  1,219,
/* 0x01d0 */ 117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,139,
/* 0x01e0 */  30,131,238,252, 17,219,115, 68,  1,219,115, 68,117,  9,139, 30,
/* 0x01f0 */ 131,238,252, 17,219,115, 68, 65, 65,131,193,  2,129,253,  0,251,
/* 0x0200 */ 255,255,131,209,  1, 86,141, 52, 47,243,164, 94,233,252,255,255,
/* 0x0210 */ 255,141, 20, 47,131,253,252,138,  4, 15,118,255,138,  2, 66,136,
/* 0x0220 */   7, 71, 73,117,247,233,252,255,255,255,139,  2,131,194,  4,137,
/* 0x0230 */   7,131,199,  4,131,233,  4,119,241,  1,207,233,252,255,255,255,
/* 0x0240 */ 235,  3,164,235,  3,138,  6, 70,136,  7, 71,  1,219,117,  7,139,
/* 0x0250 */  30,131,238,252, 17,219,114,  1, 49,192, 64,138,  7,114,255,184,
/* 0x0260 */   1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,
/* 0x0270 */ 192,  1,219,117,  7,139, 30,131,238,252, 17,219,114, 30,  1,219,
/* 0x0280 */ 115, 11,117, 30,139, 30,131,238,252, 17,219,114, 30, 72,  1,219,
/* 0x0290 */ 117,  7,139, 30,131,238,252, 17,219, 17,192,235,255,  1,219,117,
/* 0x02a0 */   7,139, 30,131,238,252, 17,219, 17,201,235,255, 49,201,131,232,
/* 0x02b0 */   3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,255,209,248,
/* 0x02c0 */ 137,197,235, 11,  1,219,117,  7,139, 30,131,238,252, 17,219,114,
/* 0x02d0 */ 204, 65,  1,219,117,  7,139, 30,131,238,252, 17,219,114,190,  1,
/* 0x02e0 */ 219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,
/* 0x02f0 */ 139, 30,131,238,252, 17,219,115, 81,  1,219,115, 81,117,  9,139,
/* 0x0300 */  30,131,238,252, 17,219,115, 81, 65, 65,131,193,  2,129,253,  0,
/* 0x0310 */ 251,255,255,131,209,  2, 86,141, 52, 47,243,164, 94,233,252,255,
/* 0x0320 */ 255,255,141, 20, 47,131,253,252,138,  4, 15,118,255,138,  2, 66,
/* 0x0330 */ 136,  7, 71, 73,117,247,233,252,255,255,255,139,  2,131,194,  4,
/* 0x0340 */ 137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,252,255,255,
/* 0x0350 */ 255,137,229,141,156, 36,  0,  0,  0,  0, 49,192, 80, 57,220,117,
/* 0x0360 */ 251, 70, 70, 83,104,  0,  0,  0,  0, 87,131,195,  4, 83,104,  0,
/* 0x0370 */   0,  0,  0, 86,131,195,  4, 83, 80,199,  3,  0,  0,  0,  0,137,
/* 0x0380 */ 229,139, 85, 44,172, 74,136,193, 36,  7,192,233,  3,187,  0,253,
/* 0x0390 */ 255,255,211,227,141,164, 92,144,241,255,255,131,228,224,106,  0,
/* 0x03a0 */ 106,  0,137,227, 83,131,195,  4,139, 77, 52,255, 49, 87, 83,131,
/* 0x03b0 */ 195,  4,136, 67,  2,172, 74,136,193, 36, 15,136,  3,192,233,  4,
/* 0x03c0 */ 136, 75,  1, 82, 86, 83, 80, 85, 87, 86, 83,131,236,124,139,148,
/* 0x03d0 */  36,144,  0,  0,  0,199, 68, 36,116,  0,  0,  0,  0,198, 68, 36,
/* 0x03e0 */ 115,  0,139,172, 36,156,  0,  0,  0,141, 66,  4,137, 68, 36,120,
/* 0x03f0 */ 184,  1,  0,  0,  0, 15,182, 74,  2,137,195,211,227,137,217, 73,
/* 0x0400 */ 137, 76, 36,108, 15,182, 74,  1,211,224, 72,137, 68, 36,104,139,
/* 0x0410 */ 132, 36,168,  0,  0,  0, 15,182, 50,199, 69,  0,  0,  0,  0,  0,
/* 0x0420 */ 199, 68, 36, 96,  0,  0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,
/* 0x0430 */   3,  0,  0,137,116, 36,100,199, 68, 36, 92,  1,  0,  0,  0,199,
/* 0x0440 */  68, 36, 88,  1,  0,  0,  0,199, 68, 36, 84,  1,  0,  0,  0,199,
/* 0x0450 */  68, 36, 80,  1,  0,  0,  0, 15,182, 74,  1,  1,241,211,224,141,
/* 0x0460 */ 136, 54,  7,  0,  0, 57, 76, 36,116,115, 14,139, 68, 36,120,102,
/* 0x0470 */ 199,  0,  0,  4,131,192,  2,226,246,139,156, 36,148,  0,  0,  0,
/* 0x0480 */  49,255,199, 68, 36, 72,255,255,255,255,137,218,  3,148, 36,152,
/* 0x0490 */   0,  0,  0,137, 84, 36, 76, 49,210, 59, 92, 36, 76, 15,132,124,
/* 0x04a0 */   9,  0,  0, 15,182,  3,193,231,  8, 66, 67,  9,199,131,250,  4,
/* 0x04b0 */ 126,231,139,140, 36,164,  0,  0,  0, 57, 76, 36,116, 15,131,100,
/* 0x04c0 */   9,  0,  0,139,116, 36,116, 35,116, 36,108,139, 68, 36, 96,139,
/* 0x04d0 */  84, 36,120,193,224,  4,137,116, 36, 68,  1,240,129,124, 36, 72,
/* 0x04e0 */ 255,255,255,  0,141, 44, 66,119, 24, 59, 92, 36, 76, 15,132, 44,
/* 0x04f0 */   9,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,
/* 0x0500 */ 199,139, 68, 36, 72,102,139, 85,  0,193,232, 11, 15,183,202, 15,
/* 0x0510 */ 175,193, 57,199, 15,131,221,  1,  0,  0,137, 68, 36, 72,184,  0,
/* 0x0520 */   8,  0,  0, 41,200,138, 76, 36,100,193,248,  5,190,  1,  0,  0,
/* 0x0530 */   0,141,  4,  2, 15,182, 84, 36,115,102,137, 69,  0,139, 68, 36,
/* 0x0540 */ 116, 35, 68, 36,104,139,108, 36,120,211,224,185,  8,  0,  0,  0,
/* 0x0550 */  43, 76, 36,100,211,250,  1,208,105,192,  0,  6,  0,  0,131,124,
/* 0x0560 */  36, 96,  6,141,132,  5,108, 14,  0,  0,137, 68, 36, 20, 15,142,
/* 0x0570 */ 202,  0,  0,  0,139, 68, 36,116, 43, 68, 36, 92,139,148, 36,160,
/* 0x0580 */   0,  0,  0, 15,182,  4,  2,137, 68, 36, 64,209,100, 36, 64,139,
/* 0x0590 */  76, 36, 64,141, 20, 54,139,108, 36, 20,129,225,  0,  1,  0,  0,
/* 0x05a0 */ 129,124, 36, 72,255,255,255,  0,141, 68, 77,  0,137, 76, 36, 60,
/* 0x05b0 */ 141, 44, 16,119, 24, 59, 92, 36, 76, 15,132, 96,  8,  0,  0,193,
/* 0x05c0 */ 100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,
/* 0x05d0 */  72,102,139,141,  0,  2,  0,  0,193,232, 11, 15,183,241, 15,175,
/* 0x05e0 */ 198, 57,199,115, 35,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,
/* 0x05f0 */ 137,214,193,248,  5,131,124, 36, 60,  0,141,  4,  1,102,137,133,
/* 0x0600 */   0,  2,  0,  0,116, 34,235, 46, 41, 68, 36, 72, 41,199,137,200,
/* 0x0610 */ 141,114,  1,102,193,232,  5,102, 41,193,131,124, 36, 60,  0,102,
/* 0x0620 */ 137,141,  0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,142,
/* 0x0630 */  87,255,255,255,235,121,129,254,255,  0,  0,  0,127,113,141, 20,
/* 0x0640 */  54,139,108, 36, 20,  1,213,129,124, 36, 72,255,255,255,  0,119,
/* 0x0650 */  24, 59, 92, 36, 76, 15,132,196,  7,  0,  0,193,100, 36, 72,  8,
/* 0x0660 */  15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 77,
/* 0x0670 */   0,193,232, 11, 15,183,241, 15,175,198, 57,199,115, 25,137, 68,
/* 0x0680 */  36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,141,  4,
/* 0x0690 */   1,102,137, 69,  0,235,159, 41, 68, 36, 72, 41,199,137,200,141,
/* 0x06a0 */ 114,  1,102,193,232,  5,102, 41,193,102,137, 77,  0,235,135,139,
/* 0x06b0 */  84, 36,116,137,240,139,140, 36,160,  0,  0,  0,136, 68, 36,115,
/* 0x06c0 */ 136,  4, 10, 66,131,124, 36, 96,  3,137, 84, 36,116,127, 13,199,
/* 0x06d0 */  68, 36, 96,  0,  0,  0,  0,233, 27,  7,  0,  0,131,124, 36, 96,
/* 0x06e0 */   9,127, 10,131,108, 36, 96,  3,233, 10,  7,  0,  0,131,108, 36,
/* 0x06f0 */  96,  6,233,  0,  7,  0,  0,139, 76, 36, 72, 41,199,139,116, 36,
/* 0x0700 */  96, 41,193,137,208,102,193,232,  5,102, 41,194,129,249,255,255,
/* 0x0710 */ 255,  0,102,137, 85,  0,139,108, 36,120,141,116,117,  0,137,116,
/* 0x0720 */  36, 56,119, 22, 59, 92, 36, 76, 15,132,241,  6,  0,  0, 15,182,
/* 0x0730 */   3,193,231,  8,193,225,  8, 67,  9,199,139,108, 36, 56,137,200,
/* 0x0740 */ 193,232, 11,102,139,149,128,  1,  0,  0, 15,183,234, 15,175,197,
/* 0x0750 */  57,199,115, 82,137,198,184,  0,  8,  0,  0, 41,232,139,108, 36,
/* 0x0760 */  88,193,248,  5,139, 76, 36, 84,141,  4,  2,139, 84, 36, 56,137,
/* 0x0770 */  76, 36, 80,139, 76, 36,120,102,137,130,128,  1,  0,  0,139, 68,
/* 0x0780 */  36, 92,137,108, 36, 84,137, 68, 36, 88, 49,192,131,124, 36, 96,
/* 0x0790 */   6, 15,159,192,129,193,100,  6,  0,  0,141,  4, 64,137, 68, 36,
/* 0x07a0 */  96,233,116,  2,  0,  0,137,206, 41,199, 41,198,137,208,102,193,
/* 0x07b0 */ 232,  5,139, 76, 36, 56,102, 41,194,129,254,255,255,255,  0,102,
/* 0x07c0 */ 137,145,128,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 77,  6,
/* 0x07d0 */   0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,139,108,
/* 0x07e0 */  36, 56,137,242,193,234, 11,102,139,141,152,  1,  0,  0, 15,183,
/* 0x07f0 */ 193, 15,175,208, 57,215, 15,131,227,  0,  0,  0,189,  0,  8,  0,
/* 0x0800 */   0,137,214, 41,197,199, 68, 36, 52,  0,  8,  0,  0,137,232,193,
/* 0x0810 */ 248,  5,141,  4,  1,139, 76, 36, 56,102,137,129,152,  1,  0,  0,
/* 0x0820 */ 139, 68, 36, 96,139, 76, 36, 68,193,224,  5,  3, 68, 36,120,129,
/* 0x0830 */ 250,255,255,255,  0,141, 44, 72,119, 22, 59, 92, 36, 76, 15,132,
/* 0x0840 */ 219,  5,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,
/* 0x0850 */ 102,139,149,224,  1,  0,  0,137,240,193,232, 11, 15,183,202, 15,
/* 0x0860 */ 175,193, 57,199,115, 96, 41, 76, 36, 52,193,124, 36, 52,  5,139,
/* 0x0870 */ 116, 36, 52,137, 68, 36, 72,131,124, 36,116,  0,141,  4, 50,102,
/* 0x0880 */ 137,133,224,  1,  0,  0, 15,132,147,  5,  0,  0, 49,192,131,124,
/* 0x0890 */  36, 96,  6,139,172, 36,160,  0,  0,  0,139, 84, 36,116, 15,159,
/* 0x08a0 */ 192,141, 68,  0,  9,137, 68, 36, 96,139, 68, 36,116, 43, 68, 36,
/* 0x08b0 */  92,138, 68,  5,  0,136, 68, 36,115,136,  4, 42, 66,137, 84, 36,
/* 0x08c0 */ 116,233, 49,  5,  0,  0, 41,198, 41,199,137,208,102,193,232,  5,
/* 0x08d0 */ 102, 41,194,102,137,149,224,  1,  0,  0,233, 31,  1,  0,  0,137,
/* 0x08e0 */ 200, 41,214,102,193,232,  5,139,108, 36, 56,102, 41,193, 41,215,
/* 0x08f0 */ 129,254,255,255,255,  0,102,137,141,152,  1,  0,  0,119, 22, 59,
/* 0x0900 */  92, 36, 76, 15,132, 22,  5,  0,  0, 15,182,  3,193,231,  8,193,
/* 0x0910 */ 230,  8, 67,  9,199,139, 76, 36, 56,137,240,193,232, 11,102,139,
/* 0x0920 */ 145,176,  1,  0,  0, 15,183,202, 15,175,193, 57,199,115, 35,137,
/* 0x0930 */ 198,184,  0,  8,  0,  0, 41,200,139,108, 36, 56,193,248,  5,141,
/* 0x0940 */   4,  2,102,137,133,176,  1,  0,  0,139, 68, 36, 88,233,160,  0,
/* 0x0950 */   0,  0,137,241, 41,199, 41,193,137,208,102,193,232,  5,102, 41,
/* 0x0960 */ 194,139, 68, 36, 56,129,249,255,255,255,  0,102,137,144,176,  1,
/* 0x0970 */   0,  0,119, 22, 59, 92, 36, 76, 15,132,161,  4,  0,  0, 15,182,
/* 0x0980 */   3,193,231,  8,193,225,  8, 67,  9,199,139,116, 36, 56,137,200,
/* 0x0990 */ 193,232, 11,102,139,150,200,  1,  0,  0, 15,183,234, 15,175,197,
/* 0x09a0 */  57,199,115, 32,137,198,184,  0,  8,  0,  0, 41,232,139,108, 36,
/* 0x09b0 */  56,193,248,  5,141,  4,  2,102,137,133,200,  1,  0,  0,139, 68,
/* 0x09c0 */  36, 84,235, 38,137,206, 41,199, 41,198,137,208,102,193,232,  5,
/* 0x09d0 */ 102, 41,194,139, 68, 36, 56,102,137,144,200,  1,  0,  0,139, 84,
/* 0x09e0 */  36, 84,139, 68, 36, 80,137, 84, 36, 80,139, 76, 36, 88,137, 76,
/* 0x09f0 */  36, 84,139,108, 36, 92,137, 68, 36, 92,137,108, 36, 88, 49,192,
/* 0x0a00 */ 131,124, 36, 96,  6,139, 76, 36,120, 15,159,192,129,193,104, 10,
/* 0x0a10 */   0,  0,141, 68, 64,  8,137, 68, 36, 96,129,254,255,255,255,  0,
/* 0x0a20 */ 119, 22, 59, 92, 36, 76, 15,132,243,  3,  0,  0, 15,182,  3,193,
/* 0x0a30 */ 231,  8,193,230,  8, 67,  9,199,102,139, 17,137,240,193,232, 11,
/* 0x0a40 */  15,183,234, 15,175,197, 57,199,115, 47,137, 68, 36, 72,184,  0,
/* 0x0a50 */   8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,  5,199, 68, 36,
/* 0x0a60 */  44,  0,  0,  0,  0,141,  4,  2,102,137,  1,139, 68, 36, 68,141,
/* 0x0a70 */  76,  1,  4,137, 76, 36, 16,235,114, 41,198, 41,199,137,208,102,
/* 0x0a80 */ 193,232,  5,102, 41,194,129,254,255,255,255,  0,102,137, 17,119,
/* 0x0a90 */  22, 59, 92, 36, 76, 15,132,132,  3,  0,  0, 15,182,  3,193,231,
/* 0x0aa0 */   8,193,230,  8, 67,  9,199,102,139, 81,  2,137,240,193,232, 11,
/* 0x0ab0 */  15,183,234, 15,175,197, 57,199,115, 59,137, 68, 36, 72,184,  0,
/* 0x0ac0 */   8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,  5,199, 68, 36,
/* 0x0ad0 */  44,  8,  0,  0,  0,141,  4,  2,139, 84, 36, 68,102,137, 65,  2,
/* 0x0ae0 */ 141,140, 17,  4,  1,  0,  0,137, 76, 36, 16,199, 68, 36, 48,  3,
/* 0x0af0 */   0,  0,  0,235, 47, 41,198, 41,199,137,208,137,116, 36, 72,102,
/* 0x0b00 */ 193,232,  5,199, 68, 36, 44, 16,  0,  0,  0,102, 41,194,199, 68,
/* 0x0b10 */  36, 48,  8,  0,  0,  0,102,137, 81,  2,129,193,  4,  2,  0,  0,
/* 0x0b20 */ 137, 76, 36, 16,139, 76, 36, 48,186,  1,  0,  0,  0,137, 76, 36,
/* 0x0b30 */  40,141, 44, 18,139,116, 36, 16,  1,238,129,124, 36, 72,255,255,
/* 0x0b40 */ 255,  0,119, 24, 59, 92, 36, 76, 15,132,209,  2,  0,  0,193,100,
/* 0x0b50 */  36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,
/* 0x0b60 */ 102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 24,
/* 0x0b70 */ 137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,
/* 0x0b80 */   2,137,234,102,137,  6,235, 21, 41, 68, 36, 72, 41,199,137,208,
/* 0x0b90 */ 102,193,232,  5,102, 41,194,102,137, 22,141, 85,  1,139,116, 36,
/* 0x0ba0 */  40, 78,137,116, 36, 40,117,137,138, 76, 36, 48,184,  1,  0,  0,
/* 0x0bb0 */   0,211,224, 41,194,  3, 84, 36, 44,131,124, 36, 96,  3,137, 84,
/* 0x0bc0 */  36, 12, 15,143,231,  1,  0,  0,131, 68, 36, 96,  7,131,250,  3,
/* 0x0bd0 */ 137,208,126,  5,184,  3,  0,  0,  0,139,116, 36,120,193,224,  7,
/* 0x0be0 */ 199, 68, 36, 36,  6,  0,  0,  0,141,132,  6, 96,  3,  0,  0,137,
/* 0x0bf0 */  68, 36,  8,184,  1,  0,  0,  0,141, 44,  0,139,116, 36,  8,  1,
/* 0x0c00 */ 238,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,
/* 0x0c10 */ 132, 10,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,
/* 0x0c20 */  67,  9,199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,202,
/* 0x0c30 */  15,175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,  0,
/* 0x0c40 */  41,200,193,248,  5,141,  4,  2,102,137,  6,137,232,235, 21, 41,
/* 0x0c50 */  68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,141, 69,
/* 0x0c60 */   1,102,137, 22,139,108, 36, 36, 77,137,108, 36, 36,117,137,141,
/* 0x0c70 */  80,192,131,250,  3,137, 20, 36, 15,142, 39,  1,  0,  0,137,208,
/* 0x0c80 */ 137,214,209,248,131,230,  1,141, 72,255,131,206,  2,131,250, 13,
/* 0x0c90 */ 137, 76, 36, 32,127, 28,139,108, 36,120,211,230,  1,210,137, 52,
/* 0x0ca0 */  36,141, 68,117,  0, 41,208,  5, 94,  5,  0,  0,137, 68, 36,  4,
/* 0x0cb0 */ 235, 86,141, 80,251,129,124, 36, 72,255,255,255,  0,119, 24, 59,
/* 0x0cc0 */  92, 36, 76, 15,132, 86,  1,  0,  0,193,100, 36, 72,  8, 15,182,
/* 0x0cd0 */   3,193,231,  8, 67,  9,199,209,108, 36, 72,  1,246, 59,124, 36,
/* 0x0ce0 */  72,114,  7, 43,124, 36, 72,131,206,  1, 74,117,200,139, 68, 36,
/* 0x0cf0 */ 120,193,230,  4,137, 52, 36,  5, 68,  6,  0,  0,199, 68, 36, 32,
/* 0x0d00 */   4,  0,  0,  0,137, 68, 36,  4,199, 68, 36, 28,  1,  0,  0,  0,
/* 0x0d10 */ 184,  1,  0,  0,  0,139,108, 36,  4,  1,192,137, 68, 36, 24,  1,
/* 0x0d20 */ 197,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,
/* 0x0d30 */ 132,234,  0,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,
/* 0x0d40 */  67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,232, 11, 15,183,
/* 0x0d50 */ 242, 15,175,198, 57,199,115, 27,137, 68, 36, 72,184,  0,  8,  0,
/* 0x0d60 */   0, 41,240,193,248,  5,141,  4,  2,102,137, 69,  0,139, 68, 36,
/* 0x0d70 */  24,235, 31, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102,
/* 0x0d80 */  41,194,139, 68, 36, 24,102,137, 85,  0,139, 84, 36, 28, 64,  9,
/* 0x0d90 */  20, 36,139, 76, 36, 32,209,100, 36, 28, 73,137, 76, 36, 32, 15,
/* 0x0da0 */ 133,112,255,255,255,139, 52, 36, 70,137,116, 36, 92,116, 89,139,
/* 0x0db0 */  76, 36, 12,139,108, 36,116,131,193,  2, 57,108, 36, 92,119, 95,
/* 0x0dc0 */ 139,132, 36,160,  0,  0,  0,137,234, 43, 68, 36, 92,  3,148, 36,
/* 0x0dd0 */ 160,  0,  0,  0,141, 52, 40,138,  6, 70,136, 68, 36,115,136,  2,
/* 0x0de0 */  66,255, 68, 36,116, 73,116, 15,139,172, 36,164,  0,  0,  0, 57,
/* 0x0df0 */ 108, 36,116,114,226,235, 17,139,132, 36,164,  0,  0,  0, 57, 68,
/* 0x0e00 */  36,116, 15,130,187,246,255,255,129,124, 36, 72,255,255,255,  0,
/* 0x0e10 */ 119, 21, 59, 92, 36, 76,184,  1,  0,  0,  0,116, 41,235,  7,184,
/* 0x0e20 */   1,  0,  0,  0,235, 32, 67, 43,156, 36,148,  0,  0,  0, 49,192,
/* 0x0e30 */ 139,148, 36,156,  0,  0,  0,139, 76, 36,116,137, 26,139,156, 36,
/* 0x0e40 */ 168,  0,  0,  0,137, 11,131,196,124, 91, 94, 95, 93, 85, 87, 86,
/* 0x0e50 */  83,131,236,124,139,148, 36,144,  0,  0,  0,199, 68, 36,116,  0,
/* 0x0e60 */   0,  0,  0,198, 68, 36,115,  0,139,172, 36,156,  0,  0,  0,141,
/* 0x0e70 */  66,  4,137, 68, 36,120,184,  1,  0,  0,  0, 15,182, 74,  2,137,
/* 0x0e80 */ 195,211,227,137,217, 73,137, 76, 36,108, 15,182, 74,  1,211,224,
/* 0x0e90 */  72,137, 68, 36,104,139,132, 36,168,  0,  0,  0, 15,182, 50,199,
/* 0x0ea0 */  69,  0,  0,  0,  0,  0,199, 68, 36, 96,  0,  0,  0,  0,199,  0,
/* 0x0eb0 */   0,  0,  0,  0,184,  0,  3,  0,  0,137,116, 36,100,199, 68, 36,
/* 0x0ec0 */  92,  1,  0,  0,  0,199, 68, 36, 88,  1,  0,  0,  0,199, 68, 36,
/* 0x0ed0 */  84,  1,  0,  0,  0,199, 68, 36, 80,  1,  0,  0,  0, 15,182, 74,
/* 0x0ee0 */   1,  1,241,211,224,141,136, 54,  7,  0,  0, 57, 76, 36,116,115,
/* 0x0ef0 */  14,139, 68, 36,120,102,199,  0,  0,  4,131,192,  2,226,246,139,
/* 0x0f00 */ 156, 36,148,  0,  0,  0, 49,255,199, 68, 36, 72,255,255,255,255,
/* 0x0f10 */ 137,218,  3,148, 36,152,  0,  0,  0,137, 84, 36, 76, 49,210, 59,
/* 0x0f20 */  92, 36, 76, 15,132,124,  9,  0,  0, 15,182,  3,193,231,  8, 66,
/* 0x0f30 */  67,  9,199,131,250,  4,126,231,139,140, 36,164,  0,  0,  0, 57,
/* 0x0f40 */  76, 36,116, 15,131,100,  9,  0,  0,139,116, 36,116, 35,116, 36,
/* 0x0f50 */ 108,139, 68, 36, 96,139, 84, 36,120,193,224,  4,137,116, 36, 68,
/* 0x0f60 */   1,240,129,124, 36, 72,255,255,255,  0,141, 44, 66,119, 24, 59,
/* 0x0f70 */  92, 36, 76, 15,132, 44,  9,  0,  0,193,100, 36, 72,  8, 15,182,
/* 0x0f80 */   3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,
/* 0x0f90 */ 232, 11, 15,183,202, 15,175,193, 57,199, 15,131,221,  1,  0,  0,
/* 0x0fa0 */ 137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,138, 76, 36,100,193,
/* 0x0fb0 */ 248,  5,190,  1,  0,  0,  0,141,  4,  2, 15,182, 84, 36,115,102,
/* 0x0fc0 */ 137, 69,  0,139, 68, 36,116, 35, 68, 36,104,139,108, 36,120,211,
/* 0x0fd0 */ 224,185,  8,  0,  0,  0, 43, 76, 36,100,211,250,  1,208,105,192,
/* 0x0fe0 */   0,  6,  0,  0,131,124, 36, 96,  6,141,132,  5,108, 14,  0,  0,
/* 0x0ff0 */ 137, 68, 36, 20, 15,142,202,  0,  0,  0,139, 68, 36,116, 43, 68,
/* 0x1000 */  36, 92,139,148, 36,160,  0,  0,  0, 15,182,  4,  2,137, 68, 36,
/* 0x1010 */  64,209,100, 36, 64,139, 76, 36, 64,141, 20, 54,139,108, 36, 20,
/* 0x1020 */ 129,225,  0,  1,  0,  0,129,124, 36, 72,255,255,255,  0,141, 68,
/* 0x1030 */  77,  0,137, 76, 36, 60,141, 44, 16,119, 24, 59, 92, 36, 76, 15,
/* 0x1040 */ 132, 96,  8,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,
/* 0x1050 */  67,  9,199,139, 68, 36, 72,102,139,141,  0,  2,  0,  0,193,232,
/* 0x1060 */  11, 15,183,241, 15,175,198, 57,199,115, 35,137, 68, 36, 72,184,
/* 0x1070 */   0,  8,  0,  0, 41,240,137,214,193,248,  5,131,124, 36, 60,  0,
/* 0x1080 */ 141,  4,  1,102,137,133,  0,  2,  0,  0,116, 34,235, 46, 41, 68,
/* 0x1090 */  36, 72, 41,199,137,200,141,114,  1,102,193,232,  5,102, 41,193,
/* 0x10a0 */ 131,124, 36, 60,  0,102,137,141,  0,  2,  0,  0,116, 14,129,254,
/* 0x10b0 */ 255,  0,  0,  0, 15,142, 87,255,255,255,235,121,129,254,255,  0,
/* 0x10c0 */   0,  0,127,113,141, 20, 54,139,108, 36, 20,  1,213,129,124, 36,
/* 0x10d0 */  72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,196,  7,  0,
/* 0x10e0 */   0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139,
/* 0x10f0 */  68, 36, 72,102,139, 77,  0,193,232, 11, 15,183,241, 15,175,198,
/* 0x1100 */  57,199,115, 25,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,
/* 0x1110 */ 214,193,248,  5,141,  4,  1,102,137, 69,  0,235,159, 41, 68, 36,
/* 0x1120 */  72, 41,199,137,200,141,114,  1,102,193,232,  5,102, 41,193,102,
/* 0x1130 */ 137, 77,  0,235,135,139, 84, 36,116,137,240,139,140, 36,160,  0,
/* 0x1140 */   0,  0,136, 68, 36,115,136,  4, 10, 66,131,124, 36, 96,  3,137,
/* 0x1150 */  84, 36,116,127, 13,199, 68, 36, 96,  0,  0,  0,  0,233, 27,  7,
/* 0x1160 */   0,  0,131,124, 36, 96,  9,127, 10,131,108, 36, 96,  3,233, 10,
/* 0x1170 */   7,  0,  0,131,108, 36, 96,  6,233,  0,  7,  0,  0,139, 76, 36,
/* 0x1180 */  72, 41,199,139,116, 36, 96, 41,193,137,208,102,193,232,  5,102,
/* 0x1190 */  41,194,129,249,255,255,255,  0,102,137, 85,  0,139,108, 36,120,
/* 0x11a0 */ 141,116,117,  0,137,116, 36, 56,119, 22, 59, 92, 36, 76, 15,132,
/* 0x11b0 */ 241,  6,  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,199,
/* 0x11c0 */ 139,108, 36, 56,137,200,193,232, 11,102,139,149,128,  1,  0,  0,
/* 0x11d0 */  15,183,234, 15,175,197, 57,199,115, 82,137,198,184,  0,  8,  0,
/* 0x11e0 */   0, 41,232,139,108, 36, 88,193,248,  5,139, 76, 36, 84,141,  4,
/* 0x11f0 */   2,139, 84, 36, 56,137, 76, 36, 80,139, 76, 36,120,102,137,130,
/* 0x1200 */ 128,  1,  0,  0,139, 68, 36, 92,137,108, 36, 84,137, 68, 36, 88,
/* 0x1210 */  49,192,131,124, 36, 96,  6, 15,159,192,129,193,100,  6,  0,  0,
/* 0x1220 */ 141,  4, 64,137, 68, 36, 96,233,116,  2,  0,  0,137,206, 41,199,
/* 0x1230 */  41,198,137,208,102,193,232,  5,139, 76, 36, 56,102, 41,194,129,
/* 0x1240 */ 254,255,255,255,  0,102,137,145,128,  1,  0,  0,119, 22, 59, 92,
/* 0x1250 */  36, 76, 15,132, 77,  6,  0,  0, 15,182,  3,193,231,  8,193,230,
/* 0x1260 */   8, 67,  9,199,139,108, 36, 56,137,242,193,234, 11,102,139,141,
/* 0x1270 */ 152,  1,  0,  0, 15,183,193, 15,175,208, 57,215, 15,131,227,  0,
/* 0x1280 */   0,  0,189,  0,  8,  0,  0,137,214, 41,197,199, 68, 36, 52,  0,
/* 0x1290 */   8,  0,  0,137,232,193,248,  5,141,  4,  1,139, 76, 36, 56,102,
/* 0x12a0 */ 137,129,152,  1,  0,  0,139, 68, 36, 96,139, 76, 36, 68,193,224,
/* 0x12b0 */   5,  3, 68, 36,120,129,250,255,255,255,  0,141, 44, 72,119, 22,
/* 0x12c0 */  59, 92, 36, 76, 15,132,219,  5,  0,  0, 15,182,  3,193,231,  8,
/* 0x12d0 */ 193,230,  8, 67,  9,199,102,139,149,224,  1,  0,  0,137,240,193,
/* 0x12e0 */ 232, 11, 15,183,202, 15,175,193, 57,199,115, 96, 41, 76, 36, 52,
/* 0x12f0 */ 193,124, 36, 52,  5,139,116, 36, 52,137, 68, 36, 72,131,124, 36,
/* 0x1300 */ 116,  0,141,  4, 50,102,137,133,224,  1,  0,  0, 15,132,147,  5,
/* 0x1310 */   0,  0, 49,192,131,124, 36, 96,  6,139,172, 36,160,  0,  0,  0,
/* 0x1320 */ 139, 84, 36,116, 15,159,192,141, 68,  0,  9,137, 68, 36, 96,139,
/* 0x1330 */  68, 36,116, 43, 68, 36, 92,138, 68,  5,  0,136, 68, 36,115,136,
/* 0x1340 */   4, 42, 66,137, 84, 36,116,233, 49,  5,  0,  0, 41,198, 41,199,
/* 0x1350 */ 137,208,102,193,232,  5,102, 41,194,102,137,149,224,  1,  0,  0,
/* 0x1360 */ 233, 31,  1,  0,  0,137,200, 41,214,102,193,232,  5,139,108, 36,
/* 0x1370 */  56,102, 41,193, 41,215,129,254,255,255,255,  0,102,137,141,152,
/* 0x1380 */   1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 22,  5,  0,  0, 15,
/* 0x1390 */ 182,  3,193,231,  8,193,230,  8, 67,  9,199,139, 76, 36, 56,137,
/* 0x13a0 */ 240,193,232, 11,102,139,145,176,  1,  0,  0, 15,183,202, 15,175,
/* 0x13b0 */ 193, 57,199,115, 35,137,198,184,  0,  8,  0,  0, 41,200,139,108,
/* 0x13c0 */  36, 56,193,248,  5,141,  4,  2,102,137,133,176,  1,  0,  0,139,
/* 0x13d0 */  68, 36, 88,233,160,  0,  0,  0,137,241, 41,199, 41,193,137,208,
/* 0x13e0 */ 102,193,232,  5,102, 41,194,139, 68, 36, 56,129,249,255,255,255,
/* 0x13f0 */   0,102,137,144,176,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132,
/* 0x1400 */ 161,  4,  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,199,
/* 0x1410 */ 139,116, 36, 56,137,200,193,232, 11,102,139,150,200,  1,  0,  0,
/* 0x1420 */  15,183,234, 15,175,197, 57,199,115, 32,137,198,184,  0,  8,  0,
/* 0x1430 */   0, 41,232,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,
/* 0x1440 */ 200,  1,  0,  0,139, 68, 36, 84,235, 38,137,206, 41,199, 41,198,
/* 0x1450 */ 137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,102,137,144,
/* 0x1460 */ 200,  1,  0,  0,139, 84, 36, 84,139, 68, 36, 80,137, 84, 36, 80,
/* 0x1470 */ 139, 76, 36, 88,137, 76, 36, 84,139,108, 36, 92,137, 68, 36, 92,
/* 0x1480 */ 137,108, 36, 88, 49,192,131,124, 36, 96,  6,139, 76, 36,120, 15,
/* 0x1490 */ 159,192,129,193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36, 96,
/* 0x14a0 */ 129,254,255,255,255,  0,119, 22, 59, 92, 36, 76, 15,132,243,  3,
/* 0x14b0 */   0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139,
/* 0x14c0 */  17,137,240,193,232, 11, 15,183,234, 15,175,197, 57,199,115, 47,
/* 0x14d0 */ 137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,
/* 0x14e0 */ 193,248,  5,199, 68, 36, 44,  0,  0,  0,  0,141,  4,  2,102,137,
/* 0x14f0 */   1,139, 68, 36, 68,141, 76,  1,  4,137, 76, 36, 16,235,114, 41,
/* 0x1500 */ 198, 41,199,137,208,102,193,232,  5,102, 41,194,129,254,255,255,
/* 0x1510 */ 255,  0,102,137, 17,119, 22, 59, 92, 36, 76, 15,132,132,  3,  0,
/* 0x1520 */   0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139, 81,
/* 0x1530 */   2,137,240,193,232, 11, 15,183,234, 15,175,197, 57,199,115, 59,
/* 0x1540 */ 137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,
/* 0x1550 */ 193,248,  5,199, 68, 36, 44,  8,  0,  0,  0,141,  4,  2,139, 84,
/* 0x1560 */  36, 68,102,137, 65,  2,141,140, 17,  4,  1,  0,  0,137, 76, 36,
/* 0x1570 */  16,199, 68, 36, 48,  3,  0,  0,  0,235, 47, 41,198, 41,199,137,
/* 0x1580 */ 208,137,116, 36, 72,102,193,232,  5,199, 68, 36, 44, 16,  0,  0,
/* 0x1590 */   0,102, 41,194,199, 68, 36, 48,  8,  0,  0,  0,102,137, 81,  2,
/* 0x15a0 */ 129,193,  4,  2,  0,  0,137, 76, 36, 16,139, 76, 36, 48,186,  1,
/* 0x15b0 */   0,  0,  0,137, 76, 36, 40,141, 44, 18,139,116, 36, 16,  1,238,
/* 0x15c0 */ 129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,
/* 0x15d0 */ 209,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,
/* 0x15e0 */   9,199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,202, 15,
/* 0x15f0 */ 175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,
/* 0x1600 */ 200,193,248,  5,141,  4,  2,137,234,102,137,  6,235, 21, 41, 68,
/* 0x1610 */  36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,102,137, 22,
/* 0x1620 */ 141, 85,  1,139,116, 36, 40, 78,137,116, 36, 40,117,137,138, 76,
/* 0x1630 */  36, 48,184,  1,  0,  0,  0,211,224, 41,194,  3, 84, 36, 44,131,
/* 0x1640 */ 124, 36, 96,  3,137, 84, 36, 12, 15,143,231,  1,  0,  0,131, 68,
/* 0x1650 */  36, 96,  7,131,250,  3,137,208,126,  5,184,  3,  0,  0,  0,139,
/* 0x1660 */ 116, 36,120,193,224,  7,199, 68, 36, 36,  6,  0,  0,  0,141,132,
/* 0x1670 */   6, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,  0,141, 44,
/* 0x1680 */   0,139,116, 36,  8,  1,238,129,124, 36, 72,255,255,255,  0,119,
/* 0x1690 */  24, 59, 92, 36, 76, 15,132, 10,  2,  0,  0,193,100, 36, 72,  8,
/* 0x16a0 */  15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,
/* 0x16b0 */ 193,232, 11, 15,183,202, 15,175,193, 57,199,115, 24,137, 68, 36,
/* 0x16c0 */  72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,
/* 0x16d0 */   6,137,232,235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,232,
/* 0x16e0 */   5,102, 41,194,141, 69,  1,102,137, 22,139,108, 36, 36, 77,137,
/* 0x16f0 */ 108, 36, 36,117,137,141, 80,192,131,250,  3,137, 20, 36, 15,142,
/* 0x1700 */  39,  1,  0,  0,137,208,137,214,209,248,131,230,  1,141, 72,255,
/* 0x1710 */ 131,206,  2,131,250, 13,137, 76, 36, 32,127, 28,139,108, 36,120,
/* 0x1720 */ 211,230,  1,210,137, 52, 36,141, 68,117,  0, 41,208,  5, 94,  5,
/* 0x1730 */   0,  0,137, 68, 36,  4,235, 86,141, 80,251,129,124, 36, 72,255,
/* 0x1740 */ 255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 86,  1,  0,  0,193,
/* 0x1750 */ 100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,209,108, 36,
/* 0x1760 */  72,  1,246, 59,124, 36, 72,114,  7, 43,124, 36, 72,131,206,  1,
/* 0x1770 */  74,117,200,139, 68, 36,120,193,230,  4,137, 52, 36,  5, 68,  6,
/* 0x1780 */   0,  0,199, 68, 36, 32,  4,  0,  0,  0,137, 68, 36,  4,199, 68,
/* 0x1790 */  36, 28,  1,  0,  0,  0,184,  1,  0,  0,  0,139,108, 36,  4,  1,
/* 0x17a0 */ 192,137, 68, 36, 24,  1,197,129,124, 36, 72,255,255,255,  0,119,
/* 0x17b0 */  24, 59, 92, 36, 76, 15,132,234,  0,  0,  0,193,100, 36, 72,  8,
/* 0x17c0 */  15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,
/* 0x17d0 */   0,193,232, 11, 15,183,242, 15,175,198, 57,199,115, 27,137, 68,
/* 0x17e0 */  36, 72,184,  0,  8,  0,  0, 41,240,193,248,  5,141,  4,  2,102,
/* 0x17f0 */ 137, 69,  0,139, 68, 36, 24,235, 31, 41, 68, 36, 72, 41,199,137,
/* 0x1800 */ 208,102,193,232,  5,102, 41,194,139, 68, 36, 24,102,137, 85,  0,
/* 0x1810 */ 139, 84, 36, 28, 64,  9, 20, 36,139, 76, 36, 32,209,100, 36, 28,
/* 0x1820 */  73,137, 76, 36, 32, 15,133,112,255,255,255,139, 52, 36, 70,137,
/* 0x1830 */ 116, 36, 92,116, 89,139, 76, 36, 12,139,108, 36,116,131,193,  2,
/* 0x1840 */  57,108, 36, 92,119, 95,139,132, 36,160,  0,  0,  0,137,234, 43,
/* 0x1850 */  68, 36, 92,  3,148, 36,160,  0,  0,  0,141, 52, 40,138,  6, 70,
/* 0x1860 */ 136, 68, 36,115,136,  2, 66,255, 68, 36,116, 73,116, 15,139,172,
/* 0x1870 */  36,164,  0,  0,  0, 57,108, 36,116,114,226,235, 17,139,132, 36,
/* 0x1880 */ 164,  0,  0,  0, 57, 68, 36,116, 15,130,187,246,255,255,129,124,
/* 0x1890 */  36, 72,255,255,255,  0,119, 21, 59, 92, 36, 76,184,  1,  0,  0,
/* 0x18a0 */   0,116, 41,235,  7,184,  1,  0,  0,  0,235, 32, 67, 43,156, 36,
/* 0x18b0 */ 148,  0,  0,  0, 49,192,139,148, 36,156,  0,  0,  0,139, 76, 36,
/* 0x18c0 */ 116,137, 26,139,156, 36,168,  0,  0,  0,137, 11,131,196,124, 91,
/* 0x18d0 */  94, 95, 93,  3,115,252,  3,123,248, 49,192,141,140, 36,  0,255,
/* 0x18e0 */ 255,255,137,236, 80, 57,204,117,251,137,236, 49,201,139, 84, 36,
/* 0x18f0 */  40,  3, 84, 36, 44, 57,242,116,  1, 72,135, 68, 36, 32,139, 84,
/* 0x1900 */  36, 52,137,249,139,124, 36, 48, 41,249,137, 10, 90, 87,106, 15,
/* 0x1910 */  91,136,215,147,233,252,255,255,255,235,  4, 90, 88, 89,151, 96,
/* 0x1920 */  49,219,187,  0,  0,  0,  0,106, 15, 88,138,100, 36, 32,106, 15,
/* 0x1930 */  91,138,124, 36, 32,138, 84, 36, 32,233,252,255,255,255, 15,183,
/* 0x1940 */  47, 43,110, 12, 41,221,117,255,131,237,  1,115,255,136, 95,255,
/* 0x1950 */  73,136,  7, 71,139,  7,156,102,193,232,  8,193,192, 16,134,196,
/* 0x1960 */ 157,115,255,176,  0, 15,200,115,255,193,232,  1,115,  4,254,203,
/* 0x1970 */  75, 35, 30,125,  2,  3, 30,137,  4,156,235,255,141, 20, 24, 15,
/* 0x1980 */ 182,210, 35, 22, 59, 22,114,  2, 43, 22,139,  4,148,254,203, 75,
/* 0x1990 */  35, 30,125,  2,  3, 30,139, 44,156,133,237,117,  9, 80,139, 70,
/* 0x19a0 */   4,254,200, 72, 35,  6,125,  2,  3,  6, 49,237,137, 70,  4,135,
/* 0x19b0 */ 108,132,  4, 88,137, 44,148,137,  4,156, 41,248,131,233,  4,  3,
/* 0x19c0 */  70, 16,  1,240,137,  7,131,199,  4,235,255, 80,176,233,176,232,
/* 0x19d0 */  80,106,  0, 83,137,230, 94,137,218,178,233,178,232, 67,106,  0,
/* 0x19e0 */ 254,203, 75,117,255, 15,183,  7,131,199,  1, 60,128,114,  4, 60,
/* 0x19f0 */ 143,118,255, 41,208, 43, 70,  8,131,232,  2,116,255,131,232,  1,
/* 0x1a00 */ 114,255,115,255,122,  0,123,  0,248,235,255,131,233,  1,127,255,
/* 0x1a10 */ 137,231,185,  4,  1,  0,  0,139, 14,131,193,  5,139, 14,131,193,
/* 0x1a20 */   4, 49,192,243,171,137,252, 86, 97,151, 81, 80, 82,195,137,254,
/* 0x1a30 */ 235, 31,138,  7, 71, 60,128,114, 10, 60,143,119,  6,128,127,254,
/* 0x1a40 */  15,116,  5, 44,232, 60,  1,119,255,131,249,  4,114,  4,139,  7,
/* 0x1a50 */  40,208,117,255,134,196,193,192, 16,134,196, 41,248,  1,240,131,
/* 0x1a60 */ 233,  4,171,131,233,  1,114,  4,138,  7, 71,235, 13,131,233,  1,
/* 0x1a70 */ 115,  3,185,  0,  0,  0,  0,137,254,138,  7, 71, 44,232, 60,  1,
/* 0x1a80 */ 119,247,128, 63,  0,117,  6,139,  7,138, 95,  4,102,193,232,  8,
/* 0x1a90 */ 134,196,193,192, 16,134,196, 41,248,128,235,232,  1,240,137,  7,
/* 0x1aa0 */ 131,199,  5,136,216,226, 11,185,  0,  0,  0,  0,176,232,176,233,
/* 0x1ab0 */ 242,174,117,  6,128, 63,  0,117,255,139,  7,102,193,232,  8,134,
/* 0x1ac0 */ 196,193,192, 16,134,196, 41,248,  1,240,171,235,  4, 97,195, 93,
/* 0x1ad0 */ 187,  0, 16, 64,  0,102,105,108,101, 32,102,111,114,109, 97,116,
/* 0x1ae0 */  32,101,108,102, 51, 50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,
/* 0x1af0 */ 116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32,
/* 0x1b00 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32,
/* 0x1b10 */  32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65,
/* 0x1b20 */  32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32,
/* 0x1b30 */  32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48,
/* 0x1b40 */  32, 76, 69, 88, 69, 67, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x1b50 */  48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b60 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1b70 */  48, 48, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1b80 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x1b90 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 76, 69, 88, 69, 67,
/* 0x1ba0 */  48, 48, 57, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1bb0 */  53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1bc0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 51, 57, 32,
/* 0x1bd0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1be0 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1bf0 */  10, 32, 32, 50, 32, 76, 69, 88, 69, 67, 48, 49, 48, 32, 32, 32,
/* 0x1c00 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101, 32, 32, 48, 48, 48,
/* 0x1c10 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1c20 */  32, 48, 48, 48, 48, 48, 48, 51,101, 32, 32, 50, 42, 42, 48, 32,
/* 0x1c30 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x1c40 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 78,
/* 0x1c50 */  50, 66, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x1c60 */  48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1c70 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1c80 */  48, 52, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1c90 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x1ca0 */  79, 78, 76, 89, 10, 32, 32, 52, 32, 78, 50, 66, 70, 65, 83, 49,
/* 0x1cb0 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,
/* 0x1cc0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1cd0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52,102, 32, 32, 50,
/* 0x1ce0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x1cf0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x1d00 */  32, 53, 32, 78, 50, 66, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32,
/* 0x1d10 */  32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48,
/* 0x1d20 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1d30 */  48, 48, 48, 48, 48, 53, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1d40 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x1d50 */  89, 10, 32, 32, 54, 32, 78, 50, 66, 68, 69, 67, 49, 48, 32, 32,
/* 0x1d60 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48,
/* 0x1d70 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d80 */  32, 32, 48, 48, 48, 48, 48, 48, 53, 55, 32, 32, 50, 42, 42, 48,
/* 0x1d90 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x1da0 */  79, 78, 76, 89, 10, 32, 32, 55, 32, 78, 50, 66, 83, 77, 65, 50,
/* 0x1db0 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32,
/* 0x1dc0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1dd0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 54, 50, 32, 32, 50,
/* 0x1de0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x1df0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x1e00 */  32, 56, 32, 78, 50, 66, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32,
/* 0x1e10 */  32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48,
/* 0x1e20 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1e30 */  48, 48, 48, 48, 48, 54, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1e40 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x1e50 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32, 78, 50, 66,
/* 0x1e60 */  68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1e70 */  48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1e80 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 55,
/* 0x1e90 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1ea0 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 48, 32,
/* 0x1eb0 */  78, 50, 66, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x1ec0 */  48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ed0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1ee0 */  48, 48, 55,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1ef0 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x1f00 */  68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 78, 50, 66, 70, 65, 83,
/* 0x1f10 */  51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102,
/* 0x1f20 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1f30 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 56, 97, 32, 32,
/* 0x1f40 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x1f50 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1f60 */  32, 49, 50, 32, 78, 50, 66, 68, 69, 67, 51, 48, 32, 32, 32, 32,
/* 0x1f70 */  32, 32, 48, 48, 48, 48, 48, 48, 51,101, 32, 32, 48, 48, 48, 48,
/* 0x1f80 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1f90 */  48, 48, 48, 48, 48, 48, 57, 57, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1fa0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x1fb0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 78, 50,
/* 0x1fc0 */  66, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1fd0 */  48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1fe0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1ff0 */ 100, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2000 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x2010 */  78, 76, 89, 10, 32, 49, 52, 32, 78, 50, 66, 70, 65, 83, 52, 48,
/* 0x2020 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32,
/* 0x2030 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2040 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101, 52, 32, 32, 50, 42,
/* 0x2050 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x2060 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,
/* 0x2070 */  53, 32, 78, 50, 66, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32,
/* 0x2080 */  48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2090 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x20a0 */  48, 48, 48, 48,102, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x20b0 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x20c0 */  10, 32, 49, 54, 32, 78, 50, 66, 70, 65, 83, 53, 48, 32, 32, 32,
/* 0x20d0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48,
/* 0x20e0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x20f0 */  32, 48, 48, 48, 48, 48, 48,102, 53, 32, 32, 50, 42, 42, 48, 32,
/* 0x2100 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x2110 */  78, 76, 89, 10, 32, 49, 55, 32, 78, 50, 66, 68, 69, 67, 53, 48,
/* 0x2120 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32,
/* 0x2130 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2140 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48,102, 56, 32, 32, 50, 42,
/* 0x2150 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x2160 */  65, 68, 79, 78, 76, 89, 10, 32, 49, 56, 32, 78, 50, 66, 83, 77,
/* 0x2170 */  65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2180 */  99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2190 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 48, 49, 32,
/* 0x21a0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x21b0 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x21c0 */  10, 32, 49, 57, 32, 78, 50, 66, 70, 65, 83, 54, 48, 32, 32, 32,
/* 0x21d0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 57, 32, 32, 48, 48, 48,
/* 0x21e0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x21f0 */  32, 48, 48, 48, 48, 48, 49, 48,100, 32, 32, 50, 42, 42, 48, 32,
/* 0x2200 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x2210 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 48, 32, 78,
/* 0x2220 */  50, 66, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x2230 */  48, 48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2240 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2250 */  49, 50, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2260 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x2270 */  79, 78, 76, 89, 10, 32, 50, 49, 32, 78, 50, 66, 68, 69, 67, 54,
/* 0x2280 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2290 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x22a0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 51, 99, 32, 32, 50,
/* 0x22b0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x22c0 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 50, 32, 78, 50, 68, 83,
/* 0x22d0 */  77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x22e0 */  48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x22f0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 51, 99,
/* 0x2300 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2310 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x2320 */  89, 10, 32, 50, 51, 32, 78, 50, 68, 70, 65, 83, 49, 48, 32, 32,
/* 0x2330 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48,
/* 0x2340 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2350 */  32, 32, 48, 48, 48, 48, 48, 49, 51,102, 32, 32, 50, 42, 42, 48,
/* 0x2360 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x2370 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 52, 32,
/* 0x2380 */  78, 50, 68, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2390 */  48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x23a0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x23b0 */  48, 49, 52, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x23c0 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x23d0 */  50, 53, 32, 78, 50, 68, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32,
/* 0x23e0 */  32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48, 48,
/* 0x23f0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2400 */  48, 48, 48, 48, 49, 52, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2410 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x2420 */  89, 10, 32, 50, 54, 32, 78, 50, 68, 83, 77, 65, 50, 48, 32, 32,
/* 0x2430 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48,
/* 0x2440 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2450 */  32, 32, 48, 48, 48, 48, 48, 49, 53, 50, 32, 32, 50, 42, 42, 48,
/* 0x2460 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x2470 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 55, 32,
/* 0x2480 */  78, 50, 68, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2490 */  48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x24a0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x24b0 */  48, 49, 53, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x24c0 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x24d0 */  68, 79, 78, 76, 89, 10, 32, 50, 56, 32, 78, 50, 68, 68, 69, 67,
/* 0x24e0 */  50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100,
/* 0x24f0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2500 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 54, 48, 32, 32,
/* 0x2510 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x2520 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 57, 32, 78, 50, 68,
/* 0x2530 */  83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2540 */  48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2550 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 54,
/* 0x2560 */ 100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2570 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2580 */  76, 89, 10, 32, 51, 48, 32, 78, 50, 68, 70, 65, 83, 51, 48, 32,
/* 0x2590 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48,
/* 0x25a0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x25b0 */  48, 32, 32, 48, 48, 48, 48, 48, 49, 55, 97, 32, 32, 50, 42, 42,
/* 0x25c0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x25d0 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 49,
/* 0x25e0 */  32, 78, 50, 68, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x25f0 */  48, 48, 48, 48, 48, 53, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2600 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2610 */  48, 48, 49, 56, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2620 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x2630 */  65, 68, 79, 78, 76, 89, 10, 32, 51, 50, 32, 78, 50, 68, 83, 77,
/* 0x2640 */  65, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2650 */ 100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2660 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,100, 98, 32,
/* 0x2670 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2680 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x2690 */  10, 32, 51, 51, 32, 78, 50, 68, 70, 65, 83, 52, 48, 32, 32, 32,
/* 0x26a0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48,
/* 0x26b0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x26c0 */  32, 48, 48, 48, 48, 48, 49,101, 56, 32, 32, 50, 42, 42, 48, 32,
/* 0x26d0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x26e0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 52, 32, 78,
/* 0x26f0 */  50, 68, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x2700 */  48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2710 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2720 */  49,102, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2730 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51,
/* 0x2740 */  53, 32, 78, 50, 68, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32,
/* 0x2750 */  48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2760 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2770 */  48, 48, 48, 49,102, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2780 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x2790 */  10, 32, 51, 54, 32, 78, 50, 68, 68, 69, 67, 53, 48, 32, 32, 32,
/* 0x27a0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48,
/* 0x27b0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x27c0 */  32, 48, 48, 48, 48, 48, 49,102, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x27d0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x27e0 */  78, 76, 89, 10, 32, 51, 55, 32, 78, 50, 68, 83, 77, 65, 54, 48,
/* 0x27f0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 99, 32, 32,
/* 0x2800 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2810 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 48, 53, 32, 32, 50, 42,
/* 0x2820 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x2830 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51,
/* 0x2840 */  56, 32, 78, 50, 68, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32,
/* 0x2850 */  48, 48, 48, 48, 48, 48, 49, 57, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2860 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2870 */  48, 48, 48, 50, 49, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2880 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x2890 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 57, 32, 78, 50, 68, 70,
/* 0x28a0 */  65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x28b0 */  49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x28c0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 50, 97,
/* 0x28d0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x28e0 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x28f0 */  89, 10, 32, 52, 48, 32, 78, 50, 68, 68, 69, 67, 54, 48, 32, 32,
/* 0x2900 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2910 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2920 */  32, 32, 48, 48, 48, 48, 48, 50, 52, 48, 32, 32, 50, 42, 42, 48,
/* 0x2930 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x2940 */  79, 78, 76, 89, 10, 32, 52, 49, 32, 78, 50, 69, 83, 77, 65, 49,
/* 0x2950 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32,
/* 0x2960 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2970 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 52, 48, 32, 32, 50,
/* 0x2980 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x2990 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x29a0 */  52, 50, 32, 78, 50, 69, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32,
/* 0x29b0 */  32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48,
/* 0x29c0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x29d0 */  48, 48, 48, 48, 50, 52, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x29e0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x29f0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 51, 32, 78, 50, 69,
/* 0x2a00 */  70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2a10 */  48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2a20 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 52,
/* 0x2a30 */  53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2a40 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 52, 32,
/* 0x2a50 */  78, 50, 69, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2a60 */  48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2a70 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2a80 */  48, 50, 52, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2a90 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2aa0 */  52, 53, 32, 78, 50, 69, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32,
/* 0x2ab0 */  32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48,
/* 0x2ac0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2ad0 */  48, 48, 48, 48, 50, 53, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2ae0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x2af0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 54, 32, 78, 50, 69,
/* 0x2b00 */  70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2b10 */  48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2b20 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 53,
/* 0x2b30 */  98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2b40 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2b50 */  76, 89, 10, 32, 52, 55, 32, 78, 50, 69, 68, 69, 67, 50, 48, 32,
/* 0x2b60 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48,
/* 0x2b70 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2b80 */  48, 32, 32, 48, 48, 48, 48, 48, 50, 54, 52, 32, 32, 50, 42, 42,
/* 0x2b90 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x2ba0 */  68, 79, 78, 76, 89, 10, 32, 52, 56, 32, 78, 50, 69, 83, 77, 65,
/* 0x2bb0 */  51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100,
/* 0x2bc0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2bd0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 55, 49, 32, 32,
/* 0x2be0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x2bf0 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x2c00 */  32, 52, 57, 32, 78, 50, 69, 70, 65, 83, 51, 48, 32, 32, 32, 32,
/* 0x2c10 */  32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48,
/* 0x2c20 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2c30 */  48, 48, 48, 48, 48, 50, 55,101, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2c40 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x2c50 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 48, 32, 78, 50,
/* 0x2c60 */  69, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x2c70 */  48, 48, 53,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2c80 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,
/* 0x2c90 */  56,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2ca0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x2cb0 */  78, 76, 89, 10, 32, 53, 49, 32, 78, 50, 69, 83, 77, 65, 52, 48,
/* 0x2cc0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32,
/* 0x2cd0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2ce0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 50,101, 99, 32, 32, 50, 42,
/* 0x2cf0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x2d00 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53,
/* 0x2d10 */  50, 32, 78, 50, 69, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32,
/* 0x2d20 */  48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2d30 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2d40 */  48, 48, 48, 50,102, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2d50 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x2d60 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 51, 32, 78, 50, 69, 83,
/* 0x2d70 */  77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2d80 */  48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2d90 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 48, 56,
/* 0x2da0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2db0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 52, 32, 78,
/* 0x2dc0 */  50, 69, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x2dd0 */  48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2de0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2df0 */  51, 48, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2e00 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53,
/* 0x2e10 */  53, 32, 78, 50, 69, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32,
/* 0x2e20 */  48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2e30 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2e40 */  48, 48, 48, 51, 48,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2e50 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x2e60 */  10, 32, 53, 54, 32, 78, 50, 69, 83, 77, 65, 54, 48, 32, 32, 32,
/* 0x2e70 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 99, 32, 32, 48, 48, 48,
/* 0x2e80 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2e90 */  32, 48, 48, 48, 48, 48, 51, 49, 54, 32, 32, 50, 42, 42, 48, 32,
/* 0x2ea0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x2eb0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 55, 32, 78,
/* 0x2ec0 */  50, 69, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x2ed0 */  48, 48, 48, 49, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2ee0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2ef0 */  51, 50, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2f00 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x2f10 */  79, 78, 76, 89, 10, 32, 53, 56, 32, 78, 50, 69, 70, 65, 83, 54,
/* 0x2f20 */  49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 54, 32,
/* 0x2f30 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2f40 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 51, 98, 32, 32, 50,
/* 0x2f50 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x2f60 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2f70 */  53, 57, 32, 78, 50, 69, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32,
/* 0x2f80 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2f90 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2fa0 */  48, 48, 48, 48, 51, 53, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2fb0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x2fc0 */  89, 10, 32, 54, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48,
/* 0x2fd0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50,101, 32, 32, 48, 48,
/* 0x2fe0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ff0 */  32, 32, 48, 48, 48, 48, 48, 51, 53, 49, 32, 32, 50, 42, 42, 48,
/* 0x3000 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x3010 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 49, 32,
/* 0x3020 */  76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 48,
/* 0x3030 */  48, 48, 48, 48, 52, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3040 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3050 */  48, 51, 55,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3060 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x3070 */  54, 50, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32,
/* 0x3080 */  32, 48, 48, 48, 48, 48, 97, 56, 54, 32, 32, 48, 48, 48, 48, 48,
/* 0x3090 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x30a0 */  48, 48, 48, 48, 51, 99, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x30b0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x30c0 */  89, 10, 32, 54, 51, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x30d0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 97, 56, 54, 32, 32, 48, 48,
/* 0x30e0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x30f0 */  32, 32, 48, 48, 48, 48, 48,101, 52,100, 32, 32, 50, 42, 42, 48,
/* 0x3100 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x3110 */  79, 78, 76, 89, 10, 32, 54, 52, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3120 */  67, 51, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 97, 32,
/* 0x3130 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x3140 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56,100, 51, 32, 32, 50,
/* 0x3150 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x3160 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 53, 32, 76, 69, 88, 69,
/* 0x3170 */  67, 48, 49, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3180 */  50, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3190 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56,101,100,
/* 0x31a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x31b0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 54, 32, 76,
/* 0x31c0 */  69, 88, 69, 67, 49, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x31d0 */  48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x31e0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x31f0 */  57, 48,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3200 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54,
/* 0x3210 */  55, 32, 76, 69, 88, 69, 67, 49, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x3220 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3230 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3240 */  48, 48, 49, 57, 49, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3250 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x3260 */  10, 32, 54, 56, 32, 76, 69, 88, 69, 67, 48, 49, 54, 32, 32, 32,
/* 0x3270 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48,
/* 0x3280 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3290 */  32, 48, 48, 48, 48, 49, 57, 49, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x32a0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x32b0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 57, 32, 76,
/* 0x32c0 */  88, 85, 78, 70, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x32d0 */  48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x32e0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x32f0 */  57, 49, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3300 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x3310 */  79, 78, 76, 89, 10, 32, 55, 48, 32, 76, 88, 85, 78, 70, 48, 48,
/* 0x3320 */  50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32,
/* 0x3330 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x3340 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 49, 98, 32, 32, 50,
/* 0x3350 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x3360 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 49, 32, 77, 82, 85, 66,
/* 0x3370 */  89, 84, 69, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3380 */  48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3390 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 50, 48,
/* 0x33a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x33b0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 50, 32, 76,
/* 0x33c0 */  88, 77, 82, 85, 48, 48, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x33d0 */  48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x33e0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x33f0 */  57, 50, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3400 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x3410 */  79, 78, 76, 89, 10, 32, 55, 51, 32, 76, 88, 77, 82, 85, 48, 48,
/* 0x3420 */  54, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32,
/* 0x3430 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x3440 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 50, 55, 32, 32, 50,
/* 0x3450 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x3460 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 52, 32, 76, 88, 77, 82,
/* 0x3470 */  85, 48, 48, 55, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3480 */  48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3490 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 50,101,
/* 0x34a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x34b0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 53, 32, 76,
/* 0x34c0 */  88, 85, 78, 70, 48, 48, 56, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x34d0 */  48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x34e0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x34f0 */  57, 51, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3500 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55,
/* 0x3510 */  54, 32, 76, 88, 85, 78, 70, 48, 49, 48, 32, 32, 32, 32, 32, 32,
/* 0x3520 */  48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3530 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3540 */  48, 48, 49, 57, 51, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3550 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x3560 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 55, 32, 76, 88, 74, 67,
/* 0x3570 */  67, 48, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3580 */  48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3590 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 51,101,
/* 0x35a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x35b0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 56, 32, 76,
/* 0x35c0 */  88, 77, 82, 85, 48, 52, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x35d0 */  48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x35e0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x35f0 */  57, 52, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3600 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55,
/* 0x3610 */  57, 32, 76, 88, 77, 82, 85, 48, 52, 54, 32, 32, 32, 32, 32, 32,
/* 0x3620 */  48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3630 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3640 */  48, 48, 49, 57, 52, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3650 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x3660 */  10, 32, 56, 48, 32, 76, 88, 74, 67, 67, 48, 50, 48, 32, 32, 32,
/* 0x3670 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,
/* 0x3680 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3690 */  32, 48, 48, 48, 48, 49, 57, 52, 54, 32, 32, 50, 42, 42, 48, 32,
/* 0x36a0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x36b0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 49, 32, 76,
/* 0x36c0 */  88, 74, 67, 67, 48, 50, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x36d0 */  48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x36e0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x36f0 */  57, 52, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3700 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x3710 */  79, 78, 76, 89, 10, 32, 56, 50, 32, 76, 88, 74, 67, 67, 48, 50,
/* 0x3720 */  51, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32,
/* 0x3730 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x3740 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 52,100, 32, 32, 50,
/* 0x3750 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x3760 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 51, 32, 76, 88, 85, 78,
/* 0x3770 */  70, 48, 51, 55, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3780 */  48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3790 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 53, 52,
/* 0x37a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x37b0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 52, 32, 76,
/* 0x37c0 */  88, 85, 78, 70, 51, 56, 54, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x37d0 */  48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x37e0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x37f0 */  57, 53, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3800 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56,
/* 0x3810 */  53, 32, 76, 88, 85, 78, 70, 51, 56, 55, 32, 32, 32, 32, 32, 32,
/* 0x3820 */  48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3830 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3840 */  48, 48, 49, 57, 53, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3850 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x3860 */  10, 32, 56, 54, 32, 76, 88, 85, 78, 70, 51, 56, 56, 32, 32, 32,
/* 0x3870 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48,
/* 0x3880 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3890 */  32, 48, 48, 48, 48, 49, 57, 54, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x38a0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x38b0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 55, 32, 76,
/* 0x38c0 */  88, 85, 78, 70, 52, 56, 54, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x38d0 */  48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x38e0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x38f0 */  57, 54, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3900 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56,
/* 0x3910 */  56, 32, 76, 88, 85, 78, 70, 52, 56, 55, 32, 32, 32, 32, 32, 32,
/* 0x3920 */  48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3930 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3940 */  48, 48, 49, 57, 54, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3950 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x3960 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 57, 32, 76, 88, 77, 82,
/* 0x3970 */  85, 48, 54, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3980 */  48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3990 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 54, 57,
/* 0x39a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x39b0 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x39c0 */  89, 10, 32, 57, 48, 32, 77, 82, 85, 66, 89, 84, 69, 51, 32, 32,
/* 0x39d0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48,
/* 0x39e0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x39f0 */  32, 32, 48, 48, 48, 48, 49, 57, 54,101, 32, 32, 50, 42, 42, 48,
/* 0x3a00 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x3a10 */  79, 78, 76, 89, 10, 32, 57, 49, 32, 77, 82, 85, 65, 82, 66, 51,
/* 0x3a20 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x3a30 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x3a40 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 55, 48, 32, 32, 50,
/* 0x3a50 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x3a60 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 50, 32, 77, 82, 85, 66,
/* 0x3a70 */  73, 84, 83, 51, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3a80 */  48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3a90 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 55, 49,
/* 0x3aa0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3ab0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 51, 32, 77,
/* 0x3ac0 */  82, 85, 65, 82, 66, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x3ad0 */  48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3ae0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x3af0 */  57, 55, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3b00 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57,
/* 0x3b10 */  52, 32, 76, 88, 77, 82, 85, 48, 55, 48, 32, 32, 32, 32, 32, 32,
/* 0x3b20 */  48, 48, 48, 48, 48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3b30 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3b40 */  48, 48, 49, 57, 55, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3b50 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x3b60 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 53, 32, 77, 82, 85, 66,
/* 0x3b70 */  89, 84, 69, 52, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3b80 */  48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3b90 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 55,102,
/* 0x3ba0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3bb0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 54, 32, 77,
/* 0x3bc0 */  82, 85, 66, 73, 84, 83, 52, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x3bd0 */  48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3be0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x3bf0 */  57, 56, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3c00 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57,
/* 0x3c10 */  55, 32, 77, 82, 85, 65, 82, 66, 53, 48, 32, 32, 32, 32, 32, 32,
/* 0x3c20 */  48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3c30 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3c40 */  48, 48, 49, 57, 56, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3c50 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x3c60 */  10, 32, 57, 56, 32, 76, 88, 77, 82, 85, 48, 56, 48, 32, 32, 32,
/* 0x3c70 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48,
/* 0x3c80 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3c90 */  32, 48, 48, 48, 48, 49, 57, 56, 97, 32, 32, 50, 42, 42, 48, 32,
/* 0x3ca0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x3cb0 */  78, 76, 89, 10, 32, 57, 57, 32, 77, 82, 85, 66, 89, 84, 69, 53,
/* 0x3cc0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,
/* 0x3cd0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3ce0 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 56,100, 32, 32, 50, 42,
/* 0x3cf0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x3d00 */  65, 68, 79, 78, 76, 89, 10, 49, 48, 48, 32, 77, 82, 85, 65, 82,
/* 0x3d10 */  66, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d20 */  49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3d30 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 56,102, 32,
/* 0x3d40 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x3d50 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 49, 32, 77, 82,
/* 0x3d60 */  85, 66, 73, 84, 83, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x3d70 */  48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3d80 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,
/* 0x3d90 */  57, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3da0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 50,
/* 0x3db0 */  32, 77, 82, 85, 65, 82, 66, 55, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x3dc0 */  48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3dd0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3de0 */  48, 49, 57, 57, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3df0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3e00 */  49, 48, 51, 32, 76, 88, 77, 82, 85, 48, 57, 48, 32, 32, 32, 32,
/* 0x3e10 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48,
/* 0x3e20 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3e30 */  48, 48, 48, 48, 49, 57, 57, 54, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3e40 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x3e50 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 52, 32, 77, 82,
/* 0x3e60 */  85, 66, 89, 84, 69, 54, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x3e70 */  48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3e80 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,
/* 0x3e90 */  97, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3ea0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 53,
/* 0x3eb0 */  32, 77, 82, 85, 65, 82, 66, 56, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x3ec0 */  48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ed0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3ee0 */  48, 49, 57, 97, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3ef0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3f00 */  49, 48, 54, 32, 77, 82, 85, 66, 73, 84, 83, 54, 32, 32, 32, 32,
/* 0x3f10 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,
/* 0x3f20 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3f30 */  48, 48, 48, 48, 49, 57, 97, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3f40 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x3f50 */  76, 89, 10, 49, 48, 55, 32, 77, 82, 85, 65, 82, 66, 57, 48, 32,
/* 0x3f60 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48,
/* 0x3f70 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f80 */  48, 32, 32, 48, 48, 48, 48, 49, 57, 97, 54, 32, 32, 50, 42, 42,
/* 0x3f90 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x3fa0 */  68, 79, 78, 76, 89, 10, 49, 48, 56, 32, 76, 88, 77, 82, 85, 49,
/* 0x3fb0 */  48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 48,
/* 0x3fc0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3fd0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 97, 97, 32, 32,
/* 0x3fe0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3ff0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 57, 32, 76, 88, 85,
/* 0x4000 */  78, 70, 48, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x4010 */  48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x4020 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 98,
/* 0x4030 */  97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x4040 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 48, 32,
/* 0x4050 */  76, 88, 77, 82, 85, 49, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x4060 */  48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4070 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x4080 */  49, 57, 98,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x4090 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49,
/* 0x40a0 */  49, 49, 32, 76, 88, 77, 82, 85, 49, 49, 49, 32, 32, 32, 32, 32,
/* 0x40b0 */  32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48,
/* 0x40c0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x40d0 */  48, 48, 48, 49, 57, 99, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x40e0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x40f0 */  89, 10, 49, 49, 50, 32, 76, 88, 85, 78, 70, 48, 52, 49, 32, 32,
/* 0x4100 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48,
/* 0x4110 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4120 */  32, 32, 48, 48, 48, 48, 49, 57, 99, 52, 32, 32, 50, 42, 42, 48,
/* 0x4130 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x4140 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 51, 32,
/* 0x4150 */  76, 88, 85, 78, 70, 48, 52, 50, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x4160 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4170 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x4180 */  49, 57, 99, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x4190 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49,
/* 0x41a0 */  49, 52, 32, 76, 88, 77, 82, 85, 48, 49, 48, 32, 32, 32, 32, 32,
/* 0x41b0 */  32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48,
/* 0x41c0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x41d0 */  48, 48, 48, 49, 57, 99, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x41e0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x41f0 */  89, 10, 49, 49, 53, 32, 76, 88, 74, 77, 80, 65, 48, 48, 32, 32,
/* 0x4200 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48,
/* 0x4210 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4220 */  32, 32, 48, 48, 48, 48, 49, 57, 99, 99, 32, 32, 50, 42, 42, 48,
/* 0x4230 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x4240 */  79, 78, 76, 89, 10, 49, 49, 54, 32, 76, 88, 67, 65, 76, 76, 66,
/* 0x4250 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,
/* 0x4260 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x4270 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 99,101, 32, 32, 50,
/* 0x4280 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x4290 */  69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 55, 32, 76, 88, 85, 78,
/* 0x42a0 */  70, 48, 50, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x42b0 */  48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x42c0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,100, 48,
/* 0x42d0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x42e0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 56, 32, 76,
/* 0x42f0 */  88, 77, 82, 85, 48, 50, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x4300 */  48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4310 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x4320 */  57,100, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x4330 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49,
/* 0x4340 */  57, 32, 76, 88, 74, 77, 80, 65, 48, 49, 32, 32, 32, 32, 32, 32,
/* 0x4350 */  48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x4360 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x4370 */  48, 48, 49, 57,100, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x4380 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x4390 */  10, 49, 50, 48, 32, 76, 88, 67, 65, 76, 76, 66, 49, 32, 32, 32,
/* 0x43a0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,
/* 0x43b0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x43c0 */  32, 48, 48, 48, 48, 49, 57,100, 98, 32, 32, 50, 42, 42, 48, 32,
/* 0x43d0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x43e0 */  78, 76, 89, 10, 49, 50, 49, 32, 77, 82, 85, 66, 73, 84, 83, 49,
/* 0x43f0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32,
/* 0x4400 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x4410 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 57,100,100, 32, 32, 50, 42,
/* 0x4420 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x4430 */  65, 68, 79, 78, 76, 89, 10, 49, 50, 50, 32, 76, 88, 77, 82, 85,
/* 0x4440 */  48, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x4450 */  50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x4460 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,100,101, 32,
/* 0x4470 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x4480 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 50, 51, 32, 77, 82,
/* 0x4490 */  85, 66, 89, 84, 69, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x44a0 */  48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x44b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,
/* 0x44c0 */ 101, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x44d0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 50, 52,
/* 0x44e0 */  32, 77, 82, 85, 65, 82, 66, 49, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x44f0 */  48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x4500 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x4510 */  48, 49, 57,101, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x4520 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x4530 */  49, 50, 53, 32, 76, 88, 77, 82, 85, 48, 52, 48, 32, 32, 32, 32,
/* 0x4540 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,
/* 0x4550 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x4560 */  48, 48, 48, 48, 49, 57,101, 51, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x4570 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x4580 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 50, 54, 32, 76, 88,
/* 0x4590 */  85, 78, 70, 48, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x45a0 */  48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x45b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,
/* 0x45c0 */ 101, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x45d0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 50, 55,
/* 0x45e0 */  32, 76, 88, 74, 67, 67, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x45f0 */  48, 48, 48, 48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x4600 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x4610 */  48, 49, 57,101, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x4620 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x4630 */  65, 68, 79, 78, 76, 89, 10, 49, 50, 56, 32, 76, 88, 67, 74, 48,
/* 0x4640 */  77, 82, 85, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x4650 */  50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x4660 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,102, 51, 32,
/* 0x4670 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x4680 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 50, 57, 32, 76, 88,
/* 0x4690 */  67, 74, 49, 77, 82, 85, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x46a0 */  48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x46b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,
/* 0x46c0 */ 102, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x46d0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 51, 48,
/* 0x46e0 */  32, 76, 88, 67, 65, 76, 74, 77, 80, 32, 32, 32, 32, 32, 32, 48,
/* 0x46f0 */  48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x4700 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x4710 */  48, 49, 57,102, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x4720 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x4730 */  49, 51, 49, 32, 76, 88, 67, 65, 76, 76, 48, 48, 32, 32, 32, 32,
/* 0x4740 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,
/* 0x4750 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x4760 */  48, 48, 48, 48, 49, 57,102, 98, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x4770 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x4780 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 51, 50, 32, 76, 88,
/* 0x4790 */  67, 65, 76, 76, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x47a0 */  48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x47b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,
/* 0x47c0 */ 102,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x47d0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 51, 51,
/* 0x47e0 */  32, 76, 88, 67, 74, 50, 77, 82, 85, 32, 32, 32, 32, 32, 32, 48,
/* 0x47f0 */  48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x4800 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x4810 */  48, 49, 97, 48, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x4820 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x4830 */  65, 68, 79, 78, 76, 89, 10, 49, 51, 52, 32, 76, 88, 67, 74, 52,
/* 0x4840 */  77, 82, 85, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x4850 */  50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x4860 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 48, 50, 32,
/* 0x4870 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x4880 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x4890 */  10, 49, 51, 53, 32, 76, 88, 67, 74, 54, 77, 82, 85, 32, 32, 32,
/* 0x48a0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,
/* 0x48b0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x48c0 */  32, 48, 48, 48, 48, 49, 97, 48, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x48d0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x48e0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 51, 54, 32, 76,
/* 0x48f0 */  88, 67, 74, 55, 77, 82, 85, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x4900 */  48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4910 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x4920 */  97, 48, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x4930 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x4940 */  79, 78, 76, 89, 10, 49, 51, 55, 32, 76, 88, 67, 74, 56, 77, 82,
/* 0x4950 */  85, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32,
/* 0x4960 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x4970 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 48, 56, 32, 32, 50,
/* 0x4980 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x4990 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49,
/* 0x49a0 */  51, 56, 32, 76, 88, 85, 78, 70, 48, 51, 52, 32, 32, 32, 32, 32,
/* 0x49b0 */  32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48,
/* 0x49c0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x49d0 */  48, 48, 48, 49, 97, 48, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x49e0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x49f0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 51, 57, 32, 76, 88, 77,
/* 0x4a00 */  82, 85, 48, 53, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x4a10 */  48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x4a20 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 49,
/* 0x4a30 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x4a40 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 52, 48, 32,
/* 0x4a50 */  77, 82, 85, 66, 89, 84, 69, 50, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x4a60 */  48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4a70 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x4a80 */  49, 97, 49, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x4a90 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49,
/* 0x4aa0 */  52, 49, 32, 77, 82, 85, 66, 73, 84, 83, 50, 32, 32, 32, 32, 32,
/* 0x4ab0 */  32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48,
/* 0x4ac0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x4ad0 */  48, 48, 48, 49, 97, 49, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x4ae0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x4af0 */  89, 10, 49, 52, 50, 32, 77, 82, 85, 65, 82, 66, 50, 48, 32, 32,
/* 0x4b00 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48,
/* 0x4b10 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b20 */  32, 32, 48, 48, 48, 48, 49, 97, 49, 99, 32, 32, 50, 42, 42, 48,
/* 0x4b30 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x4b40 */  79, 78, 76, 89, 10, 49, 52, 51, 32, 76, 88, 77, 82, 85, 48, 53,
/* 0x4b50 */  55, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32,
/* 0x4b60 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x4b70 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 50, 49, 32, 32, 50,
/* 0x4b80 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x4b90 */  69, 65, 68, 79, 78, 76, 89, 10, 49, 52, 52, 32, 76, 88, 77, 82,
/* 0x4ba0 */  85, 48, 53, 56, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x4bb0 */  48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x4bc0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 50, 55,
/* 0x4bd0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x4be0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 52, 53, 32, 76,
/* 0x4bf0 */  88, 85, 78, 70, 48, 51, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x4c00 */  48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4c10 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x4c20 */  97, 50, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x4c30 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 52,
/* 0x4c40 */  54, 32, 99,116,111,107, 51, 50, 46, 48, 48, 32, 32, 32, 32, 32,
/* 0x4c50 */  48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x4c60 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x4c70 */  48, 48, 49, 97, 50,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x4c80 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x4c90 */  69, 65, 68, 79, 78, 76, 89, 10, 49, 52, 55, 32, 99,116,111,107,
/* 0x4ca0 */  51, 50, 46, 49, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x4cb0 */  48,101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x4cc0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 51, 53,
/* 0x4cd0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x4ce0 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x4cf0 */  89, 10, 49, 52, 56, 32, 99,116,111,107, 51, 50, 46, 50, 48, 32,
/* 0x4d00 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 48, 32, 32, 48, 48,
/* 0x4d10 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d20 */  32, 32, 48, 48, 48, 48, 49, 97, 52, 51, 32, 32, 50, 42, 42, 48,
/* 0x4d30 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x4d40 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 52, 57, 32,
/* 0x4d50 */  99,116,111,107, 51, 50, 46, 51, 48, 32, 32, 32, 32, 32, 48, 48,
/* 0x4d60 */  48, 48, 48, 48, 48, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d70 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x4d80 */  49, 97, 54, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x4d90 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x4da0 */  68, 79, 78, 76, 89, 10, 49, 53, 48, 32, 99,116,111,107, 51, 50,
/* 0x4db0 */  46, 52, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53,
/* 0x4dc0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x4dd0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 54,100, 32, 32,
/* 0x4de0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x4df0 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x4e00 */  49, 53, 49, 32, 67, 65, 76, 76, 84, 82, 48, 48, 32, 32, 32, 32,
/* 0x4e10 */  32, 32, 48, 48, 48, 48, 48, 48, 49, 48, 32, 32, 48, 48, 48, 48,
/* 0x4e20 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x4e30 */  48, 48, 48, 48, 49, 97, 55, 50, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x4e40 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x4e50 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 53, 50, 32, 67, 84,
/* 0x4e60 */  67, 76, 69, 86, 69, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x4e70 */  48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x4e80 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,
/* 0x4e90 */  56, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x4ea0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x4eb0 */  78, 76, 89, 10, 49, 53, 51, 32, 67, 65, 76, 76, 84, 82, 48, 49,
/* 0x4ec0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32,
/* 0x4ed0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x4ee0 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 56, 55, 32, 32, 50, 42,
/* 0x4ef0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x4f00 */  65, 68, 79, 78, 76, 89, 10, 49, 53, 52, 32, 67, 84, 66, 83, 72,
/* 0x4f10 */  82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x4f20 */  52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x4f30 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 56, 99, 32,
/* 0x4f40 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x4f50 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 53, 53, 32, 67, 84,
/* 0x4f60 */  66, 82, 79, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x4f70 */  48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x4f80 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,
/* 0x4f90 */  57, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x4fa0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 53, 54,
/* 0x4fb0 */  32, 67, 84, 66, 83, 87, 65, 48, 49, 32, 32, 32, 32, 32, 32, 48,
/* 0x4fc0 */  48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x4fd0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x4fe0 */  48, 49, 97, 57, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x4ff0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x5000 */  49, 53, 55, 32, 67, 65, 76, 76, 84, 82, 48, 50, 32, 32, 32, 32,
/* 0x5010 */  32, 32, 48, 48, 48, 48, 48, 48, 49, 48, 32, 32, 48, 48, 48, 48,
/* 0x5020 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x5030 */  48, 48, 48, 48, 49, 97, 57, 55, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x5040 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x5050 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 53, 56, 32, 67, 65,
/* 0x5060 */  76, 76, 84, 82, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x5070 */  48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x5080 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,
/* 0x5090 */  97, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x50a0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x50b0 */  78, 76, 89, 10, 49, 53, 57, 32, 67, 65, 76, 76, 84, 82, 69, 56,
/* 0x50c0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,
/* 0x50d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x50e0 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 97, 99, 32, 32, 50, 42,
/* 0x50f0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x5100 */  65, 68, 79, 78, 76, 89, 10, 49, 54, 48, 32, 67, 65, 76, 76, 84,
/* 0x5110 */  82, 69, 57, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x5120 */  50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x5130 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 97,101, 32,
/* 0x5140 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x5150 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 54, 49, 32, 67, 65,
/* 0x5160 */  76, 76, 84, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x5170 */  48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x5180 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,
/* 0x5190 */  98, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x51a0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x51b0 */  78, 76, 89, 10, 49, 54, 50, 32, 67, 84, 67, 76, 69, 86, 69, 50,
/* 0x51c0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32,
/* 0x51d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x51e0 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 98, 52, 32, 32, 50, 42,
/* 0x51f0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x5200 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 54,
/* 0x5210 */  51, 32, 67, 65, 76, 76, 84, 82, 49, 50, 32, 32, 32, 32, 32, 32,
/* 0x5220 */  48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x5230 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x5240 */  48, 48, 49, 97, 98, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x5250 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x5260 */  10, 49, 54, 52, 32, 67, 84, 66, 83, 72, 82, 49, 49, 32, 32, 32,
/* 0x5270 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48,
/* 0x5280 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5290 */  32, 48, 48, 48, 48, 49, 97, 98, 98, 32, 32, 50, 42, 42, 48, 32,
/* 0x52a0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x52b0 */  78, 76, 89, 10, 49, 54, 53, 32, 67, 84, 66, 82, 79, 82, 49, 49,
/* 0x52c0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,
/* 0x52d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x52e0 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 98,102, 32, 32, 50, 42,
/* 0x52f0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x5300 */  65, 68, 79, 78, 76, 89, 10, 49, 54, 54, 32, 67, 84, 66, 83, 87,
/* 0x5310 */  65, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x5320 */  53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x5330 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 99, 49, 32,
/* 0x5340 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x5350 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 54, 55, 32, 67, 65,
/* 0x5360 */  76, 76, 84, 82, 49, 51, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x5370 */  48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x5380 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,
/* 0x5390 */  99, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x53a0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x53b0 */  78, 76, 89, 10, 49, 54, 56, 32, 76, 69, 88, 69, 67, 48, 49, 55,
/* 0x53c0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,
/* 0x53d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x53e0 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 99,100, 32, 32, 50, 42,
/* 0x53f0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x5400 */  65, 68, 79, 78, 76, 89, 10, 49, 54, 57, 32, 76, 69, 88, 69, 67,
/* 0x5410 */  48, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x5420 */  54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x5430 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 99,102, 32,
/* 0x5440 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x5450 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66, 79, 76,
/* 0x5460 */  32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5470 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 49,
/* 0x5480 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77,
/* 0x5490 */  65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x54a0 */  32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 49, 49,  9, 48, 48,
/* 0x54b0 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 49, 49, 10,
/* 0x54c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x54d0 */  32, 78, 50, 66, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x54e0 */  48, 48, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x54f0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x5500 */  68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x5510 */  50, 66, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5520 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 51,
/* 0x5530 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 68, 69,
/* 0x5540 */  67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5550 */  32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 53, 48,  9, 48, 48,
/* 0x5560 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10,
/* 0x5570 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5580 */  32, 78, 50, 66, 70, 65, 83, 54, 49,  9, 48, 48, 48, 48, 48, 48,
/* 0x5590 */  48, 48, 32, 78, 50, 66, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48,
/* 0x55a0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x55b0 */  68, 69, 67, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x55c0 */  50, 66, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x55d0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 49,
/* 0x55e0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77,
/* 0x55f0 */  65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5600 */  32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 49, 49,  9, 48, 48,
/* 0x5610 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 49, 49, 10,
/* 0x5620 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5630 */  32, 78, 50, 68, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x5640 */  48, 48, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x5650 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x5660 */  68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x5670 */  50, 68, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5680 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 51,
/* 0x5690 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 68, 69,
/* 0x56a0 */  67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x56b0 */  32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 53, 48,  9, 48, 48,
/* 0x56c0 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 53, 48, 10,
/* 0x56d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x56e0 */  32, 78, 50, 68, 70, 65, 83, 54, 49,  9, 48, 48, 48, 48, 48, 48,
/* 0x56f0 */  48, 48, 32, 78, 50, 68, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48,
/* 0x5700 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x5710 */  68, 69, 67, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x5720 */  50, 68, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5730 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 49,
/* 0x5740 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77,
/* 0x5750 */  65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5760 */  32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 49, 49,  9, 48, 48,
/* 0x5770 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 49, 49, 10,
/* 0x5780 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5790 */  32, 78, 50, 69, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x57a0 */  48, 48, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x57b0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x57c0 */  68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x57d0 */  50, 69, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x57e0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 51,
/* 0x57f0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 68, 69,
/* 0x5800 */  67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5810 */  32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 53, 48,  9, 48, 48,
/* 0x5820 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 53, 48, 10,
/* 0x5830 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5840 */  32, 78, 50, 69, 70, 65, 83, 54, 49,  9, 48, 48, 48, 48, 48, 48,
/* 0x5850 */  48, 48, 32, 78, 50, 69, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48,
/* 0x5860 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x5870 */  68, 69, 67, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x5880 */  50, 69, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5890 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70, 48, 49,
/* 0x58a0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 85, 78, 70,
/* 0x58b0 */  48, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x58c0 */  32, 32,100, 32, 32, 76, 88, 74, 67, 67, 48, 49, 48,  9, 48, 48,
/* 0x58d0 */  48, 48, 48, 48, 48, 48, 32, 76, 88, 74, 67, 67, 48, 49, 48, 10,
/* 0x58e0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x58f0 */  32, 76, 88, 85, 78, 70, 48, 51, 55,  9, 48, 48, 48, 48, 48, 48,
/* 0x5900 */  48, 48, 32, 76, 88, 85, 78, 70, 48, 51, 55, 10, 48, 48, 48, 48,
/* 0x5910 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77,
/* 0x5920 */  82, 85, 48, 55, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x5930 */  88, 77, 82, 85, 48, 55, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5940 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 49, 48,
/* 0x5950 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 82, 85,
/* 0x5960 */  49, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5970 */  32, 32,100, 32, 32, 76, 88, 85, 78, 70, 48, 52, 48,  9, 48, 48,
/* 0x5980 */  48, 48, 48, 48, 48, 48, 32, 76, 88, 85, 78, 70, 48, 52, 48, 10,
/* 0x5990 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x59a0 */  32, 76, 88, 85, 78, 70, 48, 52, 50,  9, 48, 48, 48, 48, 48, 48,
/* 0x59b0 */  48, 48, 32, 76, 88, 85, 78, 70, 48, 52, 50, 10, 48, 48, 48, 48,
/* 0x59c0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77,
/* 0x59d0 */  82, 85, 48, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x59e0 */  88, 77, 82, 85, 48, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x59f0 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70, 48, 51,
/* 0x5a00 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 85, 78, 70,
/* 0x5a10 */  48, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5a20 */  32, 32,100, 32, 32, 76, 88, 67, 74, 56, 77, 82, 85,  9, 48, 48,
/* 0x5a30 */  48, 48, 48, 48, 48, 48, 32, 76, 88, 67, 74, 56, 77, 82, 85, 10,
/* 0x5a40 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5a50 */  32, 76, 88, 85, 78, 70, 48, 51, 52,  9, 48, 48, 48, 48, 48, 48,
/* 0x5a60 */  48, 48, 32, 76, 88, 85, 78, 70, 48, 51, 52, 10, 48, 48, 48, 48,
/* 0x5a70 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,
/* 0x5a80 */ 107, 51, 50, 46, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5a90 */  99,116,111,107, 51, 50, 46, 48, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x5aa0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51,
/* 0x5ab0 */  50, 46, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,
/* 0x5ac0 */ 111,107, 51, 50, 46, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5ad0 */  32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46,
/* 0x5ae0 */  50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,107,
/* 0x5af0 */  51, 50, 46, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x5b00 */  32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48,
/* 0x5b10 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,107, 51, 50,
/* 0x5b20 */  46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5b30 */  32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48,  9, 48, 48,
/* 0x5b40 */  48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10,
/* 0x5b50 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5b60 */  32, 67, 65, 76, 76, 84, 82, 49, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x5b70 */  48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10, 48, 48, 48, 48,
/* 0x5b80 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76,
/* 0x5b90 */  76, 84, 82, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67,
/* 0x5ba0 */  65, 76, 76, 84, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5bb0 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49,
/* 0x5bc0 */  51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84,
/* 0x5bd0 */  82, 49, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5be0 */  32, 32,100, 32, 32, 76, 69, 88, 69, 67, 48, 50, 48,  9, 48, 48,
/* 0x5bf0 */  48, 48, 48, 48, 48, 48, 32, 76, 69, 88, 69, 67, 48, 50, 48, 10,
/* 0x5c00 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5c10 */  32, 76, 69, 88, 69, 67, 48, 48, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x5c20 */  48, 48, 32, 76, 69, 88, 69, 67, 48, 48, 48, 10, 48, 48, 48, 48,
/* 0x5c30 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 69, 88,
/* 0x5c40 */  69, 67, 48, 48, 57,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x5c50 */  69, 88, 69, 67, 48, 48, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5c60 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 69, 88, 69, 67, 48, 49,
/* 0x5c70 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 69, 88, 69, 67,
/* 0x5c80 */  48, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5c90 */  32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 49, 48,  9, 48, 48,
/* 0x5ca0 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 49, 48, 10,
/* 0x5cb0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5cc0 */  32, 78, 50, 66, 83, 77, 65, 50, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x5cd0 */  48, 48, 32, 78, 50, 66, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48,
/* 0x5ce0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x5cf0 */  70, 65, 83, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x5d00 */  50, 66, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5d10 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 51,
/* 0x5d20 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77,
/* 0x5d30 */  65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5d40 */  32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 51, 48,  9, 48, 48,
/* 0x5d50 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 51, 48, 10,
/* 0x5d60 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5d70 */  32, 78, 50, 66, 83, 77, 65, 52, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x5d80 */  48, 48, 32, 78, 50, 66, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48,
/* 0x5d90 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x5da0 */  70, 65, 83, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x5db0 */  50, 66, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5dc0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 53,
/* 0x5dd0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77,
/* 0x5de0 */  65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5df0 */  32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 53, 48,  9, 48, 48,
/* 0x5e00 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 53, 48, 10,
/* 0x5e10 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5e20 */  32, 78, 50, 66, 83, 77, 65, 54, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x5e30 */  48, 48, 32, 78, 50, 66, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48,
/* 0x5e40 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x5e50 */  70, 65, 83, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x5e60 */  50, 66, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5e70 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 49,
/* 0x5e80 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65,
/* 0x5e90 */  83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5ea0 */  32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 50, 48,  9, 48, 48,
/* 0x5eb0 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 50, 48, 10,
/* 0x5ec0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5ed0 */  32, 78, 50, 68, 70, 65, 83, 50, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x5ee0 */  48, 48, 32, 78, 50, 68, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48,
/* 0x5ef0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x5f00 */  83, 77, 65, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x5f10 */  50, 68, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5f20 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 51,
/* 0x5f30 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65,
/* 0x5f40 */  83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5f50 */  32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 52, 48,  9, 48, 48,
/* 0x5f60 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 52, 48, 10,
/* 0x5f70 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5f80 */  32, 78, 50, 68, 70, 65, 83, 52, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x5f90 */  48, 48, 32, 78, 50, 68, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48,
/* 0x5fa0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x5fb0 */  83, 77, 65, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x5fc0 */  50, 68, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5fd0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 53,
/* 0x5fe0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65,
/* 0x5ff0 */  83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x6000 */  32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 54, 48,  9, 48, 48,
/* 0x6010 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 54, 48, 10,
/* 0x6020 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6030 */  32, 78, 50, 68, 70, 65, 83, 54, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x6040 */  48, 48, 32, 78, 50, 68, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48,
/* 0x6050 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x6060 */  70, 65, 83, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x6070 */  50, 69, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6080 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 50,
/* 0x6090 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77,
/* 0x60a0 */  65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x60b0 */  32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 50, 48,  9, 48, 48,
/* 0x60c0 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 50, 48, 10,
/* 0x60d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x60e0 */  32, 78, 50, 69, 83, 77, 65, 51, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x60f0 */  48, 48, 32, 78, 50, 69, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48,
/* 0x6100 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x6110 */  70, 65, 83, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x6120 */  50, 69, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6130 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 52,
/* 0x6140 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77,
/* 0x6150 */  65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x6160 */  32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 52, 48,  9, 48, 48,
/* 0x6170 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 52, 48, 10,
/* 0x6180 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6190 */  32, 78, 50, 69, 83, 77, 65, 53, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x61a0 */  48, 48, 32, 78, 50, 69, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48,
/* 0x61b0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x61c0 */  70, 65, 83, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x61d0 */  50, 69, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x61e0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 54,
/* 0x61f0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77,
/* 0x6200 */  65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x6210 */  32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 54, 48,  9, 48, 48,
/* 0x6220 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 54, 48, 10,
/* 0x6230 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6240 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48,  9, 48, 48, 48, 48,
/* 0x6250 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 10,
/* 0x6260 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6270 */  32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48, 48, 48,
/* 0x6280 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10,
/* 0x6290 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x62a0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48,
/* 0x62b0 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x62c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x62d0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48,
/* 0x62e0 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x62f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6300 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48,
/* 0x6310 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10,
/* 0x6320 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6330 */  32, 76, 69, 88, 69, 67, 48, 49, 53,  9, 48, 48, 48, 48, 48, 48,
/* 0x6340 */  48, 48, 32, 76, 69, 88, 69, 67, 48, 49, 53, 10, 48, 48, 48, 48,
/* 0x6350 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 69, 88,
/* 0x6360 */  69, 67, 49, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x6370 */  69, 88, 69, 67, 49, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6380 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 69, 88, 69, 67, 49, 48,
/* 0x6390 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 69, 88, 69, 67,
/* 0x63a0 */  49, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x63b0 */  32, 32,100, 32, 32, 76, 69, 88, 69, 67, 48, 49, 54,  9, 48, 48,
/* 0x63c0 */  48, 48, 48, 48, 48, 48, 32, 76, 69, 88, 69, 67, 48, 49, 54, 10,
/* 0x63d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x63e0 */  32, 76, 88, 85, 78, 70, 48, 48, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x63f0 */  48, 48, 32, 76, 88, 85, 78, 70, 48, 48, 48, 10, 48, 48, 48, 48,
/* 0x6400 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85,
/* 0x6410 */  78, 70, 48, 48, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x6420 */  88, 85, 78, 70, 48, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6430 */  32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89, 84, 69,
/* 0x6440 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 66, 89,
/* 0x6450 */  84, 69, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x6460 */  32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 48, 53,  9, 48, 48,
/* 0x6470 */  48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 48, 48, 53, 10,
/* 0x6480 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6490 */  32, 76, 88, 77, 82, 85, 48, 48, 54,  9, 48, 48, 48, 48, 48, 48,
/* 0x64a0 */  48, 48, 32, 76, 88, 77, 82, 85, 48, 48, 54, 10, 48, 48, 48, 48,
/* 0x64b0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77,
/* 0x64c0 */  82, 85, 48, 48, 55,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x64d0 */  88, 77, 82, 85, 48, 48, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x64e0 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70, 48, 48,
/* 0x64f0 */  56,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 85, 78, 70,
/* 0x6500 */  48, 48, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x6510 */  32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 52, 53,  9, 48, 48,
/* 0x6520 */  48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 48, 52, 53, 10,
/* 0x6530 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6540 */  32, 76, 88, 77, 82, 85, 48, 52, 54,  9, 48, 48, 48, 48, 48, 48,
/* 0x6550 */  48, 48, 32, 76, 88, 77, 82, 85, 48, 52, 54, 10, 48, 48, 48, 48,
/* 0x6560 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 74,
/* 0x6570 */  67, 67, 48, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x6580 */  88, 74, 67, 67, 48, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6590 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 74, 67, 67, 48, 50,
/* 0x65a0 */  49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 74, 67, 67,
/* 0x65b0 */  48, 50, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x65c0 */  32, 32,100, 32, 32, 76, 88, 74, 67, 67, 48, 50, 51,  9, 48, 48,
/* 0x65d0 */  48, 48, 48, 48, 48, 48, 32, 76, 88, 74, 67, 67, 48, 50, 51, 10,
/* 0x65e0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x65f0 */  32, 76, 88, 85, 78, 70, 51, 56, 54,  9, 48, 48, 48, 48, 48, 48,
/* 0x6600 */  48, 48, 32, 76, 88, 85, 78, 70, 51, 56, 54, 10, 48, 48, 48, 48,
/* 0x6610 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85,
/* 0x6620 */  78, 70, 51, 56, 55,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x6630 */  88, 85, 78, 70, 51, 56, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6640 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85, 78, 70, 51, 56,
/* 0x6650 */  56,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 85, 78, 70,
/* 0x6660 */  51, 56, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x6670 */  32, 32,100, 32, 32, 76, 88, 85, 78, 70, 52, 56, 54,  9, 48, 48,
/* 0x6680 */  48, 48, 48, 48, 48, 48, 32, 76, 88, 85, 78, 70, 52, 56, 54, 10,
/* 0x6690 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x66a0 */  32, 76, 88, 85, 78, 70, 52, 56, 55,  9, 48, 48, 48, 48, 48, 48,
/* 0x66b0 */  48, 48, 32, 76, 88, 85, 78, 70, 52, 56, 55, 10, 48, 48, 48, 48,
/* 0x66c0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77,
/* 0x66d0 */  82, 85, 48, 54, 53,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x66e0 */  88, 77, 82, 85, 48, 54, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x66f0 */  32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89, 84, 69,
/* 0x6700 */  51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 66, 89,
/* 0x6710 */  84, 69, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x6720 */  32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66, 51, 48,  9, 48, 48,
/* 0x6730 */  48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 65, 82, 66, 51, 48, 10,
/* 0x6740 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6750 */  32, 77, 82, 85, 66, 73, 84, 83, 51,  9, 48, 48, 48, 48, 48, 48,
/* 0x6760 */  48, 48, 32, 77, 82, 85, 66, 73, 84, 83, 51, 10, 48, 48, 48, 48,
/* 0x6770 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85,
/* 0x6780 */  65, 82, 66, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77,
/* 0x6790 */  82, 85, 65, 82, 66, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x67a0 */  32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89, 84, 69,
/* 0x67b0 */  52,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 66, 89,
/* 0x67c0 */  84, 69, 52, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x67d0 */  32, 32,100, 32, 32, 77, 82, 85, 66, 73, 84, 83, 52,  9, 48, 48,
/* 0x67e0 */  48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 66, 73, 84, 83, 52, 10,
/* 0x67f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6800 */  32, 77, 82, 85, 65, 82, 66, 53, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x6810 */  48, 48, 32, 77, 82, 85, 65, 82, 66, 53, 48, 10, 48, 48, 48, 48,
/* 0x6820 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77,
/* 0x6830 */  82, 85, 48, 56, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x6840 */  88, 77, 82, 85, 48, 56, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6850 */  32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89, 84, 69,
/* 0x6860 */  53,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 66, 89,
/* 0x6870 */  84, 69, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x6880 */  32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66, 54, 48,  9, 48, 48,
/* 0x6890 */  48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 65, 82, 66, 54, 48, 10,
/* 0x68a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x68b0 */  32, 77, 82, 85, 66, 73, 84, 83, 53,  9, 48, 48, 48, 48, 48, 48,
/* 0x68c0 */  48, 48, 32, 77, 82, 85, 66, 73, 84, 83, 53, 10, 48, 48, 48, 48,
/* 0x68d0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85,
/* 0x68e0 */  65, 82, 66, 55, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77,
/* 0x68f0 */  82, 85, 65, 82, 66, 55, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6900 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 57,
/* 0x6910 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 82, 85,
/* 0x6920 */  48, 57, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x6930 */  32, 32,100, 32, 32, 77, 82, 85, 66, 89, 84, 69, 54,  9, 48, 48,
/* 0x6940 */  48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 66, 89, 84, 69, 54, 10,
/* 0x6950 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6960 */  32, 77, 82, 85, 65, 82, 66, 56, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x6970 */  48, 48, 32, 77, 82, 85, 65, 82, 66, 56, 48, 10, 48, 48, 48, 48,
/* 0x6980 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85,
/* 0x6990 */  66, 73, 84, 83, 54,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77,
/* 0x69a0 */  82, 85, 66, 73, 84, 83, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x69b0 */  32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66, 57,
/* 0x69c0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 65, 82,
/* 0x69d0 */  66, 57, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x69e0 */  32, 32,100, 32, 32, 76, 88, 77, 82, 85, 49, 49, 48,  9, 48, 48,
/* 0x69f0 */  48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 49, 49, 48, 10,
/* 0x6a00 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6a10 */  32, 76, 88, 77, 82, 85, 49, 49, 49,  9, 48, 48, 48, 48, 48, 48,
/* 0x6a20 */  48, 48, 32, 76, 88, 77, 82, 85, 49, 49, 49, 10, 48, 48, 48, 48,
/* 0x6a30 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85,
/* 0x6a40 */  78, 70, 48, 52, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x6a50 */  88, 85, 78, 70, 48, 52, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6a60 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 49,
/* 0x6a70 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 82, 85,
/* 0x6a80 */  48, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x6a90 */  32, 32,100, 32, 32, 76, 88, 74, 77, 80, 65, 48, 48,  9, 48, 48,
/* 0x6aa0 */  48, 48, 48, 48, 48, 48, 32, 76, 88, 74, 77, 80, 65, 48, 48, 10,
/* 0x6ab0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6ac0 */  32, 76, 88, 67, 65, 76, 76, 66, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x6ad0 */  48, 48, 32, 76, 88, 67, 65, 76, 76, 66, 48, 10, 48, 48, 48, 48,
/* 0x6ae0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85,
/* 0x6af0 */  78, 70, 48, 50, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x6b00 */  88, 85, 78, 70, 48, 50, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6b10 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 50,
/* 0x6b20 */  50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 82, 85,
/* 0x6b30 */  48, 50, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x6b40 */  32, 32,100, 32, 32, 76, 88, 74, 77, 80, 65, 48, 49,  9, 48, 48,
/* 0x6b50 */  48, 48, 48, 48, 48, 48, 32, 76, 88, 74, 77, 80, 65, 48, 49, 10,
/* 0x6b60 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6b70 */  32, 76, 88, 67, 65, 76, 76, 66, 49,  9, 48, 48, 48, 48, 48, 48,
/* 0x6b80 */  48, 48, 32, 76, 88, 67, 65, 76, 76, 66, 49, 10, 48, 48, 48, 48,
/* 0x6b90 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85,
/* 0x6ba0 */  66, 73, 84, 83, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77,
/* 0x6bb0 */  82, 85, 66, 73, 84, 83, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6bc0 */  32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 66, 89, 84, 69,
/* 0x6bd0 */  49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 66, 89,
/* 0x6be0 */  84, 69, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x6bf0 */  32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66, 49, 48,  9, 48, 48,
/* 0x6c00 */  48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 65, 82, 66, 49, 48, 10,
/* 0x6c10 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6c20 */  32, 76, 88, 77, 82, 85, 48, 52, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x6c30 */  48, 48, 32, 76, 88, 77, 82, 85, 48, 52, 48, 10, 48, 48, 48, 48,
/* 0x6c40 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 74,
/* 0x6c50 */  67, 67, 48, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x6c60 */  88, 74, 67, 67, 48, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6c70 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 74, 48, 77, 82,
/* 0x6c80 */  85,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 67, 74, 48,
/* 0x6c90 */  77, 82, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x6ca0 */  32, 32,100, 32, 32, 76, 88, 67, 74, 49, 77, 82, 85,  9, 48, 48,
/* 0x6cb0 */  48, 48, 48, 48, 48, 48, 32, 76, 88, 67, 74, 49, 77, 82, 85, 10,
/* 0x6cc0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6cd0 */  32, 76, 88, 67, 65, 76, 74, 77, 80,  9, 48, 48, 48, 48, 48, 48,
/* 0x6ce0 */  48, 48, 32, 76, 88, 67, 65, 76, 74, 77, 80, 10, 48, 48, 48, 48,
/* 0x6cf0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67,
/* 0x6d00 */  65, 76, 76, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x6d10 */  88, 67, 65, 76, 76, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6d20 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 65, 76, 76, 48,
/* 0x6d30 */  49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 67, 65, 76,
/* 0x6d40 */  76, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x6d50 */  32, 32,100, 32, 32, 76, 88, 67, 74, 50, 77, 82, 85,  9, 48, 48,
/* 0x6d60 */  48, 48, 48, 48, 48, 48, 32, 76, 88, 67, 74, 50, 77, 82, 85, 10,
/* 0x6d70 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6d80 */  32, 76, 88, 67, 74, 52, 77, 82, 85,  9, 48, 48, 48, 48, 48, 48,
/* 0x6d90 */  48, 48, 32, 76, 88, 67, 74, 52, 77, 82, 85, 10, 48, 48, 48, 48,
/* 0x6da0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67,
/* 0x6db0 */  74, 54, 77, 82, 85,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x6dc0 */  88, 67, 74, 54, 77, 82, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6dd0 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 74, 55, 77, 82,
/* 0x6de0 */  85,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 67, 74, 55,
/* 0x6df0 */  77, 82, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x6e00 */  32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 53, 53,  9, 48, 48,
/* 0x6e10 */  48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 48, 53, 53, 10,
/* 0x6e20 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6e30 */  32, 77, 82, 85, 66, 89, 84, 69, 50,  9, 48, 48, 48, 48, 48, 48,
/* 0x6e40 */  48, 48, 32, 77, 82, 85, 66, 89, 84, 69, 50, 10, 48, 48, 48, 48,
/* 0x6e50 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85,
/* 0x6e60 */  66, 73, 84, 83, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77,
/* 0x6e70 */  82, 85, 66, 73, 84, 83, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6e80 */  32,108, 32, 32, 32, 32,100, 32, 32, 77, 82, 85, 65, 82, 66, 50,
/* 0x6e90 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 82, 85, 65, 82,
/* 0x6ea0 */  66, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x6eb0 */  32, 32,100, 32, 32, 76, 88, 77, 82, 85, 48, 53, 55,  9, 48, 48,
/* 0x6ec0 */  48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 82, 85, 48, 53, 55, 10,
/* 0x6ed0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x6ee0 */  32, 76, 88, 77, 82, 85, 48, 53, 56,  9, 48, 48, 48, 48, 48, 48,
/* 0x6ef0 */  48, 48, 32, 76, 88, 77, 82, 85, 48, 53, 56, 10, 48, 48, 48, 48,
/* 0x6f00 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 85,
/* 0x6f10 */  78, 70, 48, 51, 53,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x6f20 */  88, 85, 78, 70, 48, 51, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6f30 */  32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46,
/* 0x6f40 */  51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,107,
/* 0x6f50 */  51, 50, 46, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x6f60 */  32, 32, 32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69, 49,  9,
/* 0x6f70 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 67, 76, 69, 86, 69,
/* 0x6f80 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x6f90 */ 100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 49,  9, 48, 48, 48, 48,
/* 0x6fa0 */  48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 48, 49, 10, 48, 48,
/* 0x6fb0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x6fc0 */  84, 66, 83, 72, 82, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x6fd0 */  32, 67, 84, 66, 83, 72, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x6fe0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 82, 79,
/* 0x6ff0 */  82, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66,
/* 0x7000 */  82, 79, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x7010 */  32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65, 48, 49,  9,
/* 0x7020 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 83, 87, 65, 48,
/* 0x7030 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x7040 */ 100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 50,  9, 48, 48, 48, 48,
/* 0x7050 */  48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 48, 50, 10, 48, 48,
/* 0x7060 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x7070 */  65, 76, 76, 84, 82, 69, 56,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x7080 */  32, 67, 65, 76, 76, 84, 82, 69, 56, 10, 48, 48, 48, 48, 48, 48,
/* 0x7090 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,
/* 0x70a0 */  82, 69, 57,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76,
/* 0x70b0 */  76, 84, 82, 69, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x70c0 */  32, 32, 32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69, 50,  9,
/* 0x70d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 67, 76, 69, 86, 69,
/* 0x70e0 */  50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x70f0 */ 100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 50,  9, 48, 48, 48, 48,
/* 0x7100 */  48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 50, 10, 48, 48,
/* 0x7110 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x7120 */  84, 66, 83, 72, 82, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x7130 */  32, 67, 84, 66, 83, 72, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x7140 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 82, 79,
/* 0x7150 */  82, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66,
/* 0x7160 */  82, 79, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x7170 */  32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65, 49, 49,  9,
/* 0x7180 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 83, 87, 65, 49,
/* 0x7190 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x71a0 */ 100, 32, 32, 76, 69, 88, 69, 67, 48, 49, 55,  9, 48, 48, 48, 48,
/* 0x71b0 */  48, 48, 48, 48, 32, 76, 69, 88, 69, 67, 48, 49, 55, 10, 48, 48,
/* 0x71c0 */  48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x71d0 */  69, 88, 69, 67, 48, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x71e0 */  32, 95,115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x71f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48,
/* 0x7200 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 77, 82, 85, 10, 48, 48, 48,
/* 0x7210 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x7220 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,
/* 0x7230 */ 116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x7240 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48,
/* 0x7250 */  48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,115,116, 97,
/* 0x7260 */  99,107, 95, 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x7270 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x7280 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,117,
/* 0x7290 */  95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x72a0 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,
/* 0x72b0 */  48, 48, 48, 48, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10,
/* 0x72c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x72d0 */  32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x72e0 */ 108,122,109, 97, 95,112,114,111,112,101,114,116,105,101,115, 10,
/* 0x72f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7300 */  32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x7310 */ 102,105,108,116,101,114, 95,108,101,110,103,116,104, 10, 10, 82,
/* 0x7320 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x7330 */  83, 32, 70, 79, 82, 32, 91, 76, 69, 88, 69, 67, 48, 48, 48, 93,
/* 0x7340 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x7350 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x7360 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,
/* 0x7370 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 76, 69,
/* 0x7380 */  88, 69, 67, 48, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x7390 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x73a0 */  76, 69, 88, 69, 67, 48, 48, 57, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x73b0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x73c0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x73d0 */  48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32,
/* 0x73e0 */  32, 32, 32, 32, 32, 32, 32, 78, 77, 82, 85, 10, 10, 82, 69, 76,
/* 0x73f0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x7400 */  70, 79, 82, 32, 91, 76, 69, 88, 69, 67, 48, 49, 48, 93, 58, 10,
/* 0x7410 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x7420 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x7430 */  10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95,
/* 0x7440 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,
/* 0x7450 */ 101,114, 95, 99,116,111, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x7460 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x7470 */  78, 50, 66, 83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x7480 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7490 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x74a0 */  48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x74b0 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10,
/* 0x74c0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x74d0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 49,
/* 0x74e0 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x74f0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x7500 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x7510 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7520 */  78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x7530 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x7540 */  32, 91, 78, 50, 66, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70,
/* 0x7550 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x7560 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x7570 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x7580 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 83, 77, 65, 49,
/* 0x7590 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x75a0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65,
/* 0x75b0 */  83, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x75c0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x75d0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32,
/* 0x75e0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x75f0 */  32, 32, 78, 50, 66, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79,
/* 0x7600 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x7610 */  79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 51, 48, 93, 58, 10, 79,
/* 0x7620 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x7630 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x7640 */  48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x7650 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69,
/* 0x7660 */  67, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x7670 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66,
/* 0x7680 */  70, 65, 83, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x7690 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x76a0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x76b0 */  51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x76c0 */  32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x76d0 */  48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x76e0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48,
/* 0x76f0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x7700 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 68, 69, 67,
/* 0x7710 */  51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x7720 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7730 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 49, 32, 82,
/* 0x7740 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7750 */  32, 78, 50, 66, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x7760 */  50,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x7770 */  32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 10, 82,
/* 0x7780 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x7790 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 52, 48, 93,
/* 0x77a0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x77b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x77c0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56,
/* 0x77d0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x77e0 */  66, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x77f0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x7800 */  78, 50, 66, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x7810 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7820 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x7830 */  48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x7840 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10,
/* 0x7850 */  48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x7860 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69,
/* 0x7870 */  67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x7880 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66,
/* 0x7890 */  83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x78a0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x78b0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x78c0 */  56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x78d0 */  32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x78e0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x78f0 */  32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 54, 48, 93, 58,
/* 0x7900 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x7910 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x7920 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54,
/* 0x7930 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66,
/* 0x7940 */  70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82,
/* 0x7950 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x7960 */  32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x7970 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x7980 */  82, 32, 91, 78, 50, 66, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70,
/* 0x7990 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x79a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x79b0 */  48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x79c0 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67,
/* 0x79d0 */  49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x79e0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83,
/* 0x79f0 */  77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x7a00 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7a10 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x7a20 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x7a30 */  32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76,
/* 0x7a40 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x7a50 */  70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 49, 48, 93, 58, 10,
/* 0x7a60 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x7a70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x7a80 */  10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x7a90 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68,
/* 0x7aa0 */  69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x7ab0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x7ac0 */  68, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x7ad0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7ae0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x7af0 */  48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x7b00 */  32, 32, 32, 32, 32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 10, 82,
/* 0x7b10 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x7b20 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 50, 48, 93,
/* 0x7b30 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x7b40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x7b50 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56,
/* 0x7b60 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x7b70 */  68, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x7b80 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x7b90 */  78, 50, 68, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x7ba0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7bb0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x7bc0 */  48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x7bd0 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10,
/* 0x7be0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x7bf0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 51,
/* 0x7c00 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x7c10 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x7c20 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95,
/* 0x7c30 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7c40 */  78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x7c50 */ 101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x7c60 */  32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69,
/* 0x7c70 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x7c80 */  32, 70, 79, 82, 32, 91, 78, 50, 68, 68, 69, 67, 51, 48, 93, 58,
/* 0x7c90 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x7ca0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x7cb0 */  69, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54,
/* 0x7cc0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,
/* 0x7cd0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 50, 49, 32, 82,
/* 0x7ce0 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7cf0 */  32, 78, 50, 68, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x7d00 */  52, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x7d10 */  32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 53, 48, 10, 10, 82,
/* 0x7d20 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x7d30 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 52, 48, 93,
/* 0x7d40 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x7d50 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x7d60 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56,
/* 0x7d70 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x7d80 */  68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x7d90 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x7da0 */  78, 50, 68, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x7db0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7dc0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x7dd0 */  48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x7de0 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10,
/* 0x7df0 */  48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x7e00 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,
/* 0x7e10 */  67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x7e20 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,
/* 0x7e30 */  83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x7e40 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7e50 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x7e60 */  56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x7e70 */  32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x7e80 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x7e90 */  32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 54, 48, 93, 58,
/* 0x7ea0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x7eb0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x7ec0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54,
/* 0x7ed0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,
/* 0x7ee0 */  70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82,
/* 0x7ef0 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x7f00 */  32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x7f10 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x7f20 */  82, 32, 91, 78, 50, 68, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70,
/* 0x7f30 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x7f40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x7f50 */  48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x7f60 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67,
/* 0x7f70 */  49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x7f80 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83,
/* 0x7f90 */  77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x7fa0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7fb0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x7fc0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x7fd0 */  32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76,
/* 0x7fe0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x7ff0 */  70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 49, 48, 93, 58, 10,
/* 0x8000 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x8010 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x8020 */  10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x8030 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68,
/* 0x8040 */  69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x8050 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x8060 */  69, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x8070 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8080 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x8090 */  48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x80a0 */  32, 32, 32, 32, 32, 78, 50, 69, 83, 77, 65, 49, 48, 10, 10, 82,
/* 0x80b0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x80c0 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 50, 48, 93,
/* 0x80d0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x80e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x80f0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56,
/* 0x8100 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x8110 */  69, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x8120 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x8130 */  78, 50, 69, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x8140 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8150 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x8160 */  48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x8170 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10,
/* 0x8180 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x8190 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 51,
/* 0x81a0 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x81b0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x81c0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95,
/* 0x81d0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x81e0 */  78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x81f0 */ 101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x8200 */  32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69,
/* 0x8210 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x8220 */  32, 70, 79, 82, 32, 91, 78, 50, 69, 68, 69, 67, 51, 48, 93, 58,
/* 0x8230 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x8240 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x8250 */  69, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54,
/* 0x8260 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,
/* 0x8270 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 49,101, 32, 82,
/* 0x8280 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8290 */  32, 78, 50, 69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x82a0 */  51, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x82b0 */  32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 54, 48, 10, 10, 82,
/* 0x82c0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x82d0 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 52, 48, 93,
/* 0x82e0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x82f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x8300 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56,
/* 0x8310 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x8320 */  69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x8330 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x8340 */  78, 50, 69, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x8350 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8360 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x8370 */  48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x8380 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10,
/* 0x8390 */  48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x83a0 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,
/* 0x83b0 */  67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x83c0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,
/* 0x83d0 */  83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x83e0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x83f0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x8400 */  56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x8410 */  32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x8420 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x8430 */  32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 54, 48, 93, 58,
/* 0x8440 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x8450 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x8460 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54,
/* 0x8470 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,
/* 0x8480 */  70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82,
/* 0x8490 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x84a0 */  32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x84b0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x84c0 */  82, 32, 91, 78, 50, 69, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70,
/* 0x84d0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x84e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x84f0 */  48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x8500 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67,
/* 0x8510 */  49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x8520 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65,
/* 0x8530 */  95, 68, 69, 67, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x8540 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8550 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x8560 */  48, 53, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x8570 */  32, 32, 32, 32, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95,
/* 0x8580 */  97,100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32,
/* 0x8590 */  82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x85a0 */  32, 32,108,122,109, 97, 95,117, 95,108,101,110, 10, 48, 48, 48,
/* 0x85b0 */  48, 48, 48, 49,101, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32,
/* 0x85c0 */  32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95, 99, 95,108,
/* 0x85d0 */ 101,110, 10, 48, 48, 48, 48, 48, 48, 50, 97, 32, 82, 95, 51, 56,
/* 0x85e0 */  54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,
/* 0x85f0 */ 109, 97, 95,112,114,111,112,101,114,116,105,101,115, 10, 10, 82,
/* 0x8600 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x8610 */  83, 32, 70, 79, 82, 32, 91, 76, 69, 88, 69, 67, 48, 49, 54, 93,
/* 0x8620 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x8630 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x8640 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,
/* 0x8650 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88,
/* 0x8660 */  85, 78, 70, 48, 52, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x8670 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x8680 */  76, 88, 85, 78, 70, 48, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x8690 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x86a0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x86b0 */  48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x86c0 */  32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 49, 48, 10,
/* 0x86d0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x86e0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 77, 82, 85, 48, 48,
/* 0x86f0 */  53, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x8700 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x8710 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x8720 */  51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8730 */  78, 77, 82, 85, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x8740 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88,
/* 0x8750 */  85, 78, 70, 48, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x8760 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8770 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x8780 */  48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x8790 */  32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 52, 50, 10, 10, 82,
/* 0x87a0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x87b0 */  83, 32, 70, 79, 82, 32, 91, 76, 88, 74, 67, 67, 48, 50, 48, 93,
/* 0x87c0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x87d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x87e0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,
/* 0x87f0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88,
/* 0x8800 */  85, 78, 70, 48, 51, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x8810 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x8820 */  76, 88, 74, 67, 67, 48, 50, 49, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x8830 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8840 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x8850 */  48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x8860 */  32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 51, 52, 10,
/* 0x8870 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x8880 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 85, 78, 70, 51, 56,
/* 0x8890 */  56, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x88a0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x88b0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95,
/* 0x88c0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x88d0 */  76, 88, 85, 78, 70, 48, 52, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x88e0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x88f0 */  32, 91, 76, 88, 85, 78, 70, 52, 56, 55, 93, 58, 10, 79, 70, 70,
/* 0x8900 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x8910 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x8920 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x8930 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 52,
/* 0x8940 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x8950 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 77, 82, 85,
/* 0x8960 */  48, 54, 53, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x8970 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8980 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32,
/* 0x8990 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x89a0 */  32, 32, 76, 88, 77, 82, 85, 48, 55, 48, 10, 10, 82, 69, 76, 79,
/* 0x89b0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x89c0 */  79, 82, 32, 91, 76, 88, 77, 82, 85, 48, 55, 48, 93, 58, 10, 79,
/* 0x89d0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x89e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x89f0 */  48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x8a00 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70,
/* 0x8a10 */  48, 52, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x8a20 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 77,
/* 0x8a30 */  82, 85, 48, 57, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x8a40 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8a50 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x8a60 */  54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x8a70 */  32, 32, 32, 32, 76, 88, 77, 82, 85, 49, 48, 48, 10, 10, 82, 69,
/* 0x8a80 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x8a90 */  32, 70, 79, 82, 32, 91, 76, 88, 85, 78, 70, 48, 52, 49, 93, 58,
/* 0x8aa0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x8ab0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x8ac0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54,
/* 0x8ad0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85,
/* 0x8ae0 */  78, 70, 48, 51, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x8af0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76,
/* 0x8b00 */  88, 77, 82, 85, 48, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x8b10 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8b20 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x8b30 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x8b40 */  32, 32, 32, 32, 32, 32, 76, 88, 77, 82, 85, 48, 51, 48, 10, 10,
/* 0x8b50 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x8b60 */  68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 74, 67, 67, 48, 48, 48,
/* 0x8b70 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x8b80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x8b90 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51,
/* 0x8ba0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x8bb0 */  88, 74, 67, 67, 48, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x8bc0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x8bd0 */  91, 76, 88, 67, 65, 76, 76, 48, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x8be0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x8bf0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x8c00 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x8c10 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 51, 55,
/* 0x8c20 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x8c30 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 67, 74, 50, 77,
/* 0x8c40 */  82, 85, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x8c50 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8c60 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,
/* 0x8c70 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8c80 */  32, 76, 88, 85, 78, 70, 48, 51, 55, 10, 10, 82, 69, 76, 79, 67,
/* 0x8c90 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x8ca0 */  82, 32, 91, 76, 88, 67, 74, 52, 77, 82, 85, 93, 58, 10, 79, 70,
/* 0x8cb0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x8cc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x8cd0 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x8ce0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48,
/* 0x8cf0 */  51, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x8d00 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 67, 74,
/* 0x8d10 */  54, 77, 82, 85, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x8d20 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8d30 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x8d40 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x8d50 */  32, 32, 32, 76, 88, 67, 74, 56, 77, 82, 85, 10, 10, 82, 69, 76,
/* 0x8d60 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x8d70 */  70, 79, 82, 32, 91, 76, 88, 67, 74, 55, 77, 82, 85, 93, 58, 10,
/* 0x8d80 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x8d90 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x8da0 */  10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x8db0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88, 67, 74,
/* 0x8dc0 */  56, 77, 82, 85, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x8dd0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88,
/* 0x8de0 */  67, 74, 56, 77, 82, 85, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x8df0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8e00 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x8e10 */  48, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x8e20 */  32, 32, 32, 32, 32, 76, 88, 85, 78, 70, 48, 51, 55, 10, 10, 82,
/* 0x8e30 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x8e40 */  83, 32, 70, 79, 82, 32, 91, 76, 88, 85, 78, 70, 48, 51, 52, 93,
/* 0x8e50 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x8e60 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x8e70 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56,
/* 0x8e80 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 88,
/* 0x8e90 */  85, 78, 70, 48, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x8ea0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x8eb0 */  99,116,111,107, 51, 50, 46, 48, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x8ec0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x8ed0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x8ee0 */  48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x8ef0 */  32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 50,
/* 0x8f00 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x8f10 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51,
/* 0x8f20 */  50, 46, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x8f30 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8f40 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,100,
/* 0x8f50 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x8f60 */  32, 32, 32, 99,116,111,107, 51, 50, 46, 50, 48, 10, 10, 82, 69,
/* 0x8f70 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x8f80 */  32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 50, 48, 93,
/* 0x8f90 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x8fa0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x8fb0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56,
/* 0x8fc0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,
/* 0x8fd0 */ 111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 97,
/* 0x8fe0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x8ff0 */  32, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48,
/* 0x9000 */  48, 48, 48, 49, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x9010 */  32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52,
/* 0x9020 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x9030 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51,
/* 0x9040 */  50, 46, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x9050 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x9060 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x9070 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x9080 */  32, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48,
/* 0x9090 */  48, 48, 48, 48, 57, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x90a0 */  32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 49,
/* 0x90b0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x90c0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51,
/* 0x90d0 */  50, 46, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x90e0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x90f0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x9100 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x9110 */  32, 32, 32, 99,116,111,107, 51, 50, 46, 48, 48, 10, 10, 82, 69,
/* 0x9120 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x9130 */  32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 48, 48, 93, 58,
/* 0x9140 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x9150 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x9160 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x9170 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,
/* 0x9180 */ 116,101,114, 95,108,101,110,103,116,104, 10, 10, 82, 69, 76, 79,
/* 0x9190 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x91a0 */  79, 82, 32, 91, 67, 84, 67, 76, 69, 86, 69, 49, 93, 58, 10, 79,
/* 0x91b0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x91c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x91d0 */  48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 56,
/* 0x91e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,
/* 0x91f0 */ 114, 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82,
/* 0x9200 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x9210 */  32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x9220 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x9230 */  82, 32, 91, 67, 65, 76, 76, 84, 82, 48, 50, 93, 58, 10, 79, 70,
/* 0x9240 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x9250 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x9260 */  48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x9270 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x9280 */  48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x9290 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76,
/* 0x92a0 */  84, 82, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x92b0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x92c0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x92d0 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x92e0 */  32, 32, 32,102,105,108,116,101,114, 95,108,101,110,103,116,104,
/* 0x92f0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x9300 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82,
/* 0x9310 */  49, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x9320 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x9330 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,
/* 0x9340 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x9350 */  32, 67, 65, 76, 76, 84, 82, 49, 51, 10, 10, 82, 69, 76, 79, 67,
/* 0x9360 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x9370 */  82, 32, 91, 67, 84, 67, 76, 69, 86, 69, 50, 93, 58, 10, 79, 70,
/* 0x9380 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x9390 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x93a0 */  48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32,
/* 0x93b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114,
/* 0x93c0 */  95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95,
/* 0x93d0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x93e0 */  67, 65, 76, 76, 84, 82, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x93f0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x9400 */  32, 91, 67, 65, 76, 76, 84, 82, 49, 51, 93, 58, 10, 79, 70, 70,
/* 0x9410 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x9420 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x9430 */  48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x9440 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49,
/* 0x9450 */  48, 10
};
