/*****************************************************************************

	unsort - reorder files semi-randomly
	Copyright (C) 2007, 2008  Wessel Dankers <wsl@fruit.je>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

*****************************************************************************/

#ifndef SHUFFLE_H
#define SHUFFLE_H

typedef void (*shuffle_algo_t)(uint32_t *, uint32_t *, uint32_t);

extern const shuffle_algo_t shuffle_heuristic;

extern void shuffle_seed(uint32_t);
extern void shuffle_tmp(uint32_t *);
extern void shuffle_init(uint32_t *, uint32_t);
extern void shuffle_none(uint32_t *, uint32_t *, uint32_t);
extern void shuffle_random(uint32_t *, uint32_t *, uint32_t);
extern void shuffle_bitreverse(uint32_t *, uint32_t *, uint32_t);
extern void shuffle_sqrtbase(uint32_t *, uint32_t *, uint32_t);

#endif
