/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#ifndef __AMT_SOAPEVENTSUBSCRIBER_H
#define __AMT_SOAPEVENTSUBSCRIBER_H
#include "AMT_EventSubscriber.h"
namespace CimClassNamespace
{

	// Class AMT_SOAPEventSubscriber:
	// Represents a SOAP-events subscriber in the Intel AMT system.
	class AMT_SOAPEventSubscriber  : public AMT_EventSubscriber
	{
	public:
		// type definitions
		typedef CimClassContainer<AMT_SOAPEventSubscriber> AMT_SOAPEventSubscriberContainer;

		// static const declarations
		static const string CLASS_NAME;
		static const string CLASS_URI;
		static const string CLASS_NS;
		static const string CLASS_NS_PREFIX;

		// class fields
		// Access and/or addressing information for a remote connection. This can be a host name, network address or similar information.
		string AccessInfo;

		// Identifies the role this RemoteServiceAccessPoint is playing in the hosting system.
		unsigned int AccessContext;

		// This field determines whether the AccessContext field is valid.
		bool AccessContextSpecified;

		// When the AccessContext property contains a value of 1, 'Other' then this is a free form string providing more information about the role of RemoteServiceAccessPoint in the hosting system.
		string OtherAccessContext;

		// This field determines whether the OtherAccessContext field is valid.
		bool OtherAccessContextSpecified;

		// The user's credentials.
		string UserName;

		// This field determines whether the UserName field is valid.
		bool UserNameSpecified;

		// The user's credentials.
		string Password;

		// This field determines whether the Password field is valid.
		bool PasswordSpecified;

		// A list of authentications allowed for this event. The priority of authentications is given by the order of the list.
		// Legal values:
		// Kerberos: 0
		// Digest: 1
		// Basic: 2
		vector<unsigned short> AlertAuthenticationOptions;

		// Associates a Subscription to its filter.
		unsigned char PolicyID;

		// Class Constructor
		AMT_SOAPEventSubscriber(
			const string& objName = AMT_SOAPEventSubscriber::CLASS_NAME,
			const string& uri = AMT_SOAPEventSubscriber::CLASS_URI,
			const string& ns = AMT_SOAPEventSubscriber::CLASS_NS,
			const string& nsPrefix = AMT_SOAPEventSubscriber::CLASS_NS_PREFIX);

		// Class Destructor
		virtual ~AMT_SOAPEventSubscriber(){}

		// This function appends a serialization of this instance to the given node.
		virtual void SerializeMembers(XMLElement& node) const;

		// This function returns the selector set of this instance.
		virtual NameValuePairs GetSelectorsList() const;

		// This function sets a field value according to the given node.
		virtual void SetValue(const XMLElement& node);

	};
}
#endif
