// ==UserScript==
// @include       http://news.yandex.ru/*
// @include       https://news.yandex.ru/*
// @require       utils.js
// ==/UserScript==

// This placeholder gets munged with real data at build time.
var WebappsGettextDict = JSON.parse(unescape(
    "%7B%22GETTEXT%22%3A%22PLACEHOLDER%22%7D"
));

window.Unity = external.getUnityObject(1);

function isCorrectPage() {
    if (!document.getElementsByClassName('b-head-logo')[0]) {
        return false;
    }

    return true;
}

function markAsRead(items) {
    var i;
    for (i = 0; i < items.length; i++) {
        localStorage.setItem(items[i], true);
    }
}

function getHeaders(doc) {
    var res = [], i;

    var snapshot = doc.evaluate('//tr/td/div/dl/dt[@class="head"]/a',
                                doc, null, XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE, null);
    reportTestState('total:' + snapshot.snapshotLength);
    for (i = 0; i < snapshot.snapshotLength; i++) {
        var node = snapshot.snapshotItem(i);
        if (node.textContent.length
                && !localStorage.getItem(node.textContent)
                && !node.textContent.match(/^HASH/)) {
            res.push(node.textContent);
        }
    }
    reportTestState('new:' + res.length);
    return res;
}

function showNotifications(items) {
    var i;
    for (i = 0; i < items.length; i++) {
        Unity.Notification.showNotification(_("Yandex News"), items[i], null);
    }
    markAsRead(items);
}

function messagingIndicatorSetup() {
    var iframe = document.createElement('iframe');
    iframe.width = 0;
    iframe.height = 0;
    iframe.src = "http://news.yandex.ru/?sdasda";
    document.body.appendChild(iframe);
    markAsRead(getHeaders(document));

    function retry() {
        iframe.src = "http://news.yandex.ru/?sdasda";
    }
    iframe.onload = wrapCallback(function () {
        showNotifications(getHeaders(iframe.contentWindow.document));
        setTimeout(retry, 60000);
    });
    retry();
}

if (isCorrectPage()) {
    Unity.init({ name: _("Yandex News"),
                 domain: 'news.yandex.ru',
                 homepage: 'http://news.yandex.ru/',
                 iconUrl: "icon://unity-webapps-yandex-news",
                 onInit: wrapCallback(messagingIndicatorSetup) });
}
