#!/usr/bin/env python3
# -*- coding: utf-8 -*-

from distutils.core import setup
import os

APPVERSION = None

with open(os.path.realpath(os.path.join(os.getcwd(), os.path.dirname(__file__), 'UnityMail/application.py')), 'r') as oFile:

    for strLine in oFile:

        if 'APPVERSION = ' in strLine:

            APPVERSION = strLine.split('=')[1].strip(" '\n")
            break

setup(
    name = 'UnityMail',
    version = APPVERSION,
    description = 'Mail notifications and counter for Unity/MATE/Xfce/LXDE/etc.',
    author = 'Robert Tari',
    author_email = 'robert.tari@gmail.com',
    url = 'https://tari.in/www/software/unitymail/',
    packages = ['UnityMail'],
    scripts = ['unity-mail', 'unity-mail-url', 'unity-mail-clear', 'unity-mail-settings', 'unity-mail-reset'],
    license = 'GPL 3+'
    )

