/*
 * unity-npapi-tools.c
 * Copyright (C) Canonical LTD 2013
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#include <glib.h>
#include <string.h>

#define WNCK_I_KNOW_THIS_IS_UNSTABLE
#include <libwnck/libwnck.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include <unity-webapps-context.h>

#include "unity-npapi-tools.h"


void
unity_npapi_tools_set_xid_for_browser_window_id(UnityWebappsContext *context,
                                                int window_id)
{
  const gchar * const
    CHROMIUM_LINUX_SESSION_ID_PROPERTY = "CHROMIUM_LINUX_SESSION_ID_PROPERTY";

  WnckScreen *screen;
  GList *windows, *walk;

  // idempotent
  gtk_init(NULL, NULL);

  screen = wnck_screen_get_default();

  // TODO find a way to get it from the WnckScreen?
  GdkDisplay* display = gdk_display_get_default();

  wnck_screen_force_update (screen);

  windows = wnck_screen_get_windows_stacked (screen);

  for (walk = windows; walk != NULL; walk = walk->next)
    {
      WnckWindow *window = WNCK_WINDOW (walk->data);

      GdkWindow *active_window =
        gdk_x11_window_foreign_new_for_display (display,
                                                wnck_window_get_xid(window));
      if (NULL == active_window)
	{
	  g_message ("Could not retrieve GdkWindow for xid %ld",
                     wnck_window_get_xid(window));
	  continue;
	}

      GdkAtom atom;
      gint format = 0;
      gint out_length = 0;
      gint * session_id = NULL;
      gboolean have_prop =
        gdk_property_get (active_window,
                          gdk_atom_intern(CHROMIUM_LINUX_SESSION_ID_PROPERTY,
                                          FALSE),
                          gdk_atom_intern("CARDINAL", FALSE),
                          0L,
                          4,
                          FALSE,
                          &atom,
                          &format,
                          &out_length,
                          (guchar **)&session_id);
      if (TRUE == have_prop &&
          NULL != session_id &&
          window_id == session_id[0])
	{
	  unity_webapps_context_set_view_window (context,
              (guint64) wnck_window_get_xid (window));

	  g_free (session_id);
	  break;
	}
    }
}

