/*
 * unity-npapi-plugin-plugin-npn-funcs.c
 * Copyright (C) Canonical LTD 2012
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>

#include "npapi-headers/headers/npapi.h"
#include "npapi-headers/headers/npfunctions.h"


NPNetscapeFuncs	* pBrowser_NPN_Functions = NULL;


void NPN_Version (int* plugin_major, int* plugin_minor, int* netscape_major, int* netscape_minor)
{
  *plugin_major = NP_VERSION_MAJOR;
  *plugin_minor = NP_VERSION_MINOR;

  // TODO
  *netscape_major = 0;
  *netscape_minor = 0;
}

NPError NPN_GetURLNotify (NPP instance, const char *url, const char *target, void* notifyData)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return NPERR_INVALID_PLUGIN_ERROR;
    }
	
  return pBrowser_NPN_Functions->geturlnotify (instance, url, target, notifyData);
}

NPError NPN_GetURL (NPP instance, const char *url, const char *target)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return NPERR_INVALID_PLUGIN_ERROR;
    }
	
  return pBrowser_NPN_Functions->geturl (instance, url, target);
}

NPError NPN_PostURLNotify (NPP instance, const char* url, const char* window, uint32_t len, const char* buf, NPBool file, void* notifyData)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return NPERR_INVALID_PLUGIN_ERROR;
    }
	
  return pBrowser_NPN_Functions->posturlnotify (instance, url, window, len, buf, file, notifyData);
}

NPError NPN_PostURL(NPP instance, const char* url, const char* window, uint32_t len, const char* buf, NPBool file)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return NPERR_INVALID_PLUGIN_ERROR;
    }
	
  return pBrowser_NPN_Functions->posturl (instance, url, window, len, buf, file);
} 

NPError NPN_RequestRead(NPStream* stream, NPByteRange* rangeList)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return NPERR_INVALID_PLUGIN_ERROR;
    }
	
  return pBrowser_NPN_Functions->requestread (stream, rangeList);
}

NPError NPN_NewStream(NPP instance, NPMIMEType type, const char* target, NPStream** stream)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return NPERR_INVALID_PLUGIN_ERROR;
    }
	
  return pBrowser_NPN_Functions->newstream (instance, type, target, stream);
}

int32_t NPN_Write(NPP instance, NPStream *stream, int32_t len, void *buffer)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return 0;
    }
	
  return pBrowser_NPN_Functions->write (instance, stream, len, buffer);
}

NPError NPN_DestroyStream(NPP instance, NPStream* stream, NPError reason)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return NPERR_INVALID_PLUGIN_ERROR;
    }
	
  return pBrowser_NPN_Functions->destroystream (instance, stream, reason);
}

void NPN_Status(NPP instance, const char *message)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return;
    }
	
  pBrowser_NPN_Functions->status (instance, message);
}

const char* NPN_UserAgent(NPP instance)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return NULL;
    }
	
  return pBrowser_NPN_Functions->uagent(instance);
}

void* NPN_MemAlloc(uint32_t size)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return NULL;
    }
	
  return pBrowser_NPN_Functions->memalloc(size);
}

void NPN_MemFree(void* ptr)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return;
    }
	
  pBrowser_NPN_Functions->memfree(ptr);
}

uint32_t NPN_MemFlush (uint32_t size)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return 0;
    }
	
  return pBrowser_NPN_Functions->memflush(size);
}

void NPN_ReloadPlugins (NPBool reloadPages)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return;
    }
	
  pBrowser_NPN_Functions->reloadplugins(reloadPages);
}

NPError NPN_GetValue(NPP instance, NPNVariable variable, void *value)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return NPERR_INVALID_PLUGIN_ERROR;
    }
  return pBrowser_NPN_Functions->getvalue(instance, variable, value);
}

NPError NPN_SetValue(NPP instance, NPPVariable variable, void *value)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return NPERR_INVALID_PLUGIN_ERROR;
    }
  return pBrowser_NPN_Functions->setvalue(instance, variable, value);
}

void NPN_InvalidateRect(NPP instance, NPRect *invalidRect)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return;
    }
  pBrowser_NPN_Functions->invalidaterect(instance, invalidRect);
}

void NPN_InvalidateRegion(NPP instance, NPRegion invalidRegion)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return;
    }
  pBrowser_NPN_Functions->invalidateregion(instance, invalidRegion);
}

void NPN_ForceRedraw(NPP instance)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return;
    }
  pBrowser_NPN_Functions->forceredraw(instance);
}

NPIdentifier NPN_GetStringIdentifier(const NPUTF8 *name)
{
  NPIdentifier identifier;
	
  if (NULL == pBrowser_NPN_Functions)
    {
      return identifier;
    }
  identifier = pBrowser_NPN_Functions->getstringidentifier(name);
	
  return identifier;
}

void NPN_GetStringIdentifiers(const NPUTF8 **names, int32_t nameCount,
                              NPIdentifier *identifiers)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return;
    }
  return pBrowser_NPN_Functions->getstringidentifiers(names, nameCount, identifiers);
}


NPIdentifier NPN_GetIntIdentifier(int32_t id)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return 0;
    }
  return pBrowser_NPN_Functions->getintidentifier(id);
}

bool NPN_IdentifierIsString(NPIdentifier identifier)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return false;
    }
  return pBrowser_NPN_Functions->identifierisstring(identifier);
}

NPUTF8 *NPN_UTF8FromIdentifier(NPIdentifier identifier)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return NULL;
    }
  return pBrowser_NPN_Functions->utf8fromidentifier(identifier);
}

int32_t NPN_IntFromIdentifier(NPIdentifier identifier)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return 0;
    }
  return pBrowser_NPN_Functions->intfromidentifier(identifier);
}

NPObject *NPN_CreateObject(NPP npp, NPClass *aClass)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return NULL;
    }
  return pBrowser_NPN_Functions->createobject(npp, aClass);
}

NPObject *NPN_RetainObject(NPObject *obj)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return NULL;
    }
  return pBrowser_NPN_Functions->retainobject(obj);
}

void NPN_ReleaseObject(NPObject *obj)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return;
    }
  return pBrowser_NPN_Functions->releaseobject(obj);
}

bool NPN_Invoke (NPP npp, NPObject* obj, NPIdentifier methodName,
		 const NPVariant *args, uint32_t argCount, NPVariant *result)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return false;
    }
  return pBrowser_NPN_Functions->invoke(npp, obj, methodName, args, argCount, result);
}

bool NPN_InvokeDefault (NPP npp, NPObject* obj, const NPVariant *args,
			uint32_t argCount, NPVariant *result)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return false;
    }
  return pBrowser_NPN_Functions->invokeDefault(npp, obj, args, argCount, result);
}

bool NPN_Evaluate(NPP npp, NPObject* obj, NPString *script,
                  NPVariant *result)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return false;
    }
  return pBrowser_NPN_Functions->evaluate(npp, obj, script, result);
}

bool NPN_GetProperty(NPP npp, NPObject* obj, NPIdentifier propertyName,
                     NPVariant *result)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return false;
    }
  return pBrowser_NPN_Functions->getproperty(npp, obj, propertyName, result);
}

bool NPN_SetProperty (NPP npp, NPObject* obj, NPIdentifier propertyName,
		      const NPVariant *value)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return false;
    }
  return pBrowser_NPN_Functions->setproperty(npp, obj, propertyName, value);
}

bool NPN_RemoveProperty (NPP npp, NPObject* obj, NPIdentifier propertyName)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return false;
    }
  return pBrowser_NPN_Functions->removeproperty(npp, obj, propertyName);
}

bool NPN_Enumerate (NPP npp, NPObject *obj, NPIdentifier **identifier,
		    uint32_t *count)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return false;
    }
  return pBrowser_NPN_Functions->enumerate(npp, obj, identifier, count);
}

bool NPN_Construct (NPP npp, NPObject *obj, const NPVariant *args,
		    uint32_t argCount, NPVariant *result)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return false;
    }
  return pBrowser_NPN_Functions->construct(npp, obj, args, argCount, result);
}

bool NPN_HasProperty (NPP npp, NPObject* obj, NPIdentifier propertyName)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return false;
    }
  return pBrowser_NPN_Functions->hasproperty(npp, obj, propertyName);
}

bool NPN_HasMethod (NPP npp, NPObject* obj, NPIdentifier methodName)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return false;
    }
  return pBrowser_NPN_Functions->hasmethod(npp, obj, methodName);
}

void NPN_ReleaseVariantValue (NPVariant *variant)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return;
    }
  pBrowser_NPN_Functions->releasevariantvalue(variant);
}

void NPN_SetException (NPObject* obj, const NPUTF8 *message)
{
  if (NULL == pBrowser_NPN_Functions)
    {
      return;
    }
  pBrowser_NPN_Functions->setexception(obj, message);
}

