/*
 * uMPS - A general purpose computer system simulator
 *
 * Copyright (C) 2010 Tomislav Jonjic
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef QUMPS_FLAT_PUSH_BUTTON_H
#define QUMPS_FLAT_PUSH_BUTTON_H

#include <QPushButton>

class FlatPushButton : public QPushButton {
Q_OBJECT

public:
FlatPushButton(QWidget* parent = 0);
FlatPushButton(const QString& text, QWidget* parent = 0);
FlatPushButton(const QIcon& icon, const QString& text, QWidget* parent = 0);

protected:
virtual void enterEvent(QEvent* event);
virtual void leaveEvent(QEvent* event);
};

#endif // QUMPS_FLAT_PUSH_BUTTON_H
