/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#ifndef UPM_DAEMON_H
#define UPM_DAEMON_H

#include <QObject>
#include <QLocalSocket>

#include "common.h"

#include "upm_brightness.h"
#include "upm_systemidle.h"
#include "upm_powerchanged.h"
#include "upm_lid.h"
#include "upm_lowpower.h"

#include "upm_externalinterface.h"

class UpmDaemon : public QObject
{
    Q_OBJECT
public:
    explicit UpmDaemon(QObject *parent = nullptr);

private:
    UpmBrightness *m_brightness;
    UpmSystemIdle *m_systemIdle;

    UpmPowerChanged *m_powerChanged;
    UpmLid *m_lid;
    UpmLowPower *m_lowPower;

    int m_powerPolicyAc;
    int m_powerPolicyBattery;
    int m_powerPolicyBatteryBackup;

    QLocalSocket *m_socket;
    void initAcpiSocket();

    UpmExternalInterface *m_externalInterface;
    void registerExternalInterface();

private slots:
    void dealPowerPolicyAcChanged(QVariant value);
    void dealPowerPolicyBatteryChanged(QVariant value);
    void dealPowerPolicyBatteryBackupChanged(QVariant value);

    void dealBrightnessControlSignal(int action);

    void dealSystemConfigChanged(const QString, const QString, const QString);
};

#endif // UPM_DAEMON_H
