/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#ifndef UPM_COMMONDBUS_H
#define UPM_COMMONDBUS_H

#include <QObject>
#include <QtDBus>
#include <QDBusInterface>

#ifdef KY_SDK_SYSINFO
#include <kysdk/kysdk-system/libkysysinfo.h>
#endif

//#include <ksoundeffects.h>
//using namespace kdk;

#define SYSTEM_BUSY_SIGNAL_VALUE      0
#define SYSTEM_IDEL_SIGNAL_VALUE      3

class UpmCommonDBus : public QObject
{
    Q_OBJECT
public:
    explicit UpmCommonDBus(QObject *parent = nullptr);
    ~UpmCommonDBus();
    static UpmCommonDBus* self();
    quint32 sendNotification(const QString &type,
                             const QString &arg,
                             bool permanent);
    void closeNotification(quint32 notificationId);
//    void playSystemSound(SoundType type);
    bool isCloudPlatform();

private:
    bool m_isCloudPlatform = false;

    void initPlatformType();

private slots:
    void dealPrepareForSleep(bool);
    void dealSystemStatusChanged(quint32);
    void dealUserActiveSignal(bool);

signals:
    void systemSleepStatus(bool);
    void systemIdleStatus(bool);
    void userActiveSignal(bool);
};

#endif // UPM_COMMONDBUS_H
