/*
 *
 *  * Copyright (C) 2023, KylinSoft Co., Ltd.
 *  *
 *  * This program is free software: you can redistribute it and/or modify
 *  * it under the terms of the GNU General Public License as published by
 *  * the Free Software Foundation, either version 3 of the License, or
 *  * (at your option) any later version.
 *  *
 *  * This program is distributed in the hope that it will be useful,
 *  * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  * GNU General Public License for more details.
 *  *
 *  * You should have received a copy of the GNU General Public License
 *  * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *  *
 *  * Authors: Nicole <buxiaoqing@kylinos.cn>
 *  *          zyy <zhangyuanyuan1@kylinos.cn>
 *
 */

#ifndef WINDOW_THUMBNAIL_MODEL_H
#define WINDOW_THUMBNAIL_MODEL_H

#include <QObject>
#include <QAbstractListModel>
#include <QIcon>

#include <windowmanager/windowmanager.h>
using namespace kdk;

class ThumbnailItem {
public:
    QVariant m_winId;
    QString m_groupName;
};

class ThumbnailModelItem
{
    Q_GADGET

public:
    ThumbnailModelItem() = default;
    explicit ThumbnailModelItem(const ThumbnailItem &thumbnail);
    ~ThumbnailModelItem() = default;

    QVariant winId() const;
    QString groupName() const;
    void setData(const ThumbnailItem &thumbnail);

private:
    ThumbnailItem m_data;
};

//----------------Model------------------
class ThumbnailModelPrivate;
class ThumbnailModel : public QAbstractListModel
{
    Q_OBJECT

public:
    static ThumbnailModel *instance();
    ~ThumbnailModel();

    QVariant data(const QModelIndex &index, int role) const override;
    int rowCount(const QModelIndex &parent) const override;

    /**
     * @brief 初始化model数据
     * @param data
     */
    void setModelData(const QList<QVariant> &data, const QString &groupName);

    /**
     * @brief 清除model
     */
    Q_INVOKABLE void clear();

    Q_INVOKABLE QList<QVariant> getGroupWIndowList(QString groupName);

    /**
     * 关闭窗口
     * @param winId
     */
    Q_INVOKABLE void closeWindow(const QVariant &winId);
    /**
     * 激活窗口
     * @param winId
     */
    Q_INVOKABLE void activateWindow(const QVariant &winId);
    /**
     * 窗口标题
     * @param winId
     * @return
     */
    Q_INVOKABLE QString getWindowTitle(const QVariant &winId);
    /**
     * 窗口图标
     * @param winId
     * @return
     */
    Q_INVOKABLE QIcon getWindowIcon(const QVariant &winId);
    /**
     * @brief 窗口uuid
     * @param winId
     * @return
     */
    Q_INVOKABLE QString getWindowUuid(const QVariant &winId);

//private Q_SLOTS:
public Q_SLOTS:
    /**
     * @brief 预览图窗口的增加
     * @param winId
     */
    void onWIndowAdded(const QVariant &winId, const QString &groupName);
    /**
     * @brief 预览图窗口的减少
     * @param winId
     */
    void onWindowRemoved(const QVariant &winId);
    /**
     * @brief 预览图窗口的更新
     * @param winId
     */
    void updateWindow(int row, const QVariant &winId, const QString &groupName);
    /**
     * @brief 悬浮不同的group时更新model中的data信息
     */
    void updateModeData();

private:
    explicit ThumbnailModel(QObject *parent = nullptr);
    // 查找预览图在数组中的索引
    int findThumbnailIndex(const QVariant winId) const;

    ThumbnailModelPrivate *d = nullptr;

Q_SIGNALS:
    void updateWinIdList(QList<QVariant> viewModel);
};

#endif //WINDOW_THUMBNAIL_MODEL_H
