/*
 *
 *  * Copyright (C) 2023, KylinSoft Co., Ltd.
 *  *
 *  * This program is free software: you can redistribute it and/or modify
 *  * it under the terms of the GNU General Public License as published by
 *  * the Free Software Foundation, either version 3 of the License, or
 *  * (at your option) any later version.
 *  *
 *  * This program is distributed in the hope that it will be useful,
 *  * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  * GNU General Public License for more details.
 *  *
 *  * You should have received a copy of the GNU General Public License
 *  * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *  *
 *  * Authors: Nicole <buxiaoqing@kylinos.cn>
 *
 */

#include "generalsettings.h"
#include <QtDebug>
GeneralSettings::GeneralSettings(QWidget *parent) : QFrame(parent)
{
    this->setMinimumSize(QSize(550, 0));
    this->setMaximumSize(QSize(16777215, 16777215));
    this->setFrameShape(QFrame::Box);

    m_generalSettingsLayout = new QVBoxLayout(this);
    m_generalSettingsLayout->setContentsMargins(0, 0, 0, 0);
    m_generalSettingsLayout->setSpacing(0);

    mergeTaskgroup();
    panelPosition();
    panelSize();
    hidePanel();
    lockPanel();

}

void GeneralSettings::setFrame_Noframe(QFrame *frame)
{
    frame->setMinimumSize(QSize(550, 60));
    frame->setMaximumSize(QSize(16777215, 60));
    frame->setFrameShape(QFrame::NoFrame);
}

QFrame *GeneralSettings::setLine(QFrame *frame)
{
    QFrame *line = new QFrame(frame);
    line->setMinimumSize(QSize(0, 1));
    line->setMaximumSize(QSize(16777215, 1));
    line->setLineWidth(0);
    line->setFrameShape(QFrame::HLine);
    line->setFrameShadow(QFrame::Sunken);
    return line;
}

void GeneralSettings::mergeTaskgroup()
{
    m_mergeTaskgroupFrame = new QFrame(this);
    setFrame_Noframe(m_mergeTaskgroupFrame);

    m_mergeTaskgroupLayout = new QHBoxLayout(m_mergeTaskgroupFrame);
    m_mergeTaskgroupLayout->setContentsMargins(16, 0, 16, 0);

    m_mergeTaskgroupLabel = new QLabel(m_mergeTaskgroupFrame);
    m_mergeTaskgroupLabel->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    m_mergeTaskgroupLabel->setText(tr("Merge icons on the taskbar"));

    m_mergeTaskgroup = new QComboBox(m_mergeTaskgroupFrame);
    m_mergeTaskgroup->setObjectName(GROUP_ENABLE);
    m_mergeTaskgroup->setMinimumWidth(320);

    QStringList panelicon_list;
    panelicon_list << tr("Always") << tr("Never");
    m_mergeTaskgroup->insertItem(0, panelicon_list.at(0), "Always");
    m_mergeTaskgroup->insertItem(1, panelicon_list.at(1), "Never");

    m_mergeTaskgroupLayout->addWidget(m_mergeTaskgroupLabel);
    m_mergeTaskgroupLayout->addWidget(m_mergeTaskgroup);
    m_generalSettingsLayout->addWidget(m_mergeTaskgroupFrame);
    m_generalSettingsLayout->addWidget(setLine(this));

    const QByteArray id(UKUI_PANEL_SETTINGS);
    if(QGSettings::isSchemaInstalled(id)) {
        m_panelSettings = new QGSettings(id);
        if (m_panelSettings->keys().contains(GROUP_ENABLE)) {
            bool groupenable = m_panelSettings->get(GROUP_ENABLE).toBool();
            if(groupenable) {
                m_mergeTaskgroup->setCurrentIndex(0);
            } else {
                m_mergeTaskgroup->setCurrentIndex(1);
            }
            connect(m_panelSettings, &QGSettings::changed, this, [=] (const QString &key) {
                if (key == GROUP_ENABLE) {
                    bool groupenable = m_panelSettings->get(GROUP_ENABLE).toBool();
                    if(groupenable) {
                        m_mergeTaskgroup->setCurrentIndex(0);
                    } else {
                        m_mergeTaskgroup->setCurrentIndex(1);
                    }
                }
            });
        }
    }
    connect(m_mergeTaskgroup, QOverload<int>::of(&QComboBox::currentIndexChanged), this, [=](int index) {
        switch (index) {
        case 0:
            m_panelSettings->set(GROUP_ENABLE, true);
            break;
        case 1:
            m_panelSettings->set(GROUP_ENABLE,false);
            break;
        default:
            m_panelSettings->set(GROUP_ENABLE, true);
            break;
        }
    });


}

void GeneralSettings::panelPosition()
{
    m_panelpositionFrame = new QFrame(this);
    setFrame_Noframe(m_panelpositionFrame);

    m_panelpositionLayout = new QHBoxLayout(m_panelpositionFrame);
    m_panelpositionLayout->setContentsMargins(16,0,16,0);

    m_panelpositionLebel = new QLabel(m_panelpositionFrame);
    m_panelpositionLebel->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    m_panelpositionLebel->setText(tr("Taskbar Position"));

    m_panelpositionCombox = new QComboBox(m_panelpositionFrame);
    m_panelpositionCombox->setObjectName(PANEL_POSITION_KEY);
    m_panelpositionCombox->setMinimumWidth(320);
    QStringList panelsize_list;
    panelsize_list<< tr("Bottom") << tr("Up") << tr("Left")<<tr("Right");
    m_panelpositionCombox->insertItem(0, panelsize_list.at(0), tr("Bottom"));
    m_panelpositionCombox->insertItem(1, panelsize_list.at(1), tr("Up"));
    m_panelpositionCombox->insertItem(2, panelsize_list.at(2), tr("Left"));
    m_panelpositionCombox->insertItem(3, panelsize_list.at(3), tr("Right"));

    m_panelpositionCombox->setCurrentIndex(m_panelSettings->get(PANEL_POSITION_KEY).toInt());

    connect(m_panelpositionCombox, QOverload<int>::of(&QComboBox::currentIndexChanged), this, [=](int index) {
            m_panelSettings->set(PANEL_POSITION_KEY,index);
    });
    connect(m_panelSettings, &QGSettings::changed, this, [=] (const QString &key) {
        if (key == PANEL_POSITION_KEY) {
            m_panelpositionCombox->setCurrentIndex(m_panelSettings->get(PANEL_POSITION_KEY).toInt());
        }
    });
    m_panelpositionCombox->setEnabled(!m_panelSettings->get(LOCK_PANEL_KEY).toBool());

    m_panelpositionLayout->addWidget(m_panelpositionLebel);
    m_panelpositionLayout->addWidget(m_panelpositionCombox);
    m_generalSettingsLayout->addWidget(m_panelpositionFrame);
    m_generalSettingsLayout->addWidget(setLine(this));
}

void GeneralSettings::panelSize()
{
    m_panelsizeFrame = new QFrame(this);
    setFrame_Noframe(m_panelsizeFrame);

    m_panelsizeLayout = new QHBoxLayout(m_panelsizeFrame);
    m_panelsizeLayout->setContentsMargins(16,0,16,0);

    m_panelsizeLebel = new QLabel(m_panelsizeFrame);
    m_panelsizeLebel->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    m_panelsizeLebel->setText(tr("Panel Size"));

    m_panelsizeCombox = new QComboBox(m_panelsizeFrame);
    m_panelsizeCombox->setObjectName(PANEL_SIZE_KEY);
    m_panelsizeCombox->setMinimumWidth(320);
    QStringList panelsize_list;
    panelsize_list<< tr("Small") << tr("Medium") << tr("Large");
    m_panelsizeCombox->insertItem(0, panelsize_list.at(0), tr("Small"));
    m_panelsizeCombox->insertItem(1, panelsize_list.at(1), tr("Medium"));
    m_panelsizeCombox->insertItem(2, panelsize_list.at(2), tr("Large"));
    setPanelSizeComboxIndex();

    connect(m_panelsizeCombox, QOverload<int>::of(&QComboBox::currentIndexChanged), this, [=](int index) {
        switch (index) {
        case 1:
            m_panelSettings->set(PANEL_SIZE_KEY, 70);
            m_panelSettings->set(ICON_SIZE_KEY, 48);
            break;
        case 2:
            m_panelSettings->set(PANEL_SIZE_KEY, 92);
            m_panelSettings->set(ICON_SIZE_KEY, 64);
            break;
        default:
            m_panelSettings->set(PANEL_SIZE_KEY, 46);
            m_panelSettings->set(ICON_SIZE_KEY, 32);
            break;
        }
    });
    connect(m_panelSettings, &QGSettings::changed, this, [=] (const QString &key) {
        if (key == PANEL_SIZE_KEY) {
            setPanelSizeComboxIndex();
        }
    });

    m_panelsizeLayout->addWidget(m_panelsizeLebel);
    m_panelsizeLayout->addWidget(m_panelsizeCombox);
    m_generalSettingsLayout->addWidget(m_panelsizeFrame);
    m_generalSettingsLayout->addWidget(setLine(this));
}

void GeneralSettings::setPanelSizeComboxIndex()
{
    int size = m_panelSettings->get(PANEL_SIZE_KEY).toInt();
    switch (size) {
    case 70:
        m_panelsizeCombox->setCurrentIndex(1);
        break;
    case 92:
        m_panelsizeCombox->setCurrentIndex(2);
        break;
    default:
        m_panelsizeCombox->setCurrentIndex(0);
        break;
    }
    m_panelsizeCombox->setEnabled(!m_panelSettings->get(LOCK_PANEL_KEY).toBool());
}

void GeneralSettings::lockPanel()
{
    m_lockPanelFrame = new QFrame(this);
    setFrame_Noframe(m_lockPanelFrame);

    m_lockPanelLayout = new QHBoxLayout(m_lockPanelFrame);
    m_lockPanelLayout->setContentsMargins(16, 0, 16, 0);

    m_lockPanelLabel = new QLabel(m_lockPanelFrame);
    m_lockPanelLabel->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    m_lockPanelLabel->setText(tr("Lock Panel"));

    m_lockPanelBtn = new KSwitchButton(m_lockPanelFrame);
    m_lockPanelBtn->setObjectName("lockpanel");
    m_lockPanelBtn->setFixedSize(48,24);

    m_lockPanelLayout->addWidget(m_lockPanelLabel);
    m_lockPanelLayout->addWidget(m_lockPanelBtn);

    m_generalSettingsLayout->addWidget(m_lockPanelFrame);

    m_lockPanelBtn->setChecked(m_panelSettings->get(LOCK_PANEL_KEY).toBool());
    connect(m_lockPanelBtn, &KSwitchButton::stateChanged, [=](bool checked) {
        m_panelSettings->set(LOCK_PANEL_KEY, checked);
    });

    connect(m_panelSettings, &QGSettings::changed, this, [=](const QString &key){
        if(key == LOCK_PANEL_KEY) {
            m_lockPanelBtn->setChecked(m_panelSettings->get(LOCK_PANEL_KEY).toBool());
            if (m_hidePanelBtn) {
                m_hidePanelBtn->setEnabled(!m_panelSettings->get(LOCK_PANEL_KEY).toBool());
            }
            if (m_panelsizeCombox) {
                m_panelsizeCombox->setEnabled(!m_panelSettings->get(LOCK_PANEL_KEY).toBool());
            }
            if (m_panelpositionCombox) {
                m_panelpositionCombox->setEnabled(!m_panelSettings->get(LOCK_PANEL_KEY).toBool());
            }
        }
    });

}

void GeneralSettings::lockPanelChanged(bool lock)
{

    QString filename = QString(QDir::homePath() + ".config/ukui/panel.conf");
    QSettings settings(filename, QSettings::IniFormat);
    settings.setIniCodec("UTF-8");
    settings.beginGroup("panel1");
    m_lockPanelBtn->setChecked(lock);
    settings.setValue("lockPanel",lock);
    settings.endGroup();
    settings.sync();
}

void GeneralSettings::hidePanel()
{
    m_hidePanelFrame = new QFrame(this);
    setFrame_Noframe(m_hidePanelFrame);

    m_hidePanelLayout = new QHBoxLayout(m_hidePanelFrame);
    m_hidePanelLayout->setContentsMargins(16, 0, 16, 0);

    m_hidePanelLabel = new QLabel(m_hidePanelFrame);
    m_hidePanelLabel->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    m_hidePanelLabel->setText(tr("Hide Panel"));

    m_hidePanelBtn = new KSwitchButton(m_hidePanelFrame);
    m_hidePanelBtn->setObjectName("hidepanel");
    m_hidePanelBtn->setFixedSize(48,24);
    m_hidePanelBtn->setEnabled(!m_panelSettings->get(LOCK_PANEL_KEY).toBool());

    m_hidePanelLayout->addWidget(m_hidePanelLabel);
    m_hidePanelLayout->addWidget(m_hidePanelBtn);

    m_generalSettingsLayout->addWidget(m_hidePanelFrame);
    m_generalSettingsLayout->addWidget(setLine(this));

    m_hidePanelBtn->setChecked(m_panelSettings->get(HIDE_PANEL_KEY).toBool());
    connect(m_hidePanelBtn, &KSwitchButton::stateChanged, [=](bool checked) {
        m_panelSettings->set(HIDE_PANEL_KEY, checked);
    });
    connect(m_panelSettings, &QGSettings::changed, this, [=](const QString &key){
        if(key == HIDE_PANEL_KEY) {
            m_hidePanelBtn->setChecked(m_panelSettings->get(HIDE_PANEL_KEY).toBool());
        }
    });

}
