/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.uima.collection.base_cpm;

/**
 * Exception to notify the CPM to disable a Cas Processor. Cas Processor can be disabled due to
 * excessive errors during processing. The presumption is that such Cas Processor is not reliable
 * and it should be removed from the processing chain.
 * 
 * 
 */
public class AbortCasProcessorException extends Exception {
  private static final long serialVersionUID = 6667835751923326076L;

  public AbortCasProcessorException(String msg) {
    super(msg);
  }
}
