// Converted from http://www.unicode.org/Public/UCD/latest/ucd/Scripts.txt by language_scripts.l
#include <reflex/unicode.h>
void reflex::Unicode::Tables::language_scripts(void)
{
  static const int ASCII[] = {
    0, 127,
    0, 0
  };
  range["ASCII"] = ASCII;
  static const int Adlam[] = {
    125184, 125259,
    125264, 125273,
    125278, 125279,
    0, 0
  };
  range["Adlam"] = Adlam;
  static const int Ahom[] = {
    71424, 71450,
    71453, 71467,
    71472, 71494,
    0, 0
  };
  range["Ahom"] = Ahom;
  static const int Anatolian_Hieroglyphs[] = {
    82944, 83526,
    0, 0
  };
  range["Anatolian_Hieroglyphs"] = Anatolian_Hieroglyphs;
  static const int Arabic[] = {
    1536, 1540,
    1542, 1547,
    1549, 1562,
    1564, 1566,
    1568, 1599,
    1601, 1610,
    1622, 1647,
    1649, 1756,
    1758, 1791,
    1872, 1919,
    2160, 2190,
    2192, 2193,
    2200, 2273,
    2275, 2303,
    64336, 64450,
    64467, 64829,
    64832, 64911,
    64914, 64967,
    64975, 64975,
    65008, 65023,
    65136, 65140,
    65142, 65276,
    69216, 69246,
    69373, 69375,
    126464, 126467,
    126469, 126495,
    126497, 126498,
    126500, 126500,
    126503, 126503,
    126505, 126514,
    126516, 126519,
    126521, 126521,
    126523, 126523,
    126530, 126530,
    126535, 126535,
    126537, 126537,
    126539, 126539,
    126541, 126543,
    126545, 126546,
    126548, 126548,
    126551, 126551,
    126553, 126553,
    126555, 126555,
    126557, 126557,
    126559, 126559,
    126561, 126562,
    126564, 126564,
    126567, 126570,
    126572, 126578,
    126580, 126583,
    126585, 126588,
    126590, 126590,
    126592, 126601,
    126603, 126619,
    126625, 126627,
    126629, 126633,
    126635, 126651,
    126704, 126705,
    0, 0
  };
  range["Arabic"] = Arabic;
  static const int Armenian[] = {
    1329, 1366,
    1369, 1418,
    1421, 1423,
    64275, 64279,
    0, 0
  };
  range["Armenian"] = Armenian;
  static const int Avestan[] = {
    68352, 68405,
    68409, 68415,
    0, 0
  };
  range["Avestan"] = Avestan;
  static const int Balinese[] = {
    6912, 6988,
    6992, 7038,
    0, 0
  };
  range["Balinese"] = Balinese;
  static const int Bamum[] = {
    42656, 42743,
    92160, 92728,
    0, 0
  };
  range["Bamum"] = Bamum;
  static const int Bassa_Vah[] = {
    92880, 92909,
    92912, 92917,
    0, 0
  };
  range["Bassa_Vah"] = Bassa_Vah;
  static const int Batak[] = {
    7104, 7155,
    7164, 7167,
    0, 0
  };
  range["Batak"] = Batak;
  static const int Bengali[] = {
    2432, 2435,
    2437, 2444,
    2447, 2448,
    2451, 2472,
    2474, 2480,
    2482, 2482,
    2486, 2489,
    2492, 2500,
    2503, 2504,
    2507, 2510,
    2519, 2519,
    2524, 2525,
    2527, 2531,
    2534, 2558,
    0, 0
  };
  range["Bengali"] = Bengali;
  static const int Bhaiksuki[] = {
    72704, 72712,
    72714, 72758,
    72760, 72773,
    72784, 72812,
    0, 0
  };
  range["Bhaiksuki"] = Bhaiksuki;
  static const int Bopomofo[] = {
    746, 747,
    12549, 12591,
    12704, 12735,
    0, 0
  };
  range["Bopomofo"] = Bopomofo;
  static const int Brahmi[] = {
    69632, 69709,
    69714, 69749,
    69759, 69759,
    0, 0
  };
  range["Brahmi"] = Brahmi;
  static const int Braille[] = {
    10240, 10495,
    0, 0
  };
  range["Braille"] = Braille;
  static const int Buginese[] = {
    6656, 6683,
    6686, 6687,
    0, 0
  };
  range["Buginese"] = Buginese;
  static const int Buhid[] = {
    5952, 5971,
    0, 0
  };
  range["Buhid"] = Buhid;
  static const int C[] = {
    0, 31,
    127, 159,
    173, 173,
    1536, 1541,
    1564, 1564,
    1757, 1757,
    1807, 1807,
    2192, 2193,
    2274, 2274,
    6158, 6158,
    8203, 8207,
    8234, 8238,
    8288, 8292,
    8294, 8303,
    65279, 65279,
    65529, 65531,
    69821, 69821,
    69837, 69837,
    78896, 78911,
    113824, 113827,
    119155, 119162,
    917505, 917505,
    917536, 917631,
    0, 0
  };
  range["C"] = C;
  static const int Canadian_Aboriginal[] = {
    5120, 5759,
    6320, 6389,
    72368, 72383,
    0, 0
  };
  range["Canadian_Aboriginal"] = Canadian_Aboriginal;
  static const int Carian[] = {
    66208, 66256,
    0, 0
  };
  range["Carian"] = Carian;
  static const int Caucasian_Albanian[] = {
    66864, 66915,
    66927, 66927,
    0, 0
  };
  range["Caucasian_Albanian"] = Caucasian_Albanian;
  static const int Cc[] = {
    0, 31,
    127, 159,
    0, 0
  };
  range["Cc"] = Cc;
  static const int Cf[] = {
    173, 173,
    1536, 1541,
    1564, 1564,
    1757, 1757,
    1807, 1807,
    2192, 2193,
    2274, 2274,
    6158, 6158,
    8203, 8207,
    8234, 8238,
    8288, 8292,
    8294, 8303,
    65279, 65279,
    65529, 65531,
    69821, 69821,
    69837, 69837,
    78896, 78911,
    113824, 113827,
    119155, 119162,
    917505, 917505,
    917536, 917631,
    0, 0
  };
  range["Cf"] = Cf;
  static const int Chakma[] = {
    69888, 69940,
    69942, 69959,
    0, 0
  };
  range["Chakma"] = Chakma;
  static const int Cham[] = {
    43520, 43574,
    43584, 43597,
    43600, 43609,
    43612, 43615,
    0, 0
  };
  range["Cham"] = Cham;
  static const int Cherokee[] = {
    5024, 5109,
    5112, 5117,
    43888, 43967,
    0, 0
  };
  range["Cherokee"] = Cherokee;
  static const int Chorasmian[] = {
    69552, 69579,
    0, 0
  };
  range["Chorasmian"] = Chorasmian;
  static const int Common[] = {
    0, 64,
    91, 96,
    123, 169,
    171, 185,
    187, 191,
    215, 215,
    247, 247,
    697, 735,
    741, 745,
    748, 767,
    884, 884,
    894, 894,
    901, 901,
    903, 903,
    1541, 1541,
    1548, 1548,
    1563, 1563,
    1567, 1567,
    1600, 1600,
    1757, 1757,
    2274, 2274,
    2404, 2405,
    3647, 3647,
    4053, 4056,
    4347, 4347,
    5867, 5869,
    5941, 5942,
    6146, 6147,
    6149, 6149,
    7379, 7379,
    7393, 7393,
    7401, 7404,
    7406, 7411,
    7413, 7415,
    7418, 7418,
    8192, 8203,
    8206, 8292,
    8294, 8304,
    8308, 8318,
    8320, 8334,
    8352, 8384,
    8448, 8485,
    8487, 8489,
    8492, 8497,
    8499, 8525,
    8527, 8543,
    8585, 8587,
    8592, 9254,
    9280, 9290,
    9312, 10239,
    10496, 11123,
    11126, 11157,
    11159, 11263,
    11776, 11869,
    12272, 12292,
    12294, 12294,
    12296, 12320,
    12336, 12343,
    12348, 12351,
    12443, 12444,
    12448, 12448,
    12539, 12540,
    12688, 12703,
    12736, 12771,
    12783, 12783,
    12832, 12895,
    12927, 13007,
    13055, 13055,
    13144, 13311,
    19904, 19967,
    42752, 42785,
    42888, 42890,
    43056, 43065,
    43310, 43310,
    43471, 43471,
    43867, 43867,
    43882, 43883,
    64830, 64831,
    65040, 65049,
    65072, 65106,
    65108, 65126,
    65128, 65131,
    65279, 65279,
    65281, 65312,
    65339, 65344,
    65371, 65381,
    65392, 65392,
    65438, 65439,
    65504, 65510,
    65512, 65518,
    65529, 65533,
    65792, 65794,
    65799, 65843,
    65847, 65855,
    65936, 65948,
    66000, 66044,
    66273, 66299,
    113824, 113827,
    118608, 118723,
    118784, 119029,
    119040, 119078,
    119081, 119142,
    119146, 119162,
    119171, 119172,
    119180, 119209,
    119214, 119274,
    119488, 119507,
    119520, 119539,
    119552, 119638,
    119648, 119672,
    119808, 119892,
    119894, 119964,
    119966, 119967,
    119970, 119970,
    119973, 119974,
    119977, 119980,
    119982, 119993,
    119995, 119995,
    119997, 120003,
    120005, 120069,
    120071, 120074,
    120077, 120084,
    120086, 120092,
    120094, 120121,
    120123, 120126,
    120128, 120132,
    120134, 120134,
    120138, 120144,
    120146, 120485,
    120488, 120779,
    120782, 120831,
    126065, 126132,
    126209, 126269,
    126976, 127019,
    127024, 127123,
    127136, 127150,
    127153, 127167,
    127169, 127183,
    127185, 127221,
    127232, 127405,
    127462, 127487,
    127489, 127490,
    127504, 127547,
    127552, 127560,
    127568, 127569,
    127584, 127589,
    127744, 128727,
    128732, 128748,
    128752, 128764,
    128768, 128886,
    128891, 128985,
    128992, 129003,
    129008, 129008,
    129024, 129035,
    129040, 129095,
    129104, 129113,
    129120, 129159,
    129168, 129197,
    129200, 129201,
    129280, 129619,
    129632, 129645,
    129648, 129660,
    129664, 129672,
    129680, 129725,
    129727, 129733,
    129742, 129755,
    129760, 129768,
    129776, 129784,
    129792, 129938,
    129940, 129994,
    130032, 130041,
    917505, 917505,
    917536, 917631,
    0, 0
  };
  range["Common"] = Common;
  static const int Coptic[] = {
    994, 1007,
    11392, 11507,
    11513, 11519,
    0, 0
  };
  range["Coptic"] = Coptic;
  static const int CsIdentifierPart[] = {
    48, 57,
    65, 90,
    95, 95,
    97, 122,
    170, 170,
    173, 173,
    181, 181,
    186, 186,
    192, 214,
    216, 246,
    248, 705,
    710, 721,
    736, 740,
    748, 748,
    750, 750,
    768, 884,
    886, 887,
    890, 893,
    895, 895,
    902, 902,
    904, 906,
    908, 908,
    910, 929,
    931, 1013,
    1015, 1153,
    1155, 1159,
    1162, 1327,
    1329, 1366,
    1369, 1369,
    1376, 1416,
    1425, 1469,
    1471, 1471,
    1473, 1474,
    1476, 1477,
    1479, 1479,
    1488, 1514,
    1519, 1522,
    1536, 1541,
    1552, 1562,
    1564, 1564,
    1568, 1641,
    1646, 1747,
    1749, 1757,
    1759, 1768,
    1770, 1788,
    1791, 1791,
    1807, 1866,
    1869, 1969,
    1984, 2037,
    2042, 2042,
    2045, 2045,
    2048, 2093,
    2112, 2139,
    2144, 2154,
    2160, 2183,
    2185, 2190,
    2192, 2193,
    2200, 2403,
    2406, 2415,
    2417, 2435,
    2437, 2444,
    2447, 2448,
    2451, 2472,
    2474, 2480,
    2482, 2482,
    2486, 2489,
    2492, 2500,
    2503, 2504,
    2507, 2510,
    2519, 2519,
    2524, 2525,
    2527, 2531,
    2534, 2545,
    2556, 2556,
    2558, 2558,
    2561, 2563,
    2565, 2570,
    2575, 2576,
    2579, 2600,
    2602, 2608,
    2610, 2611,
    2613, 2614,
    2616, 2617,
    2620, 2620,
    2622, 2626,
    2631, 2632,
    2635, 2637,
    2641, 2641,
    2649, 2652,
    2654, 2654,
    2662, 2677,
    2689, 2691,
    2693, 2701,
    2703, 2705,
    2707, 2728,
    2730, 2736,
    2738, 2739,
    2741, 2745,
    2748, 2757,
    2759, 2761,
    2763, 2765,
    2768, 2768,
    2784, 2787,
    2790, 2799,
    2809, 2815,
    2817, 2819,
    2821, 2828,
    2831, 2832,
    2835, 2856,
    2858, 2864,
    2866, 2867,
    2869, 2873,
    2876, 2884,
    2887, 2888,
    2891, 2893,
    2901, 2903,
    2908, 2909,
    2911, 2915,
    2918, 2927,
    2929, 2929,
    2946, 2947,
    2949, 2954,
    2958, 2960,
    2962, 2965,
    2969, 2970,
    2972, 2972,
    2974, 2975,
    2979, 2980,
    2984, 2986,
    2990, 3001,
    3006, 3010,
    3014, 3016,
    3018, 3021,
    3024, 3024,
    3031, 3031,
    3046, 3055,
    3072, 3084,
    3086, 3088,
    3090, 3112,
    3114, 3129,
    3132, 3140,
    3142, 3144,
    3146, 3149,
    3157, 3158,
    3160, 3162,
    3165, 3165,
    3168, 3171,
    3174, 3183,
    3200, 3203,
    3205, 3212,
    3214, 3216,
    3218, 3240,
    3242, 3251,
    3253, 3257,
    3260, 3268,
    3270, 3272,
    3274, 3277,
    3285, 3286,
    3293, 3294,
    3296, 3299,
    3302, 3311,
    3313, 3315,
    3328, 3340,
    3342, 3344,
    3346, 3396,
    3398, 3400,
    3402, 3406,
    3412, 3415,
    3423, 3427,
    3430, 3439,
    3450, 3455,
    3457, 3459,
    3461, 3478,
    3482, 3505,
    3507, 3515,
    3517, 3517,
    3520, 3526,
    3530, 3530,
    3535, 3540,
    3542, 3542,
    3544, 3551,
    3558, 3567,
    3570, 3571,
    3585, 3642,
    3648, 3662,
    3664, 3673,
    3713, 3714,
    3716, 3716,
    3718, 3722,
    3724, 3747,
    3749, 3749,
    3751, 3773,
    3776, 3780,
    3782, 3782,
    3784, 3790,
    3792, 3801,
    3804, 3807,
    3840, 3840,
    3864, 3865,
    3872, 3881,
    3893, 3893,
    3895, 3895,
    3897, 3897,
    3902, 3911,
    3913, 3948,
    3953, 3972,
    3974, 3991,
    3993, 4028,
    4038, 4038,
    4096, 4169,
    4176, 4253,
    4256, 4293,
    4295, 4295,
    4301, 4301,
    4304, 4346,
    4348, 4680,
    4682, 4685,
    4688, 4694,
    4696, 4696,
    4698, 4701,
    4704, 4744,
    4746, 4749,
    4752, 4784,
    4786, 4789,
    4792, 4798,
    4800, 4800,
    4802, 4805,
    4808, 4822,
    4824, 4880,
    4882, 4885,
    4888, 4954,
    4957, 4959,
    4992, 5007,
    5024, 5109,
    5112, 5117,
    5121, 5740,
    5743, 5759,
    5761, 5786,
    5792, 5866,
    5870, 5880,
    5888, 5909,
    5919, 5940,
    5952, 5971,
    5984, 5996,
    5998, 6000,
    6002, 6003,
    6016, 6099,
    6103, 6103,
    6108, 6109,
    6112, 6121,
    6155, 6169,
    6176, 6264,
    6272, 6314,
    6320, 6389,
    6400, 6430,
    6432, 6443,
    6448, 6459,
    6470, 6509,
    6512, 6516,
    6528, 6571,
    6576, 6601,
    6608, 6617,
    6656, 6683,
    6688, 6750,
    6752, 6780,
    6783, 6793,
    6800, 6809,
    6823, 6823,
    6832, 6845,
    6847, 6862,
    6912, 6988,
    6992, 7001,
    7019, 7027,
    7040, 7155,
    7168, 7223,
    7232, 7241,
    7245, 7293,
    7296, 7304,
    7312, 7354,
    7357, 7359,
    7376, 7378,
    7380, 7418,
    7424, 7957,
    7960, 7965,
    7968, 8005,
    8008, 8013,
    8016, 8023,
    8025, 8025,
    8027, 8027,
    8029, 8029,
    8031, 8061,
    8064, 8116,
    8118, 8124,
    8126, 8126,
    8130, 8132,
    8134, 8140,
    8144, 8147,
    8150, 8155,
    8160, 8172,
    8178, 8180,
    8182, 8188,
    8203, 8207,
    8234, 8238,
    8255, 8256,
    8276, 8276,
    8288, 8292,
    8294, 8303,
    8305, 8305,
    8319, 8319,
    8336, 8348,
    8400, 8412,
    8417, 8417,
    8421, 8432,
    8450, 8450,
    8455, 8455,
    8458, 8467,
    8469, 8469,
    8473, 8477,
    8484, 8484,
    8486, 8486,
    8488, 8488,
    8490, 8493,
    8495, 8505,
    8508, 8511,
    8517, 8521,
    8526, 8526,
    8544, 8584,
    11264, 11492,
    11499, 11507,
    11520, 11557,
    11559, 11559,
    11565, 11565,
    11568, 11623,
    11631, 11631,
    11647, 11670,
    11680, 11686,
    11688, 11694,
    11696, 11702,
    11704, 11710,
    11712, 11718,
    11720, 11726,
    11728, 11734,
    11736, 11742,
    11744, 11775,
    11823, 11823,
    12293, 12295,
    12321, 12335,
    12337, 12341,
    12344, 12348,
    12353, 12438,
    12441, 12442,
    12445, 12447,
    12449, 12538,
    12540, 12543,
    12549, 12591,
    12593, 12686,
    12704, 12735,
    12784, 12799,
    13312, 19903,
    19968, 42124,
    42192, 42237,
    42240, 42508,
    42512, 42539,
    42560, 42607,
    42612, 42621,
    42623, 42737,
    42775, 42783,
    42786, 42888,
    42891, 42954,
    42960, 42961,
    42963, 42963,
    42965, 42969,
    42994, 43047,
    43052, 43052,
    43072, 43123,
    43136, 43205,
    43216, 43225,
    43232, 43255,
    43259, 43259,
    43261, 43309,
    43312, 43347,
    43360, 43388,
    43392, 43456,
    43471, 43481,
    43488, 43518,
    43520, 43574,
    43584, 43597,
    43600, 43609,
    43616, 43638,
    43642, 43714,
    43739, 43741,
    43744, 43759,
    43762, 43766,
    43777, 43782,
    43785, 43790,
    43793, 43798,
    43808, 43814,
    43816, 43822,
    43824, 43866,
    43868, 43881,
    43888, 44010,
    44012, 44013,
    44016, 44025,
    44032, 55203,
    55216, 55238,
    55243, 55291,
    63744, 64109,
    64112, 64217,
    64256, 64262,
    64275, 64279,
    64285, 64296,
    64298, 64310,
    64312, 64316,
    64318, 64318,
    64320, 64321,
    64323, 64324,
    64326, 64433,
    64467, 64829,
    64848, 64911,
    64914, 64967,
    65008, 65019,
    65024, 65039,
    65056, 65071,
    65075, 65076,
    65101, 65103,
    65136, 65140,
    65142, 65276,
    65279, 65279,
    65296, 65305,
    65313, 65338,
    65343, 65343,
    65345, 65370,
    65382, 65470,
    65474, 65479,
    65482, 65487,
    65490, 65495,
    65498, 65500,
    65529, 65531,
    65536, 65547,
    65549, 65574,
    65576, 65594,
    65596, 65597,
    65599, 65613,
    65616, 65629,
    65664, 65786,
    65856, 65908,
    66045, 66045,
    66176, 66204,
    66208, 66256,
    66272, 66272,
    66304, 66335,
    66349, 66378,
    66384, 66426,
    66432, 66461,
    66464, 66499,
    66504, 66511,
    66513, 66517,
    66560, 66717,
    66720, 66729,
    66736, 66771,
    66776, 66811,
    66816, 66855,
    66864, 66915,
    66928, 66938,
    66940, 66954,
    66956, 66962,
    66964, 66965,
    66967, 66977,
    66979, 66993,
    66995, 67001,
    67003, 67004,
    67072, 67382,
    67392, 67413,
    67424, 67431,
    67456, 67461,
    67463, 67504,
    67506, 67514,
    67584, 67589,
    67592, 67592,
    67594, 67637,
    67639, 67640,
    67644, 67644,
    67647, 67669,
    67680, 67702,
    67712, 67742,
    67808, 67826,
    67828, 67829,
    67840, 67861,
    67872, 67897,
    67968, 68023,
    68030, 68031,
    68096, 68099,
    68101, 68102,
    68108, 68115,
    68117, 68119,
    68121, 68149,
    68152, 68154,
    68159, 68159,
    68192, 68220,
    68224, 68252,
    68288, 68295,
    68297, 68326,
    68352, 68405,
    68416, 68437,
    68448, 68466,
    68480, 68497,
    68608, 68680,
    68736, 68786,
    68800, 68850,
    68864, 68903,
    68912, 68921,
    69248, 69289,
    69291, 69292,
    69296, 69297,
    69373, 69404,
    69415, 69415,
    69424, 69456,
    69488, 69509,
    69552, 69572,
    69600, 69622,
    69632, 69702,
    69734, 69749,
    69759, 69818,
    69821, 69821,
    69826, 69826,
    69837, 69837,
    69840, 69864,
    69872, 69881,
    69888, 69940,
    69942, 69951,
    69956, 69959,
    69968, 70003,
    70006, 70006,
    70016, 70084,
    70089, 70092,
    70094, 70106,
    70108, 70108,
    70144, 70161,
    70163, 70199,
    70206, 70209,
    70272, 70278,
    70280, 70280,
    70282, 70285,
    70287, 70301,
    70303, 70312,
    70320, 70378,
    70384, 70393,
    70400, 70403,
    70405, 70412,
    70415, 70416,
    70419, 70440,
    70442, 70448,
    70450, 70451,
    70453, 70457,
    70459, 70468,
    70471, 70472,
    70475, 70477,
    70480, 70480,
    70487, 70487,
    70493, 70499,
    70502, 70508,
    70512, 70516,
    70656, 70730,
    70736, 70745,
    70750, 70753,
    70784, 70853,
    70855, 70855,
    70864, 70873,
    71040, 71093,
    71096, 71104,
    71128, 71133,
    71168, 71232,
    71236, 71236,
    71248, 71257,
    71296, 71352,
    71360, 71369,
    71424, 71450,
    71453, 71467,
    71472, 71481,
    71488, 71494,
    71680, 71738,
    71840, 71913,
    71935, 71942,
    71945, 71945,
    71948, 71955,
    71957, 71958,
    71960, 71989,
    71991, 71992,
    71995, 72003,
    72016, 72025,
    72096, 72103,
    72106, 72151,
    72154, 72161,
    72163, 72164,
    72192, 72254,
    72263, 72263,
    72272, 72345,
    72349, 72349,
    72368, 72440,
    72704, 72712,
    72714, 72758,
    72760, 72768,
    72784, 72793,
    72818, 72847,
    72850, 72871,
    72873, 72886,
    72960, 72966,
    72968, 72969,
    72971, 73014,
    73018, 73018,
    73020, 73021,
    73023, 73031,
    73040, 73049,
    73056, 73061,
    73063, 73064,
    73066, 73102,
    73104, 73105,
    73107, 73112,
    73120, 73129,
    73440, 73462,
    73472, 73488,
    73490, 73530,
    73534, 73538,
    73552, 73561,
    73648, 73648,
    73728, 74649,
    74752, 74862,
    74880, 75075,
    77712, 77808,
    77824, 78933,
    82944, 83526,
    92160, 92728,
    92736, 92766,
    92768, 92777,
    92784, 92862,
    92864, 92873,
    92880, 92909,
    92912, 92916,
    92928, 92982,
    92992, 92995,
    93008, 93017,
    93027, 93047,
    93053, 93071,
    93760, 93823,
    93952, 94026,
    94031, 94087,
    94095, 94111,
    94176, 94177,
    94179, 94180,
    94192, 94193,
    94208, 100343,
    100352, 101589,
    101632, 101640,
    110576, 110579,
    110581, 110587,
    110589, 110590,
    110592, 110882,
    110898, 110898,
    110928, 110930,
    110933, 110933,
    110948, 110951,
    110960, 111355,
    113664, 113770,
    113776, 113788,
    113792, 113800,
    113808, 113817,
    113821, 113822,
    113824, 113827,
    118528, 118573,
    118576, 118598,
    119141, 119145,
    119149, 119170,
    119173, 119179,
    119210, 119213,
    119362, 119364,
    119808, 119892,
    119894, 119964,
    119966, 119967,
    119970, 119970,
    119973, 119974,
    119977, 119980,
    119982, 119993,
    119995, 119995,
    119997, 120003,
    120005, 120069,
    120071, 120074,
    120077, 120084,
    120086, 120092,
    120094, 120121,
    120123, 120126,
    120128, 120132,
    120134, 120134,
    120138, 120144,
    120146, 120485,
    120488, 120512,
    120514, 120538,
    120540, 120570,
    120572, 120596,
    120598, 120628,
    120630, 120654,
    120656, 120686,
    120688, 120712,
    120714, 120744,
    120746, 120770,
    120772, 120779,
    120782, 120831,
    121344, 121398,
    121403, 121452,
    121461, 121461,
    121476, 121476,
    121499, 121503,
    121505, 121519,
    122624, 122654,
    122661, 122666,
    122880, 122886,
    122888, 122904,
    122907, 122913,
    122915, 122916,
    122918, 122922,
    122928, 122989,
    123023, 123023,
    123136, 123180,
    123184, 123197,
    123200, 123209,
    123214, 123214,
    123536, 123566,
    123584, 123641,
    124112, 124153,
    124896, 124902,
    124904, 124907,
    124909, 124910,
    124912, 124926,
    124928, 125124,
    125136, 125142,
    125184, 125259,
    125264, 125273,
    126464, 126467,
    126469, 126495,
    126497, 126498,
    126500, 126500,
    126503, 126503,
    126505, 126514,
    126516, 126519,
    126521, 126521,
    126523, 126523,
    126530, 126530,
    126535, 126535,
    126537, 126537,
    126539, 126539,
    126541, 126543,
    126545, 126546,
    126548, 126548,
    126551, 126551,
    126553, 126553,
    126555, 126555,
    126557, 126557,
    126559, 126559,
    126561, 126562,
    126564, 126564,
    126567, 126570,
    126572, 126578,
    126580, 126583,
    126585, 126588,
    126590, 126590,
    126592, 126601,
    126603, 126619,
    126625, 126627,
    126629, 126633,
    126635, 126651,
    130032, 130041,
    131072, 173791,
    173824, 177977,
    177984, 178205,
    178208, 183969,
    183984, 191456,
    191472, 192093,
    194560, 195101,
    196608, 201546,
    201552, 205743,
    917505, 917505,
    917536, 917631,
    917760, 917999,
    0, 0
  };
  range["CsIdentifierPart"] = CsIdentifierPart;
  static const int CsIdentifierStart[] = {
    64, 90,
    95, 95,
    97, 122,
    170, 170,
    181, 181,
    186, 186,
    192, 214,
    216, 246,
    248, 705,
    710, 721,
    736, 740,
    748, 748,
    750, 750,
    880, 884,
    886, 887,
    890, 893,
    895, 895,
    902, 902,
    904, 906,
    908, 908,
    910, 929,
    931, 1013,
    1015, 1153,
    1162, 1327,
    1329, 1366,
    1369, 1369,
    1376, 1416,
    1488, 1514,
    1519, 1522,
    1568, 1610,
    1646, 1647,
    1649, 1747,
    1749, 1749,
    1765, 1766,
    1774, 1775,
    1786, 1788,
    1791, 1791,
    1808, 1808,
    1810, 1839,
    1869, 1957,
    1969, 1969,
    1994, 2026,
    2036, 2037,
    2042, 2042,
    2048, 2069,
    2074, 2074,
    2084, 2084,
    2088, 2088,
    2112, 2136,
    2144, 2154,
    2160, 2183,
    2185, 2190,
    2208, 2249,
    2308, 2361,
    2365, 2365,
    2384, 2384,
    2392, 2401,
    2417, 2432,
    2437, 2444,
    2447, 2448,
    2451, 2472,
    2474, 2480,
    2482, 2482,
    2486, 2489,
    2493, 2493,
    2510, 2510,
    2524, 2525,
    2527, 2529,
    2544, 2545,
    2556, 2556,
    2565, 2570,
    2575, 2576,
    2579, 2600,
    2602, 2608,
    2610, 2611,
    2613, 2614,
    2616, 2617,
    2649, 2652,
    2654, 2654,
    2674, 2676,
    2693, 2701,
    2703, 2705,
    2707, 2728,
    2730, 2736,
    2738, 2739,
    2741, 2745,
    2749, 2749,
    2768, 2768,
    2784, 2785,
    2809, 2809,
    2821, 2828,
    2831, 2832,
    2835, 2856,
    2858, 2864,
    2866, 2867,
    2869, 2873,
    2877, 2877,
    2908, 2909,
    2911, 2913,
    2929, 2929,
    2947, 2947,
    2949, 2954,
    2958, 2960,
    2962, 2965,
    2969, 2970,
    2972, 2972,
    2974, 2975,
    2979, 2980,
    2984, 2986,
    2990, 3001,
    3024, 3024,
    3077, 3084,
    3086, 3088,
    3090, 3112,
    3114, 3129,
    3133, 3133,
    3160, 3162,
    3165, 3165,
    3168, 3169,
    3200, 3200,
    3205, 3212,
    3214, 3216,
    3218, 3240,
    3242, 3251,
    3253, 3257,
    3261, 3261,
    3293, 3294,
    3296, 3297,
    3313, 3314,
    3332, 3340,
    3342, 3344,
    3346, 3386,
    3389, 3389,
    3406, 3406,
    3412, 3414,
    3423, 3425,
    3450, 3455,
    3461, 3478,
    3482, 3505,
    3507, 3515,
    3517, 3517,
    3520, 3526,
    3585, 3632,
    3634, 3635,
    3648, 3654,
    3713, 3714,
    3716, 3716,
    3718, 3722,
    3724, 3747,
    3749, 3749,
    3751, 3760,
    3762, 3763,
    3773, 3773,
    3776, 3780,
    3782, 3782,
    3804, 3807,
    3840, 3840,
    3904, 3911,
    3913, 3948,
    3976, 3980,
    4096, 4138,
    4159, 4159,
    4176, 4181,
    4186, 4189,
    4193, 4193,
    4197, 4198,
    4206, 4208,
    4213, 4225,
    4238, 4238,
    4256, 4293,
    4295, 4295,
    4301, 4301,
    4304, 4346,
    4348, 4680,
    4682, 4685,
    4688, 4694,
    4696, 4696,
    4698, 4701,
    4704, 4744,
    4746, 4749,
    4752, 4784,
    4786, 4789,
    4792, 4798,
    4800, 4800,
    4802, 4805,
    4808, 4822,
    4824, 4880,
    4882, 4885,
    4888, 4954,
    4992, 5007,
    5024, 5109,
    5112, 5117,
    5121, 5740,
    5743, 5759,
    5761, 5786,
    5792, 5866,
    5870, 5880,
    5888, 5905,
    5919, 5937,
    5952, 5969,
    5984, 5996,
    5998, 6000,
    6016, 6067,
    6103, 6103,
    6108, 6108,
    6176, 6264,
    6272, 6276,
    6279, 6312,
    6314, 6314,
    6320, 6389,
    6400, 6430,
    6480, 6509,
    6512, 6516,
    6528, 6571,
    6576, 6601,
    6656, 6678,
    6688, 6740,
    6823, 6823,
    6917, 6963,
    6981, 6988,
    7043, 7072,
    7086, 7087,
    7098, 7141,
    7168, 7203,
    7245, 7247,
    7258, 7293,
    7296, 7304,
    7312, 7354,
    7357, 7359,
    7401, 7404,
    7406, 7411,
    7413, 7414,
    7418, 7418,
    7424, 7615,
    7680, 7957,
    7960, 7965,
    7968, 8005,
    8008, 8013,
    8016, 8023,
    8025, 8025,
    8027, 8027,
    8029, 8029,
    8031, 8061,
    8064, 8116,
    8118, 8124,
    8126, 8126,
    8130, 8132,
    8134, 8140,
    8144, 8147,
    8150, 8155,
    8160, 8172,
    8178, 8180,
    8182, 8188,
    8255, 8256,
    8276, 8276,
    8305, 8305,
    8319, 8319,
    8336, 8348,
    8450, 8450,
    8455, 8455,
    8458, 8467,
    8469, 8469,
    8473, 8477,
    8484, 8484,
    8486, 8486,
    8488, 8488,
    8490, 8493,
    8495, 8505,
    8508, 8511,
    8517, 8521,
    8526, 8526,
    8544, 8584,
    11264, 11492,
    11499, 11502,
    11506, 11507,
    11520, 11557,
    11559, 11559,
    11565, 11565,
    11568, 11623,
    11631, 11631,
    11648, 11670,
    11680, 11686,
    11688, 11694,
    11696, 11702,
    11704, 11710,
    11712, 11718,
    11720, 11726,
    11728, 11734,
    11736, 11742,
    11823, 11823,
    12293, 12295,
    12321, 12329,
    12337, 12341,
    12344, 12348,
    12353, 12438,
    12445, 12447,
    12449, 12538,
    12540, 12543,
    12549, 12591,
    12593, 12686,
    12704, 12735,
    12784, 12799,
    13312, 19903,
    19968, 42124,
    42192, 42237,
    42240, 42508,
    42512, 42527,
    42538, 42539,
    42560, 42606,
    42623, 42653,
    42656, 42735,
    42775, 42783,
    42786, 42888,
    42891, 42954,
    42960, 42961,
    42963, 42963,
    42965, 42969,
    42994, 43009,
    43011, 43013,
    43015, 43018,
    43020, 43042,
    43072, 43123,
    43138, 43187,
    43250, 43255,
    43259, 43259,
    43261, 43262,
    43274, 43301,
    43312, 43334,
    43360, 43388,
    43396, 43442,
    43471, 43471,
    43488, 43492,
    43494, 43503,
    43514, 43518,
    43520, 43560,
    43584, 43586,
    43588, 43595,
    43616, 43638,
    43642, 43642,
    43646, 43695,
    43697, 43697,
    43701, 43702,
    43705, 43709,
    43712, 43712,
    43714, 43714,
    43739, 43741,
    43744, 43754,
    43762, 43764,
    43777, 43782,
    43785, 43790,
    43793, 43798,
    43808, 43814,
    43816, 43822,
    43824, 43866,
    43868, 43881,
    43888, 44002,
    44032, 55203,
    55216, 55238,
    55243, 55291,
    63744, 64109,
    64112, 64217,
    64256, 64262,
    64275, 64279,
    64285, 64285,
    64287, 64296,
    64298, 64310,
    64312, 64316,
    64318, 64318,
    64320, 64321,
    64323, 64324,
    64326, 64433,
    64467, 64829,
    64848, 64911,
    64914, 64967,
    65008, 65019,
    65075, 65076,
    65101, 65103,
    65136, 65140,
    65142, 65276,
    65313, 65338,
    65343, 65343,
    65345, 65370,
    65382, 65470,
    65474, 65479,
    65482, 65487,
    65490, 65495,
    65498, 65500,
    65536, 65547,
    65549, 65574,
    65576, 65594,
    65596, 65597,
    65599, 65613,
    65616, 65629,
    65664, 65786,
    65856, 65908,
    66176, 66204,
    66208, 66256,
    66304, 66335,
    66349, 66378,
    66384, 66421,
    66432, 66461,
    66464, 66499,
    66504, 66511,
    66513, 66517,
    66560, 66717,
    66736, 66771,
    66776, 66811,
    66816, 66855,
    66864, 66915,
    66928, 66938,
    66940, 66954,
    66956, 66962,
    66964, 66965,
    66967, 66977,
    66979, 66993,
    66995, 67001,
    67003, 67004,
    67072, 67382,
    67392, 67413,
    67424, 67431,
    67456, 67461,
    67463, 67504,
    67506, 67514,
    67584, 67589,
    67592, 67592,
    67594, 67637,
    67639, 67640,
    67644, 67644,
    67647, 67669,
    67680, 67702,
    67712, 67742,
    67808, 67826,
    67828, 67829,
    67840, 67861,
    67872, 67897,
    67968, 68023,
    68030, 68031,
    68096, 68096,
    68112, 68115,
    68117, 68119,
    68121, 68149,
    68192, 68220,
    68224, 68252,
    68288, 68295,
    68297, 68324,
    68352, 68405,
    68416, 68437,
    68448, 68466,
    68480, 68497,
    68608, 68680,
    68736, 68786,
    68800, 68850,
    68864, 68899,
    69248, 69289,
    69296, 69297,
    69376, 69404,
    69415, 69415,
    69424, 69445,
    69488, 69505,
    69552, 69572,
    69600, 69622,
    69635, 69687,
    69745, 69746,
    69749, 69749,
    69763, 69807,
    69840, 69864,
    69891, 69926,
    69956, 69956,
    69959, 69959,
    69968, 70002,
    70006, 70006,
    70019, 70066,
    70081, 70084,
    70106, 70106,
    70108, 70108,
    70144, 70161,
    70163, 70187,
    70207, 70208,
    70272, 70278,
    70280, 70280,
    70282, 70285,
    70287, 70301,
    70303, 70312,
    70320, 70366,
    70405, 70412,
    70415, 70416,
    70419, 70440,
    70442, 70448,
    70450, 70451,
    70453, 70457,
    70461, 70461,
    70480, 70480,
    70493, 70497,
    70656, 70708,
    70727, 70730,
    70751, 70753,
    70784, 70831,
    70852, 70853,
    70855, 70855,
    71040, 71086,
    71128, 71131,
    71168, 71215,
    71236, 71236,
    71296, 71338,
    71352, 71352,
    71424, 71450,
    71488, 71494,
    71680, 71723,
    71840, 71903,
    71935, 71942,
    71945, 71945,
    71948, 71955,
    71957, 71958,
    71960, 71983,
    71999, 71999,
    72001, 72001,
    72096, 72103,
    72106, 72144,
    72161, 72161,
    72163, 72163,
    72192, 72192,
    72203, 72242,
    72250, 72250,
    72272, 72272,
    72284, 72329,
    72349, 72349,
    72368, 72440,
    72704, 72712,
    72714, 72750,
    72768, 72768,
    72818, 72847,
    72960, 72966,
    72968, 72969,
    72971, 73008,
    73030, 73030,
    73056, 73061,
    73063, 73064,
    73066, 73097,
    73112, 73112,
    73440, 73458,
    73474, 73474,
    73476, 73488,
    73490, 73523,
    73648, 73648,
    73728, 74649,
    74752, 74862,
    74880, 75075,
    77712, 77808,
    77824, 78895,
    78913, 78918,
    82944, 83526,
    92160, 92728,
    92736, 92766,
    92784, 92862,
    92880, 92909,
    92928, 92975,
    92992, 92995,
    93027, 93047,
    93053, 93071,
    93760, 93823,
    93952, 94026,
    94032, 94032,
    94099, 94111,
    94176, 94177,
    94179, 94179,
    94208, 100343,
    100352, 101589,
    101632, 101640,
    110576, 110579,
    110581, 110587,
    110589, 110590,
    110592, 110882,
    110898, 110898,
    110928, 110930,
    110933, 110933,
    110948, 110951,
    110960, 111355,
    113664, 113770,
    113776, 113788,
    113792, 113800,
    113808, 113817,
    119808, 119892,
    119894, 119964,
    119966, 119967,
    119970, 119970,
    119973, 119974,
    119977, 119980,
    119982, 119993,
    119995, 119995,
    119997, 120003,
    120005, 120069,
    120071, 120074,
    120077, 120084,
    120086, 120092,
    120094, 120121,
    120123, 120126,
    120128, 120132,
    120134, 120134,
    120138, 120144,
    120146, 120485,
    120488, 120512,
    120514, 120538,
    120540, 120570,
    120572, 120596,
    120598, 120628,
    120630, 120654,
    120656, 120686,
    120688, 120712,
    120714, 120744,
    120746, 120770,
    120772, 120779,
    122624, 122654,
    122661, 122666,
    122928, 122989,
    123136, 123180,
    123191, 123197,
    123214, 123214,
    123536, 123565,
    123584, 123627,
    124112, 124139,
    124896, 124902,
    124904, 124907,
    124909, 124910,
    124912, 124926,
    124928, 125124,
    125184, 125251,
    125259, 125259,
    126464, 126467,
    126469, 126495,
    126497, 126498,
    126500, 126500,
    126503, 126503,
    126505, 126514,
    126516, 126519,
    126521, 126521,
    126523, 126523,
    126530, 126530,
    126535, 126535,
    126537, 126537,
    126539, 126539,
    126541, 126543,
    126545, 126546,
    126548, 126548,
    126551, 126551,
    126553, 126553,
    126555, 126555,
    126557, 126557,
    126559, 126559,
    126561, 126562,
    126564, 126564,
    126567, 126570,
    126572, 126578,
    126580, 126583,
    126585, 126588,
    126590, 126590,
    126592, 126601,
    126603, 126619,
    126625, 126627,
    126629, 126633,
    126635, 126651,
    131072, 173791,
    173824, 177977,
    177984, 178205,
    178208, 183969,
    183984, 191456,
    191472, 192093,
    194560, 195101,
    196608, 201546,
    201552, 205743,
    0, 0
  };
  range["CsIdentifierStart"] = CsIdentifierStart;
  static const int Cuneiform[] = {
    73728, 74649,
    74752, 74862,
    74864, 74868,
    74880, 75075,
    0, 0
  };
  range["Cuneiform"] = Cuneiform;
  static const int Cypriot[] = {
    67584, 67589,
    67592, 67592,
    67594, 67637,
    67639, 67640,
    67644, 67644,
    67647, 67647,
    0, 0
  };
  range["Cypriot"] = Cypriot;
  static const int Cypro_Minoan[] = {
    77712, 77810,
    0, 0
  };
  range["Cypro_Minoan"] = Cypro_Minoan;
  static const int Cyrillic[] = {
    1024, 1156,
    1159, 1327,
    7296, 7304,
    7467, 7467,
    7544, 7544,
    11744, 11775,
    42560, 42655,
    65070, 65071,
    122928, 122989,
    123023, 123023,
    0, 0
  };
  range["Cyrillic"] = Cyrillic;
  static const int Deseret[] = {
    66560, 66639,
    0, 0
  };
  range["Deseret"] = Deseret;
  static const int Devanagari[] = {
    2304, 2384,
    2389, 2403,
    2406, 2431,
    43232, 43263,
    72448, 72457,
    0, 0
  };
  range["Devanagari"] = Devanagari;
  static const int Dives_Akuru[] = {
    71936, 71942,
    71945, 71945,
    71948, 71955,
    71957, 71958,
    71960, 71989,
    71991, 71992,
    71995, 72006,
    72016, 72025,
    0, 0
  };
  range["Dives_Akuru"] = Dives_Akuru;
  static const int Dogra[] = {
    71680, 71739,
    0, 0
  };
  range["Dogra"] = Dogra;
  static const int Duployan[] = {
    113664, 113770,
    113776, 113788,
    113792, 113800,
    113808, 113817,
    113820, 113823,
    0, 0
  };
  range["Duployan"] = Duployan;
  static const int Egyptian_Hieroglyphs[] = {
    77824, 78933,
    0, 0
  };
  range["Egyptian_Hieroglyphs"] = Egyptian_Hieroglyphs;
  static const int Elbasan[] = {
    66816, 66855,
    0, 0
  };
  range["Elbasan"] = Elbasan;
  static const int Elymaic[] = {
    69600, 69622,
    0, 0
  };
  range["Elymaic"] = Elymaic;
  static const int Ethiopic[] = {
    4608, 4680,
    4682, 4685,
    4688, 4694,
    4696, 4696,
    4698, 4701,
    4704, 4744,
    4746, 4749,
    4752, 4784,
    4786, 4789,
    4792, 4798,
    4800, 4800,
    4802, 4805,
    4808, 4822,
    4824, 4880,
    4882, 4885,
    4888, 4954,
    4957, 4988,
    4992, 5017,
    11648, 11670,
    11680, 11686,
    11688, 11694,
    11696, 11702,
    11704, 11710,
    11712, 11718,
    11720, 11726,
    11728, 11734,
    11736, 11742,
    43777, 43782,
    43785, 43790,
    43793, 43798,
    43808, 43814,
    43816, 43822,
    124896, 124902,
    124904, 124907,
    124909, 124910,
    124912, 124926,
    0, 0
  };
  range["Ethiopic"] = Ethiopic;
  static const int Georgian[] = {
    4256, 4293,
    4295, 4295,
    4301, 4301,
    4304, 4346,
    4348, 4351,
    7312, 7354,
    7357, 7359,
    11520, 11557,
    11559, 11559,
    11565, 11565,
    0, 0
  };
  range["Georgian"] = Georgian;
  static const int Glagolitic[] = {
    11264, 11359,
    122880, 122886,
    122888, 122904,
    122907, 122913,
    122915, 122916,
    122918, 122922,
    0, 0
  };
  range["Glagolitic"] = Glagolitic;
  static const int Gothic[] = {
    66352, 66378,
    0, 0
  };
  range["Gothic"] = Gothic;
  static const int Grantha[] = {
    70400, 70403,
    70405, 70412,
    70415, 70416,
    70419, 70440,
    70442, 70448,
    70450, 70451,
    70453, 70457,
    70460, 70468,
    70471, 70472,
    70475, 70477,
    70480, 70480,
    70487, 70487,
    70493, 70499,
    70502, 70508,
    70512, 70516,
    0, 0
  };
  range["Grantha"] = Grantha;
  static const int Greek[] = {
    880, 883,
    885, 887,
    890, 893,
    895, 895,
    900, 900,
    902, 902,
    904, 906,
    908, 908,
    910, 929,
    931, 993,
    1008, 1023,
    7462, 7466,
    7517, 7521,
    7526, 7530,
    7615, 7615,
    7936, 7957,
    7960, 7965,
    7968, 8005,
    8008, 8013,
    8016, 8023,
    8025, 8025,
    8027, 8027,
    8029, 8029,
    8031, 8061,
    8064, 8116,
    8118, 8132,
    8134, 8147,
    8150, 8155,
    8157, 8175,
    8178, 8180,
    8182, 8190,
    8486, 8486,
    43877, 43877,
    65856, 65934,
    65952, 65952,
    119296, 119365,
    0, 0
  };
  range["Greek"] = Greek;
  static const int Gujarati[] = {
    2689, 2691,
    2693, 2701,
    2703, 2705,
    2707, 2728,
    2730, 2736,
    2738, 2739,
    2741, 2745,
    2748, 2757,
    2759, 2761,
    2763, 2765,
    2768, 2768,
    2784, 2787,
    2790, 2801,
    2809, 2815,
    0, 0
  };
  range["Gujarati"] = Gujarati;
  static const int Gunjala_Gondi[] = {
    73056, 73061,
    73063, 73064,
    73066, 73102,
    73104, 73105,
    73107, 73112,
    73120, 73129,
    0, 0
  };
  range["Gunjala_Gondi"] = Gunjala_Gondi;
  static const int Gurmukhi[] = {
    2561, 2563,
    2565, 2570,
    2575, 2576,
    2579, 2600,
    2602, 2608,
    2610, 2611,
    2613, 2614,
    2616, 2617,
    2620, 2620,
    2622, 2626,
    2631, 2632,
    2635, 2637,
    2641, 2641,
    2649, 2652,
    2654, 2654,
    2662, 2678,
    0, 0
  };
  range["Gurmukhi"] = Gurmukhi;
  static const int Han[] = {
    11904, 11929,
    11931, 12019,
    12032, 12245,
    12293, 12293,
    12295, 12295,
    12321, 12329,
    12344, 12347,
    13312, 19903,
    19968, 40959,
    63744, 64109,
    64112, 64217,
    94178, 94179,
    94192, 94193,
    131072, 173791,
    173824, 177977,
    177984, 178205,
    178208, 183969,
    183984, 191456,
    191472, 192093,
    194560, 195101,
    196608, 201546,
    201552, 205743,
    0, 0
  };
  range["Han"] = Han;
  static const int Hangul[] = {
    4352, 4607,
    12334, 12335,
    12593, 12686,
    12800, 12830,
    12896, 12926,
    43360, 43388,
    44032, 55203,
    55216, 55238,
    55243, 55291,
    65440, 65470,
    65474, 65479,
    65482, 65487,
    65490, 65495,
    65498, 65500,
    0, 0
  };
  range["Hangul"] = Hangul;
  static const int Hanifi_Rohingya[] = {
    68864, 68903,
    68912, 68921,
    0, 0
  };
  range["Hanifi_Rohingya"] = Hanifi_Rohingya;
  static const int Hanunoo[] = {
    5920, 5940,
    0, 0
  };
  range["Hanunoo"] = Hanunoo;
  static const int Hatran[] = {
    67808, 67826,
    67828, 67829,
    67835, 67839,
    0, 0
  };
  range["Hatran"] = Hatran;
  static const int Hebrew[] = {
    1425, 1479,
    1488, 1514,
    1519, 1524,
    64285, 64310,
    64312, 64316,
    64318, 64318,
    64320, 64321,
    64323, 64324,
    64326, 64335,
    0, 0
  };
  range["Hebrew"] = Hebrew;
  static const int Hiragana[] = {
    12353, 12438,
    12445, 12447,
    110593, 110879,
    110898, 110898,
    110928, 110930,
    127488, 127488,
    0, 0
  };
  range["Hiragana"] = Hiragana;
  static const int IdentifierIgnorable[] = {
    0, 8,
    14, 27,
    127, 159,
    0, 0
  };
  range["IdentifierIgnorable"] = IdentifierIgnorable;
  static const int Imperial_Aramaic[] = {
    67648, 67669,
    67671, 67679,
    0, 0
  };
  range["Imperial_Aramaic"] = Imperial_Aramaic;
  static const int Inherited[] = {
    768, 879,
    1157, 1158,
    1611, 1621,
    1648, 1648,
    2385, 2388,
    6832, 6862,
    7376, 7378,
    7380, 7392,
    7394, 7400,
    7405, 7405,
    7412, 7412,
    7416, 7417,
    7616, 7679,
    8204, 8205,
    8400, 8432,
    12330, 12333,
    12441, 12442,
    65024, 65039,
    65056, 65069,
    66045, 66045,
    66272, 66272,
    70459, 70459,
    118528, 118573,
    118576, 118598,
    119143, 119145,
    119163, 119170,
    119173, 119179,
    119210, 119213,
    917760, 917999,
    0, 0
  };
  range["Inherited"] = Inherited;
  static const int Inscriptional_Pahlavi[] = {
    68448, 68466,
    68472, 68479,
    0, 0
  };
  range["Inscriptional_Pahlavi"] = Inscriptional_Pahlavi;
  static const int Inscriptional_Parthian[] = {
    68416, 68437,
    68440, 68447,
    0, 0
  };
  range["Inscriptional_Parthian"] = Inscriptional_Parthian;
  static const int JavaIdentifierPart[] = {
    0, 8,
    14, 27,
    36, 36,
    48, 57,
    65, 90,
    95, 95,
    97, 122,
    127, 159,
    162, 165,
    170, 170,
    173, 173,
    181, 181,
    186, 186,
    192, 214,
    216, 246,
    248, 705,
    710, 721,
    736, 740,
    748, 748,
    750, 750,
    768, 884,
    886, 887,
    890, 893,
    895, 895,
    902, 902,
    904, 906,
    908, 908,
    910, 929,
    931, 1013,
    1015, 1153,
    1155, 1159,
    1162, 1327,
    1329, 1366,
    1369, 1369,
    1376, 1416,
    1423, 1423,
    1425, 1469,
    1471, 1471,
    1473, 1474,
    1476, 1477,
    1479, 1479,
    1488, 1514,
    1519, 1522,
    1536, 1541,
    1547, 1547,
    1552, 1562,
    1564, 1564,
    1568, 1641,
    1646, 1747,
    1749, 1757,
    1759, 1768,
    1770, 1788,
    1791, 1791,
    1807, 1866,
    1869, 1969,
    1984, 2037,
    2042, 2042,
    2045, 2093,
    2112, 2139,
    2144, 2154,
    2160, 2183,
    2185, 2190,
    2192, 2193,
    2200, 2403,
    2406, 2415,
    2417, 2435,
    2437, 2444,
    2447, 2448,
    2451, 2472,
    2474, 2480,
    2482, 2482,
    2486, 2489,
    2492, 2500,
    2503, 2504,
    2507, 2510,
    2519, 2519,
    2524, 2525,
    2527, 2531,
    2534, 2547,
    2555, 2556,
    2558, 2558,
    2561, 2563,
    2565, 2570,
    2575, 2576,
    2579, 2600,
    2602, 2608,
    2610, 2611,
    2613, 2614,
    2616, 2617,
    2620, 2620,
    2622, 2626,
    2631, 2632,
    2635, 2637,
    2641, 2641,
    2649, 2652,
    2654, 2654,
    2662, 2677,
    2689, 2691,
    2693, 2701,
    2703, 2705,
    2707, 2728,
    2730, 2736,
    2738, 2739,
    2741, 2745,
    2748, 2757,
    2759, 2761,
    2763, 2765,
    2768, 2768,
    2784, 2787,
    2790, 2799,
    2801, 2801,
    2809, 2815,
    2817, 2819,
    2821, 2828,
    2831, 2832,
    2835, 2856,
    2858, 2864,
    2866, 2867,
    2869, 2873,
    2876, 2884,
    2887, 2888,
    2891, 2893,
    2901, 2903,
    2908, 2909,
    2911, 2915,
    2918, 2927,
    2929, 2929,
    2946, 2947,
    2949, 2954,
    2958, 2960,
    2962, 2965,
    2969, 2970,
    2972, 2972,
    2974, 2975,
    2979, 2980,
    2984, 2986,
    2990, 3001,
    3006, 3010,
    3014, 3016,
    3018, 3021,
    3024, 3024,
    3031, 3031,
    3046, 3055,
    3065, 3065,
    3072, 3084,
    3086, 3088,
    3090, 3112,
    3114, 3129,
    3132, 3140,
    3142, 3144,
    3146, 3149,
    3157, 3158,
    3160, 3162,
    3165, 3165,
    3168, 3171,
    3174, 3183,
    3200, 3203,
    3205, 3212,
    3214, 3216,
    3218, 3240,
    3242, 3251,
    3253, 3257,
    3260, 3268,
    3270, 3272,
    3274, 3277,
    3285, 3286,
    3293, 3294,
    3296, 3299,
    3302, 3311,
    3313, 3315,
    3328, 3340,
    3342, 3344,
    3346, 3396,
    3398, 3400,
    3402, 3406,
    3412, 3415,
    3423, 3427,
    3430, 3439,
    3450, 3455,
    3457, 3459,
    3461, 3478,
    3482, 3505,
    3507, 3515,
    3517, 3517,
    3520, 3526,
    3530, 3530,
    3535, 3540,
    3542, 3542,
    3544, 3551,
    3558, 3567,
    3570, 3571,
    3585, 3642,
    3647, 3662,
    3664, 3673,
    3713, 3714,
    3716, 3716,
    3718, 3722,
    3724, 3747,
    3749, 3749,
    3751, 3773,
    3776, 3780,
    3782, 3782,
    3784, 3790,
    3792, 3801,
    3804, 3807,
    3840, 3840,
    3864, 3865,
    3872, 3881,
    3893, 3893,
    3895, 3895,
    3897, 3897,
    3902, 3911,
    3913, 3948,
    3953, 3972,
    3974, 3991,
    3993, 4028,
    4038, 4038,
    4096, 4169,
    4176, 4253,
    4256, 4293,
    4295, 4295,
    4301, 4301,
    4304, 4346,
    4348, 4680,
    4682, 4685,
    4688, 4694,
    4696, 4696,
    4698, 4701,
    4704, 4744,
    4746, 4749,
    4752, 4784,
    4786, 4789,
    4792, 4798,
    4800, 4800,
    4802, 4805,
    4808, 4822,
    4824, 4880,
    4882, 4885,
    4888, 4954,
    4957, 4959,
    4992, 5007,
    5024, 5109,
    5112, 5117,
    5121, 5740,
    5743, 5759,
    5761, 5786,
    5792, 5866,
    5870, 5880,
    5888, 5909,
    5919, 5940,
    5952, 5971,
    5984, 5996,
    5998, 6000,
    6002, 6003,
    6016, 6099,
    6103, 6103,
    6107, 6109,
    6112, 6121,
    6155, 6169,
    6176, 6264,
    6272, 6314,
    6320, 6389,
    6400, 6430,
    6432, 6443,
    6448, 6459,
    6470, 6509,
    6512, 6516,
    6528, 6571,
    6576, 6601,
    6608, 6617,
    6656, 6683,
    6688, 6750,
    6752, 6780,
    6783, 6793,
    6800, 6809,
    6823, 6823,
    6832, 6845,
    6847, 6862,
    6912, 6988,
    6992, 7001,
    7019, 7027,
    7040, 7155,
    7168, 7223,
    7232, 7241,
    7245, 7293,
    7296, 7304,
    7312, 7354,
    7357, 7359,
    7376, 7378,
    7380, 7418,
    7424, 7957,
    7960, 7965,
    7968, 8005,
    8008, 8013,
    8016, 8023,
    8025, 8025,
    8027, 8027,
    8029, 8029,
    8031, 8061,
    8064, 8116,
    8118, 8124,
    8126, 8126,
    8130, 8132,
    8134, 8140,
    8144, 8147,
    8150, 8155,
    8160, 8172,
    8178, 8180,
    8182, 8188,
    8203, 8207,
    8234, 8238,
    8255, 8256,
    8276, 8276,
    8288, 8292,
    8294, 8303,
    8305, 8305,
    8319, 8319,
    8336, 8348,
    8352, 8384,
    8400, 8412,
    8417, 8417,
    8421, 8432,
    8450, 8450,
    8455, 8455,
    8458, 8467,
    8469, 8469,
    8473, 8477,
    8484, 8484,
    8486, 8486,
    8488, 8488,
    8490, 8493,
    8495, 8505,
    8508, 8511,
    8517, 8521,
    8526, 8526,
    8544, 8584,
    11264, 11492,
    11499, 11507,
    11520, 11557,
    11559, 11559,
    11565, 11565,
    11568, 11623,
    11631, 11631,
    11647, 11670,
    11680, 11686,
    11688, 11694,
    11696, 11702,
    11704, 11710,
    11712, 11718,
    11720, 11726,
    11728, 11734,
    11736, 11742,
    11744, 11775,
    11823, 11823,
    12293, 12295,
    12321, 12335,
    12337, 12341,
    12344, 12348,
    12353, 12438,
    12441, 12442,
    12445, 12447,
    12449, 12538,
    12540, 12543,
    12549, 12591,
    12593, 12686,
    12704, 12735,
    12784, 12799,
    13312, 19903,
    19968, 42124,
    42192, 42237,
    42240, 42508,
    42512, 42539,
    42560, 42607,
    42612, 42621,
    42623, 42737,
    42775, 42783,
    42786, 42888,
    42891, 42954,
    42960, 42961,
    42963, 42963,
    42965, 42969,
    42994, 43047,
    43052, 43052,
    43064, 43064,
    43072, 43123,
    43136, 43205,
    43216, 43225,
    43232, 43255,
    43259, 43259,
    43261, 43309,
    43312, 43347,
    43360, 43388,
    43392, 43456,
    43471, 43481,
    43488, 43518,
    43520, 43574,
    43584, 43597,
    43600, 43609,
    43616, 43638,
    43642, 43714,
    43739, 43741,
    43744, 43759,
    43762, 43766,
    43777, 43782,
    43785, 43790,
    43793, 43798,
    43808, 43814,
    43816, 43822,
    43824, 43866,
    43868, 43881,
    43888, 44010,
    44012, 44013,
    44016, 44025,
    44032, 55203,
    55216, 55238,
    55243, 55291,
    63744, 64109,
    64112, 64217,
    64256, 64262,
    64275, 64279,
    64285, 64296,
    64298, 64310,
    64312, 64316,
    64318, 64318,
    64320, 64321,
    64323, 64324,
    64326, 64433,
    64467, 64829,
    64848, 64911,
    64914, 64967,
    65008, 65020,
    65024, 65039,
    65056, 65071,
    65075, 65076,
    65101, 65103,
    65129, 65129,
    65136, 65140,
    65142, 65276,
    65279, 65279,
    65284, 65284,
    65296, 65305,
    65313, 65338,
    65343, 65343,
    65345, 65370,
    65382, 65470,
    65474, 65479,
    65482, 65487,
    65490, 65495,
    65498, 65500,
    65504, 65505,
    65509, 65510,
    65529, 65531,
    65536, 65547,
    65549, 65574,
    65576, 65594,
    65596, 65597,
    65599, 65613,
    65616, 65629,
    65664, 65786,
    65856, 65908,
    66045, 66045,
    66176, 66204,
    66208, 66256,
    66272, 66272,
    66304, 66335,
    66349, 66378,
    66384, 66426,
    66432, 66461,
    66464, 66499,
    66504, 66511,
    66513, 66517,
    66560, 66717,
    66720, 66729,
    66736, 66771,
    66776, 66811,
    66816, 66855,
    66864, 66915,
    66928, 66938,
    66940, 66954,
    66956, 66962,
    66964, 66965,
    66967, 66977,
    66979, 66993,
    66995, 67001,
    67003, 67004,
    67072, 67382,
    67392, 67413,
    67424, 67431,
    67456, 67461,
    67463, 67504,
    67506, 67514,
    67584, 67589,
    67592, 67592,
    67594, 67637,
    67639, 67640,
    67644, 67644,
    67647, 67669,
    67680, 67702,
    67712, 67742,
    67808, 67826,
    67828, 67829,
    67840, 67861,
    67872, 67897,
    67968, 68023,
    68030, 68031,
    68096, 68099,
    68101, 68102,
    68108, 68115,
    68117, 68119,
    68121, 68149,
    68152, 68154,
    68159, 68159,
    68192, 68220,
    68224, 68252,
    68288, 68295,
    68297, 68326,
    68352, 68405,
    68416, 68437,
    68448, 68466,
    68480, 68497,
    68608, 68680,
    68736, 68786,
    68800, 68850,
    68864, 68903,
    68912, 68921,
    69248, 69289,
    69291, 69292,
    69296, 69297,
    69373, 69404,
    69415, 69415,
    69424, 69456,
    69488, 69509,
    69552, 69572,
    69600, 69622,
    69632, 69702,
    69734, 69749,
    69759, 69818,
    69821, 69821,
    69826, 69826,
    69837, 69837,
    69840, 69864,
    69872, 69881,
    69888, 69940,
    69942, 69951,
    69956, 69959,
    69968, 70003,
    70006, 70006,
    70016, 70084,
    70089, 70092,
    70094, 70106,
    70108, 70108,
    70144, 70161,
    70163, 70199,
    70206, 70209,
    70272, 70278,
    70280, 70280,
    70282, 70285,
    70287, 70301,
    70303, 70312,
    70320, 70378,
    70384, 70393,
    70400, 70403,
    70405, 70412,
    70415, 70416,
    70419, 70440,
    70442, 70448,
    70450, 70451,
    70453, 70457,
    70459, 70468,
    70471, 70472,
    70475, 70477,
    70480, 70480,
    70487, 70487,
    70493, 70499,
    70502, 70508,
    70512, 70516,
    70656, 70730,
    70736, 70745,
    70750, 70753,
    70784, 70853,
    70855, 70855,
    70864, 70873,
    71040, 71093,
    71096, 71104,
    71128, 71133,
    71168, 71232,
    71236, 71236,
    71248, 71257,
    71296, 71352,
    71360, 71369,
    71424, 71450,
    71453, 71467,
    71472, 71481,
    71488, 71494,
    71680, 71738,
    71840, 71913,
    71935, 71942,
    71945, 71945,
    71948, 71955,
    71957, 71958,
    71960, 71989,
    71991, 71992,
    71995, 72003,
    72016, 72025,
    72096, 72103,
    72106, 72151,
    72154, 72161,
    72163, 72164,
    72192, 72254,
    72263, 72263,
    72272, 72345,
    72349, 72349,
    72368, 72440,
    72704, 72712,
    72714, 72758,
    72760, 72768,
    72784, 72793,
    72818, 72847,
    72850, 72871,
    72873, 72886,
    72960, 72966,
    72968, 72969,
    72971, 73014,
    73018, 73018,
    73020, 73021,
    73023, 73031,
    73040, 73049,
    73056, 73061,
    73063, 73064,
    73066, 73102,
    73104, 73105,
    73107, 73112,
    73120, 73129,
    73440, 73462,
    73472, 73488,
    73490, 73530,
    73534, 73538,
    73552, 73561,
    73648, 73648,
    73693, 73696,
    73728, 74649,
    74752, 74862,
    74880, 75075,
    77712, 77808,
    77824, 78933,
    82944, 83526,
    92160, 92728,
    92736, 92766,
    92768, 92777,
    92784, 92862,
    92864, 92873,
    92880, 92909,
    92912, 92916,
    92928, 92982,
    92992, 92995,
    93008, 93017,
    93027, 93047,
    93053, 93071,
    93760, 93823,
    93952, 94026,
    94031, 94087,
    94095, 94111,
    94176, 94177,
    94179, 94180,
    94192, 94193,
    94208, 100343,
    100352, 101589,
    101632, 101640,
    110576, 110579,
    110581, 110587,
    110589, 110590,
    110592, 110882,
    110898, 110898,
    110928, 110930,
    110933, 110933,
    110948, 110951,
    110960, 111355,
    113664, 113770,
    113776, 113788,
    113792, 113800,
    113808, 113817,
    113821, 113822,
    113824, 113827,
    118528, 118573,
    118576, 118598,
    119141, 119145,
    119149, 119170,
    119173, 119179,
    119210, 119213,
    119362, 119364,
    119808, 119892,
    119894, 119964,
    119966, 119967,
    119970, 119970,
    119973, 119974,
    119977, 119980,
    119982, 119993,
    119995, 119995,
    119997, 120003,
    120005, 120069,
    120071, 120074,
    120077, 120084,
    120086, 120092,
    120094, 120121,
    120123, 120126,
    120128, 120132,
    120134, 120134,
    120138, 120144,
    120146, 120485,
    120488, 120512,
    120514, 120538,
    120540, 120570,
    120572, 120596,
    120598, 120628,
    120630, 120654,
    120656, 120686,
    120688, 120712,
    120714, 120744,
    120746, 120770,
    120772, 120779,
    120782, 120831,
    121344, 121398,
    121403, 121452,
    121461, 121461,
    121476, 121476,
    121499, 121503,
    121505, 121519,
    122624, 122654,
    122661, 122666,
    122880, 122886,
    122888, 122904,
    122907, 122913,
    122915, 122916,
    122918, 122922,
    122928, 122989,
    123023, 123023,
    123136, 123180,
    123184, 123197,
    123200, 123209,
    123214, 123214,
    123536, 123566,
    123584, 123641,
    123647, 123647,
    124112, 124153,
    124896, 124902,
    124904, 124907,
    124909, 124910,
    124912, 124926,
    124928, 125124,
    125136, 125142,
    125184, 125259,
    125264, 125273,
    126128, 126128,
    126464, 126467,
    126469, 126495,
    126497, 126498,
    126500, 126500,
    126503, 126503,
    126505, 126514,
    126516, 126519,
    126521, 126521,
    126523, 126523,
    126530, 126530,
    126535, 126535,
    126537, 126537,
    126539, 126539,
    126541, 126543,
    126545, 126546,
    126548, 126548,
    126551, 126551,
    126553, 126553,
    126555, 126555,
    126557, 126557,
    126559, 126559,
    126561, 126562,
    126564, 126564,
    126567, 126570,
    126572, 126578,
    126580, 126583,
    126585, 126588,
    126590, 126590,
    126592, 126601,
    126603, 126619,
    126625, 126627,
    126629, 126633,
    126635, 126651,
    130032, 130041,
    131072, 173791,
    173824, 177977,
    177984, 178205,
    178208, 183969,
    183984, 191456,
    191472, 192093,
    194560, 195101,
    196608, 201546,
    201552, 205743,
    917505, 917505,
    917536, 917631,
    917760, 917999,
    0, 0
  };
  range["JavaIdentifierPart"] = JavaIdentifierPart;
  static const int JavaIdentifierStart[] = {
    36, 36,
    65, 90,
    95, 95,
    97, 122,
    162, 165,
    170, 170,
    181, 181,
    186, 186,
    192, 214,
    216, 246,
    248, 705,
    710, 721,
    736, 740,
    748, 748,
    750, 750,
    880, 884,
    886, 887,
    890, 893,
    895, 895,
    902, 902,
    904, 906,
    908, 908,
    910, 929,
    931, 1013,
    1015, 1153,
    1162, 1327,
    1329, 1366,
    1369, 1369,
    1376, 1416,
    1423, 1423,
    1488, 1514,
    1519, 1522,
    1547, 1547,
    1568, 1610,
    1646, 1647,
    1649, 1747,
    1749, 1749,
    1765, 1766,
    1774, 1775,
    1786, 1788,
    1791, 1791,
    1808, 1808,
    1810, 1839,
    1869, 1957,
    1969, 1969,
    1994, 2026,
    2036, 2037,
    2042, 2042,
    2046, 2069,
    2074, 2074,
    2084, 2084,
    2088, 2088,
    2112, 2136,
    2144, 2154,
    2160, 2183,
    2185, 2190,
    2208, 2249,
    2308, 2361,
    2365, 2365,
    2384, 2384,
    2392, 2401,
    2417, 2432,
    2437, 2444,
    2447, 2448,
    2451, 2472,
    2474, 2480,
    2482, 2482,
    2486, 2489,
    2493, 2493,
    2510, 2510,
    2524, 2525,
    2527, 2529,
    2544, 2547,
    2555, 2556,
    2565, 2570,
    2575, 2576,
    2579, 2600,
    2602, 2608,
    2610, 2611,
    2613, 2614,
    2616, 2617,
    2649, 2652,
    2654, 2654,
    2674, 2676,
    2693, 2701,
    2703, 2705,
    2707, 2728,
    2730, 2736,
    2738, 2739,
    2741, 2745,
    2749, 2749,
    2768, 2768,
    2784, 2785,
    2801, 2801,
    2809, 2809,
    2821, 2828,
    2831, 2832,
    2835, 2856,
    2858, 2864,
    2866, 2867,
    2869, 2873,
    2877, 2877,
    2908, 2909,
    2911, 2913,
    2929, 2929,
    2947, 2947,
    2949, 2954,
    2958, 2960,
    2962, 2965,
    2969, 2970,
    2972, 2972,
    2974, 2975,
    2979, 2980,
    2984, 2986,
    2990, 3001,
    3024, 3024,
    3065, 3065,
    3077, 3084,
    3086, 3088,
    3090, 3112,
    3114, 3129,
    3133, 3133,
    3160, 3162,
    3165, 3165,
    3168, 3169,
    3200, 3200,
    3205, 3212,
    3214, 3216,
    3218, 3240,
    3242, 3251,
    3253, 3257,
    3261, 3261,
    3293, 3294,
    3296, 3297,
    3313, 3314,
    3332, 3340,
    3342, 3344,
    3346, 3386,
    3389, 3389,
    3406, 3406,
    3412, 3414,
    3423, 3425,
    3450, 3455,
    3461, 3478,
    3482, 3505,
    3507, 3515,
    3517, 3517,
    3520, 3526,
    3585, 3632,
    3634, 3635,
    3647, 3654,
    3713, 3714,
    3716, 3716,
    3718, 3722,
    3724, 3747,
    3749, 3749,
    3751, 3760,
    3762, 3763,
    3773, 3773,
    3776, 3780,
    3782, 3782,
    3804, 3807,
    3840, 3840,
    3904, 3911,
    3913, 3948,
    3976, 3980,
    4096, 4138,
    4159, 4159,
    4176, 4181,
    4186, 4189,
    4193, 4193,
    4197, 4198,
    4206, 4208,
    4213, 4225,
    4238, 4238,
    4256, 4293,
    4295, 4295,
    4301, 4301,
    4304, 4346,
    4348, 4680,
    4682, 4685,
    4688, 4694,
    4696, 4696,
    4698, 4701,
    4704, 4744,
    4746, 4749,
    4752, 4784,
    4786, 4789,
    4792, 4798,
    4800, 4800,
    4802, 4805,
    4808, 4822,
    4824, 4880,
    4882, 4885,
    4888, 4954,
    4992, 5007,
    5024, 5109,
    5112, 5117,
    5121, 5740,
    5743, 5759,
    5761, 5786,
    5792, 5866,
    5870, 5880,
    5888, 5905,
    5919, 5937,
    5952, 5969,
    5984, 5996,
    5998, 6000,
    6016, 6067,
    6103, 6103,
    6107, 6108,
    6176, 6264,
    6272, 6276,
    6279, 6312,
    6314, 6314,
    6320, 6389,
    6400, 6430,
    6480, 6509,
    6512, 6516,
    6528, 6571,
    6576, 6601,
    6656, 6678,
    6688, 6740,
    6823, 6823,
    6917, 6963,
    6981, 6988,
    7043, 7072,
    7086, 7087,
    7098, 7141,
    7168, 7203,
    7245, 7247,
    7258, 7293,
    7296, 7304,
    7312, 7354,
    7357, 7359,
    7401, 7404,
    7406, 7411,
    7413, 7414,
    7418, 7418,
    7424, 7615,
    7680, 7957,
    7960, 7965,
    7968, 8005,
    8008, 8013,
    8016, 8023,
    8025, 8025,
    8027, 8027,
    8029, 8029,
    8031, 8061,
    8064, 8116,
    8118, 8124,
    8126, 8126,
    8130, 8132,
    8134, 8140,
    8144, 8147,
    8150, 8155,
    8160, 8172,
    8178, 8180,
    8182, 8188,
    8255, 8256,
    8276, 8276,
    8305, 8305,
    8319, 8319,
    8336, 8348,
    8352, 8384,
    8450, 8450,
    8455, 8455,
    8458, 8467,
    8469, 8469,
    8473, 8477,
    8484, 8484,
    8486, 8486,
    8488, 8488,
    8490, 8493,
    8495, 8505,
    8508, 8511,
    8517, 8521,
    8526, 8526,
    8544, 8584,
    11264, 11492,
    11499, 11502,
    11506, 11507,
    11520, 11557,
    11559, 11559,
    11565, 11565,
    11568, 11623,
    11631, 11631,
    11648, 11670,
    11680, 11686,
    11688, 11694,
    11696, 11702,
    11704, 11710,
    11712, 11718,
    11720, 11726,
    11728, 11734,
    11736, 11742,
    11823, 11823,
    12293, 12295,
    12321, 12329,
    12337, 12341,
    12344, 12348,
    12353, 12438,
    12445, 12447,
    12449, 12538,
    12540, 12543,
    12549, 12591,
    12593, 12686,
    12704, 12735,
    12784, 12799,
    13312, 19903,
    19968, 42124,
    42192, 42237,
    42240, 42508,
    42512, 42527,
    42538, 42539,
    42560, 42606,
    42623, 42653,
    42656, 42735,
    42775, 42783,
    42786, 42888,
    42891, 42954,
    42960, 42961,
    42963, 42963,
    42965, 42969,
    42994, 43009,
    43011, 43013,
    43015, 43018,
    43020, 43042,
    43064, 43064,
    43072, 43123,
    43138, 43187,
    43250, 43255,
    43259, 43259,
    43261, 43262,
    43274, 43301,
    43312, 43334,
    43360, 43388,
    43396, 43442,
    43471, 43471,
    43488, 43492,
    43494, 43503,
    43514, 43518,
    43520, 43560,
    43584, 43586,
    43588, 43595,
    43616, 43638,
    43642, 43642,
    43646, 43695,
    43697, 43697,
    43701, 43702,
    43705, 43709,
    43712, 43712,
    43714, 43714,
    43739, 43741,
    43744, 43754,
    43762, 43764,
    43777, 43782,
    43785, 43790,
    43793, 43798,
    43808, 43814,
    43816, 43822,
    43824, 43866,
    43868, 43881,
    43888, 44002,
    44032, 55203,
    55216, 55238,
    55243, 55291,
    63744, 64109,
    64112, 64217,
    64256, 64262,
    64275, 64279,
    64285, 64285,
    64287, 64296,
    64298, 64310,
    64312, 64316,
    64318, 64318,
    64320, 64321,
    64323, 64324,
    64326, 64433,
    64467, 64829,
    64848, 64911,
    64914, 64967,
    65008, 65020,
    65075, 65076,
    65101, 65103,
    65129, 65129,
    65136, 65140,
    65142, 65276,
    65284, 65284,
    65313, 65338,
    65343, 65343,
    65345, 65370,
    65382, 65470,
    65474, 65479,
    65482, 65487,
    65490, 65495,
    65498, 65500,
    65504, 65505,
    65509, 65510,
    65536, 65547,
    65549, 65574,
    65576, 65594,
    65596, 65597,
    65599, 65613,
    65616, 65629,
    65664, 65786,
    65856, 65908,
    66176, 66204,
    66208, 66256,
    66304, 66335,
    66349, 66378,
    66384, 66421,
    66432, 66461,
    66464, 66499,
    66504, 66511,
    66513, 66517,
    66560, 66717,
    66736, 66771,
    66776, 66811,
    66816, 66855,
    66864, 66915,
    66928, 66938,
    66940, 66954,
    66956, 66962,
    66964, 66965,
    66967, 66977,
    66979, 66993,
    66995, 67001,
    67003, 67004,
    67072, 67382,
    67392, 67413,
    67424, 67431,
    67456, 67461,
    67463, 67504,
    67506, 67514,
    67584, 67589,
    67592, 67592,
    67594, 67637,
    67639, 67640,
    67644, 67644,
    67647, 67669,
    67680, 67702,
    67712, 67742,
    67808, 67826,
    67828, 67829,
    67840, 67861,
    67872, 67897,
    67968, 68023,
    68030, 68031,
    68096, 68096,
    68112, 68115,
    68117, 68119,
    68121, 68149,
    68192, 68220,
    68224, 68252,
    68288, 68295,
    68297, 68324,
    68352, 68405,
    68416, 68437,
    68448, 68466,
    68480, 68497,
    68608, 68680,
    68736, 68786,
    68800, 68850,
    68864, 68899,
    69248, 69289,
    69296, 69297,
    69376, 69404,
    69415, 69415,
    69424, 69445,
    69488, 69505,
    69552, 69572,
    69600, 69622,
    69635, 69687,
    69745, 69746,
    69749, 69749,
    69763, 69807,
    69840, 69864,
    69891, 69926,
    69956, 69956,
    69959, 69959,
    69968, 70002,
    70006, 70006,
    70019, 70066,
    70081, 70084,
    70106, 70106,
    70108, 70108,
    70144, 70161,
    70163, 70187,
    70207, 70208,
    70272, 70278,
    70280, 70280,
    70282, 70285,
    70287, 70301,
    70303, 70312,
    70320, 70366,
    70405, 70412,
    70415, 70416,
    70419, 70440,
    70442, 70448,
    70450, 70451,
    70453, 70457,
    70461, 70461,
    70480, 70480,
    70493, 70497,
    70656, 70708,
    70727, 70730,
    70751, 70753,
    70784, 70831,
    70852, 70853,
    70855, 70855,
    71040, 71086,
    71128, 71131,
    71168, 71215,
    71236, 71236,
    71296, 71338,
    71352, 71352,
    71424, 71450,
    71488, 71494,
    71680, 71723,
    71840, 71903,
    71935, 71942,
    71945, 71945,
    71948, 71955,
    71957, 71958,
    71960, 71983,
    71999, 71999,
    72001, 72001,
    72096, 72103,
    72106, 72144,
    72161, 72161,
    72163, 72163,
    72192, 72192,
    72203, 72242,
    72250, 72250,
    72272, 72272,
    72284, 72329,
    72349, 72349,
    72368, 72440,
    72704, 72712,
    72714, 72750,
    72768, 72768,
    72818, 72847,
    72960, 72966,
    72968, 72969,
    72971, 73008,
    73030, 73030,
    73056, 73061,
    73063, 73064,
    73066, 73097,
    73112, 73112,
    73440, 73458,
    73474, 73474,
    73476, 73488,
    73490, 73523,
    73648, 73648,
    73693, 73696,
    73728, 74649,
    74752, 74862,
    74880, 75075,
    77712, 77808,
    77824, 78895,
    78913, 78918,
    82944, 83526,
    92160, 92728,
    92736, 92766,
    92784, 92862,
    92880, 92909,
    92928, 92975,
    92992, 92995,
    93027, 93047,
    93053, 93071,
    93760, 93823,
    93952, 94026,
    94032, 94032,
    94099, 94111,
    94176, 94177,
    94179, 94179,
    94208, 100343,
    100352, 101589,
    101632, 101640,
    110576, 110579,
    110581, 110587,
    110589, 110590,
    110592, 110882,
    110898, 110898,
    110928, 110930,
    110933, 110933,
    110948, 110951,
    110960, 111355,
    113664, 113770,
    113776, 113788,
    113792, 113800,
    113808, 113817,
    119808, 119892,
    119894, 119964,
    119966, 119967,
    119970, 119970,
    119973, 119974,
    119977, 119980,
    119982, 119993,
    119995, 119995,
    119997, 120003,
    120005, 120069,
    120071, 120074,
    120077, 120084,
    120086, 120092,
    120094, 120121,
    120123, 120126,
    120128, 120132,
    120134, 120134,
    120138, 120144,
    120146, 120485,
    120488, 120512,
    120514, 120538,
    120540, 120570,
    120572, 120596,
    120598, 120628,
    120630, 120654,
    120656, 120686,
    120688, 120712,
    120714, 120744,
    120746, 120770,
    120772, 120779,
    122624, 122654,
    122661, 122666,
    122928, 122989,
    123136, 123180,
    123191, 123197,
    123214, 123214,
    123536, 123565,
    123584, 123627,
    123647, 123647,
    124112, 124139,
    124896, 124902,
    124904, 124907,
    124909, 124910,
    124912, 124926,
    124928, 125124,
    125184, 125251,
    125259, 125259,
    126128, 126128,
    126464, 126467,
    126469, 126495,
    126497, 126498,
    126500, 126500,
    126503, 126503,
    126505, 126514,
    126516, 126519,
    126521, 126521,
    126523, 126523,
    126530, 126530,
    126535, 126535,
    126537, 126537,
    126539, 126539,
    126541, 126543,
    126545, 126546,
    126548, 126548,
    126551, 126551,
    126553, 126553,
    126555, 126555,
    126557, 126557,
    126559, 126559,
    126561, 126562,
    126564, 126564,
    126567, 126570,
    126572, 126578,
    126580, 126583,
    126585, 126588,
    126590, 126590,
    126592, 126601,
    126603, 126619,
    126625, 126627,
    126629, 126633,
    126635, 126651,
    131072, 173791,
    173824, 177977,
    177984, 178205,
    178208, 183969,
    183984, 191456,
    191472, 192093,
    194560, 195101,
    196608, 201546,
    201552, 205743,
    0, 0
  };
  range["JavaIdentifierStart"] = JavaIdentifierStart;
  static const int Javanese[] = {
    43392, 43469,
    43472, 43481,
    43486, 43487,
    0, 0
  };
  range["Javanese"] = Javanese;
  static const int Kaithi[] = {
    69760, 69826,
    69837, 69837,
    0, 0
  };
  range["Kaithi"] = Kaithi;
  static const int Kannada[] = {
    3200, 3212,
    3214, 3216,
    3218, 3240,
    3242, 3251,
    3253, 3257,
    3260, 3268,
    3270, 3272,
    3274, 3277,
    3285, 3286,
    3293, 3294,
    3296, 3299,
    3302, 3311,
    3313, 3315,
    0, 0
  };
  range["Kannada"] = Kannada;
  static const int Katakana[] = {
    12449, 12538,
    12541, 12543,
    12784, 12799,
    13008, 13054,
    13056, 13143,
    65382, 65391,
    65393, 65437,
    110576, 110579,
    110581, 110587,
    110589, 110590,
    110592, 110592,
    110880, 110882,
    110933, 110933,
    110948, 110951,
    0, 0
  };
  range["Katakana"] = Katakana;
  static const int Kawi[] = {
    73472, 73488,
    73490, 73530,
    73534, 73561,
    0, 0
  };
  range["Kawi"] = Kawi;
  static const int Kayah_Li[] = {
    43264, 43309,
    43311, 43311,
    0, 0
  };
  range["Kayah_Li"] = Kayah_Li;
  static const int Kharoshthi[] = {
    68096, 68099,
    68101, 68102,
    68108, 68115,
    68117, 68119,
    68121, 68149,
    68152, 68154,
    68159, 68168,
    68176, 68184,
    0, 0
  };
  range["Kharoshthi"] = Kharoshthi;
  static const int Khitan_Small_Script[] = {
    94180, 94180,
    101120, 101589,
    0, 0
  };
  range["Khitan_Small_Script"] = Khitan_Small_Script;
  static const int Khmer[] = {
    6016, 6109,
    6112, 6121,
    6128, 6137,
    6624, 6655,
    0, 0
  };
  range["Khmer"] = Khmer;
  static const int Khojki[] = {
    70144, 70161,
    70163, 70209,
    0, 0
  };
  range["Khojki"] = Khojki;
  static const int Khudawadi[] = {
    70320, 70378,
    70384, 70393,
    0, 0
  };
  range["Khudawadi"] = Khudawadi;
  static const int L[] = {
    65, 90,
    97, 122,
    170, 170,
    181, 181,
    186, 186,
    192, 214,
    216, 246,
    248, 705,
    710, 721,
    736, 740,
    748, 748,
    750, 750,
    880, 884,
    886, 887,
    890, 893,
    895, 895,
    902, 902,
    904, 906,
    908, 908,
    910, 929,
    931, 1013,
    1015, 1153,
    1162, 1327,
    1329, 1366,
    1369, 1369,
    1376, 1416,
    1488, 1514,
    1519, 1522,
    1568, 1610,
    1646, 1647,
    1649, 1747,
    1749, 1749,
    1765, 1766,
    1774, 1775,
    1786, 1788,
    1791, 1791,
    1808, 1808,
    1810, 1839,
    1869, 1957,
    1969, 1969,
    1994, 2026,
    2036, 2037,
    2042, 2042,
    2048, 2069,
    2074, 2074,
    2084, 2084,
    2088, 2088,
    2112, 2136,
    2144, 2154,
    2160, 2183,
    2185, 2190,
    2208, 2249,
    2308, 2361,
    2365, 2365,
    2384, 2384,
    2392, 2401,
    2417, 2432,
    2437, 2444,
    2447, 2448,
    2451, 2472,
    2474, 2480,
    2482, 2482,
    2486, 2489,
    2493, 2493,
    2510, 2510,
    2524, 2525,
    2527, 2529,
    2544, 2545,
    2556, 2556,
    2565, 2570,
    2575, 2576,
    2579, 2600,
    2602, 2608,
    2610, 2611,
    2613, 2614,
    2616, 2617,
    2649, 2652,
    2654, 2654,
    2674, 2676,
    2693, 2701,
    2703, 2705,
    2707, 2728,
    2730, 2736,
    2738, 2739,
    2741, 2745,
    2749, 2749,
    2768, 2768,
    2784, 2785,
    2809, 2809,
    2821, 2828,
    2831, 2832,
    2835, 2856,
    2858, 2864,
    2866, 2867,
    2869, 2873,
    2877, 2877,
    2908, 2909,
    2911, 2913,
    2929, 2929,
    2947, 2947,
    2949, 2954,
    2958, 2960,
    2962, 2965,
    2969, 2970,
    2972, 2972,
    2974, 2975,
    2979, 2980,
    2984, 2986,
    2990, 3001,
    3024, 3024,
    3077, 3084,
    3086, 3088,
    3090, 3112,
    3114, 3129,
    3133, 3133,
    3160, 3162,
    3165, 3165,
    3168, 3169,
    3200, 3200,
    3205, 3212,
    3214, 3216,
    3218, 3240,
    3242, 3251,
    3253, 3257,
    3261, 3261,
    3293, 3294,
    3296, 3297,
    3313, 3314,
    3332, 3340,
    3342, 3344,
    3346, 3386,
    3389, 3389,
    3406, 3406,
    3412, 3414,
    3423, 3425,
    3450, 3455,
    3461, 3478,
    3482, 3505,
    3507, 3515,
    3517, 3517,
    3520, 3526,
    3585, 3632,
    3634, 3635,
    3648, 3654,
    3713, 3714,
    3716, 3716,
    3718, 3722,
    3724, 3747,
    3749, 3749,
    3751, 3760,
    3762, 3763,
    3773, 3773,
    3776, 3780,
    3782, 3782,
    3804, 3807,
    3840, 3840,
    3904, 3911,
    3913, 3948,
    3976, 3980,
    4096, 4138,
    4159, 4159,
    4176, 4181,
    4186, 4189,
    4193, 4193,
    4197, 4198,
    4206, 4208,
    4213, 4225,
    4238, 4238,
    4256, 4293,
    4295, 4295,
    4301, 4301,
    4304, 4346,
    4348, 4680,
    4682, 4685,
    4688, 4694,
    4696, 4696,
    4698, 4701,
    4704, 4744,
    4746, 4749,
    4752, 4784,
    4786, 4789,
    4792, 4798,
    4800, 4800,
    4802, 4805,
    4808, 4822,
    4824, 4880,
    4882, 4885,
    4888, 4954,
    4992, 5007,
    5024, 5109,
    5112, 5117,
    5121, 5740,
    5743, 5759,
    5761, 5786,
    5792, 5866,
    5873, 5880,
    5888, 5905,
    5919, 5937,
    5952, 5969,
    5984, 5996,
    5998, 6000,
    6016, 6067,
    6103, 6103,
    6108, 6108,
    6176, 6264,
    6272, 6276,
    6279, 6312,
    6314, 6314,
    6320, 6389,
    6400, 6430,
    6480, 6509,
    6512, 6516,
    6528, 6571,
    6576, 6601,
    6656, 6678,
    6688, 6740,
    6823, 6823,
    6917, 6963,
    6981, 6988,
    7043, 7072,
    7086, 7087,
    7098, 7141,
    7168, 7203,
    7245, 7247,
    7258, 7293,
    7296, 7304,
    7312, 7354,
    7357, 7359,
    7401, 7404,
    7406, 7411,
    7413, 7414,
    7418, 7418,
    7424, 7615,
    7680, 7957,
    7960, 7965,
    7968, 8005,
    8008, 8013,
    8016, 8023,
    8025, 8025,
    8027, 8027,
    8029, 8029,
    8031, 8061,
    8064, 8116,
    8118, 8124,
    8126, 8126,
    8130, 8132,
    8134, 8140,
    8144, 8147,
    8150, 8155,
    8160, 8172,
    8178, 8180,
    8182, 8188,
    8305, 8305,
    8319, 8319,
    8336, 8348,
    8450, 8450,
    8455, 8455,
    8458, 8467,
    8469, 8469,
    8473, 8477,
    8484, 8484,
    8486, 8486,
    8488, 8488,
    8490, 8493,
    8495, 8505,
    8508, 8511,
    8517, 8521,
    8526, 8526,
    8579, 8580,
    11264, 11492,
    11499, 11502,
    11506, 11507,
    11520, 11557,
    11559, 11559,
    11565, 11565,
    11568, 11623,
    11631, 11631,
    11648, 11670,
    11680, 11686,
    11688, 11694,
    11696, 11702,
    11704, 11710,
    11712, 11718,
    11720, 11726,
    11728, 11734,
    11736, 11742,
    11823, 11823,
    12293, 12294,
    12337, 12341,
    12347, 12348,
    12353, 12438,
    12445, 12447,
    12449, 12538,
    12540, 12543,
    12549, 12591,
    12593, 12686,
    12704, 12735,
    12784, 12799,
    13312, 19903,
    19968, 42124,
    42192, 42237,
    42240, 42508,
    42512, 42527,
    42538, 42539,
    42560, 42606,
    42623, 42653,
    42656, 42725,
    42775, 42783,
    42786, 42888,
    42891, 42954,
    42960, 42961,
    42963, 42963,
    42965, 42969,
    42994, 43009,
    43011, 43013,
    43015, 43018,
    43020, 43042,
    43072, 43123,
    43138, 43187,
    43250, 43255,
    43259, 43259,
    43261, 43262,
    43274, 43301,
    43312, 43334,
    43360, 43388,
    43396, 43442,
    43471, 43471,
    43488, 43492,
    43494, 43503,
    43514, 43518,
    43520, 43560,
    43584, 43586,
    43588, 43595,
    43616, 43638,
    43642, 43642,
    43646, 43695,
    43697, 43697,
    43701, 43702,
    43705, 43709,
    43712, 43712,
    43714, 43714,
    43739, 43741,
    43744, 43754,
    43762, 43764,
    43777, 43782,
    43785, 43790,
    43793, 43798,
    43808, 43814,
    43816, 43822,
    43824, 43866,
    43868, 43881,
    43888, 44002,
    44032, 55203,
    55216, 55238,
    55243, 55291,
    63744, 64109,
    64112, 64217,
    64256, 64262,
    64275, 64279,
    64285, 64285,
    64287, 64296,
    64298, 64310,
    64312, 64316,
    64318, 64318,
    64320, 64321,
    64323, 64324,
    64326, 64433,
    64467, 64829,
    64848, 64911,
    64914, 64967,
    65008, 65019,
    65136, 65140,
    65142, 65276,
    65313, 65338,
    65345, 65370,
    65382, 65470,
    65474, 65479,
    65482, 65487,
    65490, 65495,
    65498, 65500,
    65536, 65547,
    65549, 65574,
    65576, 65594,
    65596, 65597,
    65599, 65613,
    65616, 65629,
    65664, 65786,
    66176, 66204,
    66208, 66256,
    66304, 66335,
    66349, 66368,
    66370, 66377,
    66384, 66421,
    66432, 66461,
    66464, 66499,
    66504, 66511,
    66560, 66717,
    66736, 66771,
    66776, 66811,
    66816, 66855,
    66864, 66915,
    66928, 66938,
    66940, 66954,
    66956, 66962,
    66964, 66965,
    66967, 66977,
    66979, 66993,
    66995, 67001,
    67003, 67004,
    67072, 67382,
    67392, 67413,
    67424, 67431,
    67456, 67461,
    67463, 67504,
    67506, 67514,
    67584, 67589,
    67592, 67592,
    67594, 67637,
    67639, 67640,
    67644, 67644,
    67647, 67669,
    67680, 67702,
    67712, 67742,
    67808, 67826,
    67828, 67829,
    67840, 67861,
    67872, 67897,
    67968, 68023,
    68030, 68031,
    68096, 68096,
    68112, 68115,
    68117, 68119,
    68121, 68149,
    68192, 68220,
    68224, 68252,
    68288, 68295,
    68297, 68324,
    68352, 68405,
    68416, 68437,
    68448, 68466,
    68480, 68497,
    68608, 68680,
    68736, 68786,
    68800, 68850,
    68864, 68899,
    69248, 69289,
    69296, 69297,
    69376, 69404,
    69415, 69415,
    69424, 69445,
    69488, 69505,
    69552, 69572,
    69600, 69622,
    69635, 69687,
    69745, 69746,
    69749, 69749,
    69763, 69807,
    69840, 69864,
    69891, 69926,
    69956, 69956,
    69959, 69959,
    69968, 70002,
    70006, 70006,
    70019, 70066,
    70081, 70084,
    70106, 70106,
    70108, 70108,
    70144, 70161,
    70163, 70187,
    70207, 70208,
    70272, 70278,
    70280, 70280,
    70282, 70285,
    70287, 70301,
    70303, 70312,
    70320, 70366,
    70405, 70412,
    70415, 70416,
    70419, 70440,
    70442, 70448,
    70450, 70451,
    70453, 70457,
    70461, 70461,
    70480, 70480,
    70493, 70497,
    70656, 70708,
    70727, 70730,
    70751, 70753,
    70784, 70831,
    70852, 70853,
    70855, 70855,
    71040, 71086,
    71128, 71131,
    71168, 71215,
    71236, 71236,
    71296, 71338,
    71352, 71352,
    71424, 71450,
    71488, 71494,
    71680, 71723,
    71840, 71903,
    71935, 71942,
    71945, 71945,
    71948, 71955,
    71957, 71958,
    71960, 71983,
    71999, 71999,
    72001, 72001,
    72096, 72103,
    72106, 72144,
    72161, 72161,
    72163, 72163,
    72192, 72192,
    72203, 72242,
    72250, 72250,
    72272, 72272,
    72284, 72329,
    72349, 72349,
    72368, 72440,
    72704, 72712,
    72714, 72750,
    72768, 72768,
    72818, 72847,
    72960, 72966,
    72968, 72969,
    72971, 73008,
    73030, 73030,
    73056, 73061,
    73063, 73064,
    73066, 73097,
    73112, 73112,
    73440, 73458,
    73474, 73474,
    73476, 73488,
    73490, 73523,
    73648, 73648,
    73728, 74649,
    74880, 75075,
    77712, 77808,
    77824, 78895,
    78913, 78918,
    82944, 83526,
    92160, 92728,
    92736, 92766,
    92784, 92862,
    92880, 92909,
    92928, 92975,
    92992, 92995,
    93027, 93047,
    93053, 93071,
    93760, 93823,
    93952, 94026,
    94032, 94032,
    94099, 94111,
    94176, 94177,
    94179, 94179,
    94208, 100343,
    100352, 101589,
    101632, 101640,
    110576, 110579,
    110581, 110587,
    110589, 110590,
    110592, 110882,
    110898, 110898,
    110928, 110930,
    110933, 110933,
    110948, 110951,
    110960, 111355,
    113664, 113770,
    113776, 113788,
    113792, 113800,
    113808, 113817,
    119808, 119892,
    119894, 119964,
    119966, 119967,
    119970, 119970,
    119973, 119974,
    119977, 119980,
    119982, 119993,
    119995, 119995,
    119997, 120003,
    120005, 120069,
    120071, 120074,
    120077, 120084,
    120086, 120092,
    120094, 120121,
    120123, 120126,
    120128, 120132,
    120134, 120134,
    120138, 120144,
    120146, 120485,
    120488, 120512,
    120514, 120538,
    120540, 120570,
    120572, 120596,
    120598, 120628,
    120630, 120654,
    120656, 120686,
    120688, 120712,
    120714, 120744,
    120746, 120770,
    120772, 120779,
    122624, 122654,
    122661, 122666,
    122928, 122989,
    123136, 123180,
    123191, 123197,
    123214, 123214,
    123536, 123565,
    123584, 123627,
    124112, 124139,
    124896, 124902,
    124904, 124907,
    124909, 124910,
    124912, 124926,
    124928, 125124,
    125184, 125251,
    125259, 125259,
    126464, 126467,
    126469, 126495,
    126497, 126498,
    126500, 126500,
    126503, 126503,
    126505, 126514,
    126516, 126519,
    126521, 126521,
    126523, 126523,
    126530, 126530,
    126535, 126535,
    126537, 126537,
    126539, 126539,
    126541, 126543,
    126545, 126546,
    126548, 126548,
    126551, 126551,
    126553, 126553,
    126555, 126555,
    126557, 126557,
    126559, 126559,
    126561, 126562,
    126564, 126564,
    126567, 126570,
    126572, 126578,
    126580, 126583,
    126585, 126588,
    126590, 126590,
    126592, 126601,
    126603, 126619,
    126625, 126627,
    126629, 126633,
    126635, 126651,
    131072, 173791,
    173824, 177977,
    177984, 178205,
    178208, 183969,
    183984, 191456,
    191472, 192093,
    194560, 195101,
    196608, 201546,
    201552, 205743,
    0, 0
  };
  range["L"] = L;
  static const int L_[] = {
    65, 90,
    97, 122,
    181, 181,
    192, 214,
    216, 246,
    248, 442,
    444, 447,
    452, 659,
    661, 687,
    880, 883,
    886, 887,
    891, 893,
    895, 895,
    902, 902,
    904, 906,
    908, 908,
    910, 929,
    931, 1013,
    1015, 1153,
    1162, 1327,
    1329, 1366,
    1376, 1416,
    4256, 4293,
    4295, 4295,
    4301, 4301,
    4304, 4346,
    4349, 4351,
    5024, 5109,
    5112, 5117,
    7296, 7304,
    7312, 7354,
    7357, 7359,
    7424, 7467,
    7531, 7543,
    7545, 7578,
    7680, 7957,
    7960, 7965,
    7968, 8005,
    8008, 8013,
    8016, 8023,
    8025, 8025,
    8027, 8027,
    8029, 8029,
    8031, 8061,
    8064, 8116,
    8118, 8124,
    8126, 8126,
    8130, 8132,
    8134, 8140,
    8144, 8147,
    8150, 8155,
    8160, 8172,
    8178, 8180,
    8182, 8188,
    8450, 8450,
    8455, 8455,
    8458, 8467,
    8469, 8469,
    8473, 8477,
    8484, 8484,
    8486, 8486,
    8488, 8488,
    8490, 8493,
    8495, 8500,
    8505, 8505,
    8508, 8511,
    8517, 8521,
    8526, 8526,
    8579, 8580,
    11264, 11387,
    11390, 11492,
    11499, 11502,
    11506, 11507,
    11520, 11557,
    11559, 11559,
    11565, 11565,
    42560, 42605,
    42624, 42651,
    42786, 42863,
    42865, 42887,
    42891, 42894,
    42896, 42954,
    42960, 42961,
    42963, 42963,
    42965, 42969,
    42997, 42998,
    43002, 43002,
    43824, 43866,
    43872, 43880,
    43888, 43967,
    64256, 64262,
    64275, 64279,
    65313, 65338,
    65345, 65370,
    66560, 66639,
    66736, 66771,
    66776, 66811,
    66928, 66938,
    66940, 66954,
    66956, 66962,
    66964, 66965,
    66967, 66977,
    66979, 66993,
    66995, 67001,
    67003, 67004,
    68736, 68786,
    68800, 68850,
    71840, 71903,
    93760, 93823,
    119808, 119892,
    119894, 119964,
    119966, 119967,
    119970, 119970,
    119973, 119974,
    119977, 119980,
    119982, 119993,
    119995, 119995,
    119997, 120003,
    120005, 120069,
    120071, 120074,
    120077, 120084,
    120086, 120092,
    120094, 120121,
    120123, 120126,
    120128, 120132,
    120134, 120134,
    120138, 120144,
    120146, 120485,
    120488, 120512,
    120514, 120538,
    120540, 120570,
    120572, 120596,
    120598, 120628,
    120630, 120654,
    120656, 120686,
    120688, 120712,
    120714, 120744,
    120746, 120770,
    120772, 120779,
    122624, 122633,
    122635, 122654,
    122661, 122666,
    125184, 125251,
    0, 0
  };
  range["L&"] = L_;
  static const int Lao[] = {
    3713, 3714,
    3716, 3716,
    3718, 3722,
    3724, 3747,
    3749, 3749,
    3751, 3773,
    3776, 3780,
    3782, 3782,
    3784, 3790,
    3792, 3801,
    3804, 3807,
    0, 0
  };
  range["Lao"] = Lao;
  static const int Latin[] = {
    65, 90,
    97, 122,
    170, 170,
    186, 186,
    192, 214,
    216, 246,
    248, 696,
    736, 740,
    7424, 7461,
    7468, 7516,
    7522, 7525,
    7531, 7543,
    7545, 7614,
    7680, 7935,
    8305, 8305,
    8319, 8319,
    8336, 8348,
    8490, 8491,
    8498, 8498,
    8526, 8526,
    8544, 8584,
    11360, 11391,
    42786, 42887,
    42891, 42954,
    42960, 42961,
    42963, 42963,
    42965, 42969,
    42994, 43007,
    43824, 43866,
    43868, 43876,
    43878, 43881,
    64256, 64262,
    65313, 65338,
    65345, 65370,
    67456, 67461,
    67463, 67504,
    67506, 67514,
    122624, 122654,
    122661, 122666,
    0, 0
  };
  range["Latin"] = Latin;
  static const int Lepcha[] = {
    7168, 7223,
    7227, 7241,
    7245, 7247,
    0, 0
  };
  range["Lepcha"] = Lepcha;
  static const int Limbu[] = {
    6400, 6430,
    6432, 6443,
    6448, 6459,
    6464, 6464,
    6468, 6479,
    0, 0
  };
  range["Limbu"] = Limbu;
  static const int Linear_A[] = {
    67072, 67382,
    67392, 67413,
    67424, 67431,
    0, 0
  };
  range["Linear_A"] = Linear_A;
  static const int Linear_B[] = {
    65536, 65547,
    65549, 65574,
    65576, 65594,
    65596, 65597,
    65599, 65613,
    65616, 65629,
    65664, 65786,
    0, 0
  };
  range["Linear_B"] = Linear_B;
  static const int Lisu[] = {
    42192, 42239,
    73648, 73648,
    0, 0
  };
  range["Lisu"] = Lisu;
  static const int Lm[] = {
    688, 705,
    710, 721,
    736, 740,
    748, 748,
    750, 750,
    884, 884,
    890, 890,
    1369, 1369,
    1600, 1600,
    1765, 1766,
    2036, 2037,
    2042, 2042,
    2074, 2074,
    2084, 2084,
    2088, 2088,
    2249, 2249,
    2417, 2417,
    3654, 3654,
    3782, 3782,
    4348, 4348,
    6103, 6103,
    6211, 6211,
    6823, 6823,
    7288, 7293,
    7468, 7530,
    7544, 7544,
    7579, 7615,
    8305, 8305,
    8319, 8319,
    8336, 8348,
    11388, 11389,
    11631, 11631,
    11823, 11823,
    12293, 12293,
    12337, 12341,
    12347, 12347,
    12445, 12446,
    12540, 12542,
    40981, 40981,
    42232, 42237,
    42508, 42508,
    42623, 42623,
    42652, 42653,
    42775, 42783,
    42864, 42864,
    42888, 42888,
    42994, 42996,
    43000, 43001,
    43471, 43471,
    43494, 43494,
    43632, 43632,
    43741, 43741,
    43763, 43764,
    43868, 43871,
    43881, 43881,
    65392, 65392,
    65438, 65439,
    67456, 67461,
    67463, 67504,
    67506, 67514,
    92992, 92995,
    94099, 94111,
    94176, 94177,
    94179, 94179,
    110576, 110579,
    110581, 110587,
    110589, 110590,
    122928, 122989,
    123191, 123197,
    124139, 124139,
    125259, 125259,
    0, 0
  };
  range["Lm"] = Lm;
  static const int Lo[] = {
    170, 170,
    186, 186,
    443, 443,
    448, 451,
    660, 660,
    1488, 1514,
    1519, 1522,
    1568, 1599,
    1601, 1610,
    1646, 1647,
    1649, 1747,
    1749, 1749,
    1774, 1775,
    1786, 1788,
    1791, 1791,
    1808, 1808,
    1810, 1839,
    1869, 1957,
    1969, 1969,
    1994, 2026,
    2048, 2069,
    2112, 2136,
    2144, 2154,
    2160, 2183,
    2185, 2190,
    2208, 2248,
    2308, 2361,
    2365, 2365,
    2384, 2384,
    2392, 2401,
    2418, 2432,
    2437, 2444,
    2447, 2448,
    2451, 2472,
    2474, 2480,
    2482, 2482,
    2486, 2489,
    2493, 2493,
    2510, 2510,
    2524, 2525,
    2527, 2529,
    2544, 2545,
    2556, 2556,
    2565, 2570,
    2575, 2576,
    2579, 2600,
    2602, 2608,
    2610, 2611,
    2613, 2614,
    2616, 2617,
    2649, 2652,
    2654, 2654,
    2674, 2676,
    2693, 2701,
    2703, 2705,
    2707, 2728,
    2730, 2736,
    2738, 2739,
    2741, 2745,
    2749, 2749,
    2768, 2768,
    2784, 2785,
    2809, 2809,
    2821, 2828,
    2831, 2832,
    2835, 2856,
    2858, 2864,
    2866, 2867,
    2869, 2873,
    2877, 2877,
    2908, 2909,
    2911, 2913,
    2929, 2929,
    2947, 2947,
    2949, 2954,
    2958, 2960,
    2962, 2965,
    2969, 2970,
    2972, 2972,
    2974, 2975,
    2979, 2980,
    2984, 2986,
    2990, 3001,
    3024, 3024,
    3077, 3084,
    3086, 3088,
    3090, 3112,
    3114, 3129,
    3133, 3133,
    3160, 3162,
    3165, 3165,
    3168, 3169,
    3200, 3200,
    3205, 3212,
    3214, 3216,
    3218, 3240,
    3242, 3251,
    3253, 3257,
    3261, 3261,
    3293, 3294,
    3296, 3297,
    3313, 3314,
    3332, 3340,
    3342, 3344,
    3346, 3386,
    3389, 3389,
    3406, 3406,
    3412, 3414,
    3423, 3425,
    3450, 3455,
    3461, 3478,
    3482, 3505,
    3507, 3515,
    3517, 3517,
    3520, 3526,
    3585, 3632,
    3634, 3635,
    3648, 3653,
    3713, 3714,
    3716, 3716,
    3718, 3722,
    3724, 3747,
    3749, 3749,
    3751, 3760,
    3762, 3763,
    3773, 3773,
    3776, 3780,
    3804, 3807,
    3840, 3840,
    3904, 3911,
    3913, 3948,
    3976, 3980,
    4096, 4138,
    4159, 4159,
    4176, 4181,
    4186, 4189,
    4193, 4193,
    4197, 4198,
    4206, 4208,
    4213, 4225,
    4238, 4238,
    4352, 4680,
    4682, 4685,
    4688, 4694,
    4696, 4696,
    4698, 4701,
    4704, 4744,
    4746, 4749,
    4752, 4784,
    4786, 4789,
    4792, 4798,
    4800, 4800,
    4802, 4805,
    4808, 4822,
    4824, 4880,
    4882, 4885,
    4888, 4954,
    4992, 5007,
    5121, 5740,
    5743, 5759,
    5761, 5786,
    5792, 5866,
    5873, 5880,
    5888, 5905,
    5919, 5937,
    5952, 5969,
    5984, 5996,
    5998, 6000,
    6016, 6067,
    6108, 6108,
    6176, 6210,
    6212, 6264,
    6272, 6276,
    6279, 6312,
    6314, 6314,
    6320, 6389,
    6400, 6430,
    6480, 6509,
    6512, 6516,
    6528, 6571,
    6576, 6601,
    6656, 6678,
    6688, 6740,
    6917, 6963,
    6981, 6988,
    7043, 7072,
    7086, 7087,
    7098, 7141,
    7168, 7203,
    7245, 7247,
    7258, 7287,
    7401, 7404,
    7406, 7411,
    7413, 7414,
    7418, 7418,
    8501, 8504,
    11568, 11623,
    11648, 11670,
    11680, 11686,
    11688, 11694,
    11696, 11702,
    11704, 11710,
    11712, 11718,
    11720, 11726,
    11728, 11734,
    11736, 11742,
    12294, 12294,
    12348, 12348,
    12353, 12438,
    12447, 12447,
    12449, 12538,
    12543, 12543,
    12549, 12591,
    12593, 12686,
    12704, 12735,
    12784, 12799,
    13312, 19903,
    19968, 40980,
    40982, 42124,
    42192, 42231,
    42240, 42507,
    42512, 42527,
    42538, 42539,
    42606, 42606,
    42656, 42725,
    42895, 42895,
    42999, 42999,
    43003, 43009,
    43011, 43013,
    43015, 43018,
    43020, 43042,
    43072, 43123,
    43138, 43187,
    43250, 43255,
    43259, 43259,
    43261, 43262,
    43274, 43301,
    43312, 43334,
    43360, 43388,
    43396, 43442,
    43488, 43492,
    43495, 43503,
    43514, 43518,
    43520, 43560,
    43584, 43586,
    43588, 43595,
    43616, 43631,
    43633, 43638,
    43642, 43642,
    43646, 43695,
    43697, 43697,
    43701, 43702,
    43705, 43709,
    43712, 43712,
    43714, 43714,
    43739, 43740,
    43744, 43754,
    43762, 43762,
    43777, 43782,
    43785, 43790,
    43793, 43798,
    43808, 43814,
    43816, 43822,
    43968, 44002,
    44032, 55203,
    55216, 55238,
    55243, 55291,
    63744, 64109,
    64112, 64217,
    64285, 64285,
    64287, 64296,
    64298, 64310,
    64312, 64316,
    64318, 64318,
    64320, 64321,
    64323, 64324,
    64326, 64433,
    64467, 64829,
    64848, 64911,
    64914, 64967,
    65008, 65019,
    65136, 65140,
    65142, 65276,
    65382, 65391,
    65393, 65437,
    65440, 65470,
    65474, 65479,
    65482, 65487,
    65490, 65495,
    65498, 65500,
    65536, 65547,
    65549, 65574,
    65576, 65594,
    65596, 65597,
    65599, 65613,
    65616, 65629,
    65664, 65786,
    66176, 66204,
    66208, 66256,
    66304, 66335,
    66349, 66368,
    66370, 66377,
    66384, 66421,
    66432, 66461,
    66464, 66499,
    66504, 66511,
    66640, 66717,
    66816, 66855,
    66864, 66915,
    67072, 67382,
    67392, 67413,
    67424, 67431,
    67584, 67589,
    67592, 67592,
    67594, 67637,
    67639, 67640,
    67644, 67644,
    67647, 67669,
    67680, 67702,
    67712, 67742,
    67808, 67826,
    67828, 67829,
    67840, 67861,
    67872, 67897,
    67968, 68023,
    68030, 68031,
    68096, 68096,
    68112, 68115,
    68117, 68119,
    68121, 68149,
    68192, 68220,
    68224, 68252,
    68288, 68295,
    68297, 68324,
    68352, 68405,
    68416, 68437,
    68448, 68466,
    68480, 68497,
    68608, 68680,
    68864, 68899,
    69248, 69289,
    69296, 69297,
    69376, 69404,
    69415, 69415,
    69424, 69445,
    69488, 69505,
    69552, 69572,
    69600, 69622,
    69635, 69687,
    69745, 69746,
    69749, 69749,
    69763, 69807,
    69840, 69864,
    69891, 69926,
    69956, 69956,
    69959, 69959,
    69968, 70002,
    70006, 70006,
    70019, 70066,
    70081, 70084,
    70106, 70106,
    70108, 70108,
    70144, 70161,
    70163, 70187,
    70207, 70208,
    70272, 70278,
    70280, 70280,
    70282, 70285,
    70287, 70301,
    70303, 70312,
    70320, 70366,
    70405, 70412,
    70415, 70416,
    70419, 70440,
    70442, 70448,
    70450, 70451,
    70453, 70457,
    70461, 70461,
    70480, 70480,
    70493, 70497,
    70656, 70708,
    70727, 70730,
    70751, 70753,
    70784, 70831,
    70852, 70853,
    70855, 70855,
    71040, 71086,
    71128, 71131,
    71168, 71215,
    71236, 71236,
    71296, 71338,
    71352, 71352,
    71424, 71450,
    71488, 71494,
    71680, 71723,
    71935, 71942,
    71945, 71945,
    71948, 71955,
    71957, 71958,
    71960, 71983,
    71999, 71999,
    72001, 72001,
    72096, 72103,
    72106, 72144,
    72161, 72161,
    72163, 72163,
    72192, 72192,
    72203, 72242,
    72250, 72250,
    72272, 72272,
    72284, 72329,
    72349, 72349,
    72368, 72440,
    72704, 72712,
    72714, 72750,
    72768, 72768,
    72818, 72847,
    72960, 72966,
    72968, 72969,
    72971, 73008,
    73030, 73030,
    73056, 73061,
    73063, 73064,
    73066, 73097,
    73112, 73112,
    73440, 73458,
    73474, 73474,
    73476, 73488,
    73490, 73523,
    73648, 73648,
    73728, 74649,
    74880, 75075,
    77712, 77808,
    77824, 78895,
    78913, 78918,
    82944, 83526,
    92160, 92728,
    92736, 92766,
    92784, 92862,
    92880, 92909,
    92928, 92975,
    93027, 93047,
    93053, 93071,
    93952, 94026,
    94032, 94032,
    94208, 100343,
    100352, 101589,
    101632, 101640,
    110592, 110882,
    110898, 110898,
    110928, 110930,
    110933, 110933,
    110948, 110951,
    110960, 111355,
    113664, 113770,
    113776, 113788,
    113792, 113800,
    113808, 113817,
    122634, 122634,
    123136, 123180,
    123214, 123214,
    123536, 123565,
    123584, 123627,
    124112, 124138,
    124896, 124902,
    124904, 124907,
    124909, 124910,
    124912, 124926,
    124928, 125124,
    126464, 126467,
    126469, 126495,
    126497, 126498,
    126500, 126500,
    126503, 126503,
    126505, 126514,
    126516, 126519,
    126521, 126521,
    126523, 126523,
    126530, 126530,
    126535, 126535,
    126537, 126537,
    126539, 126539,
    126541, 126543,
    126545, 126546,
    126548, 126548,
    126551, 126551,
    126553, 126553,
    126555, 126555,
    126557, 126557,
    126559, 126559,
    126561, 126562,
    126564, 126564,
    126567, 126570,
    126572, 126578,
    126580, 126583,
    126585, 126588,
    126590, 126590,
    126592, 126601,
    126603, 126619,
    126625, 126627,
    126629, 126633,
    126635, 126651,
    131072, 173791,
    173824, 177977,
    177984, 178205,
    178208, 183969,
    183984, 191456,
    191472, 192093,
    194560, 195101,
    196608, 201546,
    201552, 205743,
    0, 0
  };
  range["Lo"] = Lo;
  static const int Lycian[] = {
    66176, 66204,
    0, 0
  };
  range["Lycian"] = Lycian;
  static const int Lydian[] = {
    67872, 67897,
    67903, 67903,
    0, 0
  };
  range["Lydian"] = Lydian;
  static const int M[] = {
    768, 879,
    1155, 1161,
    1425, 1469,
    1471, 1471,
    1473, 1474,
    1476, 1477,
    1479, 1479,
    1552, 1562,
    1611, 1631,
    1648, 1648,
    1750, 1756,
    1759, 1764,
    1767, 1768,
    1770, 1773,
    1809, 1809,
    1840, 1866,
    1958, 1968,
    2027, 2035,
    2045, 2045,
    2070, 2073,
    2075, 2083,
    2085, 2087,
    2089, 2093,
    2137, 2139,
    2200, 2207,
    2250, 2273,
    2275, 2307,
    2362, 2364,
    2366, 2383,
    2385, 2391,
    2402, 2403,
    2433, 2435,
    2492, 2492,
    2494, 2500,
    2503, 2504,
    2507, 2509,
    2519, 2519,
    2530, 2531,
    2558, 2558,
    2561, 2563,
    2620, 2620,
    2622, 2626,
    2631, 2632,
    2635, 2637,
    2641, 2641,
    2672, 2673,
    2677, 2677,
    2689, 2691,
    2748, 2748,
    2750, 2757,
    2759, 2761,
    2763, 2765,
    2786, 2787,
    2810, 2815,
    2817, 2819,
    2876, 2876,
    2878, 2884,
    2887, 2888,
    2891, 2893,
    2901, 2903,
    2914, 2915,
    2946, 2946,
    3006, 3010,
    3014, 3016,
    3018, 3021,
    3031, 3031,
    3072, 3076,
    3132, 3132,
    3134, 3140,
    3142, 3144,
    3146, 3149,
    3157, 3158,
    3170, 3171,
    3201, 3203,
    3260, 3260,
    3262, 3268,
    3270, 3272,
    3274, 3277,
    3285, 3286,
    3298, 3299,
    3315, 3315,
    3328, 3331,
    3387, 3388,
    3390, 3396,
    3398, 3400,
    3402, 3405,
    3415, 3415,
    3426, 3427,
    3457, 3459,
    3530, 3530,
    3535, 3540,
    3542, 3542,
    3544, 3551,
    3570, 3571,
    3633, 3633,
    3636, 3642,
    3655, 3662,
    3761, 3761,
    3764, 3772,
    3784, 3790,
    3864, 3865,
    3893, 3893,
    3895, 3895,
    3897, 3897,
    3902, 3903,
    3953, 3972,
    3974, 3975,
    3981, 3991,
    3993, 4028,
    4038, 4038,
    4139, 4158,
    4182, 4185,
    4190, 4192,
    4194, 4196,
    4199, 4205,
    4209, 4212,
    4226, 4237,
    4239, 4239,
    4250, 4253,
    4957, 4959,
    5906, 5909,
    5938, 5940,
    5970, 5971,
    6002, 6003,
    6068, 6099,
    6109, 6109,
    6155, 6157,
    6159, 6159,
    6277, 6278,
    6313, 6313,
    6432, 6443,
    6448, 6459,
    6679, 6683,
    6741, 6750,
    6752, 6780,
    6783, 6783,
    6832, 6862,
    6912, 6916,
    6964, 6980,
    7019, 7027,
    7040, 7042,
    7073, 7085,
    7142, 7155,
    7204, 7223,
    7376, 7378,
    7380, 7400,
    7405, 7405,
    7412, 7412,
    7415, 7417,
    7616, 7679,
    8400, 8432,
    11503, 11505,
    11647, 11647,
    11744, 11775,
    12330, 12335,
    12441, 12442,
    42607, 42610,
    42612, 42621,
    42654, 42655,
    42736, 42737,
    43010, 43010,
    43014, 43014,
    43019, 43019,
    43043, 43047,
    43052, 43052,
    43136, 43137,
    43188, 43205,
    43232, 43249,
    43263, 43263,
    43302, 43309,
    43335, 43347,
    43392, 43395,
    43443, 43456,
    43493, 43493,
    43561, 43574,
    43587, 43587,
    43596, 43597,
    43643, 43645,
    43696, 43696,
    43698, 43700,
    43703, 43704,
    43710, 43711,
    43713, 43713,
    43755, 43759,
    43765, 43766,
    44003, 44010,
    44012, 44013,
    64286, 64286,
    65024, 65039,
    65056, 65071,
    66045, 66045,
    66272, 66272,
    66422, 66426,
    68097, 68099,
    68101, 68102,
    68108, 68111,
    68152, 68154,
    68159, 68159,
    68325, 68326,
    68900, 68903,
    69291, 69292,
    69373, 69375,
    69446, 69456,
    69506, 69509,
    69632, 69634,
    69688, 69702,
    69744, 69744,
    69747, 69748,
    69759, 69762,
    69808, 69818,
    69826, 69826,
    69888, 69890,
    69927, 69940,
    69957, 69958,
    70003, 70003,
    70016, 70018,
    70067, 70080,
    70089, 70092,
    70094, 70095,
    70188, 70199,
    70206, 70206,
    70209, 70209,
    70367, 70378,
    70400, 70403,
    70459, 70460,
    70462, 70468,
    70471, 70472,
    70475, 70477,
    70487, 70487,
    70498, 70499,
    70502, 70508,
    70512, 70516,
    70709, 70726,
    70750, 70750,
    70832, 70851,
    71087, 71093,
    71096, 71104,
    71132, 71133,
    71216, 71232,
    71339, 71351,
    71453, 71467,
    71724, 71738,
    71984, 71989,
    71991, 71992,
    71995, 71998,
    72000, 72000,
    72002, 72003,
    72145, 72151,
    72154, 72160,
    72164, 72164,
    72193, 72202,
    72243, 72249,
    72251, 72254,
    72263, 72263,
    72273, 72283,
    72330, 72345,
    72751, 72758,
    72760, 72767,
    72850, 72871,
    72873, 72886,
    73009, 73014,
    73018, 73018,
    73020, 73021,
    73023, 73029,
    73031, 73031,
    73098, 73102,
    73104, 73105,
    73107, 73111,
    73459, 73462,
    73472, 73473,
    73475, 73475,
    73524, 73530,
    73534, 73538,
    78912, 78912,
    78919, 78933,
    92912, 92916,
    92976, 92982,
    94031, 94031,
    94033, 94087,
    94095, 94098,
    94180, 94180,
    94192, 94193,
    113821, 113822,
    118528, 118573,
    118576, 118598,
    119141, 119145,
    119149, 119154,
    119163, 119170,
    119173, 119179,
    119210, 119213,
    119362, 119364,
    121344, 121398,
    121403, 121452,
    121461, 121461,
    121476, 121476,
    121499, 121503,
    121505, 121519,
    122880, 122886,
    122888, 122904,
    122907, 122913,
    122915, 122916,
    122918, 122922,
    123023, 123023,
    123184, 123190,
    123566, 123566,
    123628, 123631,
    124140, 124143,
    125136, 125142,
    125252, 125258,
    917760, 917999,
    0, 0
  };
  range["M"] = M;
  static const int Mahajani[] = {
    69968, 70006,
    0, 0
  };
  range["Mahajani"] = Mahajani;
  static const int Makasar[] = {
    73440, 73464,
    0, 0
  };
  range["Makasar"] = Makasar;
  static const int Malayalam[] = {
    3328, 3340,
    3342, 3344,
    3346, 3396,
    3398, 3400,
    3402, 3407,
    3412, 3427,
    3430, 3455,
    0, 0
  };
  range["Malayalam"] = Malayalam;
  static const int Mandaic[] = {
    2112, 2139,
    2142, 2142,
    0, 0
  };
  range["Mandaic"] = Mandaic;
  static const int Manichaean[] = {
    68288, 68326,
    68331, 68342,
    0, 0
  };
  range["Manichaean"] = Manichaean;
  static const int Marchen[] = {
    72816, 72847,
    72850, 72871,
    72873, 72886,
    0, 0
  };
  range["Marchen"] = Marchen;
  static const int Masaram_Gondi[] = {
    72960, 72966,
    72968, 72969,
    72971, 73014,
    73018, 73018,
    73020, 73021,
    73023, 73031,
    73040, 73049,
    0, 0
  };
  range["Masaram_Gondi"] = Masaram_Gondi;
  static const int Mc[] = {
    2307, 2307,
    2363, 2363,
    2366, 2368,
    2377, 2380,
    2382, 2383,
    2434, 2435,
    2494, 2496,
    2503, 2504,
    2507, 2508,
    2519, 2519,
    2563, 2563,
    2622, 2624,
    2691, 2691,
    2750, 2752,
    2761, 2761,
    2763, 2764,
    2818, 2819,
    2878, 2878,
    2880, 2880,
    2887, 2888,
    2891, 2892,
    2903, 2903,
    3006, 3007,
    3009, 3010,
    3014, 3016,
    3018, 3020,
    3031, 3031,
    3073, 3075,
    3137, 3140,
    3202, 3203,
    3262, 3262,
    3264, 3268,
    3271, 3272,
    3274, 3275,
    3285, 3286,
    3315, 3315,
    3330, 3331,
    3390, 3392,
    3398, 3400,
    3402, 3404,
    3415, 3415,
    3458, 3459,
    3535, 3537,
    3544, 3551,
    3570, 3571,
    3902, 3903,
    3967, 3967,
    4139, 4140,
    4145, 4145,
    4152, 4152,
    4155, 4156,
    4182, 4183,
    4194, 4196,
    4199, 4205,
    4227, 4228,
    4231, 4236,
    4239, 4239,
    4250, 4252,
    5909, 5909,
    5940, 5940,
    6070, 6070,
    6078, 6085,
    6087, 6088,
    6435, 6438,
    6441, 6443,
    6448, 6449,
    6451, 6456,
    6681, 6682,
    6741, 6741,
    6743, 6743,
    6753, 6753,
    6755, 6756,
    6765, 6770,
    6916, 6916,
    6965, 6965,
    6971, 6971,
    6973, 6977,
    6979, 6980,
    7042, 7042,
    7073, 7073,
    7078, 7079,
    7082, 7082,
    7143, 7143,
    7146, 7148,
    7150, 7150,
    7154, 7155,
    7204, 7211,
    7220, 7221,
    7393, 7393,
    7415, 7415,
    12334, 12335,
    43043, 43044,
    43047, 43047,
    43136, 43137,
    43188, 43203,
    43346, 43347,
    43395, 43395,
    43444, 43445,
    43450, 43451,
    43454, 43456,
    43567, 43568,
    43571, 43572,
    43597, 43597,
    43643, 43643,
    43645, 43645,
    43755, 43755,
    43758, 43759,
    43765, 43765,
    44003, 44004,
    44006, 44007,
    44009, 44010,
    44012, 44012,
    69632, 69632,
    69634, 69634,
    69762, 69762,
    69808, 69810,
    69815, 69816,
    69932, 69932,
    69957, 69958,
    70018, 70018,
    70067, 70069,
    70079, 70080,
    70094, 70094,
    70188, 70190,
    70194, 70195,
    70197, 70197,
    70368, 70370,
    70402, 70403,
    70462, 70463,
    70465, 70468,
    70471, 70472,
    70475, 70477,
    70487, 70487,
    70498, 70499,
    70709, 70711,
    70720, 70721,
    70725, 70725,
    70832, 70834,
    70841, 70841,
    70843, 70846,
    70849, 70849,
    71087, 71089,
    71096, 71099,
    71102, 71102,
    71216, 71218,
    71227, 71228,
    71230, 71230,
    71340, 71340,
    71342, 71343,
    71350, 71350,
    71456, 71457,
    71462, 71462,
    71724, 71726,
    71736, 71736,
    71984, 71989,
    71991, 71992,
    71997, 71997,
    72000, 72000,
    72002, 72002,
    72145, 72147,
    72156, 72159,
    72164, 72164,
    72249, 72249,
    72279, 72280,
    72343, 72343,
    72751, 72751,
    72766, 72766,
    72873, 72873,
    72881, 72881,
    72884, 72884,
    73098, 73102,
    73107, 73108,
    73110, 73110,
    73461, 73462,
    73475, 73475,
    73524, 73525,
    73534, 73535,
    73537, 73537,
    94033, 94087,
    94192, 94193,
    119141, 119142,
    119149, 119154,
    0, 0
  };
  range["Mc"] = Mc;
  static const int Me[] = {
    1160, 1161,
    6846, 6846,
    8413, 8416,
    8418, 8420,
    42608, 42610,
    0, 0
  };
  range["Me"] = Me;
  static const int Medefaidrin[] = {
    93760, 93850,
    0, 0
  };
  range["Medefaidrin"] = Medefaidrin;
  static const int Meetei_Mayek[] = {
    43744, 43766,
    43968, 44013,
    44016, 44025,
    0, 0
  };
  range["Meetei_Mayek"] = Meetei_Mayek;
  static const int Mende_Kikakui[] = {
    124928, 125124,
    125127, 125142,
    0, 0
  };
  range["Mende_Kikakui"] = Mende_Kikakui;
  static const int Meroitic_Cursive[] = {
    68000, 68023,
    68028, 68047,
    68050, 68095,
    0, 0
  };
  range["Meroitic_Cursive"] = Meroitic_Cursive;
  static const int Meroitic_Hieroglyphs[] = {
    67968, 67999,
    0, 0
  };
  range["Meroitic_Hieroglyphs"] = Meroitic_Hieroglyphs;
  static const int Miao[] = {
    93952, 94026,
    94031, 94087,
    94095, 94111,
    0, 0
  };
  range["Miao"] = Miao;
  static const int Mn[] = {
    768, 879,
    1155, 1159,
    1425, 1469,
    1471, 1471,
    1473, 1474,
    1476, 1477,
    1479, 1479,
    1552, 1562,
    1611, 1631,
    1648, 1648,
    1750, 1756,
    1759, 1764,
    1767, 1768,
    1770, 1773,
    1809, 1809,
    1840, 1866,
    1958, 1968,
    2027, 2035,
    2045, 2045,
    2070, 2073,
    2075, 2083,
    2085, 2087,
    2089, 2093,
    2137, 2139,
    2200, 2207,
    2250, 2273,
    2275, 2306,
    2362, 2362,
    2364, 2364,
    2369, 2376,
    2381, 2381,
    2385, 2391,
    2402, 2403,
    2433, 2433,
    2492, 2492,
    2497, 2500,
    2509, 2509,
    2530, 2531,
    2558, 2558,
    2561, 2562,
    2620, 2620,
    2625, 2626,
    2631, 2632,
    2635, 2637,
    2641, 2641,
    2672, 2673,
    2677, 2677,
    2689, 2690,
    2748, 2748,
    2753, 2757,
    2759, 2760,
    2765, 2765,
    2786, 2787,
    2810, 2815,
    2817, 2817,
    2876, 2876,
    2879, 2879,
    2881, 2884,
    2893, 2893,
    2901, 2902,
    2914, 2915,
    2946, 2946,
    3008, 3008,
    3021, 3021,
    3072, 3072,
    3076, 3076,
    3132, 3132,
    3134, 3136,
    3142, 3144,
    3146, 3149,
    3157, 3158,
    3170, 3171,
    3201, 3201,
    3260, 3260,
    3263, 3263,
    3270, 3270,
    3276, 3277,
    3298, 3299,
    3328, 3329,
    3387, 3388,
    3393, 3396,
    3405, 3405,
    3426, 3427,
    3457, 3457,
    3530, 3530,
    3538, 3540,
    3542, 3542,
    3633, 3633,
    3636, 3642,
    3655, 3662,
    3761, 3761,
    3764, 3772,
    3784, 3790,
    3864, 3865,
    3893, 3893,
    3895, 3895,
    3897, 3897,
    3953, 3966,
    3968, 3972,
    3974, 3975,
    3981, 3991,
    3993, 4028,
    4038, 4038,
    4141, 4144,
    4146, 4151,
    4153, 4154,
    4157, 4158,
    4184, 4185,
    4190, 4192,
    4209, 4212,
    4226, 4226,
    4229, 4230,
    4237, 4237,
    4253, 4253,
    4957, 4959,
    5906, 5908,
    5938, 5939,
    5970, 5971,
    6002, 6003,
    6068, 6069,
    6071, 6077,
    6086, 6086,
    6089, 6099,
    6109, 6109,
    6155, 6157,
    6159, 6159,
    6277, 6278,
    6313, 6313,
    6432, 6434,
    6439, 6440,
    6450, 6450,
    6457, 6459,
    6679, 6680,
    6683, 6683,
    6742, 6742,
    6744, 6750,
    6752, 6752,
    6754, 6754,
    6757, 6764,
    6771, 6780,
    6783, 6783,
    6832, 6845,
    6847, 6862,
    6912, 6915,
    6964, 6964,
    6966, 6970,
    6972, 6972,
    6978, 6978,
    7019, 7027,
    7040, 7041,
    7074, 7077,
    7080, 7081,
    7083, 7085,
    7142, 7142,
    7144, 7145,
    7149, 7149,
    7151, 7153,
    7212, 7219,
    7222, 7223,
    7376, 7378,
    7380, 7392,
    7394, 7400,
    7405, 7405,
    7412, 7412,
    7416, 7417,
    7616, 7679,
    8400, 8412,
    8417, 8417,
    8421, 8432,
    11503, 11505,
    11647, 11647,
    11744, 11775,
    12330, 12333,
    12441, 12442,
    42607, 42607,
    42612, 42621,
    42654, 42655,
    42736, 42737,
    43010, 43010,
    43014, 43014,
    43019, 43019,
    43045, 43046,
    43052, 43052,
    43204, 43205,
    43232, 43249,
    43263, 43263,
    43302, 43309,
    43335, 43345,
    43392, 43394,
    43443, 43443,
    43446, 43449,
    43452, 43453,
    43493, 43493,
    43561, 43566,
    43569, 43570,
    43573, 43574,
    43587, 43587,
    43596, 43596,
    43644, 43644,
    43696, 43696,
    43698, 43700,
    43703, 43704,
    43710, 43711,
    43713, 43713,
    43756, 43757,
    43766, 43766,
    44005, 44005,
    44008, 44008,
    44013, 44013,
    64286, 64286,
    65024, 65039,
    65056, 65071,
    66045, 66045,
    66272, 66272,
    66422, 66426,
    68097, 68099,
    68101, 68102,
    68108, 68111,
    68152, 68154,
    68159, 68159,
    68325, 68326,
    68900, 68903,
    69291, 69292,
    69373, 69375,
    69446, 69456,
    69506, 69509,
    69633, 69633,
    69688, 69702,
    69744, 69744,
    69747, 69748,
    69759, 69761,
    69811, 69814,
    69817, 69818,
    69826, 69826,
    69888, 69890,
    69927, 69931,
    69933, 69940,
    70003, 70003,
    70016, 70017,
    70070, 70078,
    70089, 70092,
    70095, 70095,
    70191, 70193,
    70196, 70196,
    70198, 70199,
    70206, 70206,
    70209, 70209,
    70367, 70367,
    70371, 70378,
    70400, 70401,
    70459, 70460,
    70464, 70464,
    70502, 70508,
    70512, 70516,
    70712, 70719,
    70722, 70724,
    70726, 70726,
    70750, 70750,
    70835, 70840,
    70842, 70842,
    70847, 70848,
    70850, 70851,
    71090, 71093,
    71100, 71101,
    71103, 71104,
    71132, 71133,
    71219, 71226,
    71229, 71229,
    71231, 71232,
    71339, 71339,
    71341, 71341,
    71344, 71349,
    71351, 71351,
    71453, 71455,
    71458, 71461,
    71463, 71467,
    71727, 71735,
    71737, 71738,
    71995, 71996,
    71998, 71998,
    72003, 72003,
    72148, 72151,
    72154, 72155,
    72160, 72160,
    72193, 72202,
    72243, 72248,
    72251, 72254,
    72263, 72263,
    72273, 72278,
    72281, 72283,
    72330, 72342,
    72344, 72345,
    72752, 72758,
    72760, 72765,
    72767, 72767,
    72850, 72871,
    72874, 72880,
    72882, 72883,
    72885, 72886,
    73009, 73014,
    73018, 73018,
    73020, 73021,
    73023, 73029,
    73031, 73031,
    73104, 73105,
    73109, 73109,
    73111, 73111,
    73459, 73460,
    73472, 73473,
    73526, 73530,
    73536, 73536,
    73538, 73538,
    78912, 78912,
    78919, 78933,
    92912, 92916,
    92976, 92982,
    94031, 94031,
    94095, 94098,
    94180, 94180,
    113821, 113822,
    118528, 118573,
    118576, 118598,
    119143, 119145,
    119163, 119170,
    119173, 119179,
    119210, 119213,
    119362, 119364,
    121344, 121398,
    121403, 121452,
    121461, 121461,
    121476, 121476,
    121499, 121503,
    121505, 121519,
    122880, 122886,
    122888, 122904,
    122907, 122913,
    122915, 122916,
    122918, 122922,
    123023, 123023,
    123184, 123190,
    123566, 123566,
    123628, 123631,
    124140, 124143,
    125136, 125142,
    125252, 125258,
    917760, 917999,
    0, 0
  };
  range["Mn"] = Mn;
  static const int Modi[] = {
    71168, 71236,
    71248, 71257,
    0, 0
  };
  range["Modi"] = Modi;
  static const int Mongolian[] = {
    6144, 6145,
    6148, 6148,
    6150, 6169,
    6176, 6264,
    6272, 6314,
    71264, 71276,
    0, 0
  };
  range["Mongolian"] = Mongolian;
  static const int Mro[] = {
    92736, 92766,
    92768, 92777,
    92782, 92783,
    0, 0
  };
  range["Mro"] = Mro;
  static const int Multani[] = {
    70272, 70278,
    70280, 70280,
    70282, 70285,
    70287, 70301,
    70303, 70313,
    0, 0
  };
  range["Multani"] = Multani;
  static const int Myanmar[] = {
    4096, 4255,
    43488, 43518,
    43616, 43647,
    0, 0
  };
  range["Myanmar"] = Myanmar;
  static const int N[] = {
    48, 57,
    178, 179,
    185, 185,
    188, 190,
    1632, 1641,
    1776, 1785,
    1984, 1993,
    2406, 2415,
    2534, 2543,
    2548, 2553,
    2662, 2671,
    2790, 2799,
    2918, 2927,
    2930, 2935,
    3046, 3058,
    3174, 3183,
    3192, 3198,
    3302, 3311,
    3416, 3422,
    3430, 3448,
    3558, 3567,
    3664, 3673,
    3792, 3801,
    3872, 3891,
    4160, 4169,
    4240, 4249,
    4969, 4988,
    5870, 5872,
    6112, 6121,
    6128, 6137,
    6160, 6169,
    6470, 6479,
    6608, 6618,
    6784, 6793,
    6800, 6809,
    6992, 7001,
    7088, 7097,
    7232, 7241,
    7248, 7257,
    8304, 8304,
    8308, 8313,
    8320, 8329,
    8528, 8578,
    8581, 8585,
    9312, 9371,
    9450, 9471,
    10102, 10131,
    11517, 11517,
    12295, 12295,
    12321, 12329,
    12344, 12346,
    12690, 12693,
    12832, 12841,
    12872, 12879,
    12881, 12895,
    12928, 12937,
    12977, 12991,
    42528, 42537,
    42726, 42735,
    43056, 43061,
    43216, 43225,
    43264, 43273,
    43472, 43481,
    43504, 43513,
    43600, 43609,
    44016, 44025,
    65296, 65305,
    65799, 65843,
    65856, 65912,
    65930, 65931,
    66273, 66299,
    66336, 66339,
    66369, 66369,
    66378, 66378,
    66513, 66517,
    66720, 66729,
    67672, 67679,
    67705, 67711,
    67751, 67759,
    67835, 67839,
    67862, 67867,
    68028, 68029,
    68032, 68047,
    68050, 68095,
    68160, 68168,
    68221, 68222,
    68253, 68255,
    68331, 68335,
    68440, 68447,
    68472, 68479,
    68521, 68527,
    68858, 68863,
    68912, 68921,
    69216, 69246,
    69405, 69414,
    69457, 69460,
    69573, 69579,
    69714, 69743,
    69872, 69881,
    69942, 69951,
    70096, 70105,
    70113, 70132,
    70384, 70393,
    70736, 70745,
    70864, 70873,
    71248, 71257,
    71360, 71369,
    71472, 71483,
    71904, 71922,
    72016, 72025,
    72784, 72812,
    73040, 73049,
    73120, 73129,
    73552, 73561,
    73664, 73684,
    74752, 74862,
    92768, 92777,
    92864, 92873,
    93008, 93017,
    93019, 93025,
    93824, 93846,
    119488, 119507,
    119520, 119539,
    119648, 119672,
    120782, 120831,
    123200, 123209,
    123632, 123641,
    124144, 124153,
    125127, 125135,
    125264, 125273,
    126065, 126123,
    126125, 126127,
    126129, 126132,
    126209, 126253,
    126255, 126269,
    127232, 127244,
    130032, 130041,
    0, 0
  };
  range["N"] = N;
  static const int Nabataean[] = {
    67712, 67742,
    67751, 67759,
    0, 0
  };
  range["Nabataean"] = Nabataean;
  static const int Nag_Mundari[] = {
    124112, 124153,
    0, 0
  };
  range["Nag_Mundari"] = Nag_Mundari;
  static const int Nandinagari[] = {
    72096, 72103,
    72106, 72151,
    72154, 72164,
    0, 0
  };
  range["Nandinagari"] = Nandinagari;
  static const int Nd[] = {
    48, 57,
    1632, 1641,
    1776, 1785,
    1984, 1993,
    2406, 2415,
    2534, 2543,
    2662, 2671,
    2790, 2799,
    2918, 2927,
    3046, 3055,
    3174, 3183,
    3302, 3311,
    3430, 3439,
    3558, 3567,
    3664, 3673,
    3792, 3801,
    3872, 3881,
    4160, 4169,
    4240, 4249,
    6112, 6121,
    6160, 6169,
    6470, 6479,
    6608, 6617,
    6784, 6793,
    6800, 6809,
    6992, 7001,
    7088, 7097,
    7232, 7241,
    7248, 7257,
    42528, 42537,
    43216, 43225,
    43264, 43273,
    43472, 43481,
    43504, 43513,
    43600, 43609,
    44016, 44025,
    65296, 65305,
    66720, 66729,
    68912, 68921,
    69734, 69743,
    69872, 69881,
    69942, 69951,
    70096, 70105,
    70384, 70393,
    70736, 70745,
    70864, 70873,
    71248, 71257,
    71360, 71369,
    71472, 71481,
    71904, 71913,
    72016, 72025,
    72784, 72793,
    73040, 73049,
    73120, 73129,
    73552, 73561,
    92768, 92777,
    92864, 92873,
    93008, 93017,
    120782, 120831,
    123200, 123209,
    123632, 123641,
    124144, 124153,
    125264, 125273,
    130032, 130041,
    0, 0
  };
  range["Nd"] = Nd;
  static const int New_Tai_Lue[] = {
    6528, 6571,
    6576, 6601,
    6608, 6618,
    6622, 6623,
    0, 0
  };
  range["New_Tai_Lue"] = New_Tai_Lue;
  static const int Newa[] = {
    70656, 70747,
    70749, 70753,
    0, 0
  };
  range["Newa"] = Newa;
  static const int Nko[] = {
    1984, 2042,
    2045, 2047,
    0, 0
  };
  range["Nko"] = Nko;
  static const int Nl[] = {
    5870, 5872,
    8544, 8578,
    8581, 8584,
    12295, 12295,
    12321, 12329,
    12344, 12346,
    42726, 42735,
    65856, 65908,
    66369, 66369,
    66378, 66378,
    66513, 66517,
    74752, 74862,
    0, 0
  };
  range["Nl"] = Nl;
  static const int No[] = {
    178, 179,
    185, 185,
    188, 190,
    2548, 2553,
    2930, 2935,
    3056, 3058,
    3192, 3198,
    3416, 3422,
    3440, 3448,
    3882, 3891,
    4969, 4988,
    6128, 6137,
    6618, 6618,
    8304, 8304,
    8308, 8313,
    8320, 8329,
    8528, 8543,
    8585, 8585,
    9312, 9371,
    9450, 9471,
    10102, 10131,
    11517, 11517,
    12690, 12693,
    12832, 12841,
    12872, 12879,
    12881, 12895,
    12928, 12937,
    12977, 12991,
    43056, 43061,
    65799, 65843,
    65909, 65912,
    65930, 65931,
    66273, 66299,
    66336, 66339,
    67672, 67679,
    67705, 67711,
    67751, 67759,
    67835, 67839,
    67862, 67867,
    68028, 68029,
    68032, 68047,
    68050, 68095,
    68160, 68168,
    68221, 68222,
    68253, 68255,
    68331, 68335,
    68440, 68447,
    68472, 68479,
    68521, 68527,
    68858, 68863,
    69216, 69246,
    69405, 69414,
    69457, 69460,
    69573, 69579,
    69714, 69733,
    70113, 70132,
    71482, 71483,
    71914, 71922,
    72794, 72812,
    73664, 73684,
    93019, 93025,
    93824, 93846,
    119488, 119507,
    119520, 119539,
    119648, 119672,
    125127, 125135,
    126065, 126123,
    126125, 126127,
    126129, 126132,
    126209, 126253,
    126255, 126269,
    127232, 127244,
    0, 0
  };
  range["No"] = No;
  static const int Non_ASCII_Unicode[] = {
    128, 55295,
    57344, 1114111,
    0, 0
  };
  range["Non_ASCII_Unicode"] = Non_ASCII_Unicode;
  static const int Nushu[] = {
    94177, 94177,
    110960, 111355,
    0, 0
  };
  range["Nushu"] = Nushu;
  static const int Nyiakeng_Puachue_Hmong[] = {
    123136, 123180,
    123184, 123197,
    123200, 123209,
    123214, 123215,
    0, 0
  };
  range["Nyiakeng_Puachue_Hmong"] = Nyiakeng_Puachue_Hmong;
  static const int Ogham[] = {
    5760, 5788,
    0, 0
  };
  range["Ogham"] = Ogham;
  static const int Ol_Chiki[] = {
    7248, 7295,
    0, 0
  };
  range["Ol_Chiki"] = Ol_Chiki;
  static const int Old_Hungarian[] = {
    68736, 68786,
    68800, 68850,
    68858, 68863,
    0, 0
  };
  range["Old_Hungarian"] = Old_Hungarian;
  static const int Old_Italic[] = {
    66304, 66339,
    66349, 66351,
    0, 0
  };
  range["Old_Italic"] = Old_Italic;
  static const int Old_North_Arabian[] = {
    68224, 68255,
    0, 0
  };
  range["Old_North_Arabian"] = Old_North_Arabian;
  static const int Old_Permic[] = {
    66384, 66426,
    0, 0
  };
  range["Old_Permic"] = Old_Permic;
  static const int Old_Persian[] = {
    66464, 66499,
    66504, 66517,
    0, 0
  };
  range["Old_Persian"] = Old_Persian;
  static const int Old_Sogdian[] = {
    69376, 69415,
    0, 0
  };
  range["Old_Sogdian"] = Old_Sogdian;
  static const int Old_South_Arabian[] = {
    68192, 68223,
    0, 0
  };
  range["Old_South_Arabian"] = Old_South_Arabian;
  static const int Old_Turkic[] = {
    68608, 68680,
    0, 0
  };
  range["Old_Turkic"] = Old_Turkic;
  static const int Old_Uyghur[] = {
    69488, 69513,
    0, 0
  };
  range["Old_Uyghur"] = Old_Uyghur;
  static const int Oriya[] = {
    2817, 2819,
    2821, 2828,
    2831, 2832,
    2835, 2856,
    2858, 2864,
    2866, 2867,
    2869, 2873,
    2876, 2884,
    2887, 2888,
    2891, 2893,
    2901, 2903,
    2908, 2909,
    2911, 2915,
    2918, 2935,
    0, 0
  };
  range["Oriya"] = Oriya;
  static const int Osage[] = {
    66736, 66771,
    66776, 66811,
    0, 0
  };
  range["Osage"] = Osage;
  static const int Osmanya[] = {
    66688, 66717,
    66720, 66729,
    0, 0
  };
  range["Osmanya"] = Osmanya;
  static const int P[] = {
    33, 35,
    37, 42,
    44, 47,
    58, 59,
    63, 64,
    91, 93,
    95, 95,
    123, 123,
    125, 125,
    161, 161,
    167, 167,
    171, 171,
    182, 183,
    187, 187,
    191, 191,
    894, 894,
    903, 903,
    1370, 1375,
    1417, 1418,
    1470, 1470,
    1472, 1472,
    1475, 1475,
    1478, 1478,
    1523, 1524,
    1545, 1546,
    1548, 1549,
    1563, 1563,
    1565, 1567,
    1642, 1645,
    1748, 1748,
    1792, 1805,
    2039, 2041,
    2096, 2110,
    2142, 2142,
    2404, 2405,
    2416, 2416,
    2557, 2557,
    2678, 2678,
    2800, 2800,
    3191, 3191,
    3204, 3204,
    3572, 3572,
    3663, 3663,
    3674, 3675,
    3844, 3858,
    3860, 3860,
    3898, 3901,
    3973, 3973,
    4048, 4052,
    4057, 4058,
    4170, 4175,
    4347, 4347,
    4960, 4968,
    5120, 5120,
    5742, 5742,
    5787, 5788,
    5867, 5869,
    5941, 5942,
    6100, 6102,
    6104, 6106,
    6144, 6154,
    6468, 6469,
    6686, 6687,
    6816, 6822,
    6824, 6829,
    7002, 7008,
    7037, 7038,
    7164, 7167,
    7227, 7231,
    7294, 7295,
    7360, 7367,
    7379, 7379,
    8208, 8231,
    8240, 8259,
    8261, 8273,
    8275, 8286,
    8317, 8318,
    8333, 8334,
    8968, 8971,
    9001, 9002,
    10088, 10101,
    10181, 10182,
    10214, 10223,
    10627, 10648,
    10712, 10715,
    10748, 10749,
    11513, 11516,
    11518, 11519,
    11632, 11632,
    11776, 11822,
    11824, 11855,
    11858, 11869,
    12289, 12291,
    12296, 12305,
    12308, 12319,
    12336, 12336,
    12349, 12349,
    12448, 12448,
    12539, 12539,
    42238, 42239,
    42509, 42511,
    42611, 42611,
    42622, 42622,
    42738, 42743,
    43124, 43127,
    43214, 43215,
    43256, 43258,
    43260, 43260,
    43310, 43311,
    43359, 43359,
    43457, 43469,
    43486, 43487,
    43612, 43615,
    43742, 43743,
    43760, 43761,
    44011, 44011,
    64830, 64831,
    65040, 65049,
    65072, 65106,
    65108, 65121,
    65123, 65123,
    65128, 65128,
    65130, 65131,
    65281, 65283,
    65285, 65290,
    65292, 65295,
    65306, 65307,
    65311, 65312,
    65339, 65341,
    65343, 65343,
    65371, 65371,
    65373, 65373,
    65375, 65381,
    65792, 65794,
    66463, 66463,
    66512, 66512,
    66927, 66927,
    67671, 67671,
    67871, 67871,
    67903, 67903,
    68176, 68184,
    68223, 68223,
    68336, 68342,
    68409, 68415,
    68505, 68508,
    69293, 69293,
    69461, 69465,
    69510, 69513,
    69703, 69709,
    69819, 69820,
    69822, 69825,
    69952, 69955,
    70004, 70005,
    70085, 70088,
    70093, 70093,
    70107, 70107,
    70109, 70111,
    70200, 70205,
    70313, 70313,
    70731, 70735,
    70746, 70747,
    70749, 70749,
    70854, 70854,
    71105, 71127,
    71233, 71235,
    71264, 71276,
    71353, 71353,
    71484, 71486,
    71739, 71739,
    72004, 72006,
    72162, 72162,
    72255, 72262,
    72346, 72348,
    72350, 72354,
    72448, 72457,
    72769, 72773,
    72816, 72817,
    73463, 73464,
    73539, 73551,
    73727, 73727,
    74864, 74868,
    77809, 77810,
    92782, 92783,
    92917, 92917,
    92983, 92987,
    92996, 92996,
    93847, 93850,
    94178, 94178,
    113823, 113823,
    121479, 121483,
    125278, 125279,
    0, 0
  };
  range["P"] = P;
  static const int Pahawh_Hmong[] = {
    92928, 92997,
    93008, 93017,
    93019, 93025,
    93027, 93047,
    93053, 93071,
    0, 0
  };
  range["Pahawh_Hmong"] = Pahawh_Hmong;
  static const int Palmyrene[] = {
    67680, 67711,
    0, 0
  };
  range["Palmyrene"] = Palmyrene;
  static const int Pau_Cin_Hau[] = {
    72384, 72440,
    0, 0
  };
  range["Pau_Cin_Hau"] = Pau_Cin_Hau;
  static const int Pc[] = {
    95, 95,
    8255, 8256,
    8276, 8276,
    65075, 65076,
    65101, 65103,
    65343, 65343,
    0, 0
  };
  range["Pc"] = Pc;
  static const int Pd[] = {
    45, 45,
    1418, 1418,
    1470, 1470,
    5120, 5120,
    6150, 6150,
    8208, 8213,
    11799, 11799,
    11802, 11802,
    11834, 11835,
    11840, 11840,
    11869, 11869,
    12316, 12316,
    12336, 12336,
    12448, 12448,
    65073, 65074,
    65112, 65112,
    65123, 65123,
    65293, 65293,
    69293, 69293,
    0, 0
  };
  range["Pd"] = Pd;
  static const int Pe[] = {
    41, 41,
    93, 93,
    125, 125,
    3899, 3899,
    3901, 3901,
    5788, 5788,
    8262, 8262,
    8318, 8318,
    8334, 8334,
    8969, 8969,
    8971, 8971,
    9002, 9002,
    10089, 10089,
    10091, 10091,
    10093, 10093,
    10095, 10095,
    10097, 10097,
    10099, 10099,
    10101, 10101,
    10182, 10182,
    10215, 10215,
    10217, 10217,
    10219, 10219,
    10221, 10221,
    10223, 10223,
    10628, 10628,
    10630, 10630,
    10632, 10632,
    10634, 10634,
    10636, 10636,
    10638, 10638,
    10640, 10640,
    10642, 10642,
    10644, 10644,
    10646, 10646,
    10648, 10648,
    10713, 10713,
    10715, 10715,
    10749, 10749,
    11811, 11811,
    11813, 11813,
    11815, 11815,
    11817, 11817,
    11862, 11862,
    11864, 11864,
    11866, 11866,
    11868, 11868,
    12297, 12297,
    12299, 12299,
    12301, 12301,
    12303, 12303,
    12305, 12305,
    12309, 12309,
    12311, 12311,
    12313, 12313,
    12315, 12315,
    12318, 12319,
    64830, 64830,
    65048, 65048,
    65078, 65078,
    65080, 65080,
    65082, 65082,
    65084, 65084,
    65086, 65086,
    65088, 65088,
    65090, 65090,
    65092, 65092,
    65096, 65096,
    65114, 65114,
    65116, 65116,
    65118, 65118,
    65289, 65289,
    65341, 65341,
    65373, 65373,
    65376, 65376,
    65379, 65379,
    0, 0
  };
  range["Pe"] = Pe;
  static const int Pf[] = {
    187, 187,
    8217, 8217,
    8221, 8221,
    8250, 8250,
    11779, 11779,
    11781, 11781,
    11786, 11786,
    11789, 11789,
    11805, 11805,
    11809, 11809,
    0, 0
  };
  range["Pf"] = Pf;
  static const int Phags_Pa[] = {
    43072, 43127,
    0, 0
  };
  range["Phags_Pa"] = Phags_Pa;
  static const int Phoenician[] = {
    67840, 67867,
    67871, 67871,
    0, 0
  };
  range["Phoenician"] = Phoenician;
  static const int Pi[] = {
    171, 171,
    8216, 8216,
    8219, 8220,
    8223, 8223,
    8249, 8249,
    11778, 11778,
    11780, 11780,
    11785, 11785,
    11788, 11788,
    11804, 11804,
    11808, 11808,
    0, 0
  };
  range["Pi"] = Pi;
  static const int Po[] = {
    33, 35,
    37, 39,
    42, 42,
    44, 44,
    46, 47,
    58, 59,
    63, 64,
    92, 92,
    161, 161,
    167, 167,
    182, 183,
    191, 191,
    894, 894,
    903, 903,
    1370, 1375,
    1417, 1417,
    1472, 1472,
    1475, 1475,
    1478, 1478,
    1523, 1524,
    1545, 1546,
    1548, 1549,
    1563, 1563,
    1565, 1567,
    1642, 1645,
    1748, 1748,
    1792, 1805,
    2039, 2041,
    2096, 2110,
    2142, 2142,
    2404, 2405,
    2416, 2416,
    2557, 2557,
    2678, 2678,
    2800, 2800,
    3191, 3191,
    3204, 3204,
    3572, 3572,
    3663, 3663,
    3674, 3675,
    3844, 3858,
    3860, 3860,
    3973, 3973,
    4048, 4052,
    4057, 4058,
    4170, 4175,
    4347, 4347,
    4960, 4968,
    5742, 5742,
    5867, 5869,
    5941, 5942,
    6100, 6102,
    6104, 6106,
    6144, 6149,
    6151, 6154,
    6468, 6469,
    6686, 6687,
    6816, 6822,
    6824, 6829,
    7002, 7008,
    7037, 7038,
    7164, 7167,
    7227, 7231,
    7294, 7295,
    7360, 7367,
    7379, 7379,
    8214, 8215,
    8224, 8231,
    8240, 8248,
    8251, 8254,
    8257, 8259,
    8263, 8273,
    8275, 8275,
    8277, 8286,
    11513, 11516,
    11518, 11519,
    11632, 11632,
    11776, 11777,
    11782, 11784,
    11787, 11787,
    11790, 11798,
    11800, 11801,
    11803, 11803,
    11806, 11807,
    11818, 11822,
    11824, 11833,
    11836, 11839,
    11841, 11841,
    11843, 11855,
    11858, 11860,
    12289, 12291,
    12349, 12349,
    12539, 12539,
    42238, 42239,
    42509, 42511,
    42611, 42611,
    42622, 42622,
    42738, 42743,
    43124, 43127,
    43214, 43215,
    43256, 43258,
    43260, 43260,
    43310, 43311,
    43359, 43359,
    43457, 43469,
    43486, 43487,
    43612, 43615,
    43742, 43743,
    43760, 43761,
    44011, 44011,
    65040, 65046,
    65049, 65049,
    65072, 65072,
    65093, 65094,
    65097, 65100,
    65104, 65106,
    65108, 65111,
    65119, 65121,
    65128, 65128,
    65130, 65131,
    65281, 65283,
    65285, 65287,
    65290, 65290,
    65292, 65292,
    65294, 65295,
    65306, 65307,
    65311, 65312,
    65340, 65340,
    65377, 65377,
    65380, 65381,
    65792, 65794,
    66463, 66463,
    66512, 66512,
    66927, 66927,
    67671, 67671,
    67871, 67871,
    67903, 67903,
    68176, 68184,
    68223, 68223,
    68336, 68342,
    68409, 68415,
    68505, 68508,
    69461, 69465,
    69510, 69513,
    69703, 69709,
    69819, 69820,
    69822, 69825,
    69952, 69955,
    70004, 70005,
    70085, 70088,
    70093, 70093,
    70107, 70107,
    70109, 70111,
    70200, 70205,
    70313, 70313,
    70731, 70735,
    70746, 70747,
    70749, 70749,
    70854, 70854,
    71105, 71127,
    71233, 71235,
    71264, 71276,
    71353, 71353,
    71484, 71486,
    71739, 71739,
    72004, 72006,
    72162, 72162,
    72255, 72262,
    72346, 72348,
    72350, 72354,
    72448, 72457,
    72769, 72773,
    72816, 72817,
    73463, 73464,
    73539, 73551,
    73727, 73727,
    74864, 74868,
    77809, 77810,
    92782, 92783,
    92917, 92917,
    92983, 92987,
    92996, 92996,
    93847, 93850,
    94178, 94178,
    113823, 113823,
    121479, 121483,
    125278, 125279,
    0, 0
  };
  range["Po"] = Po;
  static const int Ps[] = {
    40, 40,
    91, 91,
    123, 123,
    3898, 3898,
    3900, 3900,
    5787, 5787,
    8218, 8218,
    8222, 8222,
    8261, 8261,
    8317, 8317,
    8333, 8333,
    8968, 8968,
    8970, 8970,
    9001, 9001,
    10088, 10088,
    10090, 10090,
    10092, 10092,
    10094, 10094,
    10096, 10096,
    10098, 10098,
    10100, 10100,
    10181, 10181,
    10214, 10214,
    10216, 10216,
    10218, 10218,
    10220, 10220,
    10222, 10222,
    10627, 10627,
    10629, 10629,
    10631, 10631,
    10633, 10633,
    10635, 10635,
    10637, 10637,
    10639, 10639,
    10641, 10641,
    10643, 10643,
    10645, 10645,
    10647, 10647,
    10712, 10712,
    10714, 10714,
    10748, 10748,
    11810, 11810,
    11812, 11812,
    11814, 11814,
    11816, 11816,
    11842, 11842,
    11861, 11861,
    11863, 11863,
    11865, 11865,
    11867, 11867,
    12296, 12296,
    12298, 12298,
    12300, 12300,
    12302, 12302,
    12304, 12304,
    12308, 12308,
    12310, 12310,
    12312, 12312,
    12314, 12314,
    12317, 12317,
    64831, 64831,
    65047, 65047,
    65077, 65077,
    65079, 65079,
    65081, 65081,
    65083, 65083,
    65085, 65085,
    65087, 65087,
    65089, 65089,
    65091, 65091,
    65095, 65095,
    65113, 65113,
    65115, 65115,
    65117, 65117,
    65288, 65288,
    65339, 65339,
    65371, 65371,
    65375, 65375,
    65378, 65378,
    0, 0
  };
  range["Ps"] = Ps;
  static const int Psalter_Pahlavi[] = {
    68480, 68497,
    68505, 68508,
    68521, 68527,
    0, 0
  };
  range["Psalter_Pahlavi"] = Psalter_Pahlavi;
  static const int PythonIdentifierPart[] = {
    48, 57,
    65, 90,
    95, 95,
    97, 122,
    170, 170,
    181, 181,
    183, 183,
    186, 186,
    192, 214,
    216, 246,
    248, 705,
    710, 721,
    736, 740,
    748, 748,
    750, 750,
    768, 884,
    886, 887,
    890, 893,
    895, 895,
    902, 906,
    908, 908,
    910, 929,
    931, 1013,
    1015, 1153,
    1155, 1159,
    1162, 1327,
    1329, 1366,
    1369, 1369,
    1376, 1416,
    1425, 1469,
    1471, 1471,
    1473, 1474,
    1476, 1477,
    1479, 1479,
    1488, 1514,
    1519, 1522,
    1552, 1562,
    1568, 1641,
    1646, 1747,
    1749, 1756,
    1759, 1768,
    1770, 1788,
    1791, 1791,
    1808, 1866,
    1869, 1969,
    1984, 2037,
    2042, 2042,
    2045, 2045,
    2048, 2093,
    2112, 2139,
    2144, 2154,
    2160, 2183,
    2185, 2190,
    2200, 2273,
    2275, 2403,
    2406, 2415,
    2417, 2435,
    2437, 2444,
    2447, 2448,
    2451, 2472,
    2474, 2480,
    2482, 2482,
    2486, 2489,
    2492, 2500,
    2503, 2504,
    2507, 2510,
    2519, 2519,
    2524, 2525,
    2527, 2531,
    2534, 2545,
    2556, 2556,
    2558, 2558,
    2561, 2563,
    2565, 2570,
    2575, 2576,
    2579, 2600,
    2602, 2608,
    2610, 2611,
    2613, 2614,
    2616, 2617,
    2620, 2620,
    2622, 2626,
    2631, 2632,
    2635, 2637,
    2641, 2641,
    2649, 2652,
    2654, 2654,
    2662, 2677,
    2689, 2691,
    2693, 2701,
    2703, 2705,
    2707, 2728,
    2730, 2736,
    2738, 2739,
    2741, 2745,
    2748, 2757,
    2759, 2761,
    2763, 2765,
    2768, 2768,
    2784, 2787,
    2790, 2799,
    2809, 2815,
    2817, 2819,
    2821, 2828,
    2831, 2832,
    2835, 2856,
    2858, 2864,
    2866, 2867,
    2869, 2873,
    2876, 2884,
    2887, 2888,
    2891, 2893,
    2901, 2903,
    2908, 2909,
    2911, 2915,
    2918, 2927,
    2929, 2929,
    2946, 2947,
    2949, 2954,
    2958, 2960,
    2962, 2965,
    2969, 2970,
    2972, 2972,
    2974, 2975,
    2979, 2980,
    2984, 2986,
    2990, 3001,
    3006, 3010,
    3014, 3016,
    3018, 3021,
    3024, 3024,
    3031, 3031,
    3046, 3055,
    3072, 3084,
    3086, 3088,
    3090, 3112,
    3114, 3129,
    3132, 3140,
    3142, 3144,
    3146, 3149,
    3157, 3158,
    3160, 3162,
    3165, 3165,
    3168, 3171,
    3174, 3183,
    3200, 3203,
    3205, 3212,
    3214, 3216,
    3218, 3240,
    3242, 3251,
    3253, 3257,
    3260, 3268,
    3270, 3272,
    3274, 3277,
    3285, 3286,
    3293, 3294,
    3296, 3299,
    3302, 3311,
    3313, 3315,
    3328, 3340,
    3342, 3344,
    3346, 3396,
    3398, 3400,
    3402, 3406,
    3412, 3415,
    3423, 3427,
    3430, 3439,
    3450, 3455,
    3457, 3459,
    3461, 3478,
    3482, 3505,
    3507, 3515,
    3517, 3517,
    3520, 3526,
    3530, 3530,
    3535, 3540,
    3542, 3542,
    3544, 3551,
    3558, 3567,
    3570, 3571,
    3585, 3642,
    3648, 3662,
    3664, 3673,
    3713, 3714,
    3716, 3716,
    3718, 3722,
    3724, 3747,
    3749, 3749,
    3751, 3773,
    3776, 3780,
    3782, 3782,
    3784, 3790,
    3792, 3801,
    3804, 3807,
    3840, 3840,
    3864, 3865,
    3872, 3881,
    3893, 3893,
    3895, 3895,
    3897, 3897,
    3902, 3911,
    3913, 3948,
    3953, 3972,
    3974, 3991,
    3993, 4028,
    4038, 4038,
    4096, 4169,
    4176, 4253,
    4256, 4293,
    4295, 4295,
    4301, 4301,
    4304, 4346,
    4348, 4680,
    4682, 4685,
    4688, 4694,
    4696, 4696,
    4698, 4701,
    4704, 4744,
    4746, 4749,
    4752, 4784,
    4786, 4789,
    4792, 4798,
    4800, 4800,
    4802, 4805,
    4808, 4822,
    4824, 4880,
    4882, 4885,
    4888, 4954,
    4957, 4959,
    4969, 4977,
    4992, 5007,
    5024, 5109,
    5112, 5117,
    5121, 5740,
    5743, 5759,
    5761, 5786,
    5792, 5866,
    5870, 5880,
    5888, 5909,
    5919, 5940,
    5952, 5971,
    5984, 5996,
    5998, 6000,
    6002, 6003,
    6016, 6099,
    6103, 6103,
    6108, 6109,
    6112, 6121,
    6155, 6157,
    6159, 6169,
    6176, 6264,
    6272, 6314,
    6320, 6389,
    6400, 6430,
    6432, 6443,
    6448, 6459,
    6470, 6509,
    6512, 6516,
    6528, 6571,
    6576, 6601,
    6608, 6618,
    6656, 6683,
    6688, 6750,
    6752, 6780,
    6783, 6793,
    6800, 6809,
    6823, 6823,
    6832, 6845,
    6847, 6862,
    6912, 6988,
    6992, 7001,
    7019, 7027,
    7040, 7155,
    7168, 7223,
    7232, 7241,
    7245, 7293,
    7296, 7304,
    7312, 7354,
    7357, 7359,
    7376, 7378,
    7380, 7418,
    7424, 7957,
    7960, 7965,
    7968, 8005,
    8008, 8013,
    8016, 8023,
    8025, 8025,
    8027, 8027,
    8029, 8029,
    8031, 8061,
    8064, 8116,
    8118, 8124,
    8126, 8126,
    8130, 8132,
    8134, 8140,
    8144, 8147,
    8150, 8155,
    8160, 8172,
    8178, 8180,
    8182, 8188,
    8255, 8256,
    8276, 8276,
    8305, 8305,
    8319, 8319,
    8336, 8348,
    8400, 8412,
    8417, 8417,
    8421, 8432,
    8450, 8450,
    8455, 8455,
    8458, 8467,
    8469, 8469,
    8473, 8477,
    8484, 8484,
    8486, 8486,
    8488, 8488,
    8490, 8493,
    8495, 8505,
    8508, 8511,
    8517, 8521,
    8526, 8526,
    8544, 8584,
    11264, 11492,
    11499, 11507,
    11520, 11557,
    11559, 11559,
    11565, 11565,
    11568, 11623,
    11631, 11631,
    11647, 11670,
    11680, 11686,
    11688, 11694,
    11696, 11702,
    11704, 11710,
    11712, 11718,
    11720, 11726,
    11728, 11734,
    11736, 11742,
    11744, 11775,
    11823, 11823,
    12293, 12295,
    12321, 12335,
    12337, 12341,
    12344, 12348,
    12353, 12438,
    12441, 12442,
    12445, 12447,
    12449, 12538,
    12540, 12543,
    12549, 12591,
    12593, 12686,
    12704, 12735,
    12784, 12799,
    13312, 19903,
    19968, 42124,
    42192, 42237,
    42240, 42508,
    42512, 42539,
    42560, 42607,
    42612, 42621,
    42623, 42737,
    42775, 42783,
    42786, 42888,
    42891, 42954,
    42960, 42961,
    42963, 42963,
    42965, 42969,
    42994, 43047,
    43052, 43052,
    43072, 43123,
    43136, 43205,
    43216, 43225,
    43232, 43255,
    43259, 43259,
    43261, 43309,
    43312, 43347,
    43360, 43388,
    43392, 43456,
    43471, 43481,
    43488, 43518,
    43520, 43574,
    43584, 43597,
    43600, 43609,
    43616, 43638,
    43642, 43714,
    43739, 43741,
    43744, 43759,
    43762, 43766,
    43777, 43782,
    43785, 43790,
    43793, 43798,
    43808, 43814,
    43816, 43822,
    43824, 43866,
    43868, 43881,
    43888, 44010,
    44012, 44013,
    44016, 44025,
    44032, 55203,
    55216, 55238,
    55243, 55291,
    63744, 64109,
    64112, 64217,
    64256, 64262,
    64275, 64279,
    64285, 64296,
    64298, 64310,
    64312, 64316,
    64318, 64318,
    64320, 64321,
    64323, 64324,
    64326, 64433,
    64467, 64829,
    64848, 64911,
    64914, 64967,
    65008, 65019,
    65024, 65039,
    65056, 65071,
    65075, 65076,
    65101, 65103,
    65136, 65140,
    65142, 65276,
    65296, 65305,
    65313, 65338,
    65343, 65343,
    65345, 65370,
    65382, 65470,
    65474, 65479,
    65482, 65487,
    65490, 65495,
    65498, 65500,
    65536, 65547,
    65549, 65574,
    65576, 65594,
    65596, 65597,
    65599, 65613,
    65616, 65629,
    65664, 65786,
    65856, 65908,
    66045, 66045,
    66176, 66204,
    66208, 66256,
    66272, 66272,
    66304, 66335,
    66349, 66378,
    66384, 66426,
    66432, 66461,
    66464, 66499,
    66504, 66511,
    66513, 66517,
    66560, 66717,
    66720, 66729,
    66736, 66771,
    66776, 66811,
    66816, 66855,
    66864, 66915,
    66928, 66938,
    66940, 66954,
    66956, 66962,
    66964, 66965,
    66967, 66977,
    66979, 66993,
    66995, 67001,
    67003, 67004,
    67072, 67382,
    67392, 67413,
    67424, 67431,
    67456, 67461,
    67463, 67504,
    67506, 67514,
    67584, 67589,
    67592, 67592,
    67594, 67637,
    67639, 67640,
    67644, 67644,
    67647, 67669,
    67680, 67702,
    67712, 67742,
    67808, 67826,
    67828, 67829,
    67840, 67861,
    67872, 67897,
    67968, 68023,
    68030, 68031,
    68096, 68099,
    68101, 68102,
    68108, 68115,
    68117, 68119,
    68121, 68149,
    68152, 68154,
    68159, 68159,
    68192, 68220,
    68224, 68252,
    68288, 68295,
    68297, 68326,
    68352, 68405,
    68416, 68437,
    68448, 68466,
    68480, 68497,
    68608, 68680,
    68736, 68786,
    68800, 68850,
    68864, 68903,
    68912, 68921,
    69248, 69289,
    69291, 69292,
    69296, 69297,
    69373, 69404,
    69415, 69415,
    69424, 69456,
    69488, 69509,
    69552, 69572,
    69600, 69622,
    69632, 69702,
    69734, 69749,
    69759, 69818,
    69826, 69826,
    69840, 69864,
    69872, 69881,
    69888, 69940,
    69942, 69951,
    69956, 69959,
    69968, 70003,
    70006, 70006,
    70016, 70084,
    70089, 70092,
    70094, 70106,
    70108, 70108,
    70144, 70161,
    70163, 70199,
    70206, 70209,
    70272, 70278,
    70280, 70280,
    70282, 70285,
    70287, 70301,
    70303, 70312,
    70320, 70378,
    70384, 70393,
    70400, 70403,
    70405, 70412,
    70415, 70416,
    70419, 70440,
    70442, 70448,
    70450, 70451,
    70453, 70457,
    70459, 70468,
    70471, 70472,
    70475, 70477,
    70480, 70480,
    70487, 70487,
    70493, 70499,
    70502, 70508,
    70512, 70516,
    70656, 70730,
    70736, 70745,
    70750, 70753,
    70784, 70853,
    70855, 70855,
    70864, 70873,
    71040, 71093,
    71096, 71104,
    71128, 71133,
    71168, 71232,
    71236, 71236,
    71248, 71257,
    71296, 71352,
    71360, 71369,
    71424, 71450,
    71453, 71467,
    71472, 71481,
    71488, 71494,
    71680, 71738,
    71840, 71913,
    71935, 71942,
    71945, 71945,
    71948, 71955,
    71957, 71958,
    71960, 71989,
    71991, 71992,
    71995, 72003,
    72016, 72025,
    72096, 72103,
    72106, 72151,
    72154, 72161,
    72163, 72164,
    72192, 72254,
    72263, 72263,
    72272, 72345,
    72349, 72349,
    72368, 72440,
    72704, 72712,
    72714, 72758,
    72760, 72768,
    72784, 72793,
    72818, 72847,
    72850, 72871,
    72873, 72886,
    72960, 72966,
    72968, 72969,
    72971, 73014,
    73018, 73018,
    73020, 73021,
    73023, 73031,
    73040, 73049,
    73056, 73061,
    73063, 73064,
    73066, 73102,
    73104, 73105,
    73107, 73112,
    73120, 73129,
    73440, 73462,
    73472, 73488,
    73490, 73530,
    73534, 73538,
    73552, 73561,
    73648, 73648,
    73728, 74649,
    74752, 74862,
    74880, 75075,
    77712, 77808,
    77824, 78895,
    78912, 78933,
    82944, 83526,
    92160, 92728,
    92736, 92766,
    92768, 92777,
    92784, 92862,
    92864, 92873,
    92880, 92909,
    92912, 92916,
    92928, 92982,
    92992, 92995,
    93008, 93017,
    93027, 93047,
    93053, 93071,
    93760, 93823,
    93952, 94026,
    94031, 94087,
    94095, 94111,
    94176, 94177,
    94179, 94180,
    94192, 94193,
    94208, 100343,
    100352, 101589,
    101632, 101640,
    110576, 110579,
    110581, 110587,
    110589, 110590,
    110592, 110882,
    110898, 110898,
    110928, 110930,
    110933, 110933,
    110948, 110951,
    110960, 111355,
    113664, 113770,
    113776, 113788,
    113792, 113800,
    113808, 113817,
    113821, 113822,
    118528, 118573,
    118576, 118598,
    119141, 119145,
    119149, 119154,
    119163, 119170,
    119173, 119179,
    119210, 119213,
    119362, 119364,
    119808, 119892,
    119894, 119964,
    119966, 119967,
    119970, 119970,
    119973, 119974,
    119977, 119980,
    119982, 119993,
    119995, 119995,
    119997, 120003,
    120005, 120069,
    120071, 120074,
    120077, 120084,
    120086, 120092,
    120094, 120121,
    120123, 120126,
    120128, 120132,
    120134, 120134,
    120138, 120144,
    120146, 120485,
    120488, 120512,
    120514, 120538,
    120540, 120570,
    120572, 120596,
    120598, 120628,
    120630, 120654,
    120656, 120686,
    120688, 120712,
    120714, 120744,
    120746, 120770,
    120772, 120779,
    120782, 120831,
    121344, 121398,
    121403, 121452,
    121461, 121461,
    121476, 121476,
    121499, 121503,
    121505, 121519,
    122624, 122654,
    122661, 122666,
    122880, 122886,
    122888, 122904,
    122907, 122913,
    122915, 122916,
    122918, 122922,
    122928, 122989,
    123023, 123023,
    123136, 123180,
    123184, 123197,
    123200, 123209,
    123214, 123214,
    123536, 123566,
    123584, 123641,
    124112, 124153,
    124896, 124902,
    124904, 124907,
    124909, 124910,
    124912, 124926,
    124928, 125124,
    125136, 125142,
    125184, 125259,
    125264, 125273,
    126464, 126467,
    126469, 126495,
    126497, 126498,
    126500, 126500,
    126503, 126503,
    126505, 126514,
    126516, 126519,
    126521, 126521,
    126523, 126523,
    126530, 126530,
    126535, 126535,
    126537, 126537,
    126539, 126539,
    126541, 126543,
    126545, 126546,
    126548, 126548,
    126551, 126551,
    126553, 126553,
    126555, 126555,
    126557, 126557,
    126559, 126559,
    126561, 126562,
    126564, 126564,
    126567, 126570,
    126572, 126578,
    126580, 126583,
    126585, 126588,
    126590, 126590,
    126592, 126601,
    126603, 126619,
    126625, 126627,
    126629, 126633,
    126635, 126651,
    130032, 130041,
    131072, 173791,
    173824, 177977,
    177984, 178205,
    178208, 183969,
    183984, 191456,
    191472, 192093,
    194560, 195101,
    196608, 201546,
    201552, 205743,
    917760, 917999,
    0, 0
  };
  range["PythonIdentifierPart"] = PythonIdentifierPart;
  static const int PythonIdentifierStart[] = {
    65, 90,
    97, 122,
    170, 170,
    181, 181,
    186, 186,
    192, 214,
    216, 246,
    248, 705,
    710, 721,
    736, 740,
    748, 748,
    750, 750,
    880, 884,
    886, 887,
    890, 893,
    895, 895,
    902, 902,
    904, 906,
    908, 908,
    910, 929,
    931, 1013,
    1015, 1153,
    1162, 1327,
    1329, 1366,
    1369, 1369,
    1376, 1416,
    1488, 1514,
    1519, 1522,
    1568, 1610,
    1646, 1647,
    1649, 1747,
    1749, 1749,
    1765, 1766,
    1774, 1775,
    1786, 1788,
    1791, 1791,
    1808, 1808,
    1810, 1839,
    1869, 1957,
    1969, 1969,
    1994, 2026,
    2036, 2037,
    2042, 2042,
    2048, 2069,
    2074, 2074,
    2084, 2084,
    2088, 2088,
    2112, 2136,
    2144, 2154,
    2160, 2183,
    2185, 2190,
    2208, 2249,
    2308, 2361,
    2365, 2365,
    2384, 2384,
    2392, 2401,
    2417, 2432,
    2437, 2444,
    2447, 2448,
    2451, 2472,
    2474, 2480,
    2482, 2482,
    2486, 2489,
    2493, 2493,
    2510, 2510,
    2524, 2525,
    2527, 2529,
    2544, 2545,
    2556, 2556,
    2565, 2570,
    2575, 2576,
    2579, 2600,
    2602, 2608,
    2610, 2611,
    2613, 2614,
    2616, 2617,
    2649, 2652,
    2654, 2654,
    2674, 2676,
    2693, 2701,
    2703, 2705,
    2707, 2728,
    2730, 2736,
    2738, 2739,
    2741, 2745,
    2749, 2749,
    2768, 2768,
    2784, 2785,
    2809, 2809,
    2821, 2828,
    2831, 2832,
    2835, 2856,
    2858, 2864,
    2866, 2867,
    2869, 2873,
    2877, 2877,
    2908, 2909,
    2911, 2913,
    2929, 2929,
    2947, 2947,
    2949, 2954,
    2958, 2960,
    2962, 2965,
    2969, 2970,
    2972, 2972,
    2974, 2975,
    2979, 2980,
    2984, 2986,
    2990, 3001,
    3024, 3024,
    3077, 3084,
    3086, 3088,
    3090, 3112,
    3114, 3129,
    3133, 3133,
    3160, 3162,
    3165, 3165,
    3168, 3169,
    3200, 3200,
    3205, 3212,
    3214, 3216,
    3218, 3240,
    3242, 3251,
    3253, 3257,
    3261, 3261,
    3293, 3294,
    3296, 3297,
    3313, 3314,
    3332, 3340,
    3342, 3344,
    3346, 3386,
    3389, 3389,
    3406, 3406,
    3412, 3414,
    3423, 3425,
    3450, 3455,
    3461, 3478,
    3482, 3505,
    3507, 3515,
    3517, 3517,
    3520, 3526,
    3585, 3632,
    3634, 3635,
    3648, 3654,
    3713, 3714,
    3716, 3716,
    3718, 3722,
    3724, 3747,
    3749, 3749,
    3751, 3760,
    3762, 3763,
    3773, 3773,
    3776, 3780,
    3782, 3782,
    3804, 3807,
    3840, 3840,
    3904, 3911,
    3913, 3948,
    3976, 3980,
    4096, 4138,
    4159, 4159,
    4176, 4181,
    4186, 4189,
    4193, 4193,
    4197, 4198,
    4206, 4208,
    4213, 4225,
    4238, 4238,
    4256, 4293,
    4295, 4295,
    4301, 4301,
    4304, 4346,
    4348, 4680,
    4682, 4685,
    4688, 4694,
    4696, 4696,
    4698, 4701,
    4704, 4744,
    4746, 4749,
    4752, 4784,
    4786, 4789,
    4792, 4798,
    4800, 4800,
    4802, 4805,
    4808, 4822,
    4824, 4880,
    4882, 4885,
    4888, 4954,
    4992, 5007,
    5024, 5109,
    5112, 5117,
    5121, 5740,
    5743, 5759,
    5761, 5786,
    5792, 5866,
    5870, 5880,
    5888, 5905,
    5919, 5937,
    5952, 5969,
    5984, 5996,
    5998, 6000,
    6016, 6067,
    6103, 6103,
    6108, 6108,
    6176, 6264,
    6272, 6312,
    6314, 6314,
    6320, 6389,
    6400, 6430,
    6480, 6509,
    6512, 6516,
    6528, 6571,
    6576, 6601,
    6656, 6678,
    6688, 6740,
    6823, 6823,
    6917, 6963,
    6981, 6988,
    7043, 7072,
    7086, 7087,
    7098, 7141,
    7168, 7203,
    7245, 7247,
    7258, 7293,
    7296, 7304,
    7312, 7354,
    7357, 7359,
    7401, 7404,
    7406, 7411,
    7413, 7414,
    7418, 7418,
    7424, 7615,
    7680, 7957,
    7960, 7965,
    7968, 8005,
    8008, 8013,
    8016, 8023,
    8025, 8025,
    8027, 8027,
    8029, 8029,
    8031, 8061,
    8064, 8116,
    8118, 8124,
    8126, 8126,
    8130, 8132,
    8134, 8140,
    8144, 8147,
    8150, 8155,
    8160, 8172,
    8178, 8180,
    8182, 8188,
    8305, 8305,
    8319, 8319,
    8336, 8348,
    8450, 8450,
    8455, 8455,
    8458, 8467,
    8469, 8469,
    8472, 8477,
    8484, 8484,
    8486, 8486,
    8488, 8488,
    8490, 8505,
    8508, 8511,
    8517, 8521,
    8526, 8526,
    8544, 8584,
    11264, 11492,
    11499, 11502,
    11506, 11507,
    11520, 11557,
    11559, 11559,
    11565, 11565,
    11568, 11623,
    11631, 11631,
    11648, 11670,
    11680, 11686,
    11688, 11694,
    11696, 11702,
    11704, 11710,
    11712, 11718,
    11720, 11726,
    11728, 11734,
    11736, 11742,
    11823, 11823,
    12293, 12295,
    12321, 12329,
    12337, 12341,
    12344, 12348,
    12353, 12438,
    12443, 12447,
    12449, 12538,
    12540, 12543,
    12549, 12591,
    12593, 12686,
    12704, 12735,
    12784, 12799,
    13312, 19903,
    19968, 42124,
    42192, 42237,
    42240, 42508,
    42512, 42527,
    42538, 42539,
    42560, 42606,
    42623, 42653,
    42656, 42735,
    42775, 42783,
    42786, 42888,
    42891, 42954,
    42960, 42961,
    42963, 42963,
    42965, 42969,
    42994, 43009,
    43011, 43013,
    43015, 43018,
    43020, 43042,
    43072, 43123,
    43138, 43187,
    43250, 43255,
    43259, 43259,
    43261, 43262,
    43274, 43301,
    43312, 43334,
    43360, 43388,
    43396, 43442,
    43471, 43471,
    43488, 43492,
    43494, 43503,
    43514, 43518,
    43520, 43560,
    43584, 43586,
    43588, 43595,
    43616, 43638,
    43642, 43642,
    43646, 43695,
    43697, 43697,
    43701, 43702,
    43705, 43709,
    43712, 43712,
    43714, 43714,
    43739, 43741,
    43744, 43754,
    43762, 43764,
    43777, 43782,
    43785, 43790,
    43793, 43798,
    43808, 43814,
    43816, 43822,
    43824, 43866,
    43868, 43881,
    43888, 44002,
    44032, 55203,
    55216, 55238,
    55243, 55291,
    63744, 64109,
    64112, 64217,
    64256, 64262,
    64275, 64279,
    64285, 64285,
    64287, 64296,
    64298, 64310,
    64312, 64316,
    64318, 64318,
    64320, 64321,
    64323, 64324,
    64326, 64433,
    64467, 64829,
    64848, 64911,
    64914, 64967,
    65008, 65019,
    65136, 65140,
    65142, 65276,
    65313, 65338,
    65345, 65370,
    65382, 65470,
    65474, 65479,
    65482, 65487,
    65490, 65495,
    65498, 65500,
    65536, 65547,
    65549, 65574,
    65576, 65594,
    65596, 65597,
    65599, 65613,
    65616, 65629,
    65664, 65786,
    65856, 65908,
    66176, 66204,
    66208, 66256,
    66304, 66335,
    66349, 66378,
    66384, 66421,
    66432, 66461,
    66464, 66499,
    66504, 66511,
    66513, 66517,
    66560, 66717,
    66736, 66771,
    66776, 66811,
    66816, 66855,
    66864, 66915,
    66928, 66938,
    66940, 66954,
    66956, 66962,
    66964, 66965,
    66967, 66977,
    66979, 66993,
    66995, 67001,
    67003, 67004,
    67072, 67382,
    67392, 67413,
    67424, 67431,
    67456, 67461,
    67463, 67504,
    67506, 67514,
    67584, 67589,
    67592, 67592,
    67594, 67637,
    67639, 67640,
    67644, 67644,
    67647, 67669,
    67680, 67702,
    67712, 67742,
    67808, 67826,
    67828, 67829,
    67840, 67861,
    67872, 67897,
    67968, 68023,
    68030, 68031,
    68096, 68096,
    68112, 68115,
    68117, 68119,
    68121, 68149,
    68192, 68220,
    68224, 68252,
    68288, 68295,
    68297, 68324,
    68352, 68405,
    68416, 68437,
    68448, 68466,
    68480, 68497,
    68608, 68680,
    68736, 68786,
    68800, 68850,
    68864, 68899,
    69248, 69289,
    69296, 69297,
    69376, 69404,
    69415, 69415,
    69424, 69445,
    69488, 69505,
    69552, 69572,
    69600, 69622,
    69635, 69687,
    69745, 69746,
    69749, 69749,
    69763, 69807,
    69840, 69864,
    69891, 69926,
    69956, 69956,
    69959, 69959,
    69968, 70002,
    70006, 70006,
    70019, 70066,
    70081, 70084,
    70106, 70106,
    70108, 70108,
    70144, 70161,
    70163, 70187,
    70207, 70208,
    70272, 70278,
    70280, 70280,
    70282, 70285,
    70287, 70301,
    70303, 70312,
    70320, 70366,
    70405, 70412,
    70415, 70416,
    70419, 70440,
    70442, 70448,
    70450, 70451,
    70453, 70457,
    70461, 70461,
    70480, 70480,
    70493, 70497,
    70656, 70708,
    70727, 70730,
    70751, 70753,
    70784, 70831,
    70852, 70853,
    70855, 70855,
    71040, 71086,
    71128, 71131,
    71168, 71215,
    71236, 71236,
    71296, 71338,
    71352, 71352,
    71424, 71450,
    71488, 71494,
    71680, 71723,
    71840, 71903,
    71935, 71942,
    71945, 71945,
    71948, 71955,
    71957, 71958,
    71960, 71983,
    71999, 71999,
    72001, 72001,
    72096, 72103,
    72106, 72144,
    72161, 72161,
    72163, 72163,
    72192, 72192,
    72203, 72242,
    72250, 72250,
    72272, 72272,
    72284, 72329,
    72349, 72349,
    72368, 72440,
    72704, 72712,
    72714, 72750,
    72768, 72768,
    72818, 72847,
    72960, 72966,
    72968, 72969,
    72971, 73008,
    73030, 73030,
    73056, 73061,
    73063, 73064,
    73066, 73097,
    73112, 73112,
    73440, 73458,
    73474, 73474,
    73476, 73488,
    73490, 73523,
    73648, 73648,
    73728, 74649,
    74752, 74862,
    74880, 75075,
    77712, 77808,
    77824, 78895,
    78913, 78918,
    82944, 83526,
    92160, 92728,
    92736, 92766,
    92784, 92862,
    92880, 92909,
    92928, 92975,
    92992, 92995,
    93027, 93047,
    93053, 93071,
    93760, 93823,
    93952, 94026,
    94032, 94032,
    94099, 94111,
    94176, 94177,
    94179, 94179,
    94208, 100343,
    100352, 101589,
    101632, 101640,
    110576, 110579,
    110581, 110587,
    110589, 110590,
    110592, 110882,
    110898, 110898,
    110928, 110930,
    110933, 110933,
    110948, 110951,
    110960, 111355,
    113664, 113770,
    113776, 113788,
    113792, 113800,
    113808, 113817,
    119808, 119892,
    119894, 119964,
    119966, 119967,
    119970, 119970,
    119973, 119974,
    119977, 119980,
    119982, 119993,
    119995, 119995,
    119997, 120003,
    120005, 120069,
    120071, 120074,
    120077, 120084,
    120086, 120092,
    120094, 120121,
    120123, 120126,
    120128, 120132,
    120134, 120134,
    120138, 120144,
    120146, 120485,
    120488, 120512,
    120514, 120538,
    120540, 120570,
    120572, 120596,
    120598, 120628,
    120630, 120654,
    120656, 120686,
    120688, 120712,
    120714, 120744,
    120746, 120770,
    120772, 120779,
    122624, 122654,
    122661, 122666,
    122928, 122989,
    123136, 123180,
    123191, 123197,
    123214, 123214,
    123536, 123565,
    123584, 123627,
    124112, 124139,
    124896, 124902,
    124904, 124907,
    124909, 124910,
    124912, 124926,
    124928, 125124,
    125184, 125251,
    125259, 125259,
    126464, 126467,
    126469, 126495,
    126497, 126498,
    126500, 126500,
    126503, 126503,
    126505, 126514,
    126516, 126519,
    126521, 126521,
    126523, 126523,
    126530, 126530,
    126535, 126535,
    126537, 126537,
    126539, 126539,
    126541, 126543,
    126545, 126546,
    126548, 126548,
    126551, 126551,
    126553, 126553,
    126555, 126555,
    126557, 126557,
    126559, 126559,
    126561, 126562,
    126564, 126564,
    126567, 126570,
    126572, 126578,
    126580, 126583,
    126585, 126588,
    126590, 126590,
    126592, 126601,
    126603, 126619,
    126625, 126627,
    126629, 126633,
    126635, 126651,
    131072, 173791,
    173824, 177977,
    177984, 178205,
    178208, 183969,
    183984, 191456,
    191472, 192093,
    194560, 195101,
    196608, 201546,
    201552, 205743,
    0, 0
  };
  range["PythonIdentifierStart"] = PythonIdentifierStart;
  static const int Rejang[] = {
    43312, 43347,
    43359, 43359,
    0, 0
  };
  range["Rejang"] = Rejang;
  static const int Runic[] = {
    5792, 5866,
    5870, 5880,
    0, 0
  };
  range["Runic"] = Runic;
  static const int S[] = {
    36, 36,
    43, 43,
    60, 62,
    94, 94,
    96, 96,
    124, 124,
    126, 126,
    162, 166,
    168, 169,
    172, 172,
    174, 177,
    180, 180,
    184, 184,
    215, 215,
    247, 247,
    706, 709,
    722, 735,
    741, 747,
    749, 749,
    751, 767,
    885, 885,
    900, 901,
    1014, 1014,
    1154, 1154,
    1421, 1423,
    1542, 1544,
    1547, 1547,
    1550, 1551,
    1758, 1758,
    1769, 1769,
    1789, 1790,
    2038, 2038,
    2046, 2047,
    2184, 2184,
    2546, 2547,
    2554, 2555,
    2801, 2801,
    2928, 2928,
    3059, 3066,
    3199, 3199,
    3407, 3407,
    3449, 3449,
    3647, 3647,
    3841, 3843,
    3859, 3859,
    3861, 3863,
    3866, 3871,
    3892, 3892,
    3894, 3894,
    3896, 3896,
    4030, 4037,
    4039, 4044,
    4046, 4047,
    4053, 4056,
    4254, 4255,
    5008, 5017,
    5741, 5741,
    6107, 6107,
    6464, 6464,
    6622, 6655,
    7009, 7018,
    7028, 7036,
    8125, 8125,
    8127, 8129,
    8141, 8143,
    8157, 8159,
    8173, 8175,
    8189, 8190,
    8260, 8260,
    8274, 8274,
    8314, 8316,
    8330, 8332,
    8352, 8384,
    8448, 8449,
    8451, 8454,
    8456, 8457,
    8468, 8468,
    8470, 8472,
    8478, 8483,
    8485, 8485,
    8487, 8487,
    8489, 8489,
    8494, 8494,
    8506, 8507,
    8512, 8516,
    8522, 8525,
    8527, 8527,
    8586, 8587,
    8592, 8967,
    8972, 9000,
    9003, 9254,
    9280, 9290,
    9372, 9449,
    9472, 10087,
    10132, 10180,
    10183, 10213,
    10224, 10626,
    10649, 10711,
    10716, 10747,
    10750, 11123,
    11126, 11157,
    11159, 11263,
    11493, 11498,
    11856, 11857,
    11904, 11929,
    11931, 12019,
    12032, 12245,
    12272, 12287,
    12292, 12292,
    12306, 12307,
    12320, 12320,
    12342, 12343,
    12350, 12351,
    12443, 12444,
    12688, 12689,
    12694, 12703,
    12736, 12771,
    12783, 12783,
    12800, 12830,
    12842, 12871,
    12880, 12880,
    12896, 12927,
    12938, 12976,
    12992, 13311,
    19904, 19967,
    42128, 42182,
    42752, 42774,
    42784, 42785,
    42889, 42890,
    43048, 43051,
    43062, 43065,
    43639, 43641,
    43867, 43867,
    43882, 43883,
    64297, 64297,
    64434, 64450,
    64832, 64847,
    64975, 64975,
    65020, 65023,
    65122, 65122,
    65124, 65126,
    65129, 65129,
    65284, 65284,
    65291, 65291,
    65308, 65310,
    65342, 65342,
    65344, 65344,
    65372, 65372,
    65374, 65374,
    65504, 65510,
    65512, 65518,
    65532, 65533,
    65847, 65855,
    65913, 65929,
    65932, 65934,
    65936, 65948,
    65952, 65952,
    66000, 66044,
    67703, 67704,
    68296, 68296,
    71487, 71487,
    73685, 73713,
    92988, 92991,
    92997, 92997,
    113820, 113820,
    118608, 118723,
    118784, 119029,
    119040, 119078,
    119081, 119140,
    119146, 119148,
    119171, 119172,
    119180, 119209,
    119214, 119274,
    119296, 119361,
    119365, 119365,
    119552, 119638,
    120513, 120513,
    120539, 120539,
    120571, 120571,
    120597, 120597,
    120629, 120629,
    120655, 120655,
    120687, 120687,
    120713, 120713,
    120745, 120745,
    120771, 120771,
    120832, 121343,
    121399, 121402,
    121453, 121460,
    121462, 121475,
    121477, 121478,
    123215, 123215,
    123647, 123647,
    126124, 126124,
    126128, 126128,
    126254, 126254,
    126704, 126705,
    126976, 127019,
    127024, 127123,
    127136, 127150,
    127153, 127167,
    127169, 127183,
    127185, 127221,
    127245, 127405,
    127462, 127490,
    127504, 127547,
    127552, 127560,
    127568, 127569,
    127584, 127589,
    127744, 128727,
    128732, 128748,
    128752, 128764,
    128768, 128886,
    128891, 128985,
    128992, 129003,
    129008, 129008,
    129024, 129035,
    129040, 129095,
    129104, 129113,
    129120, 129159,
    129168, 129197,
    129200, 129201,
    129280, 129619,
    129632, 129645,
    129648, 129660,
    129664, 129672,
    129680, 129725,
    129727, 129733,
    129742, 129755,
    129760, 129768,
    129776, 129784,
    129792, 129938,
    129940, 129994,
    0, 0
  };
  range["S"] = S;
  static const int Samaritan[] = {
    2048, 2093,
    2096, 2110,
    0, 0
  };
  range["Samaritan"] = Samaritan;
  static const int Saurashtra[] = {
    43136, 43205,
    43214, 43225,
    0, 0
  };
  range["Saurashtra"] = Saurashtra;
  static const int Sc[] = {
    36, 36,
    162, 165,
    1423, 1423,
    1547, 1547,
    2046, 2047,
    2546, 2547,
    2555, 2555,
    2801, 2801,
    3065, 3065,
    3647, 3647,
    6107, 6107,
    8352, 8384,
    43064, 43064,
    65020, 65020,
    65129, 65129,
    65284, 65284,
    65504, 65505,
    65509, 65510,
    73693, 73696,
    123647, 123647,
    126128, 126128,
    0, 0
  };
  range["Sc"] = Sc;
  static const int Sharada[] = {
    70016, 70111,
    0, 0
  };
  range["Sharada"] = Sharada;
  static const int Shavian[] = {
    66640, 66687,
    0, 0
  };
  range["Shavian"] = Shavian;
  static const int Siddham[] = {
    71040, 71093,
    71096, 71133,
    0, 0
  };
  range["Siddham"] = Siddham;
  static const int SignWriting[] = {
    120832, 121483,
    121499, 121503,
    121505, 121519,
    0, 0
  };
  range["SignWriting"] = SignWriting;
  static const int Sinhala[] = {
    3457, 3459,
    3461, 3478,
    3482, 3505,
    3507, 3515,
    3517, 3517,
    3520, 3526,
    3530, 3530,
    3535, 3540,
    3542, 3542,
    3544, 3551,
    3558, 3567,
    3570, 3572,
    70113, 70132,
    0, 0
  };
  range["Sinhala"] = Sinhala;
  static const int Sk[] = {
    94, 94,
    96, 96,
    168, 168,
    175, 175,
    180, 180,
    184, 184,
    706, 709,
    722, 735,
    741, 747,
    749, 749,
    751, 767,
    885, 885,
    900, 901,
    2184, 2184,
    8125, 8125,
    8127, 8129,
    8141, 8143,
    8157, 8159,
    8173, 8175,
    8189, 8190,
    12443, 12444,
    42752, 42774,
    42784, 42785,
    42889, 42890,
    43867, 43867,
    43882, 43883,
    64434, 64450,
    65342, 65342,
    65344, 65344,
    65507, 65507,
    127995, 127999,
    0, 0
  };
  range["Sk"] = Sk;
  static const int Sm[] = {
    43, 43,
    60, 62,
    124, 124,
    126, 126,
    172, 172,
    177, 177,
    215, 215,
    247, 247,
    1014, 1014,
    1542, 1544,
    8260, 8260,
    8274, 8274,
    8314, 8316,
    8330, 8332,
    8472, 8472,
    8512, 8516,
    8523, 8523,
    8592, 8596,
    8602, 8603,
    8608, 8608,
    8611, 8611,
    8614, 8614,
    8622, 8622,
    8654, 8655,
    8658, 8658,
    8660, 8660,
    8692, 8959,
    8992, 8993,
    9084, 9084,
    9115, 9139,
    9180, 9185,
    9655, 9655,
    9665, 9665,
    9720, 9727,
    9839, 9839,
    10176, 10180,
    10183, 10213,
    10224, 10239,
    10496, 10626,
    10649, 10711,
    10716, 10747,
    10750, 11007,
    11056, 11076,
    11079, 11084,
    64297, 64297,
    65122, 65122,
    65124, 65126,
    65291, 65291,
    65308, 65310,
    65372, 65372,
    65374, 65374,
    65506, 65506,
    65513, 65516,
    120513, 120513,
    120539, 120539,
    120571, 120571,
    120597, 120597,
    120629, 120629,
    120655, 120655,
    120687, 120687,
    120713, 120713,
    120745, 120745,
    120771, 120771,
    126704, 126705,
    0, 0
  };
  range["Sm"] = Sm;
  static const int So[] = {
    166, 166,
    169, 169,
    174, 174,
    176, 176,
    1154, 1154,
    1421, 1422,
    1550, 1551,
    1758, 1758,
    1769, 1769,
    1789, 1790,
    2038, 2038,
    2554, 2554,
    2928, 2928,
    3059, 3064,
    3066, 3066,
    3199, 3199,
    3407, 3407,
    3449, 3449,
    3841, 3843,
    3859, 3859,
    3861, 3863,
    3866, 3871,
    3892, 3892,
    3894, 3894,
    3896, 3896,
    4030, 4037,
    4039, 4044,
    4046, 4047,
    4053, 4056,
    4254, 4255,
    5008, 5017,
    5741, 5741,
    6464, 6464,
    6622, 6655,
    7009, 7018,
    7028, 7036,
    8448, 8449,
    8451, 8454,
    8456, 8457,
    8468, 8468,
    8470, 8471,
    8478, 8483,
    8485, 8485,
    8487, 8487,
    8489, 8489,
    8494, 8494,
    8506, 8507,
    8522, 8522,
    8524, 8525,
    8527, 8527,
    8586, 8587,
    8597, 8601,
    8604, 8607,
    8609, 8610,
    8612, 8613,
    8615, 8621,
    8623, 8653,
    8656, 8657,
    8659, 8659,
    8661, 8691,
    8960, 8967,
    8972, 8991,
    8994, 9000,
    9003, 9083,
    9085, 9114,
    9140, 9179,
    9186, 9254,
    9280, 9290,
    9372, 9449,
    9472, 9654,
    9656, 9664,
    9666, 9719,
    9728, 9838,
    9840, 10087,
    10132, 10175,
    10240, 10495,
    11008, 11055,
    11077, 11078,
    11085, 11123,
    11126, 11157,
    11159, 11263,
    11493, 11498,
    11856, 11857,
    11904, 11929,
    11931, 12019,
    12032, 12245,
    12272, 12287,
    12292, 12292,
    12306, 12307,
    12320, 12320,
    12342, 12343,
    12350, 12351,
    12688, 12689,
    12694, 12703,
    12736, 12771,
    12783, 12783,
    12800, 12830,
    12842, 12871,
    12880, 12880,
    12896, 12927,
    12938, 12976,
    12992, 13311,
    19904, 19967,
    42128, 42182,
    43048, 43051,
    43062, 43063,
    43065, 43065,
    43639, 43641,
    64832, 64847,
    64975, 64975,
    65021, 65023,
    65508, 65508,
    65512, 65512,
    65517, 65518,
    65532, 65533,
    65847, 65855,
    65913, 65929,
    65932, 65934,
    65936, 65948,
    65952, 65952,
    66000, 66044,
    67703, 67704,
    68296, 68296,
    71487, 71487,
    73685, 73692,
    73697, 73713,
    92988, 92991,
    92997, 92997,
    113820, 113820,
    118608, 118723,
    118784, 119029,
    119040, 119078,
    119081, 119140,
    119146, 119148,
    119171, 119172,
    119180, 119209,
    119214, 119274,
    119296, 119361,
    119365, 119365,
    119552, 119638,
    120832, 121343,
    121399, 121402,
    121453, 121460,
    121462, 121475,
    121477, 121478,
    123215, 123215,
    126124, 126124,
    126254, 126254,
    126976, 127019,
    127024, 127123,
    127136, 127150,
    127153, 127167,
    127169, 127183,
    127185, 127221,
    127245, 127405,
    127462, 127490,
    127504, 127547,
    127552, 127560,
    127568, 127569,
    127584, 127589,
    127744, 127994,
    128000, 128727,
    128732, 128748,
    128752, 128764,
    128768, 128886,
    128891, 128985,
    128992, 129003,
    129008, 129008,
    129024, 129035,
    129040, 129095,
    129104, 129113,
    129120, 129159,
    129168, 129197,
    129200, 129201,
    129280, 129619,
    129632, 129645,
    129648, 129660,
    129664, 129672,
    129680, 129725,
    129727, 129733,
    129742, 129755,
    129760, 129768,
    129776, 129784,
    129792, 129938,
    129940, 129994,
    0, 0
  };
  range["So"] = So;
  static const int Sogdian[] = {
    69424, 69465,
    0, 0
  };
  range["Sogdian"] = Sogdian;
  static const int Sora_Sompeng[] = {
    69840, 69864,
    69872, 69881,
    0, 0
  };
  range["Sora_Sompeng"] = Sora_Sompeng;
  static const int Soyombo[] = {
    72272, 72354,
    0, 0
  };
  range["Soyombo"] = Soyombo;
  static const int Space[] = {
    9, 13,
    32, 32,
    160, 160,
    5760, 5760,
    8192, 8202,
    8239, 8239,
    8287, 8287,
    12288, 12288,
    0, 0
  };
  range["Space"] = Space;
  static const int Sundanese[] = {
    7040, 7103,
    7360, 7367,
    0, 0
  };
  range["Sundanese"] = Sundanese;
  static const int Syloti_Nagri[] = {
    43008, 43052,
    0, 0
  };
  range["Syloti_Nagri"] = Syloti_Nagri;
  static const int Syriac[] = {
    1792, 1805,
    1807, 1866,
    1869, 1871,
    2144, 2154,
    0, 0
  };
  range["Syriac"] = Syriac;
  static const int Tagalog[] = {
    5888, 5909,
    5919, 5919,
    0, 0
  };
  range["Tagalog"] = Tagalog;
  static const int Tagbanwa[] = {
    5984, 5996,
    5998, 6000,
    6002, 6003,
    0, 0
  };
  range["Tagbanwa"] = Tagbanwa;
  static const int Tai_Le[] = {
    6480, 6509,
    6512, 6516,
    0, 0
  };
  range["Tai_Le"] = Tai_Le;
  static const int Tai_Tham[] = {
    6688, 6750,
    6752, 6780,
    6783, 6793,
    6800, 6809,
    6816, 6829,
    0, 0
  };
  range["Tai_Tham"] = Tai_Tham;
  static const int Tai_Viet[] = {
    43648, 43714,
    43739, 43743,
    0, 0
  };
  range["Tai_Viet"] = Tai_Viet;
  static const int Takri[] = {
    71296, 71353,
    71360, 71369,
    0, 0
  };
  range["Takri"] = Takri;
  static const int Tamil[] = {
    2946, 2947,
    2949, 2954,
    2958, 2960,
    2962, 2965,
    2969, 2970,
    2972, 2972,
    2974, 2975,
    2979, 2980,
    2984, 2986,
    2990, 3001,
    3006, 3010,
    3014, 3016,
    3018, 3021,
    3024, 3024,
    3031, 3031,
    3046, 3066,
    73664, 73713,
    73727, 73727,
    0, 0
  };
  range["Tamil"] = Tamil;
  static const int Tangsa[] = {
    92784, 92862,
    92864, 92873,
    0, 0
  };
  range["Tangsa"] = Tangsa;
  static const int Tangut[] = {
    94176, 94176,
    94208, 100343,
    100352, 101119,
    101632, 101640,
    0, 0
  };
  range["Tangut"] = Tangut;
  static const int Telugu[] = {
    3072, 3084,
    3086, 3088,
    3090, 3112,
    3114, 3129,
    3132, 3140,
    3142, 3144,
    3146, 3149,
    3157, 3158,
    3160, 3162,
    3165, 3165,
    3168, 3171,
    3174, 3183,
    3191, 3199,
    0, 0
  };
  range["Telugu"] = Telugu;
  static const int Thaana[] = {
    1920, 1969,
    0, 0
  };
  range["Thaana"] = Thaana;
  static const int Thai[] = {
    3585, 3642,
    3648, 3675,
    0, 0
  };
  range["Thai"] = Thai;
  static const int Tibetan[] = {
    3840, 3911,
    3913, 3948,
    3953, 3991,
    3993, 4028,
    4030, 4044,
    4046, 4052,
    4057, 4058,
    0, 0
  };
  range["Tibetan"] = Tibetan;
  static const int Tifinagh[] = {
    11568, 11623,
    11631, 11632,
    11647, 11647,
    0, 0
  };
  range["Tifinagh"] = Tifinagh;
  static const int Tirhuta[] = {
    70784, 70855,
    70864, 70873,
    0, 0
  };
  range["Tirhuta"] = Tirhuta;
  static const int Toto[] = {
    123536, 123566,
    0, 0
  };
  range["Toto"] = Toto;
  static const int Ugaritic[] = {
    66432, 66461,
    66463, 66463,
    0, 0
  };
  range["Ugaritic"] = Ugaritic;
  static const int Unicode[] = {
    0, 55295,
    57344, 1114111,
    0, 0
  };
  range["Unicode"] = Unicode;
  static const int UnicodeIdentifierPart[] = {
    0, 8,
    14, 27,
    48, 57,
    65, 90,
    95, 95,
    97, 122,
    127, 159,
    170, 170,
    173, 173,
    181, 181,
    186, 186,
    192, 214,
    216, 246,
    248, 705,
    710, 721,
    736, 740,
    748, 748,
    750, 750,
    768, 884,
    886, 887,
    890, 893,
    895, 895,
    902, 902,
    904, 906,
    908, 908,
    910, 929,
    931, 1013,
    1015, 1153,
    1155, 1159,
    1162, 1327,
    1329, 1366,
    1369, 1369,
    1376, 1416,
    1425, 1469,
    1471, 1471,
    1473, 1474,
    1476, 1477,
    1479, 1479,
    1488, 1514,
    1519, 1522,
    1536, 1541,
    1552, 1562,
    1564, 1564,
    1568, 1641,
    1646, 1747,
    1749, 1757,
    1759, 1768,
    1770, 1788,
    1791, 1791,
    1807, 1866,
    1869, 1969,
    1984, 2037,
    2042, 2042,
    2045, 2045,
    2048, 2093,
    2112, 2139,
    2144, 2154,
    2160, 2183,
    2185, 2190,
    2192, 2193,
    2200, 2403,
    2406, 2415,
    2417, 2435,
    2437, 2444,
    2447, 2448,
    2451, 2472,
    2474, 2480,
    2482, 2482,
    2486, 2489,
    2492, 2500,
    2503, 2504,
    2507, 2510,
    2519, 2519,
    2524, 2525,
    2527, 2531,
    2534, 2545,
    2556, 2556,
    2558, 2558,
    2561, 2563,
    2565, 2570,
    2575, 2576,
    2579, 2600,
    2602, 2608,
    2610, 2611,
    2613, 2614,
    2616, 2617,
    2620, 2620,
    2622, 2626,
    2631, 2632,
    2635, 2637,
    2641, 2641,
    2649, 2652,
    2654, 2654,
    2662, 2677,
    2689, 2691,
    2693, 2701,
    2703, 2705,
    2707, 2728,
    2730, 2736,
    2738, 2739,
    2741, 2745,
    2748, 2757,
    2759, 2761,
    2763, 2765,
    2768, 2768,
    2784, 2787,
    2790, 2799,
    2809, 2815,
    2817, 2819,
    2821, 2828,
    2831, 2832,
    2835, 2856,
    2858, 2864,
    2866, 2867,
    2869, 2873,
    2876, 2884,
    2887, 2888,
    2891, 2893,
    2901, 2903,
    2908, 2909,
    2911, 2915,
    2918, 2927,
    2929, 2929,
    2946, 2947,
    2949, 2954,
    2958, 2960,
    2962, 2965,
    2969, 2970,
    2972, 2972,
    2974, 2975,
    2979, 2980,
    2984, 2986,
    2990, 3001,
    3006, 3010,
    3014, 3016,
    3018, 3021,
    3024, 3024,
    3031, 3031,
    3046, 3055,
    3072, 3084,
    3086, 3088,
    3090, 3112,
    3114, 3129,
    3132, 3140,
    3142, 3144,
    3146, 3149,
    3157, 3158,
    3160, 3162,
    3165, 3165,
    3168, 3171,
    3174, 3183,
    3200, 3203,
    3205, 3212,
    3214, 3216,
    3218, 3240,
    3242, 3251,
    3253, 3257,
    3260, 3268,
    3270, 3272,
    3274, 3277,
    3285, 3286,
    3293, 3294,
    3296, 3299,
    3302, 3311,
    3313, 3315,
    3328, 3340,
    3342, 3344,
    3346, 3396,
    3398, 3400,
    3402, 3406,
    3412, 3415,
    3423, 3427,
    3430, 3439,
    3450, 3455,
    3457, 3459,
    3461, 3478,
    3482, 3505,
    3507, 3515,
    3517, 3517,
    3520, 3526,
    3530, 3530,
    3535, 3540,
    3542, 3542,
    3544, 3551,
    3558, 3567,
    3570, 3571,
    3585, 3642,
    3648, 3662,
    3664, 3673,
    3713, 3714,
    3716, 3716,
    3718, 3722,
    3724, 3747,
    3749, 3749,
    3751, 3773,
    3776, 3780,
    3782, 3782,
    3784, 3790,
    3792, 3801,
    3804, 3807,
    3840, 3840,
    3864, 3865,
    3872, 3881,
    3893, 3893,
    3895, 3895,
    3897, 3897,
    3902, 3911,
    3913, 3948,
    3953, 3972,
    3974, 3991,
    3993, 4028,
    4038, 4038,
    4096, 4169,
    4176, 4253,
    4256, 4293,
    4295, 4295,
    4301, 4301,
    4304, 4346,
    4348, 4680,
    4682, 4685,
    4688, 4694,
    4696, 4696,
    4698, 4701,
    4704, 4744,
    4746, 4749,
    4752, 4784,
    4786, 4789,
    4792, 4798,
    4800, 4800,
    4802, 4805,
    4808, 4822,
    4824, 4880,
    4882, 4885,
    4888, 4954,
    4957, 4959,
    4992, 5007,
    5024, 5109,
    5112, 5117,
    5121, 5740,
    5743, 5759,
    5761, 5786,
    5792, 5866,
    5870, 5880,
    5888, 5909,
    5919, 5940,
    5952, 5971,
    5984, 5996,
    5998, 6000,
    6002, 6003,
    6016, 6099,
    6103, 6103,
    6108, 6109,
    6112, 6121,
    6155, 6169,
    6176, 6264,
    6272, 6314,
    6320, 6389,
    6400, 6430,
    6432, 6443,
    6448, 6459,
    6470, 6509,
    6512, 6516,
    6528, 6571,
    6576, 6601,
    6608, 6617,
    6656, 6683,
    6688, 6750,
    6752, 6780,
    6783, 6793,
    6800, 6809,
    6823, 6823,
    6832, 6845,
    6847, 6862,
    6912, 6988,
    6992, 7001,
    7019, 7027,
    7040, 7155,
    7168, 7223,
    7232, 7241,
    7245, 7293,
    7296, 7304,
    7312, 7354,
    7357, 7359,
    7376, 7378,
    7380, 7418,
    7424, 7957,
    7960, 7965,
    7968, 8005,
    8008, 8013,
    8016, 8023,
    8025, 8025,
    8027, 8027,
    8029, 8029,
    8031, 8061,
    8064, 8116,
    8118, 8124,
    8126, 8126,
    8130, 8132,
    8134, 8140,
    8144, 8147,
    8150, 8155,
    8160, 8172,
    8178, 8180,
    8182, 8188,
    8203, 8207,
    8234, 8238,
    8255, 8256,
    8276, 8276,
    8288, 8292,
    8294, 8303,
    8305, 8305,
    8319, 8319,
    8336, 8348,
    8400, 8412,
    8417, 8417,
    8421, 8432,
    8450, 8450,
    8455, 8455,
    8458, 8467,
    8469, 8469,
    8473, 8477,
    8484, 8484,
    8486, 8486,
    8488, 8488,
    8490, 8493,
    8495, 8505,
    8508, 8511,
    8517, 8521,
    8526, 8526,
    8544, 8584,
    11264, 11492,
    11499, 11507,
    11520, 11557,
    11559, 11559,
    11565, 11565,
    11568, 11623,
    11631, 11631,
    11647, 11670,
    11680, 11686,
    11688, 11694,
    11696, 11702,
    11704, 11710,
    11712, 11718,
    11720, 11726,
    11728, 11734,
    11736, 11742,
    11744, 11775,
    11823, 11823,
    12293, 12295,
    12321, 12335,
    12337, 12341,
    12344, 12348,
    12353, 12438,
    12441, 12442,
    12445, 12447,
    12449, 12538,
    12540, 12543,
    12549, 12591,
    12593, 12686,
    12704, 12735,
    12784, 12799,
    13312, 19903,
    19968, 42124,
    42192, 42237,
    42240, 42508,
    42512, 42539,
    42560, 42607,
    42612, 42621,
    42623, 42737,
    42775, 42783,
    42786, 42888,
    42891, 42954,
    42960, 42961,
    42963, 42963,
    42965, 42969,
    42994, 43047,
    43052, 43052,
    43072, 43123,
    43136, 43205,
    43216, 43225,
    43232, 43255,
    43259, 43259,
    43261, 43309,
    43312, 43347,
    43360, 43388,
    43392, 43456,
    43471, 43481,
    43488, 43518,
    43520, 43574,
    43584, 43597,
    43600, 43609,
    43616, 43638,
    43642, 43714,
    43739, 43741,
    43744, 43759,
    43762, 43766,
    43777, 43782,
    43785, 43790,
    43793, 43798,
    43808, 43814,
    43816, 43822,
    43824, 43866,
    43868, 43881,
    43888, 44010,
    44012, 44013,
    44016, 44025,
    44032, 55203,
    55216, 55238,
    55243, 55291,
    63744, 64109,
    64112, 64217,
    64256, 64262,
    64275, 64279,
    64285, 64296,
    64298, 64310,
    64312, 64316,
    64318, 64318,
    64320, 64321,
    64323, 64324,
    64326, 64433,
    64467, 64829,
    64848, 64911,
    64914, 64967,
    65008, 65019,
    65024, 65039,
    65056, 65071,
    65075, 65076,
    65101, 65103,
    65136, 65140,
    65142, 65276,
    65279, 65279,
    65296, 65305,
    65313, 65338,
    65343, 65343,
    65345, 65370,
    65382, 65470,
    65474, 65479,
    65482, 65487,
    65490, 65495,
    65498, 65500,
    65529, 65531,
    65536, 65547,
    65549, 65574,
    65576, 65594,
    65596, 65597,
    65599, 65613,
    65616, 65629,
    65664, 65786,
    65856, 65908,
    66045, 66045,
    66176, 66204,
    66208, 66256,
    66272, 66272,
    66304, 66335,
    66349, 66378,
    66384, 66426,
    66432, 66461,
    66464, 66499,
    66504, 66511,
    66513, 66517,
    66560, 66717,
    66720, 66729,
    66736, 66771,
    66776, 66811,
    66816, 66855,
    66864, 66915,
    66928, 66938,
    66940, 66954,
    66956, 66962,
    66964, 66965,
    66967, 66977,
    66979, 66993,
    66995, 67001,
    67003, 67004,
    67072, 67382,
    67392, 67413,
    67424, 67431,
    67456, 67461,
    67463, 67504,
    67506, 67514,
    67584, 67589,
    67592, 67592,
    67594, 67637,
    67639, 67640,
    67644, 67644,
    67647, 67669,
    67680, 67702,
    67712, 67742,
    67808, 67826,
    67828, 67829,
    67840, 67861,
    67872, 67897,
    67968, 68023,
    68030, 68031,
    68096, 68099,
    68101, 68102,
    68108, 68115,
    68117, 68119,
    68121, 68149,
    68152, 68154,
    68159, 68159,
    68192, 68220,
    68224, 68252,
    68288, 68295,
    68297, 68326,
    68352, 68405,
    68416, 68437,
    68448, 68466,
    68480, 68497,
    68608, 68680,
    68736, 68786,
    68800, 68850,
    68864, 68903,
    68912, 68921,
    69248, 69289,
    69291, 69292,
    69296, 69297,
    69373, 69404,
    69415, 69415,
    69424, 69456,
    69488, 69509,
    69552, 69572,
    69600, 69622,
    69632, 69702,
    69734, 69749,
    69759, 69818,
    69821, 69821,
    69826, 69826,
    69837, 69837,
    69840, 69864,
    69872, 69881,
    69888, 69940,
    69942, 69951,
    69956, 69959,
    69968, 70003,
    70006, 70006,
    70016, 70084,
    70089, 70092,
    70094, 70106,
    70108, 70108,
    70144, 70161,
    70163, 70199,
    70206, 70209,
    70272, 70278,
    70280, 70280,
    70282, 70285,
    70287, 70301,
    70303, 70312,
    70320, 70378,
    70384, 70393,
    70400, 70403,
    70405, 70412,
    70415, 70416,
    70419, 70440,
    70442, 70448,
    70450, 70451,
    70453, 70457,
    70459, 70468,
    70471, 70472,
    70475, 70477,
    70480, 70480,
    70487, 70487,
    70493, 70499,
    70502, 70508,
    70512, 70516,
    70656, 70730,
    70736, 70745,
    70750, 70753,
    70784, 70853,
    70855, 70855,
    70864, 70873,
    71040, 71093,
    71096, 71104,
    71128, 71133,
    71168, 71232,
    71236, 71236,
    71248, 71257,
    71296, 71352,
    71360, 71369,
    71424, 71450,
    71453, 71467,
    71472, 71481,
    71488, 71494,
    71680, 71738,
    71840, 71913,
    71935, 71942,
    71945, 71945,
    71948, 71955,
    71957, 71958,
    71960, 71989,
    71991, 71992,
    71995, 72003,
    72016, 72025,
    72096, 72103,
    72106, 72151,
    72154, 72161,
    72163, 72164,
    72192, 72254,
    72263, 72263,
    72272, 72345,
    72349, 72349,
    72368, 72440,
    72704, 72712,
    72714, 72758,
    72760, 72768,
    72784, 72793,
    72818, 72847,
    72850, 72871,
    72873, 72886,
    72960, 72966,
    72968, 72969,
    72971, 73014,
    73018, 73018,
    73020, 73021,
    73023, 73031,
    73040, 73049,
    73056, 73061,
    73063, 73064,
    73066, 73102,
    73104, 73105,
    73107, 73112,
    73120, 73129,
    73440, 73462,
    73472, 73488,
    73490, 73530,
    73534, 73538,
    73552, 73561,
    73648, 73648,
    73728, 74649,
    74752, 74862,
    74880, 75075,
    77712, 77808,
    77824, 78933,
    82944, 83526,
    92160, 92728,
    92736, 92766,
    92768, 92777,
    92784, 92862,
    92864, 92873,
    92880, 92909,
    92912, 92916,
    92928, 92982,
    92992, 92995,
    93008, 93017,
    93027, 93047,
    93053, 93071,
    93760, 93823,
    93952, 94026,
    94031, 94087,
    94095, 94111,
    94176, 94177,
    94179, 94180,
    94192, 94193,
    94208, 100343,
    100352, 101589,
    101632, 101640,
    110576, 110579,
    110581, 110587,
    110589, 110590,
    110592, 110882,
    110898, 110898,
    110928, 110930,
    110933, 110933,
    110948, 110951,
    110960, 111355,
    113664, 113770,
    113776, 113788,
    113792, 113800,
    113808, 113817,
    113821, 113822,
    113824, 113827,
    118528, 118573,
    118576, 118598,
    119141, 119145,
    119149, 119170,
    119173, 119179,
    119210, 119213,
    119362, 119364,
    119808, 119892,
    119894, 119964,
    119966, 119967,
    119970, 119970,
    119973, 119974,
    119977, 119980,
    119982, 119993,
    119995, 119995,
    119997, 120003,
    120005, 120069,
    120071, 120074,
    120077, 120084,
    120086, 120092,
    120094, 120121,
    120123, 120126,
    120128, 120132,
    120134, 120134,
    120138, 120144,
    120146, 120485,
    120488, 120512,
    120514, 120538,
    120540, 120570,
    120572, 120596,
    120598, 120628,
    120630, 120654,
    120656, 120686,
    120688, 120712,
    120714, 120744,
    120746, 120770,
    120772, 120779,
    120782, 120831,
    121344, 121398,
    121403, 121452,
    121461, 121461,
    121476, 121476,
    121499, 121503,
    121505, 121519,
    122624, 122654,
    122661, 122666,
    122880, 122886,
    122888, 122904,
    122907, 122913,
    122915, 122916,
    122918, 122922,
    122928, 122989,
    123023, 123023,
    123136, 123180,
    123184, 123197,
    123200, 123209,
    123214, 123214,
    123536, 123566,
    123584, 123641,
    124112, 124153,
    124896, 124902,
    124904, 124907,
    124909, 124910,
    124912, 124926,
    124928, 125124,
    125136, 125142,
    125184, 125259,
    125264, 125273,
    126464, 126467,
    126469, 126495,
    126497, 126498,
    126500, 126500,
    126503, 126503,
    126505, 126514,
    126516, 126519,
    126521, 126521,
    126523, 126523,
    126530, 126530,
    126535, 126535,
    126537, 126537,
    126539, 126539,
    126541, 126543,
    126545, 126546,
    126548, 126548,
    126551, 126551,
    126553, 126553,
    126555, 126555,
    126557, 126557,
    126559, 126559,
    126561, 126562,
    126564, 126564,
    126567, 126570,
    126572, 126578,
    126580, 126583,
    126585, 126588,
    126590, 126590,
    126592, 126601,
    126603, 126619,
    126625, 126627,
    126629, 126633,
    126635, 126651,
    130032, 130041,
    131072, 173791,
    173824, 177977,
    177984, 178205,
    178208, 183969,
    183984, 191456,
    191472, 192093,
    194560, 195101,
    196608, 201546,
    201552, 205743,
    917505, 917505,
    917536, 917631,
    917760, 917999,
    0, 0
  };
  range["UnicodeIdentifierPart"] = UnicodeIdentifierPart;
  static const int UnicodeIdentifierStart[] = {
    65, 90,
    97, 122,
    170, 170,
    181, 181,
    186, 186,
    192, 214,
    216, 246,
    248, 705,
    710, 721,
    736, 740,
    748, 748,
    750, 750,
    880, 884,
    886, 887,
    890, 893,
    895, 895,
    902, 902,
    904, 906,
    908, 908,
    910, 929,
    931, 1013,
    1015, 1153,
    1162, 1327,
    1329, 1366,
    1369, 1369,
    1376, 1416,
    1488, 1514,
    1519, 1522,
    1568, 1610,
    1646, 1647,
    1649, 1747,
    1749, 1749,
    1765, 1766,
    1774, 1775,
    1786, 1788,
    1791, 1791,
    1808, 1808,
    1810, 1839,
    1869, 1957,
    1969, 1969,
    1994, 2026,
    2036, 2037,
    2042, 2042,
    2048, 2069,
    2074, 2074,
    2084, 2084,
    2088, 2088,
    2112, 2136,
    2144, 2154,
    2160, 2183,
    2185, 2190,
    2208, 2249,
    2308, 2361,
    2365, 2365,
    2384, 2384,
    2392, 2401,
    2417, 2432,
    2437, 2444,
    2447, 2448,
    2451, 2472,
    2474, 2480,
    2482, 2482,
    2486, 2489,
    2493, 2493,
    2510, 2510,
    2524, 2525,
    2527, 2529,
    2544, 2545,
    2556, 2556,
    2565, 2570,
    2575, 2576,
    2579, 2600,
    2602, 2608,
    2610, 2611,
    2613, 2614,
    2616, 2617,
    2649, 2652,
    2654, 2654,
    2674, 2676,
    2693, 2701,
    2703, 2705,
    2707, 2728,
    2730, 2736,
    2738, 2739,
    2741, 2745,
    2749, 2749,
    2768, 2768,
    2784, 2785,
    2809, 2809,
    2821, 2828,
    2831, 2832,
    2835, 2856,
    2858, 2864,
    2866, 2867,
    2869, 2873,
    2877, 2877,
    2908, 2909,
    2911, 2913,
    2929, 2929,
    2947, 2947,
    2949, 2954,
    2958, 2960,
    2962, 2965,
    2969, 2970,
    2972, 2972,
    2974, 2975,
    2979, 2980,
    2984, 2986,
    2990, 3001,
    3024, 3024,
    3077, 3084,
    3086, 3088,
    3090, 3112,
    3114, 3129,
    3133, 3133,
    3160, 3162,
    3165, 3165,
    3168, 3169,
    3200, 3200,
    3205, 3212,
    3214, 3216,
    3218, 3240,
    3242, 3251,
    3253, 3257,
    3261, 3261,
    3293, 3294,
    3296, 3297,
    3313, 3314,
    3332, 3340,
    3342, 3344,
    3346, 3386,
    3389, 3389,
    3406, 3406,
    3412, 3414,
    3423, 3425,
    3450, 3455,
    3461, 3478,
    3482, 3505,
    3507, 3515,
    3517, 3517,
    3520, 3526,
    3585, 3632,
    3634, 3635,
    3648, 3654,
    3713, 3714,
    3716, 3716,
    3718, 3722,
    3724, 3747,
    3749, 3749,
    3751, 3760,
    3762, 3763,
    3773, 3773,
    3776, 3780,
    3782, 3782,
    3804, 3807,
    3840, 3840,
    3904, 3911,
    3913, 3948,
    3976, 3980,
    4096, 4138,
    4159, 4159,
    4176, 4181,
    4186, 4189,
    4193, 4193,
    4197, 4198,
    4206, 4208,
    4213, 4225,
    4238, 4238,
    4256, 4293,
    4295, 4295,
    4301, 4301,
    4304, 4346,
    4348, 4680,
    4682, 4685,
    4688, 4694,
    4696, 4696,
    4698, 4701,
    4704, 4744,
    4746, 4749,
    4752, 4784,
    4786, 4789,
    4792, 4798,
    4800, 4800,
    4802, 4805,
    4808, 4822,
    4824, 4880,
    4882, 4885,
    4888, 4954,
    4992, 5007,
    5024, 5109,
    5112, 5117,
    5121, 5740,
    5743, 5759,
    5761, 5786,
    5792, 5866,
    5870, 5880,
    5888, 5905,
    5919, 5937,
    5952, 5969,
    5984, 5996,
    5998, 6000,
    6016, 6067,
    6103, 6103,
    6108, 6108,
    6176, 6264,
    6272, 6276,
    6279, 6312,
    6314, 6314,
    6320, 6389,
    6400, 6430,
    6480, 6509,
    6512, 6516,
    6528, 6571,
    6576, 6601,
    6656, 6678,
    6688, 6740,
    6823, 6823,
    6917, 6963,
    6981, 6988,
    7043, 7072,
    7086, 7087,
    7098, 7141,
    7168, 7203,
    7245, 7247,
    7258, 7293,
    7296, 7304,
    7312, 7354,
    7357, 7359,
    7401, 7404,
    7406, 7411,
    7413, 7414,
    7418, 7418,
    7424, 7615,
    7680, 7957,
    7960, 7965,
    7968, 8005,
    8008, 8013,
    8016, 8023,
    8025, 8025,
    8027, 8027,
    8029, 8029,
    8031, 8061,
    8064, 8116,
    8118, 8124,
    8126, 8126,
    8130, 8132,
    8134, 8140,
    8144, 8147,
    8150, 8155,
    8160, 8172,
    8178, 8180,
    8182, 8188,
    8305, 8305,
    8319, 8319,
    8336, 8348,
    8450, 8450,
    8455, 8455,
    8458, 8467,
    8469, 8469,
    8473, 8477,
    8484, 8484,
    8486, 8486,
    8488, 8488,
    8490, 8493,
    8495, 8505,
    8508, 8511,
    8517, 8521,
    8526, 8526,
    8544, 8584,
    11264, 11492,
    11499, 11502,
    11506, 11507,
    11520, 11557,
    11559, 11559,
    11565, 11565,
    11568, 11623,
    11631, 11631,
    11648, 11670,
    11680, 11686,
    11688, 11694,
    11696, 11702,
    11704, 11710,
    11712, 11718,
    11720, 11726,
    11728, 11734,
    11736, 11742,
    11823, 11823,
    12293, 12295,
    12321, 12329,
    12337, 12341,
    12344, 12348,
    12353, 12438,
    12445, 12447,
    12449, 12538,
    12540, 12543,
    12549, 12591,
    12593, 12686,
    12704, 12735,
    12784, 12799,
    13312, 19903,
    19968, 42124,
    42192, 42237,
    42240, 42508,
    42512, 42527,
    42538, 42539,
    42560, 42606,
    42623, 42653,
    42656, 42735,
    42775, 42783,
    42786, 42888,
    42891, 42954,
    42960, 42961,
    42963, 42963,
    42965, 42969,
    42994, 43009,
    43011, 43013,
    43015, 43018,
    43020, 43042,
    43072, 43123,
    43138, 43187,
    43250, 43255,
    43259, 43259,
    43261, 43262,
    43274, 43301,
    43312, 43334,
    43360, 43388,
    43396, 43442,
    43471, 43471,
    43488, 43492,
    43494, 43503,
    43514, 43518,
    43520, 43560,
    43584, 43586,
    43588, 43595,
    43616, 43638,
    43642, 43642,
    43646, 43695,
    43697, 43697,
    43701, 43702,
    43705, 43709,
    43712, 43712,
    43714, 43714,
    43739, 43741,
    43744, 43754,
    43762, 43764,
    43777, 43782,
    43785, 43790,
    43793, 43798,
    43808, 43814,
    43816, 43822,
    43824, 43866,
    43868, 43881,
    43888, 44002,
    44032, 55203,
    55216, 55238,
    55243, 55291,
    63744, 64109,
    64112, 64217,
    64256, 64262,
    64275, 64279,
    64285, 64285,
    64287, 64296,
    64298, 64310,
    64312, 64316,
    64318, 64318,
    64320, 64321,
    64323, 64324,
    64326, 64433,
    64467, 64829,
    64848, 64911,
    64914, 64967,
    65008, 65019,
    65136, 65140,
    65142, 65276,
    65313, 65338,
    65345, 65370,
    65382, 65470,
    65474, 65479,
    65482, 65487,
    65490, 65495,
    65498, 65500,
    65536, 65547,
    65549, 65574,
    65576, 65594,
    65596, 65597,
    65599, 65613,
    65616, 65629,
    65664, 65786,
    65856, 65908,
    66176, 66204,
    66208, 66256,
    66304, 66335,
    66349, 66378,
    66384, 66421,
    66432, 66461,
    66464, 66499,
    66504, 66511,
    66513, 66517,
    66560, 66717,
    66736, 66771,
    66776, 66811,
    66816, 66855,
    66864, 66915,
    66928, 66938,
    66940, 66954,
    66956, 66962,
    66964, 66965,
    66967, 66977,
    66979, 66993,
    66995, 67001,
    67003, 67004,
    67072, 67382,
    67392, 67413,
    67424, 67431,
    67456, 67461,
    67463, 67504,
    67506, 67514,
    67584, 67589,
    67592, 67592,
    67594, 67637,
    67639, 67640,
    67644, 67644,
    67647, 67669,
    67680, 67702,
    67712, 67742,
    67808, 67826,
    67828, 67829,
    67840, 67861,
    67872, 67897,
    67968, 68023,
    68030, 68031,
    68096, 68096,
    68112, 68115,
    68117, 68119,
    68121, 68149,
    68192, 68220,
    68224, 68252,
    68288, 68295,
    68297, 68324,
    68352, 68405,
    68416, 68437,
    68448, 68466,
    68480, 68497,
    68608, 68680,
    68736, 68786,
    68800, 68850,
    68864, 68899,
    69248, 69289,
    69296, 69297,
    69376, 69404,
    69415, 69415,
    69424, 69445,
    69488, 69505,
    69552, 69572,
    69600, 69622,
    69635, 69687,
    69745, 69746,
    69749, 69749,
    69763, 69807,
    69840, 69864,
    69891, 69926,
    69956, 69956,
    69959, 69959,
    69968, 70002,
    70006, 70006,
    70019, 70066,
    70081, 70084,
    70106, 70106,
    70108, 70108,
    70144, 70161,
    70163, 70187,
    70207, 70208,
    70272, 70278,
    70280, 70280,
    70282, 70285,
    70287, 70301,
    70303, 70312,
    70320, 70366,
    70405, 70412,
    70415, 70416,
    70419, 70440,
    70442, 70448,
    70450, 70451,
    70453, 70457,
    70461, 70461,
    70480, 70480,
    70493, 70497,
    70656, 70708,
    70727, 70730,
    70751, 70753,
    70784, 70831,
    70852, 70853,
    70855, 70855,
    71040, 71086,
    71128, 71131,
    71168, 71215,
    71236, 71236,
    71296, 71338,
    71352, 71352,
    71424, 71450,
    71488, 71494,
    71680, 71723,
    71840, 71903,
    71935, 71942,
    71945, 71945,
    71948, 71955,
    71957, 71958,
    71960, 71983,
    71999, 71999,
    72001, 72001,
    72096, 72103,
    72106, 72144,
    72161, 72161,
    72163, 72163,
    72192, 72192,
    72203, 72242,
    72250, 72250,
    72272, 72272,
    72284, 72329,
    72349, 72349,
    72368, 72440,
    72704, 72712,
    72714, 72750,
    72768, 72768,
    72818, 72847,
    72960, 72966,
    72968, 72969,
    72971, 73008,
    73030, 73030,
    73056, 73061,
    73063, 73064,
    73066, 73097,
    73112, 73112,
    73440, 73458,
    73474, 73474,
    73476, 73488,
    73490, 73523,
    73648, 73648,
    73728, 74649,
    74752, 74862,
    74880, 75075,
    77712, 77808,
    77824, 78895,
    78913, 78918,
    82944, 83526,
    92160, 92728,
    92736, 92766,
    92784, 92862,
    92880, 92909,
    92928, 92975,
    92992, 92995,
    93027, 93047,
    93053, 93071,
    93760, 93823,
    93952, 94026,
    94032, 94032,
    94099, 94111,
    94176, 94177,
    94179, 94179,
    94208, 100343,
    100352, 101589,
    101632, 101640,
    110576, 110579,
    110581, 110587,
    110589, 110590,
    110592, 110882,
    110898, 110898,
    110928, 110930,
    110933, 110933,
    110948, 110951,
    110960, 111355,
    113664, 113770,
    113776, 113788,
    113792, 113800,
    113808, 113817,
    119808, 119892,
    119894, 119964,
    119966, 119967,
    119970, 119970,
    119973, 119974,
    119977, 119980,
    119982, 119993,
    119995, 119995,
    119997, 120003,
    120005, 120069,
    120071, 120074,
    120077, 120084,
    120086, 120092,
    120094, 120121,
    120123, 120126,
    120128, 120132,
    120134, 120134,
    120138, 120144,
    120146, 120485,
    120488, 120512,
    120514, 120538,
    120540, 120570,
    120572, 120596,
    120598, 120628,
    120630, 120654,
    120656, 120686,
    120688, 120712,
    120714, 120744,
    120746, 120770,
    120772, 120779,
    122624, 122654,
    122661, 122666,
    122928, 122989,
    123136, 123180,
    123191, 123197,
    123214, 123214,
    123536, 123565,
    123584, 123627,
    124112, 124139,
    124896, 124902,
    124904, 124907,
    124909, 124910,
    124912, 124926,
    124928, 125124,
    125184, 125251,
    125259, 125259,
    126464, 126467,
    126469, 126495,
    126497, 126498,
    126500, 126500,
    126503, 126503,
    126505, 126514,
    126516, 126519,
    126521, 126521,
    126523, 126523,
    126530, 126530,
    126535, 126535,
    126537, 126537,
    126539, 126539,
    126541, 126543,
    126545, 126546,
    126548, 126548,
    126551, 126551,
    126553, 126553,
    126555, 126555,
    126557, 126557,
    126559, 126559,
    126561, 126562,
    126564, 126564,
    126567, 126570,
    126572, 126578,
    126580, 126583,
    126585, 126588,
    126590, 126590,
    126592, 126601,
    126603, 126619,
    126625, 126627,
    126629, 126633,
    126635, 126651,
    131072, 173791,
    173824, 177977,
    177984, 178205,
    178208, 183969,
    183984, 191456,
    191472, 192093,
    194560, 195101,
    196608, 201546,
    201552, 205743,
    0, 0
  };
  range["UnicodeIdentifierStart"] = UnicodeIdentifierStart;
  static const int Vai[] = {
    42240, 42539,
    0, 0
  };
  range["Vai"] = Vai;
  static const int Vithkuqi[] = {
    66928, 66938,
    66940, 66954,
    66956, 66962,
    66964, 66965,
    66967, 66977,
    66979, 66993,
    66995, 67001,
    67003, 67004,
    0, 0
  };
  range["Vithkuqi"] = Vithkuqi;
  static const int Wancho[] = {
    123584, 123641,
    123647, 123647,
    0, 0
  };
  range["Wancho"] = Wancho;
  static const int Warang_Citi[] = {
    71840, 71922,
    71935, 71935,
    0, 0
  };
  range["Warang_Citi"] = Warang_Citi;
  static const int Word[] = {
    48, 57,
    65, 90,
    95, 95,
    97, 122,
    170, 170,
    181, 181,
    186, 186,
    192, 214,
    216, 246,
    248, 705,
    710, 721,
    736, 740,
    748, 748,
    750, 750,
    880, 884,
    886, 887,
    890, 893,
    895, 895,
    902, 902,
    904, 906,
    908, 908,
    910, 929,
    931, 1013,
    1015, 1153,
    1162, 1327,
    1329, 1366,
    1369, 1369,
    1376, 1416,
    1488, 1514,
    1519, 1522,
    1568, 1610,
    1632, 1641,
    1646, 1647,
    1649, 1747,
    1749, 1749,
    1765, 1766,
    1774, 1788,
    1791, 1791,
    1808, 1808,
    1810, 1839,
    1869, 1957,
    1969, 1969,
    1984, 2026,
    2036, 2037,
    2042, 2042,
    2048, 2069,
    2074, 2074,
    2084, 2084,
    2088, 2088,
    2112, 2136,
    2144, 2154,
    2160, 2183,
    2185, 2190,
    2208, 2249,
    2308, 2361,
    2365, 2365,
    2384, 2384,
    2392, 2401,
    2406, 2415,
    2417, 2432,
    2437, 2444,
    2447, 2448,
    2451, 2472,
    2474, 2480,
    2482, 2482,
    2486, 2489,
    2493, 2493,
    2510, 2510,
    2524, 2525,
    2527, 2529,
    2534, 2545,
    2556, 2556,
    2565, 2570,
    2575, 2576,
    2579, 2600,
    2602, 2608,
    2610, 2611,
    2613, 2614,
    2616, 2617,
    2649, 2652,
    2654, 2654,
    2662, 2671,
    2674, 2676,
    2693, 2701,
    2703, 2705,
    2707, 2728,
    2730, 2736,
    2738, 2739,
    2741, 2745,
    2749, 2749,
    2768, 2768,
    2784, 2785,
    2790, 2799,
    2809, 2809,
    2821, 2828,
    2831, 2832,
    2835, 2856,
    2858, 2864,
    2866, 2867,
    2869, 2873,
    2877, 2877,
    2908, 2909,
    2911, 2913,
    2918, 2927,
    2929, 2929,
    2947, 2947,
    2949, 2954,
    2958, 2960,
    2962, 2965,
    2969, 2970,
    2972, 2972,
    2974, 2975,
    2979, 2980,
    2984, 2986,
    2990, 3001,
    3024, 3024,
    3046, 3055,
    3077, 3084,
    3086, 3088,
    3090, 3112,
    3114, 3129,
    3133, 3133,
    3160, 3162,
    3165, 3165,
    3168, 3169,
    3174, 3183,
    3200, 3200,
    3205, 3212,
    3214, 3216,
    3218, 3240,
    3242, 3251,
    3253, 3257,
    3261, 3261,
    3293, 3294,
    3296, 3297,
    3302, 3311,
    3313, 3314,
    3332, 3340,
    3342, 3344,
    3346, 3386,
    3389, 3389,
    3406, 3406,
    3412, 3414,
    3423, 3425,
    3430, 3439,
    3450, 3455,
    3461, 3478,
    3482, 3505,
    3507, 3515,
    3517, 3517,
    3520, 3526,
    3558, 3567,
    3585, 3632,
    3634, 3635,
    3648, 3654,
    3664, 3673,
    3713, 3714,
    3716, 3716,
    3718, 3722,
    3724, 3747,
    3749, 3749,
    3751, 3760,
    3762, 3763,
    3773, 3773,
    3776, 3780,
    3782, 3782,
    3792, 3801,
    3804, 3807,
    3840, 3840,
    3872, 3881,
    3904, 3911,
    3913, 3948,
    3976, 3980,
    4096, 4138,
    4159, 4169,
    4176, 4181,
    4186, 4189,
    4193, 4193,
    4197, 4198,
    4206, 4208,
    4213, 4225,
    4238, 4238,
    4240, 4249,
    4256, 4293,
    4295, 4295,
    4301, 4301,
    4304, 4346,
    4348, 4680,
    4682, 4685,
    4688, 4694,
    4696, 4696,
    4698, 4701,
    4704, 4744,
    4746, 4749,
    4752, 4784,
    4786, 4789,
    4792, 4798,
    4800, 4800,
    4802, 4805,
    4808, 4822,
    4824, 4880,
    4882, 4885,
    4888, 4954,
    4992, 5007,
    5024, 5109,
    5112, 5117,
    5121, 5740,
    5743, 5759,
    5761, 5786,
    5792, 5866,
    5873, 5880,
    5888, 5905,
    5919, 5937,
    5952, 5969,
    5984, 5996,
    5998, 6000,
    6016, 6067,
    6103, 6103,
    6108, 6108,
    6112, 6121,
    6160, 6169,
    6176, 6264,
    6272, 6276,
    6279, 6312,
    6314, 6314,
    6320, 6389,
    6400, 6430,
    6470, 6509,
    6512, 6516,
    6528, 6571,
    6576, 6601,
    6608, 6617,
    6656, 6678,
    6688, 6740,
    6784, 6793,
    6800, 6809,
    6823, 6823,
    6917, 6963,
    6981, 6988,
    6992, 7001,
    7043, 7072,
    7086, 7141,
    7168, 7203,
    7232, 7241,
    7245, 7293,
    7296, 7304,
    7312, 7354,
    7357, 7359,
    7401, 7404,
    7406, 7411,
    7413, 7414,
    7418, 7418,
    7424, 7615,
    7680, 7957,
    7960, 7965,
    7968, 8005,
    8008, 8013,
    8016, 8023,
    8025, 8025,
    8027, 8027,
    8029, 8029,
    8031, 8061,
    8064, 8116,
    8118, 8124,
    8126, 8126,
    8130, 8132,
    8134, 8140,
    8144, 8147,
    8150, 8155,
    8160, 8172,
    8178, 8180,
    8182, 8188,
    8255, 8256,
    8276, 8276,
    8305, 8305,
    8319, 8319,
    8336, 8348,
    8450, 8450,
    8455, 8455,
    8458, 8467,
    8469, 8469,
    8473, 8477,
    8484, 8484,
    8486, 8486,
    8488, 8488,
    8490, 8493,
    8495, 8505,
    8508, 8511,
    8517, 8521,
    8526, 8526,
    8579, 8580,
    11264, 11492,
    11499, 11502,
    11506, 11507,
    11520, 11557,
    11559, 11559,
    11565, 11565,
    11568, 11623,
    11631, 11631,
    11648, 11670,
    11680, 11686,
    11688, 11694,
    11696, 11702,
    11704, 11710,
    11712, 11718,
    11720, 11726,
    11728, 11734,
    11736, 11742,
    11823, 11823,
    12293, 12294,
    12337, 12341,
    12347, 12348,
    12353, 12438,
    12445, 12447,
    12449, 12538,
    12540, 12543,
    12549, 12591,
    12593, 12686,
    12704, 12735,
    12784, 12799,
    13312, 19903,
    19968, 42124,
    42192, 42237,
    42240, 42508,
    42512, 42539,
    42560, 42606,
    42623, 42653,
    42656, 42725,
    42775, 42783,
    42786, 42888,
    42891, 42954,
    42960, 42961,
    42963, 42963,
    42965, 42969,
    42994, 43009,
    43011, 43013,
    43015, 43018,
    43020, 43042,
    43072, 43123,
    43138, 43187,
    43216, 43225,
    43250, 43255,
    43259, 43259,
    43261, 43262,
    43264, 43301,
    43312, 43334,
    43360, 43388,
    43396, 43442,
    43471, 43481,
    43488, 43492,
    43494, 43518,
    43520, 43560,
    43584, 43586,
    43588, 43595,
    43600, 43609,
    43616, 43638,
    43642, 43642,
    43646, 43695,
    43697, 43697,
    43701, 43702,
    43705, 43709,
    43712, 43712,
    43714, 43714,
    43739, 43741,
    43744, 43754,
    43762, 43764,
    43777, 43782,
    43785, 43790,
    43793, 43798,
    43808, 43814,
    43816, 43822,
    43824, 43866,
    43868, 43881,
    43888, 44002,
    44016, 44025,
    44032, 55203,
    55216, 55238,
    55243, 55291,
    63744, 64109,
    64112, 64217,
    64256, 64262,
    64275, 64279,
    64285, 64285,
    64287, 64296,
    64298, 64310,
    64312, 64316,
    64318, 64318,
    64320, 64321,
    64323, 64324,
    64326, 64433,
    64467, 64829,
    64848, 64911,
    64914, 64967,
    65008, 65019,
    65075, 65076,
    65101, 65103,
    65136, 65140,
    65142, 65276,
    65296, 65305,
    65313, 65338,
    65343, 65343,
    65345, 65370,
    65382, 65470,
    65474, 65479,
    65482, 65487,
    65490, 65495,
    65498, 65500,
    65536, 65547,
    65549, 65574,
    65576, 65594,
    65596, 65597,
    65599, 65613,
    65616, 65629,
    65664, 65786,
    66176, 66204,
    66208, 66256,
    66304, 66335,
    66349, 66368,
    66370, 66377,
    66384, 66421,
    66432, 66461,
    66464, 66499,
    66504, 66511,
    66560, 66717,
    66720, 66729,
    66736, 66771,
    66776, 66811,
    66816, 66855,
    66864, 66915,
    66928, 66938,
    66940, 66954,
    66956, 66962,
    66964, 66965,
    66967, 66977,
    66979, 66993,
    66995, 67001,
    67003, 67004,
    67072, 67382,
    67392, 67413,
    67424, 67431,
    67456, 67461,
    67463, 67504,
    67506, 67514,
    67584, 67589,
    67592, 67592,
    67594, 67637,
    67639, 67640,
    67644, 67644,
    67647, 67669,
    67680, 67702,
    67712, 67742,
    67808, 67826,
    67828, 67829,
    67840, 67861,
    67872, 67897,
    67968, 68023,
    68030, 68031,
    68096, 68096,
    68112, 68115,
    68117, 68119,
    68121, 68149,
    68192, 68220,
    68224, 68252,
    68288, 68295,
    68297, 68324,
    68352, 68405,
    68416, 68437,
    68448, 68466,
    68480, 68497,
    68608, 68680,
    68736, 68786,
    68800, 68850,
    68864, 68899,
    68912, 68921,
    69248, 69289,
    69296, 69297,
    69376, 69404,
    69415, 69415,
    69424, 69445,
    69488, 69505,
    69552, 69572,
    69600, 69622,
    69635, 69687,
    69734, 69743,
    69745, 69746,
    69749, 69749,
    69763, 69807,
    69840, 69864,
    69872, 69881,
    69891, 69926,
    69942, 69951,
    69956, 69956,
    69959, 69959,
    69968, 70002,
    70006, 70006,
    70019, 70066,
    70081, 70084,
    70096, 70106,
    70108, 70108,
    70144, 70161,
    70163, 70187,
    70207, 70208,
    70272, 70278,
    70280, 70280,
    70282, 70285,
    70287, 70301,
    70303, 70312,
    70320, 70366,
    70384, 70393,
    70405, 70412,
    70415, 70416,
    70419, 70440,
    70442, 70448,
    70450, 70451,
    70453, 70457,
    70461, 70461,
    70480, 70480,
    70493, 70497,
    70656, 70708,
    70727, 70730,
    70736, 70745,
    70751, 70753,
    70784, 70831,
    70852, 70853,
    70855, 70855,
    70864, 70873,
    71040, 71086,
    71128, 71131,
    71168, 71215,
    71236, 71236,
    71248, 71257,
    71296, 71338,
    71352, 71352,
    71360, 71369,
    71424, 71450,
    71472, 71481,
    71488, 71494,
    71680, 71723,
    71840, 71913,
    71935, 71942,
    71945, 71945,
    71948, 71955,
    71957, 71958,
    71960, 71983,
    71999, 71999,
    72001, 72001,
    72016, 72025,
    72096, 72103,
    72106, 72144,
    72161, 72161,
    72163, 72163,
    72192, 72192,
    72203, 72242,
    72250, 72250,
    72272, 72272,
    72284, 72329,
    72349, 72349,
    72368, 72440,
    72704, 72712,
    72714, 72750,
    72768, 72768,
    72784, 72793,
    72818, 72847,
    72960, 72966,
    72968, 72969,
    72971, 73008,
    73030, 73030,
    73040, 73049,
    73056, 73061,
    73063, 73064,
    73066, 73097,
    73112, 73112,
    73120, 73129,
    73440, 73458,
    73474, 73474,
    73476, 73488,
    73490, 73523,
    73552, 73561,
    73648, 73648,
    73728, 74649,
    74880, 75075,
    77712, 77808,
    77824, 78895,
    78913, 78918,
    82944, 83526,
    92160, 92728,
    92736, 92766,
    92768, 92777,
    92784, 92862,
    92864, 92873,
    92880, 92909,
    92928, 92975,
    92992, 92995,
    93008, 93017,
    93027, 93047,
    93053, 93071,
    93760, 93823,
    93952, 94026,
    94032, 94032,
    94099, 94111,
    94176, 94177,
    94179, 94179,
    94208, 100343,
    100352, 101589,
    101632, 101640,
    110576, 110579,
    110581, 110587,
    110589, 110590,
    110592, 110882,
    110898, 110898,
    110928, 110930,
    110933, 110933,
    110948, 110951,
    110960, 111355,
    113664, 113770,
    113776, 113788,
    113792, 113800,
    113808, 113817,
    119808, 119892,
    119894, 119964,
    119966, 119967,
    119970, 119970,
    119973, 119974,
    119977, 119980,
    119982, 119993,
    119995, 119995,
    119997, 120003,
    120005, 120069,
    120071, 120074,
    120077, 120084,
    120086, 120092,
    120094, 120121,
    120123, 120126,
    120128, 120132,
    120134, 120134,
    120138, 120144,
    120146, 120485,
    120488, 120512,
    120514, 120538,
    120540, 120570,
    120572, 120596,
    120598, 120628,
    120630, 120654,
    120656, 120686,
    120688, 120712,
    120714, 120744,
    120746, 120770,
    120772, 120779,
    120782, 120831,
    122624, 122654,
    122661, 122666,
    122928, 122989,
    123136, 123180,
    123191, 123197,
    123200, 123209,
    123214, 123214,
    123536, 123565,
    123584, 123627,
    123632, 123641,
    124112, 124139,
    124144, 124153,
    124896, 124902,
    124904, 124907,
    124909, 124910,
    124912, 124926,
    124928, 125124,
    125184, 125251,
    125259, 125259,
    125264, 125273,
    126464, 126467,
    126469, 126495,
    126497, 126498,
    126500, 126500,
    126503, 126503,
    126505, 126514,
    126516, 126519,
    126521, 126521,
    126523, 126523,
    126530, 126530,
    126535, 126535,
    126537, 126537,
    126539, 126539,
    126541, 126543,
    126545, 126546,
    126548, 126548,
    126551, 126551,
    126553, 126553,
    126555, 126555,
    126557, 126557,
    126559, 126559,
    126561, 126562,
    126564, 126564,
    126567, 126570,
    126572, 126578,
    126580, 126583,
    126585, 126588,
    126590, 126590,
    126592, 126601,
    126603, 126619,
    126625, 126627,
    126629, 126633,
    126635, 126651,
    130032, 130041,
    131072, 173791,
    173824, 177977,
    177984, 178205,
    178208, 183969,
    183984, 191456,
    191472, 192093,
    194560, 195101,
    196608, 201546,
    201552, 205743,
    0, 0
  };
  range["Word"] = Word;
  static const int Yezidi[] = {
    69248, 69289,
    69291, 69293,
    69296, 69297,
    0, 0
  };
  range["Yezidi"] = Yezidi;
  static const int Yi[] = {
    40960, 42124,
    42128, 42182,
    0, 0
  };
  range["Yi"] = Yi;
  static const int Z[] = {
    32, 32,
    160, 160,
    5760, 5760,
    8192, 8202,
    8232, 8233,
    8239, 8239,
    8287, 8287,
    12288, 12288,
    0, 0
  };
  range["Z"] = Z;
  static const int Zanabazar_Square[] = {
    72192, 72263,
    0, 0
  };
  range["Zanabazar_Square"] = Zanabazar_Square;
  static const int Zl[] = {
    8232, 8232,
    0, 0
  };
  range["Zl"] = Zl;
  static const int Zp[] = {
    8233, 8233,
    0, 0
  };
  range["Zp"] = Zp;
  static const int Zs[] = {
    32, 32,
    160, 160,
    5760, 5760,
    8192, 8202,
    8239, 8239,
    8287, 8287,
    12288, 12288,
    0, 0
  };
  range["Zs"] = Zs;
}
