// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright (c) 2015, NVIDIA CORPORATION. All rights reserved.
 */

#include <common.h>
#include <asm/io.h>
#include <asm/arch/pinmux.h>

#define PIN(pin, f0, f1, f2, f3)	\
	{				\
		.funcs = {		\
			PMUX_FUNC_##f0,	\
			PMUX_FUNC_##f1,	\
			PMUX_FUNC_##f2,	\
			PMUX_FUNC_##f3,	\
		},			\
	}

#define PIN_RESERVED {}

static const struct pmux_pingrp_desc tegra210_pingroups[] = {
	/*  pin,                  f0,         f1,     f2,    f3 */
	/* Offset 0x3000 */
	PIN(SDMMC1_CLK_PM0,       SDMMC1,     RSVD1,  RSVD2, RSVD3),
	PIN(SDMMC1_CMD_PM1,       SDMMC1,     SPI3,   RSVD2, RSVD3),
	PIN(SDMMC1_DAT3_PM2,      SDMMC1,     SPI3,   RSVD2, RSVD3),
	PIN(SDMMC1_DAT2_PM3,      SDMMC1,     SPI3,   RSVD2, RSVD3),
	PIN(SDMMC1_DAT1_PM4,      SDMMC1,     SPI3,   RSVD2, RSVD3),
	PIN(SDMMC1_DAT0_PM5,      SDMMC1,     RSVD1,  RSVD2, RSVD3),
	PIN_RESERVED,
	/* Offset 0x301c */
	PIN(SDMMC3_CLK_PP0,       SDMMC3,     RSVD1,  RSVD2, RSVD3),
	PIN(SDMMC3_CMD_PP1,       SDMMC3,     RSVD1,  RSVD2, RSVD3),
	PIN(SDMMC3_DAT0_PP5,      SDMMC3,     RSVD1,  RSVD2, RSVD3),
	PIN(SDMMC3_DAT1_PP4,      SDMMC3,     RSVD1,  RSVD2, RSVD3),
	PIN(SDMMC3_DAT2_PP3,      SDMMC3,     RSVD1,  RSVD2, RSVD3),
	PIN(SDMMC3_DAT3_PP2,      SDMMC3,     RSVD1,  RSVD2, RSVD3),
	PIN_RESERVED,
	/* Offset 0x3038 */
	PIN(PEX_L0_RST_N_PA0,     PE0,        RSVD1,  RSVD2, RSVD3),
	PIN(PEX_L0_CLKREQ_N_PA1,  PE0,        RSVD1,  RSVD2, RSVD3),
	PIN(PEX_WAKE_N_PA2,       PE,         RSVD1,  RSVD2, RSVD3),
	PIN(PEX_L1_RST_N_PA3,     PE1,        RSVD1,  RSVD2, RSVD3),
	PIN(PEX_L1_CLKREQ_N_PA4,  PE1,        RSVD1,  RSVD2, RSVD3),
	PIN(SATA_LED_ACTIVE_PA5,  SATA,       RSVD1,  RSVD2, RSVD3),
	PIN(SPI1_MOSI_PC0,        SPI1,       RSVD1,  RSVD2, RSVD3),
	PIN(SPI1_MISO_PC1,        SPI1,       RSVD1,  RSVD2, RSVD3),
	PIN(SPI1_SCK_PC2,         SPI1,       RSVD1,  RSVD2, RSVD3),
	PIN(SPI1_CS0_PC3,         SPI1,       RSVD1,  RSVD2, RSVD3),
	PIN(SPI1_CS1_PC4,         SPI1,       RSVD1,  RSVD2, RSVD3),
	PIN(SPI2_MOSI_PB4,        SPI2,       DTV,    RSVD2, RSVD3),
	PIN(SPI2_MISO_PB5,        SPI2,       DTV,    RSVD2, RSVD3),
	PIN(SPI2_SCK_PB6,         SPI2,       DTV,    RSVD2, RSVD3),
	PIN(SPI2_CS0_PB7,         SPI2,       DTV,    RSVD2, RSVD3),
	PIN(SPI2_CS1_PDD0,        SPI2,       RSVD1,  RSVD2, RSVD3),
	PIN(SPI4_MOSI_PC7,        SPI4,       RSVD1,  RSVD2, RSVD3),
	PIN(SPI4_MISO_PD0,        SPI4,       RSVD1,  RSVD2, RSVD3),
	PIN(SPI4_SCK_PC5,         SPI4,       RSVD1,  RSVD2, RSVD3),
	PIN(SPI4_CS0_PC6,         SPI4,       RSVD1,  RSVD2, RSVD3),
	PIN(QSPI_SCK_PEE0,        QSPI,       RSVD1,  RSVD2, RSVD3),
	PIN(QSPI_CS_N_PEE1,       QSPI,       RSVD1,  RSVD2, RSVD3),
	PIN(QSPI_IO0_PEE2,        QSPI,       RSVD1,  RSVD2, RSVD3),
	PIN(QSPI_IO1_PEE3,        QSPI,       RSVD1,  RSVD2, RSVD3),
	PIN(QSPI_IO2_PEE4,        QSPI,       RSVD1,  RSVD2, RSVD3),
	PIN(QSPI_IO3_PEE5,        QSPI,       RSVD1,  RSVD2, RSVD3),
	PIN_RESERVED,
	/* Offset 0x30a4 */
	PIN(DMIC1_CLK_PE0,        DMIC1,      I2S3,   RSVD2, RSVD3),
	PIN(DMIC1_DAT_PE1,        DMIC1,      I2S3,   RSVD2, RSVD3),
	PIN(DMIC2_CLK_PE2,        DMIC2,      I2S3,   RSVD2, RSVD3),
	PIN(DMIC2_DAT_PE3,        DMIC2,      I2S3,   RSVD2, RSVD3),
	PIN(DMIC3_CLK_PE4,        DMIC3,      I2S5A,  RSVD2, RSVD3),
	PIN(DMIC3_DAT_PE5,        DMIC3,      I2S5A,  RSVD2, RSVD3),
	PIN(GEN1_I2C_SCL_PJ1,     I2C1,       RSVD1,  RSVD2, RSVD3),
	PIN(GEN1_I2C_SDA_PJ0,     I2C1,       RSVD1,  RSVD2, RSVD3),
	PIN(GEN2_I2C_SCL_PJ2,     I2C2,       RSVD1,  RSVD2, RSVD3),
	PIN(GEN2_I2C_SDA_PJ3,     I2C2,       RSVD1,  RSVD2, RSVD3),
	PIN(GEN3_I2C_SCL_PF0,     I2C3,       RSVD1,  RSVD2, RSVD3),
	PIN(GEN3_I2C_SDA_PF1,     I2C3,       RSVD1,  RSVD2, RSVD3),
	PIN(CAM_I2C_SCL_PS2,      I2C3,       I2CVI,  RSVD2, RSVD3),
	PIN(CAM_I2C_SDA_PS3,      I2C3,       I2CVI,  RSVD2, RSVD3),
	PIN(PWR_I2C_SCL_PY3,      I2CPMU,     RSVD1,  RSVD2, RSVD3),
	PIN(PWR_I2C_SDA_PY4,      I2CPMU,     RSVD1,  RSVD2, RSVD3),
	PIN(UART1_TX_PU0,         UARTA,      RSVD1,  RSVD2, RSVD3),
	PIN(UART1_RX_PU1,         UARTA,      RSVD1,  RSVD2, RSVD3),
	PIN(UART1_RTS_PU2,        UARTA,      RSVD1,  RSVD2, RSVD3),
	PIN(UART1_CTS_PU3,        UARTA,      RSVD1,  RSVD2, RSVD3),
	PIN(UART2_TX_PG0,         UARTB,      I2S4A,  SPDIF, UART),
	PIN(UART2_RX_PG1,         UARTB,      I2S4A,  SPDIF, UART),
	PIN(UART2_RTS_PG2,        UARTB,      I2S4A,  RSVD2, UART),
	PIN(UART2_CTS_PG3,        UARTB,      I2S4A,  RSVD2, UART),
	PIN(UART3_TX_PD1,         UARTC,      SPI4,   RSVD2, RSVD3),
	PIN(UART3_RX_PD2,         UARTC,      SPI4,   RSVD2, RSVD3),
	PIN(UART3_RTS_PD3,        UARTC,      SPI4,   RSVD2, RSVD3),
	PIN(UART3_CTS_PD4,        UARTC,      SPI4,   RSVD2, RSVD3),
	PIN(UART4_TX_PI4,         UARTD,      UART,   RSVD2, RSVD3),
	PIN(UART4_RX_PI5,         UARTD,      UART,   RSVD2, RSVD3),
	PIN(UART4_RTS_PI6,        UARTD,      UART,   RSVD2, RSVD3),
	PIN(UART4_CTS_PI7,        UARTD,      UART,   RSVD2, RSVD3),
	PIN(DAP1_FS_PB0,          I2S1,       RSVD1,  RSVD2, RSVD3),
	PIN(DAP1_DIN_PB1,         I2S1,       RSVD1,  RSVD2, RSVD3),
	PIN(DAP1_DOUT_PB2,        I2S1,       RSVD1,  RSVD2, RSVD3),
	PIN(DAP1_SCLK_PB3,        I2S1,       RSVD1,  RSVD2, RSVD3),
	PIN(DAP2_FS_PAA0,         I2S2,       RSVD1,  RSVD2, RSVD3),
	PIN(DAP2_DIN_PAA2,        I2S2,       RSVD1,  RSVD2, RSVD3),
	PIN(DAP2_DOUT_PAA3,       I2S2,       RSVD1,  RSVD2, RSVD3),
	PIN(DAP2_SCLK_PAA1,       I2S2,       RSVD1,  RSVD2, RSVD3),
	PIN(DAP4_FS_PJ4,          I2S4B,      RSVD1,  RSVD2, RSVD3),
	PIN(DAP4_DIN_PJ5,         I2S4B,      RSVD1,  RSVD2, RSVD3),
	PIN(DAP4_DOUT_PJ6,        I2S4B,      RSVD1,  RSVD2, RSVD3),
	PIN(DAP4_SCLK_PJ7,        I2S4B,      RSVD1,  RSVD2, RSVD3),
	PIN(CAM1_MCLK_PS0,        EXTPERIPH3, RSVD1,  RSVD2, RSVD3),
	PIN(CAM2_MCLK_PS1,        EXTPERIPH3, RSVD1,  RSVD2, RSVD3),
	PIN(JTAG_RTCK,            JTAG,       RSVD1,  RSVD2, RSVD3),
	PIN(CLK_32K_IN,           CLK,        RSVD1,  RSVD2, RSVD3),
	PIN(CLK_32K_OUT_PY5,      SOC,        BLINK,  RSVD2, RSVD3),
	PIN(BATT_BCL,             BCL,        RSVD1,  RSVD2, RSVD3),
	PIN(CLK_REQ,              SYS,        RSVD1,  RSVD2, RSVD3),
	PIN(CPU_PWR_REQ,          CPU,        RSVD1,  RSVD2, RSVD3),
	PIN(PWR_INT_N,            PMI,        RSVD1,  RSVD2, RSVD3),
	PIN(SHUTDOWN,             SHUTDOWN,   RSVD1,  RSVD2, RSVD3),
	PIN(CORE_PWR_REQ,         CORE,       RSVD1,  RSVD2, RSVD3),
	PIN(AUD_MCLK_PBB0,        AUD,        RSVD1,  RSVD2, RSVD3),
	PIN(DVFS_PWM_PBB1,        RSVD0,      CLDVFS, SPI3,  RSVD3),
	PIN(DVFS_CLK_PBB2,        RSVD0,      CLDVFS, SPI3,  RSVD3),
	PIN(GPIO_X1_AUD_PBB3,     RSVD0,      RSVD1,  SPI3,  RSVD3),
	PIN(GPIO_X3_AUD_PBB4,     RSVD0,      RSVD1,  SPI3,  RSVD3),
	PIN(PCC7,                 RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(HDMI_CEC_PCC0,        CEC,        RSVD1,  RSVD2, RSVD3),
	PIN(HDMI_INT_DP_HPD_PCC1, DP,         RSVD1,  RSVD2, RSVD3),
	PIN(SPDIF_OUT_PCC2,       SPDIF,      RSVD1,  RSVD2, RSVD3),
	PIN(SPDIF_IN_PCC3,        SPDIF,      RSVD1,  RSVD2, RSVD3),
	PIN(USB_VBUS_EN0_PCC4,    USB,        RSVD1,  RSVD2, RSVD3),
	PIN(USB_VBUS_EN1_PCC5,    USB,        RSVD1,  RSVD2, RSVD3),
	PIN(DP_HPD0_PCC6,         DP,         RSVD1,  RSVD2, RSVD3),
	PIN(WIFI_EN_PH0,          RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(WIFI_RST_PH1,         RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(WIFI_WAKE_AP_PH2,     RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(AP_WAKE_BT_PH3,       RSVD0,      UARTB,  SPDIF, RSVD3),
	PIN(BT_RST_PH4,           RSVD0,      UARTB,  SPDIF, RSVD3),
	PIN(BT_WAKE_AP_PH5,       RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(AP_WAKE_NFC_PH7,      RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(NFC_EN_PI0,           RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(NFC_INT_PI1,          RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(GPS_EN_PI2,           RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(GPS_RST_PI3,          RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(CAM_RST_PS4,          VGP1,       RSVD1,  RSVD2, RSVD3),
	PIN(CAM_AF_EN_PS5,        VIMCLK,     VGP2,   RSVD2, RSVD3),
	PIN(CAM_FLASH_EN_PS6,     VIMCLK,     VGP3,   RSVD2, RSVD3),
	PIN(CAM1_PWDN_PS7,        VGP4,       RSVD1,  RSVD2, RSVD3),
	PIN(CAM2_PWDN_PT0,        VGP5,       RSVD1,  RSVD2, RSVD3),
	PIN(CAM1_STROBE_PT1,      VGP6,       RSVD1,  RSVD2, RSVD3),
	PIN(LCD_TE_PY2,           DISPLAYA,   RSVD1,  RSVD2, RSVD3),
	PIN(LCD_BL_PWM_PV0,       DISPLAYA,   PWM0,   SOR0,  RSVD3),
	PIN(LCD_BL_EN_PV1,        RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(LCD_RST_PV2,          RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(LCD_GPIO1_PV3,        DISPLAYB,   RSVD1,  RSVD2, RSVD3),
	PIN(LCD_GPIO2_PV4,        DISPLAYB,   PWM1,   RSVD2, SOR1),
	PIN(AP_READY_PV5,         RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(TOUCH_RST_PV6,        RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(TOUCH_CLK_PV7,        TOUCH,      RSVD1,  RSVD2, RSVD3),
	PIN(MODEM_WAKE_AP_PX0,    RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(TOUCH_INT_PX1,        RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(MOTION_INT_PX2,       RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(ALS_PROX_INT_PX3,     RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(TEMP_ALERT_PX4,       RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(BUTTON_POWER_ON_PX5,  RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(BUTTON_VOL_UP_PX6,    RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(BUTTON_VOL_DOWN_PX7,  RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(BUTTON_SLIDE_SW_PY0,  RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(BUTTON_HOME_PY1,      RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(PA6,                  SATA,       RSVD1,  RSVD2, RSVD3),
	PIN(PE6,                  RSVD0,      I2S5A,  PWM2,  RSVD3),
	PIN(PE7,                  RSVD0,      I2S5A,  PWM3,  RSVD3),
	PIN(PH6,                  RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(PK0,                  IQC0,       I2S5B,  RSVD2, RSVD3),
	PIN(PK1,                  IQC0,       I2S5B,  RSVD2, RSVD3),
	PIN(PK2,                  IQC0,       I2S5B,  RSVD2, RSVD3),
	PIN(PK3,                  IQC0,       I2S5B,  RSVD2, RSVD3),
	PIN(PK4,                  IQC1,       RSVD1,  RSVD2, RSVD3),
	PIN(PK5,                  IQC1,       RSVD1,  RSVD2, RSVD3),
	PIN(PK6,                  IQC1,       RSVD1,  RSVD2, RSVD3),
	PIN(PK7,                  IQC1,       RSVD1,  RSVD2, RSVD3),
	PIN(PL0,                  RSVD0,      RSVD1,  RSVD2, RSVD3),
	PIN(PL1,                  SOC,        RSVD1,  RSVD2, RSVD3),
	PIN(PZ0,                  VIMCLK2,    RSVD1,  RSVD2, RSVD3),
	PIN(PZ1,                  VIMCLK2,    SDMMC1, RSVD2, RSVD3),
	PIN(PZ2,                  SDMMC3,     CCLA,   RSVD2, RSVD3),
	PIN(PZ3,                  SDMMC3,     RSVD1,  RSVD2, RSVD3),
	PIN(PZ4,                  SDMMC1,     RSVD1,  RSVD2, RSVD3),
	PIN(PZ5,                  SOC,        RSVD1,  RSVD2, RSVD3),
};
const struct pmux_pingrp_desc *tegra_soc_pingroups = tegra210_pingroups;
